/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.DriverShim;
import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.vrtest.CommonImpl;
import com.novell.nds.dirxml.driver.vrtest.VRTestAPIWrapper;
import com.novell.nds.dirxml.driver.vrtest.VRTestPublicationShim;
import com.novell.nds.dirxml.driver.vrtest.VRTestSubscriptionShim;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.RequiredConstraint;
import com.novell.nds.dirxml.driver.xds.StateParent;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAttrDefElement;
import com.novell.nds.dirxml.driver.xds.XDSClassDefElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverOptionsElement;
import com.novell.nds.dirxml.driver.xds.XDSDriverStateElement;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSSchemaDefElement;
import com.novell.nds.dirxml.driver.xds.XDSSchemaResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.ListIterator;

public class VRTestDriverShim
extends CommonImpl
implements DriverShim {
    private static final String TRACE_SUFFIX = "Driver";
    private static final int NO_OF_PARAMS = 2;
    private static final String TAG_PORT = "port";
    private static final String TAG_HOST = "host";
    private static final String DEFAULT_HOST = "localhost";
    private static final String APPLICATION_NAME = "VRTest";
    private VRTestSubscriptionShim subscriptionShim;
    private VRTestPublicationShim publicationShim;

    public VRTestDriverShim() {
        this.setDriverRDN("VRTest Driver");
        this.setTrace(null);
        this.setDriverParams();
        this.subscriptionShim = null;
        this.publicationShim = null;
    }

    private void setDriverParams() {
        this.driverParams = new HashMap(2);
        Parameter parameter = new Parameter(TAG_PORT, null, DataType.INT);
        parameter.add((Constraint)RequiredConstraint.REQUIRED);
        parameter.add((Constraint)new RangeConstraint(1L, 65535L));
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_HOST, DEFAULT_HOST, DataType.STRING);
        this.driverParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("run-count", "0", DataType.LONG);
        parameter.add((Constraint)RangeConstraint.POSITIVE);
        this.driverParams.put(parameter.tagName(), parameter);
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        this.trace.trace("init", 1);
        XDSResultDocument xDSResultDocument = new XDSResultDocument();
        try {
            XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
            this.setDriverRDN(xDSInitDocument.rdn());
            this.setTrace(TRACE_SUFFIX);
            this.appendSourceInfo((WriteableDocument)xDSResultDocument);
            xDSInitDocument.parameters(this.driverParams);
            this.setAPI(new VRTestAPIWrapper(this.driverParams.get(TAG_HOST).toString(), ((Parameter)this.driverParams.get(TAG_PORT)).toInteger()));
            Parameter parameter = (Parameter)this.driverParams.get("run-count");
            this.setRunCount(parameter.toLong());
            parameter.overrideValue(String.valueOf(this.getRunCount()));
            this.subscriptionShim = new VRTestSubscriptionShim(this);
            this.publicationShim = new VRTestPublicationShim(this);
            XDSDriverStateElement xDSDriverStateElement = xDSResultDocument.appendInitParamsElement().appendDriverStateElement();
            this.appendStateInfo((StateParent)xDSDriverStateElement);
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement xDSStatusElement = XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
            xDSStatusElement.parametersAppend(this.driverParams);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
        }
        return xDSResultDocument.toXML();
    }

    public XmlDocument shutdown(XmlDocument xmlDocument) {
        this.trace.trace("shutdown", 1);
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        try {
            if (this.publicationShim != null) {
                this.publicationShim.shutdown();
            }
            if (this.subscriptionShim != null) {
                this.subscriptionShim.shutdown();
            }
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)true, null);
        }
        return xDSResultDocument.toXML();
    }

    public SubscriptionShim getSubscriptionShim() {
        this.trace.trace("getSubscriptionShim", 1);
        return this.subscriptionShim;
    }

    public PublicationShim getPublicationShim() {
        this.trace.trace("getPublicationShim", 1);
        return this.publicationShim;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlDocument getSchema(XmlDocument xmlDocument) {
        this.trace.trace("getSchema", 1);
        XDSSchemaResultDocument xDSSchemaResultDocument = new XDSSchemaResultDocument();
        try {
            try {
                XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
                this.setDriverRDN(xDSInitDocument.rdn());
                this.setTrace(TRACE_SUFFIX);
                this.appendSourceInfo((WriteableDocument)xDSSchemaResultDocument);
                XDSDriverOptionsElement xDSDriverOptionsElement = xDSInitDocument.extractInitParamsElement().extractDriverOptionsElement();
                xDSDriverOptionsElement.parameters(this.driverParams);
                this.setAPI(new VRTestAPIWrapper(this.driverParams.get(TAG_HOST).toString(), ((Parameter)this.driverParams.get(TAG_PORT)).toInteger()));
                this.connect();
                VRTestSchema vRTestSchema = this.api.getSchema();
                this.disconnect();
                VRTestDriverShim.appendSchemaDefElement(xDSSchemaResultDocument, vRTestSchema);
                StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, null);
                XDSUtil.appendStatus((StatusDocument)xDSSchemaResultDocument, (StatusAttributes)statusAttributes, null);
            }
            catch (Exception exception) {
                xDSSchemaResultDocument.empty();
                StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_STATUS, null);
                XDSUtil.appendStatus((StatusDocument)xDSSchemaResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
                Object var8_10 = null;
                this.disconnect();
                return xDSSchemaResultDocument.toXML();
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.disconnect();
            throw throwable;
        }
        this.disconnect();
        return xDSSchemaResultDocument.toXML();
    }

    private static void appendSchemaDefElement(XDSSchemaResultDocument xDSSchemaResultDocument, VRTestSchema vRTestSchema) {
        XDSSchemaDefElement xDSSchemaDefElement = xDSSchemaResultDocument.appendSchemaDefElement();
        xDSSchemaDefElement.setApplicationName(APPLICATION_NAME);
        xDSSchemaDefElement.setHierarchical(vRTestSchema.isHierarchical());
        VRTestDriverShim.appendClassDefElements(xDSSchemaDefElement, vRTestSchema);
    }

    private static void appendClassDefElements(XDSSchemaDefElement xDSSchemaDefElement, VRTestSchema vRTestSchema) {
        ListIterator listIterator = vRTestSchema.getClassSchemas().listIterator();
        while (listIterator.hasNext()) {
            VRTestClassSchema vRTestClassSchema = (VRTestClassSchema)listIterator.next();
            XDSClassDefElement xDSClassDefElement = xDSSchemaDefElement.appendClassDefElement();
            xDSClassDefElement.setClassName(vRTestClassSchema.getName());
            xDSClassDefElement.setContainer(vRTestClassSchema.isContainer());
            VRTestDriverShim.appendAttrDefElements(xDSClassDefElement, vRTestClassSchema);
        }
    }

    private static void appendAttrDefElements(XDSClassDefElement xDSClassDefElement, VRTestClassSchema vRTestClassSchema) {
        VRTestAttributeSchema vRTestAttributeSchema = vRTestClassSchema.getNamingAttributeSchema();
        Enumeration enumeration = vRTestClassSchema.enumAttributeSchemas();
        while (enumeration.hasMoreElements()) {
            VRTestAttributeSchema vRTestAttributeSchema2 = (VRTestAttributeSchema)enumeration.nextElement();
            boolean bl = vRTestAttributeSchema2 == vRTestAttributeSchema;
            XDSAttrDefElement xDSAttrDefElement = xDSClassDefElement.appendAttrDefElement();
            xDSAttrDefElement.setAttrName(vRTestAttributeSchema2.getName());
            xDSAttrDefElement.setCaseSensitive(vRTestAttributeSchema2.isCaseSensitive());
            xDSAttrDefElement.setMultiValued(vRTestAttributeSchema2.isMultiValued());
            xDSAttrDefElement.setNaming(bl);
            xDSAttrDefElement.setReadOnly(vRTestAttributeSchema2.isReadOnly());
            xDSAttrDefElement.setRequired(vRTestAttributeSchema2.isRequired());
            xDSAttrDefElement.setType(ValueType.STRING);
        }
    }
}

