/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestAPIWrapper;
import com.novell.nds.dirxml.driver.vrtest.VRTestAttributeFilter;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeList;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

class VRTestObject
implements VRTestConstants,
Constants {
    private static final int DN_LENGTH = 20;
    private long handle;
    private VRTestAPIWrapper api;
    protected String association;
    protected String dn;
    protected String name;
    protected LinkedList otherNames;
    protected String className;
    protected String path;
    protected boolean hierarchical;
    protected VRTestClassSchema classSchema;
    protected VRTestAttributeList attributes;
    protected VRTestAttributeSchema namingAttributeSchema;

    protected VRTestObject(String string, String string2, String string3, String string4) {
        this.name = string;
        this.path = string2;
        this.dn = string3;
        this.association = string4;
        this.attributes = VRTestAttributeList.EMPTY;
        this.className = null;
        this.classSchema = null;
        this.handle = -1L;
        this.api = null;
        this.hierarchical = true;
        this.otherNames = null;
        this.namingAttributeSchema = null;
    }

    VRTestObject(long l, String string, String string2, VRTestAPIWrapper vRTestAPIWrapper) throws VRTestException {
        this.api = vRTestAPIWrapper;
        this.className = string2;
        this.handle = l;
        this.name = string;
        this.attributes = VRTestAttributeList.EMPTY;
        this.dn = null;
        this.association = null;
        this.path = null;
        this.classSchema = null;
        this.hierarchical = this.api.getSchema().isHierarchical();
        this.otherNames = null;
        this.namingAttributeSchema = null;
    }

    VRTestClassSchema getClassSchema() throws VRTestException {
        if (this.classSchema == null) {
            this.classSchema = this.api.getSchema().getClassSchema(this.className);
            if (this.classSchema == null) {
                throw new VRTestException(Errors.noClassSchema(this.className));
            }
        }
        return this.classSchema;
    }

    long getHandle() {
        return this.handle;
    }

    String getName() throws VRTestException, IOException {
        if (this.name == null) {
            this.setNames();
        }
        return this.name;
    }

    LinkedList getOtherNames() throws VRTestException, IOException {
        if (this.name == null) {
            this.setNames();
        }
        return this.otherNames;
    }

    List getAttributes() throws VRTestException, IOException {
        this.setAttributes();
        return this.attributes.attributes();
    }

    private void setAttributes() throws VRTestException, IOException {
        if (this.attributes == VRTestAttributeList.EMPTY) {
            this.attributes = this.api.getAttributes(this.handle);
        }
    }

    private void setNames() throws VRTestException, IOException {
        this.setAttributes();
        this.getNamingAttributeSchema();
        LinkedList linkedList = this.attributes.getAttribute(this.namingAttributeSchema);
        if (linkedList != null) {
            if (this.namingAttributeSchema.isMultiValued()) {
                this.name = ((VRTestAttribute)linkedList.getFirst()).getValue();
                linkedList.removeFirst();
                ListIterator listIterator = linkedList.listIterator();
                while (listIterator.hasNext()) {
                    if (this.otherNames == null) {
                        this.otherNames = new LinkedList();
                    }
                    this.otherNames.add(((VRTestAttribute)listIterator.next()).getValue());
                }
            } else {
                this.name = ((VRTestAttribute)linkedList.getFirst()).getValue();
            }
        }
    }

    String extractAssociationText() throws VRTestException, IOException {
        VRTestAttribute vRTestAttribute;
        if (this.association == null && (vRTestAttribute = this.getAttributeByName("Unique Id")) != null) {
            this.association = vRTestAttribute.getValue();
        }
        return this.association;
    }

    VRTestAttribute getAttributeByName(String string) throws VRTestException, IOException {
        this.setAttributes();
        return this.attributes.getAttributeByName(string);
    }

    String getClassName() {
        return this.className;
    }

    String getDN() throws VRTestException, IOException {
        if (this.dn == null) {
            this.setDN();
        }
        return this.dn;
    }

    private void setDN() throws VRTestException, IOException {
        StringBuffer stringBuffer = new StringBuffer(20);
        if (this.hierarchical) {
            this.getPath();
            if (this.path == null) {
                return;
            }
            stringBuffer.append(this.path);
        }
        this.getName();
        if (this.name == null) {
            return;
        }
        stringBuffer.append(this.name);
        this.dn = stringBuffer.toString();
    }

    String getPath() throws VRTestException, IOException {
        if (this.path == null && this.hierarchical) {
            this.setPath();
        }
        return this.path;
    }

    private void setPath() throws VRTestException, IOException {
        this.setAttributes();
        VRTestAttribute vRTestAttribute = this.attributes.getPath();
        if (vRTestAttribute != null) {
            this.path = vRTestAttribute.getValue();
        }
    }

    List getAttributes(VRTestAttributeFilter vRTestAttributeFilter) throws VRTestException, IOException {
        if (vRTestAttributeFilter == VRTestAttributeFilter.NO_ATTRIBUTES) {
            return Collections.EMPTY_LIST;
        }
        this.setAttributes();
        if (vRTestAttributeFilter == VRTestAttributeFilter.ALL_ATTRIBUTES) {
            return this.attributes.attributes();
        }
        this.getClassSchema();
        VRTestAttributeList vRTestAttributeList = new VRTestAttributeList();
        List list = vRTestAttributeFilter.attributes();
        VRTestAttribute vRTestAttribute = null;
        VRTestAttribute vRTestAttribute2 = null;
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            LinkedList linkedList;
            vRTestAttribute = (VRTestAttribute)listIterator.next();
            VRTestAttributeSchema vRTestAttributeSchema = this.classSchema.getAttributeSchema(vRTestAttribute.getName());
            if (vRTestAttributeSchema == null || (linkedList = this.attributes.getAttribute(vRTestAttributeSchema)) == null) continue;
            ListIterator listIterator2 = linkedList.listIterator();
            while (listIterator2.hasNext()) {
                vRTestAttribute2 = (VRTestAttribute)listIterator2.next();
                vRTestAttributeList.addAttribute(vRTestAttribute2);
            }
        }
        return vRTestAttributeList.attributes();
    }

    VRTestAttributeSchema getNamingAttributeSchema() throws VRTestException {
        if (this.namingAttributeSchema == null) {
            this.namingAttributeSchema = this.getClassSchema().getNamingAttributeSchema();
        }
        return this.namingAttributeSchema;
    }

    void resetAttributes() {
        this.attributes = VRTestAttributeList.EMPTY;
    }

    boolean isSubordinate(VRTestObject vRTestObject) throws VRTestException, IOException {
        if (vRTestObject == null) {
            throw new IllegalArgumentException(Errors.nullParam("object"));
        }
        if (this == vRTestObject) {
            return false;
        }
        String string = this.getDN();
        String string2 = vRTestObject.getDN();
        if (string2 == null || string == null) {
            throw new VRTestException("Object missing required dn.");
        }
        int n = string.length();
        boolean bl = string.regionMatches(true, 0, string2, 0, n);
        if (!bl) {
            return false;
        }
        int n2 = string2.lastIndexOf(92);
        return n2 == n - 1;
    }

    boolean inSubtree(VRTestObject vRTestObject) throws VRTestException, IOException {
        if (vRTestObject == null) {
            throw new IllegalArgumentException(Errors.nullParam("object"));
        }
        if (this == vRTestObject) {
            return true;
        }
        String string = this.getDN();
        String string2 = vRTestObject.getDN();
        if (string == null || string2 == null) {
            throw new VRTestException("Object missing required dn.");
        }
        if (string2 == null) {
            return false;
        }
        int n = string.length();
        boolean bl = string.regionMatches(true, 0, string2, 0, n);
        if (!bl) {
            return false;
        }
        return string2.charAt(n - 1) == '\\';
    }
}

