/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestRootObject;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;

class VRTestPathParser
implements VRTestConstants,
Constants {
    private String containerName;
    private String containerPath;
    private String containerDN;

    VRTestPathParser(String string) throws VRTestException {
        if (string == null) {
            throw new IllegalArgumentException(Errors.nullParam("objectPath"));
        }
        this.parsePath(string);
    }

    String getContainerName() {
        return this.containerName;
    }

    String getContainerPath() {
        return this.containerPath;
    }

    String getContainerDN() {
        return this.containerDN;
    }

    private void parsePath(String string) throws VRTestException {
        int n = string.lastIndexOf(92);
        if (n == -1) {
            throw new VRTestException(Errors.badPath(string));
        }
        if (n == 0) {
            this.containerName = VRTestRootObject.NAME;
            this.containerPath = VRTestRootObject.PATH;
            this.containerDN = "\\";
        } else {
            int n2 = string.lastIndexOf(92, n - 1);
            if (n2 == -1) {
                throw new VRTestException(Errors.badPath(string));
            }
            this.containerName = string.substring(n2 + 1, n);
            int n3 = string.indexOf(92);
            this.containerDN = string.substring(n3, n);
            n = n2;
            n2 = string.indexOf(92);
            this.containerPath = string.substring(n2, n + 1);
        }
    }
}

