/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.PublicationShim;
import com.novell.nds.dirxml.driver.XmlCommandProcessor;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.vrtest.CommonImpl;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestClassFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestDriverFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestDriverShim;
import com.novell.nds.dirxml.driver.vrtest.VRTestModifiedObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestNotification;
import com.novell.nds.dirxml.driver.vrtest.VRTestObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestPathParser;
import com.novell.nds.dirxml.driver.vrtest.VRTestRootObject;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.StateParent;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAddAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAddElement;
import com.novell.nds.dirxml.driver.xds.XDSAddValueElement;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSDeleteElement;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSModifyAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyElement;
import com.novell.nds.dirxml.driver.xds.XDSMoveElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryDocument;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement;
import com.novell.nds.dirxml.driver.xds.XDSRenameElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import com.novell.nds.dirxml.vrtest.VRTestAction;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestEventType;
import com.novell.nds.dirxml.vrtest.VRTestException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class VRTestPublicationShim
extends CommonImpl
implements PublicationShim,
XmlQueryProcessor,
VRTestConstants {
    private static final String TRACE_SUFFIX = "Publisher";
    private static final int NO_OF_PARAMS = 5;
    private static final String TAG_ALLOW_LOOPBACK = "allow-loopback";
    private static final String TAG_USE_FILTER = "use-filter";
    private static final String TAG_SAVE_STATE = "save-state-each-event";
    private static final String TAG_MODIFY_ALL = "modify-all";
    private static final int RECONNECT_WAIT_MILLIS = 10000;
    private boolean running;
    private VRTestDriverFilter filter;
    private Map pubParams;
    private VRTestDriverShim driver;
    private Thread thread;
    private boolean allowLoopBack;
    private boolean useFilter;
    private boolean saveState;
    private boolean modifyAll;

    public VRTestPublicationShim(VRTestDriverShim vRTestDriverShim) {
        this.driver = vRTestDriverShim;
        this.setAPI(this.driver.getAPI());
        this.setDriverRDN(this.driver.getDriverRDN());
        this.setDriverParams(this.driver.getDriverParams());
        this.setTrace(TRACE_SUFFIX);
        this.setPubParams();
        this.running = false;
        this.thread = null;
    }

    private void setPubParams() {
        this.pubParams = new HashMap(5);
        Parameter parameter = new Parameter(TAG_ALLOW_LOOPBACK, "no", DataType.BOOLEAN);
        this.pubParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_USE_FILTER, "yes", DataType.BOOLEAN);
        this.pubParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_SAVE_STATE, "no", DataType.BOOLEAN);
        this.pubParams.put(parameter.tagName(), parameter);
        parameter = new Parameter(TAG_MODIFY_ALL, "no", DataType.BOOLEAN);
        this.pubParams.put(parameter.tagName(), parameter);
        parameter = new Parameter("run-count", "0", DataType.LONG);
        parameter.add((Constraint)RangeConstraint.POSITIVE);
        this.pubParams.put(parameter.tagName(), parameter);
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        this.trace.trace("init", 1);
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        try {
            XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
            xDSInitDocument.parameters(this.pubParams);
            Parameter parameter = (Parameter)this.pubParams.get("run-count");
            this.setRunCount(parameter.toLong());
            parameter.overrideValue(String.valueOf(this.getRunCount()));
            this.allowLoopBack = ((Parameter)this.pubParams.get(TAG_ALLOW_LOOPBACK)).toBoolean();
            this.useFilter = ((Parameter)this.pubParams.get(TAG_USE_FILTER)).toBoolean();
            this.saveState = ((Parameter)this.pubParams.get(TAG_SAVE_STATE)).toBoolean();
            this.modifyAll = ((Parameter)this.pubParams.get(TAG_MODIFY_ALL)).toBoolean();
            this.filter = new VRTestDriverFilter(xDSInitDocument.extractInitParamsElement().extractDriverFilterElement().domElement());
            this.appendStateInfo((StateParent)xDSResultDocument.appendInitParamsElement().appendPublisherStateElement());
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement xDSStatusElement = XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
            xDSStatusElement.parametersAppend(this.pubParams);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
        }
        return xDSResultDocument.toXML();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XmlDocument start(XmlCommandProcessor xmlCommandProcessor) {
        this.thread = Thread.currentThread();
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        XDSStatusElement xDSStatusElement = xDSResultDocument.appendStatusElement();
        try {
            block5: {
                try {
                    this.setupInitialConnection(xmlCommandProcessor, xDSStatusElement);
                    if (!this.connected) break block5;
                    this.running = true;
                    this.publish(xmlCommandProcessor);
                    xDSStatusElement.setLevel(StatusLevel.SUCCESS);
                    xDSStatusElement.setType(StatusType.DRIVER_STATUS);
                }
                catch (InterruptedException interruptedException) {
                    xDSStatusElement.setLevel(StatusLevel.SUCCESS);
                    xDSStatusElement.setType(StatusType.DRIVER_STATUS);
                    Object var7_5 = null;
                    this.disconnect();
                    return xDSResultDocument.toXML();
                }
                catch (Exception exception) {
                    xDSStatusElement.setLevel(StatusLevel.FATAL);
                    xDSStatusElement.setType(StatusType.DRIVER_STATUS);
                    xDSStatusElement.descriptionAppend(exception.getMessage());
                    xDSStatusElement.exceptionAppend(exception, true);
                    Object var7_6 = null;
                    this.disconnect();
                    return xDSResultDocument.toXML();
                }
            }
            Object var7_4 = null;
            this.disconnect();
            return xDSResultDocument.toXML();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.disconnect();
            throw throwable;
        }
    }

    private void setPublicationProperties() throws VRTestException {
        this.filter.setProperties(this.api.getSchema());
        this.api.setQueryProcessor(this);
        this.api.setLoopBack(this.allowLoopBack);
    }

    private void setupInitialConnection(XmlCommandProcessor xmlCommandProcessor, XDSStatusElement xDSStatusElement) throws InterruptedException, Exception {
        int n = 0;
        while (!this.connected) {
            try {
                this.connect();
                this.setPublicationProperties();
                this.connected = true;
                if (n <= 0) break;
                XDSCommandDocument xDSCommandDocument = this.newCommandDoc();
                xDSStatusElement = xDSCommandDocument.appendStatusElement();
                xDSStatusElement.setLevel(StatusLevel.SUCCESS);
                xDSStatusElement.setType(StatusType.APP_CONNECTION);
                xDSStatusElement.appendText("Connected.");
                xmlCommandProcessor.execute(xDSCommandDocument.toXML(), (XmlQueryProcessor)this);
                break;
            }
            catch (Exception exception) {
                if (exception instanceof VRTestException) {
                    xDSStatusElement.setLevel(StatusLevel.FATAL);
                    xDSStatusElement.setType(StatusType.DRIVER_STATUS);
                    xDSStatusElement.descriptionAppend(exception.getMessage());
                    xDSStatusElement.exceptionAppend(exception, true);
                    break;
                }
                if (exception instanceof IOException) {
                    XDSCommandDocument xDSCommandDocument = new XDSCommandDocument();
                    xDSStatusElement = xDSCommandDocument.appendStatusElement();
                    xDSStatusElement.setLevel(StatusLevel.WARNING);
                    xDSStatusElement.setType(StatusType.APP_CONNECTION);
                    xDSStatusElement.descriptionAppend("Unable to connect.");
                    xDSStatusElement.exceptionAppend(exception, false);
                    xmlCommandProcessor.execute(xDSCommandDocument.toXML(), (XmlQueryProcessor)this);
                    Thread.sleep(10000L);
                    ++n;
                    continue;
                }
                throw exception;
            }
        }
    }

    private void publish(XmlCommandProcessor xmlCommandProcessor) throws InterruptedException, Exception {
        while (this.running) {
            StatusAttributes statusAttributes;
            XDSCommandDocument xDSCommandDocument = this.newCommandDoc();
            try {
                if (!this.connected) {
                    this.connect();
                    this.setPublicationProperties();
                    this.connected = true;
                    statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.APP_CONNECTION, null);
                    XDSUtil.appendStatus((StatusDocument)xDSCommandDocument, (StatusAttributes)statusAttributes, (String)"Connected.");
                    xmlCommandProcessor.execute(xDSCommandDocument.toXML(), (XmlQueryProcessor)this);
                    xDSCommandDocument = this.newCommandDoc();
                }
                VRTestNotification vRTestNotification = this.api.waitForNotification(xmlCommandProcessor, this.trace);
                this.publishNotification(vRTestNotification, xmlCommandProcessor, xDSCommandDocument);
            }
            catch (Exception exception) {
                xDSCommandDocument.empty();
                statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.APP_GENERAL, null);
                if (exception instanceof VRTestException) {
                    XDSUtil.appendStatus((StatusDocument)xDSCommandDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)false, null);
                    xmlCommandProcessor.execute(xDSCommandDocument.toXML(), (XmlQueryProcessor)this);
                    continue;
                }
                if (exception instanceof IOException) {
                    if (this.running) {
                        statusAttributes.setLevel(StatusLevel.WARNING);
                        statusAttributes.setType(StatusType.APP_CONNECTION);
                        XDSUtil.appendStatus((StatusDocument)xDSCommandDocument, (StatusAttributes)statusAttributes, (String)this.getConnectHeader(), (Exception)exception, (boolean)false, null);
                        xmlCommandProcessor.execute(xDSCommandDocument.toXML(), (XmlQueryProcessor)this);
                        Thread.sleep(10000L);
                    }
                    this.connected = false;
                    continue;
                }
                throw exception;
            }
        }
    }

    private void publishNotification(VRTestNotification vRTestNotification, XmlCommandProcessor xmlCommandProcessor, XDSCommandDocument xDSCommandDocument) throws VRTestException, IOException {
        VRTestModifiedObject vRTestModifiedObject = vRTestNotification.getObject();
        String string = vRTestModifiedObject.getClassName();
        VRTestClassFilter vRTestClassFilter = this.filter.getClassFilter(string);
        if (vRTestClassFilter == null && this.useFilter) {
            this.trace.trace("Filtered Class:  " + string);
        } else {
            VRTestEventType vRTestEventType;
            if (vRTestClassFilter != null) {
                string = vRTestClassFilter.getClassName().toString();
            }
            if ((vRTestEventType = vRTestNotification.getType()) == VRTestEventType.CREATE) {
                this.appendAddElement(xDSCommandDocument, vRTestModifiedObject, vRTestClassFilter, string);
            } else if (vRTestEventType == VRTestEventType.MODIFY) {
                this.appendMoveModifyORRenameElement(xDSCommandDocument, vRTestModifiedObject, vRTestClassFilter, string);
            } else if (vRTestEventType == VRTestEventType.DELETE) {
                this.appendDeleteElement(xDSCommandDocument, vRTestModifiedObject, string);
            } else {
                XDSStatusElement xDSStatusElement = xDSCommandDocument.appendStatusElement();
                xDSStatusElement.setLevel(StatusLevel.WARNING);
                xDSStatusElement.appendText(Errors.unsupportedEventType(vRTestEventType.toString()));
            }
            this.publishNotificationDocument(xDSCommandDocument, xmlCommandProcessor);
        }
    }

    private void appendAddElement(XDSCommandDocument xDSCommandDocument, VRTestModifiedObject vRTestModifiedObject, VRTestClassFilter vRTestClassFilter, String string) throws VRTestException, IOException {
        XDSAddElement xDSAddElement = xDSCommandDocument.appendAddElement();
        xDSAddElement.setClassName(string);
        xDSAddElement.setSrcDN(vRTestModifiedObject.getDN());
        String string2 = vRTestModifiedObject.extractAssociationText();
        xDSAddElement.appendAssociationElement(string2);
        this.appendAddAttrElements(xDSAddElement, vRTestModifiedObject, vRTestClassFilter, string);
    }

    private void appendMoveModifyORRenameElement(XDSCommandDocument xDSCommandDocument, VRTestModifiedObject vRTestModifiedObject, VRTestClassFilter vRTestClassFilter, String string) throws VRTestException, IOException {
        String string2;
        boolean bl = true;
        String string3 = vRTestModifiedObject.getNamingAttributeSchema().toString();
        if (vRTestClassFilter != null) {
            string3 = vRTestClassFilter.getFilterName(string3);
            if (this.useFilter && string3 == null) {
                bl = false;
            }
        }
        LinkedList linkedList = new LinkedList();
        if (bl && vRTestModifiedObject.renamed(linkedList)) {
            if (vRTestModifiedObject.getNamingAttributeSchema().isMultiValued()) {
                this.appendRenameElement(xDSCommandDocument, vRTestModifiedObject, string, vRTestModifiedObject.getName());
                if (linkedList.size() != 0 && !this.modifyAll) {
                    this.appendOtherNames(xDSCommandDocument, vRTestModifiedObject, string, string3);
                    vRTestModifiedObject.removeCurrent();
                }
            } else {
                this.appendRenameElement(xDSCommandDocument, vRTestModifiedObject, string, (String)linkedList.getFirst());
                vRTestModifiedObject.removeCurrent();
            }
        }
        if ((string2 = vRTestModifiedObject.getNewPath()) != null) {
            this.appendMoveElement(xDSCommandDocument, vRTestModifiedObject, string, string2);
        }
        if (vRTestModifiedObject.hasMoreModifiedAttributes()) {
            this.appendModifyElement(xDSCommandDocument, vRTestModifiedObject, vRTestClassFilter, string);
        }
    }

    private void appendOtherNames(XDSCommandDocument xDSCommandDocument, VRTestObject vRTestObject, String string, String string2) throws IOException, VRTestException {
        LinkedList linkedList = vRTestObject.getOtherNames();
        if (linkedList != null) {
            XDSModifyElement xDSModifyElement = xDSCommandDocument.appendModifyElement();
            xDSModifyElement.setClassName(string);
            xDSModifyElement.setSrcDN(vRTestObject.getDN());
            xDSModifyElement.appendAssociationElement(vRTestObject.extractAssociationText());
            XDSModifyAttrElement xDSModifyAttrElement = xDSModifyElement.appendModifyAttrElement();
            xDSModifyAttrElement.setAttrName(string2);
            xDSModifyAttrElement.appendRemoveAllValuesElement();
            XDSAddValueElement xDSAddValueElement = xDSModifyAttrElement.appendAddValueElement();
            ListIterator listIterator = linkedList.listIterator();
            while (listIterator.hasNext()) {
                xDSAddValueElement.appendValueElement((String)listIterator.next());
            }
        }
    }

    private void appendDeleteElement(XDSCommandDocument xDSCommandDocument, VRTestModifiedObject vRTestModifiedObject, String string) throws VRTestException, IOException {
        XDSDeleteElement xDSDeleteElement = xDSCommandDocument.appendDeleteElement();
        xDSDeleteElement.setClassName(string);
        xDSDeleteElement.appendAssociationElement(vRTestModifiedObject.extractAssociationText());
    }

    private void appendModifyElement(XDSCommandDocument xDSCommandDocument, VRTestModifiedObject vRTestModifiedObject, VRTestClassFilter vRTestClassFilter, String string) throws VRTestException, IOException {
        XDSModifyElement xDSModifyElement = xDSCommandDocument.appendModifyElement();
        xDSModifyElement.setClassName(string);
        xDSModifyElement.setSrcDN(vRTestModifiedObject.getDN());
        xDSModifyElement.appendAssociationElement(vRTestModifiedObject.extractAssociationText());
        this.appendModifyAttrElements(xDSModifyElement, vRTestModifiedObject, vRTestClassFilter);
    }

    private void appendModifyAttrElements(XDSModifyElement xDSModifyElement, VRTestModifiedObject vRTestModifiedObject, VRTestClassFilter vRTestClassFilter) throws VRTestException, IOException {
        XDSModifyAttrElement xDSModifyAttrElement;
        LinkedList<String> linkedList;
        List list = this.modifyAll ? vRTestModifiedObject.getAttributes() : vRTestModifiedObject.getModifiedAttributes();
        HashMap<String, LinkedList<String>> hashMap = null;
        VRTestClassSchema vRTestClassSchema = vRTestModifiedObject.getClassSchema();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            VRTestAttributeSchema vRTestAttributeSchema;
            VRTestAttribute vRTestAttribute = (VRTestAttribute)listIterator.next();
            String string = vRTestAttribute.getName();
            String string2 = null;
            if (this.useFilter && (string2 = vRTestClassFilter.getFilterName(string)) == null) {
                this.trace.trace("Filtered Attribute:  " + string);
                continue;
            }
            if (string2 != null) {
                string = string2;
            }
            if ((vRTestAttributeSchema = vRTestClassSchema.getAttributeSchema(string)) == null) {
                throw new VRTestException(Errors.noAttributeSchema(string));
            }
            if (this.modifyAll) {
                if (hashMap == null) {
                    hashMap = new HashMap<String, LinkedList<String>>();
                }
                if ((linkedList = (LinkedList)hashMap.get(string)) == null) {
                    linkedList = new LinkedList<String>();
                    hashMap.put(string, linkedList);
                }
                linkedList.add(vRTestAttribute.getValue());
                continue;
            }
            xDSModifyAttrElement = xDSModifyElement.appendModifyAttrElement();
            xDSModifyAttrElement.setAttrName(string);
            this.appendValueElement(xDSModifyAttrElement, vRTestAttribute, vRTestAttributeSchema);
        }
        if (this.modifyAll && hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                linkedList = (LinkedList<String>)hashMap.get(string);
                ListIterator listIterator2 = linkedList.listIterator();
                xDSModifyAttrElement = xDSModifyElement.appendModifyAttrElement();
                xDSModifyAttrElement.setAttrName(string);
                xDSModifyAttrElement.appendRemoveAllValuesElement();
                XDSAddValueElement xDSAddValueElement = xDSModifyAttrElement.appendAddValueElement();
                while (listIterator2.hasNext()) {
                    String string3 = (String)listIterator2.next();
                    xDSAddValueElement.appendValueElement(string3);
                }
            }
        }
    }

    private void appendValueElement(XDSModifyAttrElement xDSModifyAttrElement, VRTestAttribute vRTestAttribute, VRTestAttributeSchema vRTestAttributeSchema) {
        boolean bl = vRTestAttribute.hasAction(VRTestAction.ADD);
        if (bl && !vRTestAttributeSchema.isMultiValued()) {
            xDSModifyAttrElement.appendRemoveAllValuesElement();
        }
        if (bl) {
            XDSAddValueElement xDSAddValueElement = xDSModifyAttrElement.appendAddValueElement();
            xDSAddValueElement.appendValueElement(vRTestAttribute.getValue());
        } else {
            XDSRemoveValueElement xDSRemoveValueElement = xDSModifyAttrElement.appendRemoveValueElement();
            xDSRemoveValueElement.appendValueElement(vRTestAttribute.getValue());
        }
    }

    private void appendRenameElement(XDSCommandDocument xDSCommandDocument, VRTestModifiedObject vRTestModifiedObject, String string, String string2) throws VRTestException, IOException {
        XDSRenameElement xDSRenameElement = xDSCommandDocument.appendRenameElement();
        xDSRenameElement.setClassName(string);
        xDSRenameElement.setRemoveOldName(true);
        xDSRenameElement.setSrcDN(vRTestModifiedObject.getDN());
        xDSRenameElement.appendAssociationElement(vRTestModifiedObject.extractAssociationText());
        xDSRenameElement.appendNewNameElement(string2);
    }

    private void appendMoveElement(XDSCommandDocument xDSCommandDocument, VRTestModifiedObject vRTestModifiedObject, String string, String string2) throws VRTestException, IOException {
        String string3;
        XDSMoveElement xDSMoveElement = xDSCommandDocument.appendMoveElement();
        xDSMoveElement.setClassName(string);
        xDSMoveElement.setSrcDN(vRTestModifiedObject.getDN());
        xDSMoveElement.appendAssociationElement(vRTestModifiedObject.extractAssociationText());
        VRTestPathParser vRTestPathParser = new VRTestPathParser(string2);
        XDSParentElement xDSParentElement = xDSMoveElement.appendParentElement();
        xDSParentElement.setSrcDN(vRTestPathParser.getContainerDN());
        VRTestRootObject vRTestRootObject = this.api.getRootObject();
        String string4 = vRTestPathParser.getContainerName();
        if (vRTestRootObject.hasName(string4)) {
            string3 = vRTestRootObject.extractAssociationText();
        } else {
            VRTestObject vRTestObject = this.api.getObjectByNameANDPath(string4, vRTestPathParser.getContainerPath());
            string3 = vRTestObject.extractAssociationText();
        }
        xDSParentElement.appendAssociationElement(string3);
    }

    public XmlDocument query(XmlDocument xmlDocument) {
        this.trace.trace("query", 1);
        XDSQueryResultDocument xDSQueryResultDocument = new XDSQueryResultDocument();
        this.appendSourceInfo((WriteableDocument)xDSQueryResultDocument);
        String string = null;
        try {
            XDSQueryDocument xDSQueryDocument = new XDSQueryDocument(xmlDocument);
            ListIterator listIterator = xDSQueryDocument.extractQueryElements().listIterator();
            while (listIterator.hasNext()) {
                XDSQueryElement xDSQueryElement = (XDSQueryElement)listIterator.next();
                string = xDSQueryElement.getEventID();
                this.queryHandler(xDSQueryElement, (QueryResultDocument)xDSQueryResultDocument);
                StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)string);
                XDSUtil.appendStatus((StatusDocument)xDSQueryResultDocument, (StatusAttributes)statusAttributes, null);
            }
        }
        catch (XDSException xDSException) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)xDSQueryResultDocument, (StatusAttributes)statusAttributes, null, (Exception)((Object)xDSException), (boolean)false, (XmlDocument)xmlDocument);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                this.connected = false;
            }
            xDSQueryResultDocument.empty();
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, string);
            XDSUtil.appendStatus((StatusDocument)xDSQueryResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)true, (XmlDocument)xmlDocument);
        }
        return xDSQueryResultDocument.toXML();
    }

    void shutdown() {
        this.running = false;
        this.thread.interrupt();
        this.api.closeConnection();
    }

    private void publishNotificationDocument(XDSCommandDocument xDSCommandDocument, XmlCommandProcessor xmlCommandProcessor) {
        if (!xDSCommandDocument.isEmpty()) {
            if (this.saveState) {
                this.appendStateInfo((StateParent)xDSCommandDocument.appendInitParamsElement().appendPublisherStateElement());
            }
            xmlCommandProcessor.execute(xDSCommandDocument.toXML(), (XmlQueryProcessor)this);
        }
    }

    private void appendAddAttrElements(XDSAddElement xDSAddElement, VRTestModifiedObject vRTestModifiedObject, VRTestClassFilter vRTestClassFilter, String string) {
        ListIterator listIterator = vRTestModifiedObject.getModifiedAttributes().listIterator();
        while (listIterator.hasNext()) {
            VRTestAttribute vRTestAttribute = (VRTestAttribute)listIterator.next();
            String string2 = vRTestAttribute.getName();
            String string3 = null;
            if (this.useFilter && (string3 = vRTestClassFilter.getFilterName(string2)) == null) {
                this.trace.trace("Filtered Attribute:  " + string2);
                continue;
            }
            if (string3 != null) {
                string2 = string3;
            }
            XDSAddAttrElement xDSAddAttrElement = xDSAddElement.appendAddAttrElement();
            xDSAddAttrElement.setAttrName(string2);
            xDSAddAttrElement.appendValueElement(vRTestAttribute.getValue());
        }
    }
}

