/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver.vrtest;

import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.driver.XmlQueryProcessor;
import com.novell.nds.dirxml.driver.vrtest.CommonImpl;
import com.novell.nds.dirxml.driver.vrtest.Constants;
import com.novell.nds.dirxml.driver.vrtest.Errors;
import com.novell.nds.dirxml.driver.vrtest.VRTestAddAttributes;
import com.novell.nds.dirxml.driver.vrtest.VRTestAttributeFilter;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNParser;
import com.novell.nds.dirxml.driver.vrtest.VRTestDNType;
import com.novell.nds.dirxml.driver.vrtest.VRTestDriverShim;
import com.novell.nds.dirxml.driver.vrtest.VRTestModifyAttributes;
import com.novell.nds.dirxml.driver.vrtest.VRTestObject;
import com.novell.nds.dirxml.driver.vrtest.VRTestRootObject;
import com.novell.nds.dirxml.driver.xds.CommandElement;
import com.novell.nds.dirxml.driver.xds.Constraint;
import com.novell.nds.dirxml.driver.xds.DataType;
import com.novell.nds.dirxml.driver.xds.Parameter;
import com.novell.nds.dirxml.driver.xds.QueryResultDocument;
import com.novell.nds.dirxml.driver.xds.RangeConstraint;
import com.novell.nds.dirxml.driver.xds.StateParent;
import com.novell.nds.dirxml.driver.xds.StatusDocument;
import com.novell.nds.dirxml.driver.xds.StatusLevel;
import com.novell.nds.dirxml.driver.xds.StatusType;
import com.novell.nds.dirxml.driver.xds.ValueElementsParent;
import com.novell.nds.dirxml.driver.xds.ValueType;
import com.novell.nds.dirxml.driver.xds.WriteableDocument;
import com.novell.nds.dirxml.driver.xds.XDSAddAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSAddAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSAddElement;
import com.novell.nds.dirxml.driver.xds.XDSAddValueElement;
import com.novell.nds.dirxml.driver.xds.XDSCommandDocument;
import com.novell.nds.dirxml.driver.xds.XDSCommandResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSDeleteElement;
import com.novell.nds.dirxml.driver.xds.XDSElement;
import com.novell.nds.dirxml.driver.xds.XDSException;
import com.novell.nds.dirxml.driver.xds.XDSInitDocument;
import com.novell.nds.dirxml.driver.xds.XDSModifyAttrElement;
import com.novell.nds.dirxml.driver.xds.XDSModifyElement;
import com.novell.nds.dirxml.driver.xds.XDSMoveElement;
import com.novell.nds.dirxml.driver.xds.XDSParentElement;
import com.novell.nds.dirxml.driver.xds.XDSQueryElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAllValuesElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveAssociationElement;
import com.novell.nds.dirxml.driver.xds.XDSRemoveValueElement;
import com.novell.nds.dirxml.driver.xds.XDSRenameElement;
import com.novell.nds.dirxml.driver.xds.XDSResultDocument;
import com.novell.nds.dirxml.driver.xds.XDSStatusElement;
import com.novell.nds.dirxml.driver.xds.XDSValueElement;
import com.novell.nds.dirxml.driver.xds.util.StatusAttributes;
import com.novell.nds.dirxml.driver.xds.util.XDSUtil;
import com.novell.nds.dirxml.vrtest.VRTestAttribute;
import com.novell.nds.dirxml.vrtest.VRTestAttributeSchema;
import com.novell.nds.dirxml.vrtest.VRTestClassSchema;
import com.novell.nds.dirxml.vrtest.VRTestConstants;
import com.novell.nds.dirxml.vrtest.VRTestException;
import com.novell.nds.dirxml.vrtest.VRTestSchema;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Element;

public class VRTestSubscriptionShim
extends CommonImpl
implements SubscriptionShim,
VRTestConstants,
Constants {
    private static final String TRACE_SUFFIX = "Subscriber";
    private static final int NO_OF_PARAMS = 1;
    private static final String DRIVER_ID_VALUE = "VRTEST";
    private static final String DRIVER_MIN_ACTIVATION_VERSION = "0";
    private Map subParams;
    private VRTestDriverShim driver;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSAddElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSModifyElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSRenameElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSMoveElement;
    static /* synthetic */ Class class$com$novell$nds$dirxml$driver$xds$XDSQueryElement;

    private static boolean unsupportedType(ValueType valueType) {
        return valueType == ValueType.OCTET || valueType == ValueType.STRUCTURED;
    }

    public VRTestSubscriptionShim(VRTestDriverShim vRTestDriverShim) {
        this.driver = vRTestDriverShim;
        this.setAPI(this.driver.getAPI());
        this.setDriverRDN(this.driver.getDriverRDN());
        this.setDriverParams(this.driver.getDriverParams());
        this.setTrace(TRACE_SUFFIX);
        this.setSubParams();
    }

    private void setSubParams() {
        this.subParams = new HashMap(1);
        Parameter parameter = new Parameter("run-count", DRIVER_MIN_ACTIVATION_VERSION, DataType.LONG);
        parameter.add((Constraint)RangeConstraint.POSITIVE);
        this.subParams.put(parameter.tagName(), parameter);
    }

    public XmlDocument init(XmlDocument xmlDocument) {
        this.trace.trace("init", 1);
        XDSResultDocument xDSResultDocument = this.newResultDoc();
        try {
            XDSInitDocument xDSInitDocument = new XDSInitDocument(xmlDocument);
            xDSInitDocument.parameters(this.subParams);
            Parameter parameter = (Parameter)this.subParams.get("run-count");
            this.setRunCount(parameter.toLong());
            parameter.overrideValue(String.valueOf(this.getRunCount()));
            this.appendStateInfo((StateParent)xDSResultDocument.appendInitParamsElement().appendSubscriberStateElement());
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSStatusElement xDSStatusElement = XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null);
            xDSStatusElement.parametersAppend(this.subParams);
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, null);
            XDSUtil.appendStatus((StatusDocument)xDSResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)XDSUtil.appendStackTrace((Exception)exception), (XmlDocument)xmlDocument);
        }
        return xDSResultDocument.toXML();
    }

    public XmlDocument execute(XmlDocument xmlDocument, XmlQueryProcessor xmlQueryProcessor) {
        this.trace.trace("execute", 1);
        XDSCommandResultDocument xDSCommandResultDocument = new XDSCommandResultDocument();
        this.appendSourceInfo((WriteableDocument)xDSCommandResultDocument);
        String string = null;
        try {
            XDSCommandDocument xDSCommandDocument = new XDSCommandDocument(xmlDocument);
            if (xDSCommandDocument.containsIdentityQuery()) {
                XDSQueryElement xDSQueryElement = xDSCommandDocument.identityQuery();
                this.appendDriverIdentityInfo(xDSCommandResultDocument);
                StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)xDSQueryElement.getEventID());
                XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, null);
            } else {
                this.connect();
                this.connected = true;
                ListIterator listIterator = xDSCommandDocument.childElements().listIterator();
                while (listIterator.hasNext()) {
                    CommandElement commandElement = (CommandElement)listIterator.next();
                    string = commandElement.getEventID();
                    this.dispatch(commandElement, xDSCommandResultDocument);
                    StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.SUCCESS, (StatusType)StatusType.DRIVER_GENERAL, (String)string);
                    XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, null);
                }
            }
        }
        catch (XDSException xDSException) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.DRIVER_GENERAL, null);
            XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, null, (Exception)((Object)xDSException), (boolean)false, (XmlDocument)xmlDocument);
        }
        catch (VRTestException vRTestException) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.ERROR, (StatusType)StatusType.APP_GENERAL, string);
            XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, null, (Exception)((Object)vRTestException), (boolean)false, null);
        }
        catch (IOException iOException) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.RETRY, (StatusType)StatusType.APP_CONNECTION, string);
            XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, (String)this.getConnectHeader(), (Exception)iOException, (boolean)false, null);
            this.connected = false;
        }
        catch (Exception exception) {
            StatusAttributes statusAttributes = StatusAttributes.factory((StatusLevel)StatusLevel.FATAL, (StatusType)StatusType.DRIVER_STATUS, string);
            XDSUtil.appendStatus((StatusDocument)xDSCommandResultDocument, (StatusAttributes)statusAttributes, null, (Exception)exception, (boolean)true, (XmlDocument)xmlDocument);
        }
        return xDSCommandResultDocument.toXML();
    }

    private void dispatch(CommandElement commandElement, XDSCommandResultDocument xDSCommandResultDocument) throws VRTestException, IOException {
        this.trace.trace("dispatch", 1);
        Class<?> clazz = commandElement.getClass();
        if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSAddElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSAddElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSAddElement")) : class$com$novell$nds$dirxml$driver$xds$XDSAddElement)) {
            this.addHandler((XDSAddElement)commandElement, xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSModifyElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSModifyElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSModifyElement")) : class$com$novell$nds$dirxml$driver$xds$XDSModifyElement)) {
            this.modifyHandler((XDSModifyElement)commandElement, xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSDeleteElement")) : class$com$novell$nds$dirxml$driver$xds$XDSDeleteElement)) {
            this.deleteHandler((XDSDeleteElement)commandElement, xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSRenameElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSRenameElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSRenameElement")) : class$com$novell$nds$dirxml$driver$xds$XDSRenameElement)) {
            this.renameHandler((XDSRenameElement)commandElement, xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSMoveElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSMoveElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSMoveElement")) : class$com$novell$nds$dirxml$driver$xds$XDSMoveElement)) {
            this.moveHandler((XDSMoveElement)commandElement, xDSCommandResultDocument);
        } else if (clazz == (class$com$novell$nds$dirxml$driver$xds$XDSQueryElement == null ? (class$com$novell$nds$dirxml$driver$xds$XDSQueryElement = VRTestSubscriptionShim.class$("com.novell.nds.dirxml.driver.xds.XDSQueryElement")) : class$com$novell$nds$dirxml$driver$xds$XDSQueryElement)) {
            this.queryHandler((XDSQueryElement)commandElement, (QueryResultDocument)xDSCommandResultDocument);
        } else {
            this.trace.trace("unhandled element:  " + commandElement.tagName(), 3);
        }
    }

    private void addHandler(XDSAddElement xDSAddElement, XDSCommandResultDocument xDSCommandResultDocument) throws VRTestException, IOException {
        Object object;
        VRTestSchema vRTestSchema = this.api.getSchema();
        VRTestClassSchema vRTestClassSchema = vRTestSchema.getClassSchema(xDSAddElement.getClassName());
        if (vRTestClassSchema == null) {
            throw new VRTestException(Errors.noClassSchema(xDSAddElement.getClassName()));
        }
        String string = xDSAddElement.getSrcDN();
        if (string == null) {
            throw new VRTestException(Errors.noAttributeValue("src-dn"));
        }
        VRTestAddAttributes vRTestAddAttributes = new VRTestAddAttributes();
        if (vRTestSchema.isHierarchical()) {
            object = VRTestDNParser.ParseObjectPath(string, VRTestDNType.EDIR);
            vRTestAddAttributes.addAttribute("Object Path", (String)object);
        }
        object = vRTestClassSchema.getNamingAttributeSchema();
        this.ToVRTestAttributes(xDSAddElement.extractAddAttrElements(), vRTestAddAttributes, (VRTestAttributeSchema)object, vRTestClassSchema, (StatusDocument)xDSCommandResultDocument);
        VRTestObject vRTestObject = this.api.createObject(vRTestClassSchema.getName(), vRTestAddAttributes);
        XDSAddAssociationElement xDSAddAssociationElement = xDSCommandResultDocument.appendAddAssociationElement();
        xDSAddAssociationElement.setDestDN(string);
        xDSAddAssociationElement.appendText(vRTestObject.extractAssociationText());
    }

    private void ToVRTestAttributes(List list, VRTestAddAttributes vRTestAddAttributes, VRTestAttributeSchema vRTestAttributeSchema, VRTestClassSchema vRTestClassSchema, StatusDocument statusDocument) throws VRTestException {
        ListIterator listIterator = list.listIterator();
        boolean bl = false;
        while (listIterator.hasNext()) {
            XDSAddAttrElement xDSAddAttrElement = (XDSAddAttrElement)listIterator.next();
            String string = xDSAddAttrElement.getAttrName();
            VRTestAttributeSchema vRTestAttributeSchema2 = vRTestClassSchema.getAttributeSchema(string);
            if (vRTestAttributeSchema2 == null) {
                XDSStatusElement xDSStatusElement = statusDocument.appendStatusElement();
                xDSStatusElement.setLevel(StatusLevel.WARNING);
                xDSStatusElement.appendText(Errors.noAttributeSchema(string));
                continue;
            }
            if (vRTestAttributeSchema.hasName(string)) {
                bl = true;
            }
            this.ToVRTestAttributes(xDSAddAttrElement, vRTestAddAttributes, vRTestAttributeSchema2.getName(), vRTestAttributeSchema2.isMultiValued());
        }
        if (!bl) {
            throw new VRTestException(Errors.noAddAttr(vRTestAttributeSchema.getName()));
        }
    }

    private void ToVRTestAttributes(XDSAddAttrElement xDSAddAttrElement, VRTestAddAttributes vRTestAddAttributes, String string, boolean bl) throws VRTestException {
        List list = xDSAddAttrElement.extractValueElements();
        ListIterator listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            XDSValueElement xDSValueElement = (XDSValueElement)listIterator.next();
            if (VRTestSubscriptionShim.unsupportedType(xDSValueElement.getType())) {
                throw new VRTestException("Unsupported type:  '" + xDSValueElement.getType() + "'.");
            }
            String string2 = xDSValueElement.extractText();
            vRTestAddAttributes.addAttribute(string, string2);
            if (!bl) break;
        }
    }

    private void modifyHandler(XDSModifyElement xDSModifyElement, XDSCommandResultDocument xDSCommandResultDocument) throws VRTestException, IOException {
        VRTestObject vRTestObject;
        String string = xDSModifyElement.extractAssociationText();
        String string2 = null;
        VRTestClassSchema vRTestClassSchema = this.api.getSchema().getClassSchema(xDSModifyElement.getClassName());
        if (vRTestClassSchema != null) {
            string2 = vRTestClassSchema.getName();
        }
        if ((vRTestObject = this.api.getObjectByAssociation(string, string2)) == null) {
            XDSRemoveAssociationElement xDSRemoveAssociationElement = xDSCommandResultDocument.appendRemoveAssociationElement();
            xDSRemoveAssociationElement.appendText(string);
            return;
        }
        VRTestModifyAttributes vRTestModifyAttributes = new VRTestModifyAttributes();
        VRTestSubscriptionShim.ToVRTestAttributes(vRTestModifyAttributes, xDSModifyElement, vRTestObject, vRTestClassSchema, (StatusDocument)xDSCommandResultDocument);
        this.api.modifyObject(vRTestObject, vRTestModifyAttributes);
    }

    private static void ToVRTestAttributes(VRTestModifyAttributes vRTestModifyAttributes, XDSModifyElement xDSModifyElement, VRTestObject vRTestObject, VRTestClassSchema vRTestClassSchema, StatusDocument statusDocument) throws VRTestException, IOException {
        ListIterator listIterator = xDSModifyElement.extractModifyAttrElements().listIterator();
        while (listIterator.hasNext()) {
            XDSModifyAttrElement xDSModifyAttrElement = (XDSModifyAttrElement)listIterator.next();
            String string = xDSModifyAttrElement.getAttrName();
            VRTestAttributeSchema vRTestAttributeSchema = vRTestClassSchema.getAttributeSchema(string);
            if (vRTestAttributeSchema == null) {
                XDSStatusElement xDSStatusElement = statusDocument.appendStatusElement();
                xDSStatusElement.setLevel(StatusLevel.WARNING);
                xDSStatusElement.appendText(Errors.noAttributeSchema(string));
                continue;
            }
            VRTestSubscriptionShim.ToVRTestAttributes(vRTestModifyAttributes, xDSModifyAttrElement, vRTestObject, vRTestAttributeSchema);
        }
    }

    private static void ToVRTestAttributes(VRTestModifyAttributes vRTestModifyAttributes, XDSModifyAttrElement xDSModifyAttrElement, VRTestObject vRTestObject, VRTestAttributeSchema vRTestAttributeSchema) throws VRTestException, IOException {
        String string = vRTestAttributeSchema.getName();
        ListIterator listIterator = xDSModifyAttrElement.childElements().listIterator();
        while (listIterator.hasNext()) {
            XDSElement xDSElement = (XDSElement)listIterator.next();
            if (xDSElement instanceof XDSRemoveAllValuesElement) {
                VRTestSubscriptionShim.ToVRTestAttributes(vRTestModifyAttributes, vRTestObject, string);
                continue;
            }
            if (xDSElement instanceof XDSRemoveValueElement) {
                VRTestSubscriptionShim.ToVRTestAttributes(vRTestModifyAttributes, (XDSRemoveValueElement)xDSElement, string);
                continue;
            }
            if (!(xDSElement instanceof XDSAddValueElement)) continue;
            CommonImpl.ToVRTestAttributes(vRTestModifyAttributes, (ValueElementsParent)((XDSAddValueElement)xDSElement), string);
        }
    }

    private static void ToVRTestAttributes(VRTestModifyAttributes vRTestModifyAttributes, VRTestObject vRTestObject, String string) throws VRTestException, IOException {
        VRTestAttributeFilter vRTestAttributeFilter = new VRTestAttributeFilter();
        vRTestAttributeFilter.addAttribute(string, VRTestAttribute.ANY_VALUE);
        ListIterator listIterator = vRTestObject.getAttributes(vRTestAttributeFilter).listIterator();
        while (listIterator.hasNext()) {
            VRTestAttribute vRTestAttribute = (VRTestAttribute)listIterator.next();
            vRTestModifyAttributes.removeAttribute(vRTestAttribute.getName(), vRTestAttribute.getValue());
        }
    }

    private static void ToVRTestAttributes(VRTestModifyAttributes vRTestModifyAttributes, XDSRemoveValueElement xDSRemoveValueElement, String string) throws VRTestException {
        ListIterator listIterator = xDSRemoveValueElement.extractValueElements().listIterator();
        while (listIterator.hasNext()) {
            XDSValueElement xDSValueElement = (XDSValueElement)listIterator.next();
            if (VRTestSubscriptionShim.unsupportedType(xDSValueElement.getType())) {
                throw new VRTestException("Unsupported type '" + xDSValueElement.getType() + "'.");
            }
            vRTestModifyAttributes.removeAttribute(string, xDSValueElement.extractText());
        }
    }

    private void deleteHandler(XDSDeleteElement xDSDeleteElement, XDSCommandResultDocument xDSCommandResultDocument) throws VRTestException, IOException {
        String string = xDSDeleteElement.extractAssociationText();
        String string2 = null;
        VRTestClassSchema vRTestClassSchema = this.api.getSchema().getClassSchema(xDSDeleteElement.getClassName());
        if (vRTestClassSchema != null) {
            string2 = vRTestClassSchema.getName();
        }
        this.api.deleteObject(string, string2);
        XDSRemoveAssociationElement xDSRemoveAssociationElement = xDSCommandResultDocument.appendRemoveAssociationElement();
        xDSRemoveAssociationElement.setEventID(xDSDeleteElement.getEventID());
        xDSRemoveAssociationElement.appendText(string);
    }

    void renameHandler(XDSRenameElement xDSRenameElement, XDSCommandResultDocument xDSCommandResultDocument) throws VRTestException, IOException {
        String string = xDSRenameElement.getClassName();
        if (string == null) {
            throw new VRTestException(Errors.noAttributeValue("class-name"));
        }
        VRTestObject vRTestObject = this.api.getObjectByAssociation(xDSRenameElement.extractAssociationText(), string);
        if (vRTestObject == null) {
            XDSRemoveAssociationElement xDSRemoveAssociationElement = xDSCommandResultDocument.appendRemoveAssociationElement();
            xDSRemoveAssociationElement.appendText(xDSRenameElement.extractAssociationText());
            return;
        }
        String string2 = vRTestObject.getName();
        if (string2 == null) {
            throw new VRTestException("Object missing name.");
        }
        VRTestClassSchema vRTestClassSchema = vRTestObject.getClassSchema();
        if (vRTestClassSchema == null) {
            throw new VRTestException(Errors.noClassSchema(string));
        }
        String string3 = vRTestClassSchema.getNamingAttributeSchema().getName();
        VRTestModifyAttributes vRTestModifyAttributes = new VRTestModifyAttributes();
        vRTestModifyAttributes.removeAttribute(string3, string2);
        vRTestModifyAttributes.addAttribute(string3, xDSRenameElement.extractNewNameText());
        this.api.modifyObject(vRTestObject, vRTestModifyAttributes);
    }

    void moveHandler(XDSMoveElement xDSMoveElement, XDSCommandResultDocument xDSCommandResultDocument) throws VRTestException, IOException {
        Object object;
        String string;
        XDSParentElement xDSParentElement;
        String string2;
        VRTestObject vRTestObject;
        if (!this.api.getSchema().isHierarchical()) {
            return;
        }
        String string3 = null;
        VRTestClassSchema vRTestClassSchema = this.api.getSchema().getClassSchema(xDSMoveElement.getClassName());
        if (vRTestClassSchema != null) {
            string3 = vRTestClassSchema.getName();
        }
        if ((vRTestObject = this.api.getObjectByAssociation(xDSMoveElement.extractAssociationText(), string3)) == null) {
            XDSRemoveAssociationElement xDSRemoveAssociationElement = xDSCommandResultDocument.appendRemoveAssociationElement();
            xDSRemoveAssociationElement.appendText(xDSMoveElement.extractAssociationText());
            return;
        }
        String string4 = vRTestObject.getPath();
        if (string4 == null) {
            throw new VRTestException("Object missing path.");
        }
        VRTestRootObject vRTestRootObject = this.api.getRootObject();
        if (vRTestRootObject.hasAssociation(string2 = (xDSParentElement = xDSMoveElement.extractParentElement()).extractAssociationText())) {
            string = vRTestRootObject.getChildPath();
        } else {
            object = this.api.getObjectByAssociation(string2, null);
            if (object == null) {
                XDSRemoveAssociationElement xDSRemoveAssociationElement = xDSCommandResultDocument.appendRemoveAssociationElement();
                xDSRemoveAssociationElement.appendText(string2);
                throw new VRTestException("Parent object not found.");
            }
            String string5 = ((VRTestObject)object).getDN();
            if (string5 == null) {
                throw new VRTestException("Object missing required dn.");
            }
            string = string5 + "\\";
        }
        object = new VRTestModifyAttributes();
        ((VRTestModifyAttributes)object).removeAttribute("Object Path", string4);
        ((VRTestModifyAttributes)object).addAttribute("Object Path", string);
        this.api.modifyObject(vRTestObject, (VRTestModifyAttributes)object);
    }

    private void appendDriverIdentityInfo(XDSCommandResultDocument xDSCommandResultDocument) {
        if (xDSCommandResultDocument != null) {
            String string = "<instance class-name=\"__driver_identification_class__\"><attr attr-name=\"driver-id\"><value type=\"string\">VRTEST</value></attr><attr attr-name=\"driver-version\"><value type=\"string\">1.1</value></attr><attr attr-name=\"min-activation-version\"><value type=\"string\">0</value></attr></instance>";
            XDSUtil.appendXML((Element)xDSCommandResultDocument.domIOElement(), (String)string);
        }
    }

    void shutdown() {
        this.disconnect();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

