/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class ThreadGroupLocal {
    private static final String THREAD_PROXY_GROUP = "threadProxyGroup";
    private static Hashtable threadGroupTable = new Hashtable();
    private static Hashtable threadTable = new Hashtable();

    private ThreadGroupLocal() {
    }

    private static ThreadGroup getEffectiveThreadGroup() {
        ThreadGroup threadGroup = ThreadGroupLocal.getThreadProxyGroup();
        if (threadGroup == null) {
            threadGroup = Thread.currentThread().getThreadGroup();
        }
        return threadGroup;
    }

    public static ThreadGroup getThreadProxyGroup() {
        return (ThreadGroup)ThreadGroupLocal.threadLocalGet(THREAD_PROXY_GROUP);
    }

    public static ThreadGroup setThreadProxyGroup(ThreadGroup threadGroup) {
        if (threadGroup == Thread.currentThread().getThreadGroup() || threadGroup == null) {
            ThreadGroup threadGroup2 = (ThreadGroup)ThreadGroupLocal.threadLocalGet(THREAD_PROXY_GROUP);
            ThreadGroupLocal.threadLocalRemove(THREAD_PROXY_GROUP);
            return threadGroup2;
        }
        return (ThreadGroup)ThreadGroupLocal.threadLocalPut(THREAD_PROXY_GROUP, threadGroup);
    }

    public static synchronized Object put(Object object, Object object2) {
        if (object2 == null) {
            return ThreadGroupLocal.remove(object);
        }
        Hashtable<Object, Object> hashtable = (Hashtable<Object, Object>)threadGroupTable.get(ThreadGroupLocal.getEffectiveThreadGroup());
        if (hashtable == null) {
            hashtable = new Hashtable<Object, Object>();
            threadGroupTable.put(ThreadGroupLocal.getEffectiveThreadGroup(), hashtable);
        }
        return hashtable.put(object, object2);
    }

    public static synchronized Object get(Object object) {
        ThreadGroup threadGroup = ThreadGroupLocal.getEffectiveThreadGroup();
        Object var2_2 = null;
        while (var2_2 == null && threadGroup != null) {
            Hashtable hashtable = (Hashtable)threadGroupTable.get(threadGroup);
            if (hashtable != null) {
                var2_2 = hashtable.get(object);
            }
            threadGroup = threadGroup.getParent();
        }
        return var2_2;
    }

    public static synchronized Object remove(Object object) {
        Hashtable hashtable = (Hashtable)threadGroupTable.get(ThreadGroupLocal.getEffectiveThreadGroup());
        if (hashtable != null) {
            return hashtable.remove(object);
        }
        return null;
    }

    public static synchronized void removeAll() {
        threadGroupTable.remove(ThreadGroupLocal.getEffectiveThreadGroup());
    }

    public static synchronized void cleanup() {
        ThreadGroupLocal.removeAll();
        ThreadGroup threadGroup = ThreadGroupLocal.getEffectiveThreadGroup();
        Enumeration enumeration = threadTable.keys();
        Vector<Thread> vector = new Vector<Thread>();
        while (enumeration.hasMoreElements()) {
            Thread thread = (Thread)enumeration.nextElement();
            if (thread.getThreadGroup() != threadGroup) continue;
            vector.addElement(thread);
        }
        int n = 0;
        while (n < vector.size()) {
            threadTable.remove(vector.elementAt(n));
            ++n;
        }
    }

    private static Object threadLocalPut(Object object, Object object2) {
        if (object2 == null) {
            return ThreadGroupLocal.threadLocalRemove(object);
        }
        Hashtable<Object, Object> hashtable = (Hashtable<Object, Object>)threadTable.get(Thread.currentThread());
        if (hashtable == null) {
            hashtable = new Hashtable<Object, Object>();
            threadTable.put(Thread.currentThread(), hashtable);
        }
        return hashtable.put(object, object2);
    }

    private static Object threadLocalGet(Object object) {
        Hashtable hashtable = (Hashtable)threadTable.get(Thread.currentThread());
        if (hashtable != null) {
            return hashtable.get(object);
        }
        return null;
    }

    private static Object threadLocalRemove(Object object) {
        Thread thread = Thread.currentThread();
        Object var2_2 = null;
        Hashtable hashtable = (Hashtable)threadTable.get(Thread.currentThread());
        if (hashtable != null) {
            var2_2 = hashtable.remove(object);
            if (hashtable.size() == 0) {
                threadTable.remove(thread);
            }
        }
        return var2_2;
    }
}

