/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.VRDExceptionListener;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xsl.process.ResultTreeFragment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XdsCommandProcessor {
    private com.novell.nds.dirxml.engine.XdsCommandProcessor processor;
    private Trace trace;
    private VRDExceptionListener exceptionListener;
    private static String cmdMsg;
    private static String resultMsg;
    private static final String MSG_CMD = "xcp_cmd";
    private static final String MSG_RESULT = "xcp_result";

    public XdsCommandProcessor(com.novell.nds.dirxml.engine.XdsCommandProcessor xdsCommandProcessor, VRDExceptionListener vRDExceptionListener) {
        this.processor = xdsCommandProcessor;
        this.exceptionListener = vRDExceptionListener;
        this.trace = new Trace(null);
    }

    public Document execute(Document document) throws VRDException {
        Document document2 = null;
        try {
            this.trace.trace(cmdMsg, 2);
            this.trace.trace(document, 2);
            document2 = this.processor.execute(document);
            this.trace.trace(resultMsg, 2);
            this.trace.trace(document2, 2);
            Driver.checkShimError(document2, false);
        }
        catch (VRDException vRDException) {
            if (this.exceptionListener != null) {
                this.exceptionListener.exceptionNotify(vRDException);
            }
            throw vRDException;
        }
        return document2;
    }

    public Document execute(ResultTreeFragment resultTreeFragment) throws VRDException {
        Document document = DocumentFactory.newDocument();
        Node node = XdsUtil.cloneSubtree(document, resultTreeFragment.getRoot());
        Node node2 = document;
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            if (node3 instanceof Element) {
                if (node3.getNodeName().equals("nds")) break;
                Element element = document.createElementNS(null, "nds");
                element.setAttributeNS(null, "ndsversion", "8.x");
                element.setAttributeNS(null, "dtdversion", "2.0");
                node2.appendChild(element);
                node2 = element;
                if (node3.getNodeName().equals("input")) break;
                Element element2 = document.createElementNS(null, "input");
                node2.appendChild(element2);
                node2 = element2;
                break;
            }
            node3 = node3.getNextSibling();
        }
        while ((node3 = node.getFirstChild()) != null) {
            node2.appendChild(node3);
            DOMUtil.addNamespaceDecls((Node)node3);
        }
        return this.execute(document);
    }

    static {
        LocalizedMessageSource localizedMessageSource = new LocalizedMessageSource("com.novell.nds.dirxml.driver.XdsCommandProcessor");
        cmdMsg = localizedMessageSource.getMessageString(MSG_CMD);
        resultMsg = localizedMessageSource.getMessageString(MSG_RESULT);
    }
}

