/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.driver;

import com.novell.nds.dirxml.driver.Trace;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.VRDExceptionListener;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathUtil;
import com.novell.xsl.process.ResultTreeFragment;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XdsQueryProcessor {
    private com.novell.nds.dirxml.engine.XdsQueryProcessor processor;
    private Trace trace;
    private VRDExceptionListener exceptionListener;
    private static String queryMsg;
    private static String resultMsg;
    private static final String MSG_QUERY = "xqp_query";
    private static final String MSG_RESULT = "xqp_result";

    public XdsQueryProcessor(com.novell.nds.dirxml.engine.XdsQueryProcessor xdsQueryProcessor, VRDExceptionListener vRDExceptionListener) {
        this.processor = xdsQueryProcessor;
        this.exceptionListener = vRDExceptionListener;
        this.trace = new Trace(null);
    }

    public Document query(Document document) throws VRDException {
        Document document2 = null;
        try {
            this.trace.trace(queryMsg, 2);
            this.trace.trace(document, 2);
            document2 = this.processor.query(document);
            this.trace.trace(resultMsg, 2);
            this.trace.trace(document2, 2);
            Driver.checkShimError(document2, false);
        }
        catch (VRDException vRDException) {
            if (this.exceptionListener != null) {
                this.exceptionListener.exceptionNotify(vRDException);
            }
            throw vRDException;
        }
        return document2;
    }

    public Document query(ResultTreeFragment resultTreeFragment) throws VRDException {
        Document document = DocumentFactory.newDocument();
        Node node = XdsUtil.cloneSubtree(document, resultTreeFragment.getRoot());
        Node node2 = document;
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            if (node3 instanceof Element) {
                if (node3.getNodeName().equals("nds")) break;
                Element element = document.createElementNS(null, "nds");
                element.setAttributeNS(null, "ndsversion", "8.x");
                element.setAttributeNS(null, "dtdversion", "2.0");
                node2.appendChild(element);
                node2 = element;
                if (node3.getNodeName().equals("input")) break;
                Element element2 = document.createElementNS(null, "input");
                node2.appendChild(element2);
                node2 = element2;
                break;
            }
            node3 = node3.getNextSibling();
        }
        while ((node3 = node.getFirstChild()) != null) {
            node2.appendChild(node3);
            DOMUtil.addNamespaceDecls((Node)node3);
        }
        return this.query(document);
    }

    public Element readObject(String string, String string2, String string3, String string4) throws VRDException {
        Object object;
        Element element = NdsDtd.createDoc("input");
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, "query");
        element.appendChild(element2);
        element2.setAttributeNS(null, "scope", "entry");
        if (string3 != null && string3.length() != 0) {
            element2.setAttributeNS(null, "class-name", string3);
        }
        if (string2 != null && string2.length() != 0) {
            element2.setAttributeNS(null, "dest-dn", string2);
        }
        if (string != null && string.length() != 0) {
            object = document.createElementNS(null, "association");
            element2.appendChild((Node)object);
            XdsUtil.setNodeText((Node)object, string);
        }
        if (string4 == null || string4.length() == 0) {
            object = document.createElementNS(null, "read-attr");
            element2.appendChild((Node)object);
        } else if (!string4.equals("*")) {
            object = new StringTokenizer(string4, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                Element element3 = document.createElementNS(null, "read-attr");
                element2.appendChild(element3);
                element3.setAttributeNS(null, "attr-name", ((StringTokenizer)object).nextToken().trim());
            }
        }
        object = this.query(document);
        if (object == null) {
            return null;
        }
        return XdsUtil.getFirstElementByTagNameNS((Node)object, null, "instance");
    }

    public NodeSet search(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws VRDException {
        Object object;
        Object object2;
        Element element = NdsDtd.createDoc("input");
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, "query");
        element.appendChild(element2);
        element2.setAttributeNS(null, "scope", string);
        if (string4 != null && string4.length() != 0) {
            element2.setAttributeNS(null, "class-name", string4);
        }
        if (string3 != null && string3.length() != 0) {
            element2.setAttributeNS(null, "dest-dn", string3);
        }
        if (string2 != null && string2.length() != 0) {
            object2 = document.createElementNS(null, "association");
            element2.appendChild((Node)object2);
            XdsUtil.setNodeText((Node)object2, string2);
        }
        if (string4 != null && string4.length() != 0) {
            object2 = document.createElementNS(null, "search-class");
            element2.appendChild((Node)object2);
            object2.setAttributeNS(null, "class-name", string4);
        }
        if (string5 != null && string5.length() != 0) {
            object2 = document.createElementNS(null, "search-attr");
            element2.appendChild((Node)object2);
            object2.setAttributeNS(null, "attr-name", string5);
            object = document.createElementNS(null, "value");
            object2.appendChild((Node)object);
            if (string6 != null) {
                XdsUtil.setNodeText((Node)object, string6);
            }
        }
        if (string7 == null || string7.length() == 0) {
            object2 = document.createElementNS(null, "read-attr");
            element2.appendChild((Node)object2);
        } else if (!string7.equals("*")) {
            object2 = new StringTokenizer(string7, ",");
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = document.createElementNS(null, "read-attr");
                element2.appendChild((Node)object);
                object.setAttributeNS(null, "attr-name", ((StringTokenizer)object2).nextToken().trim());
            }
        }
        object2 = this.query(document);
        object = new NodeSet();
        if (object2 != null) {
            Node node;
            NodeList nodeList = XdsUtil.getElementsByTagNameNS((Node)object2, null, "instance");
            int n = 0;
            while ((node = nodeList.item(n)) != null) {
                object.add(node);
                ++n;
            }
        }
        return object;
    }

    public String getNamedPassword(String string) throws VRDException {
        Element element;
        Element element2 = NdsDtd.createDoc("input");
        Document document = element2.getOwnerDocument();
        Element element3 = document.createElementNS(null, "get-named-password");
        element2.appendChild(element3);
        Text text = document.createTextNode(string);
        element3.appendChild(text);
        Document document2 = this.query(document);
        String string2 = null;
        if (document2 != null && (element = (Element)XdsUtil.getElementsByTagNameNS(document2, null, "password").item(0)) != null) {
            string2 = XPathUtil.getNodeValue((Node)element);
        }
        if (string2 == null) {
            string2 = new String();
        }
        return string2;
    }

    static {
        LocalizedMessageSource localizedMessageSource = new LocalizedMessageSource("com.novell.nds.dirxml.driver.XdsQueryProcessor");
        queryMsg = localizedMessageSource.getMessageString(MSG_QUERY);
        resultMsg = localizedMessageSource.getMessageString(MSG_RESULT);
    }
}

