/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.engine.CaseIgnoreStringKey;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.util.XdsDN;
import java.util.HashMap;
import org.w3c.dom.Element;

class AppSchema {
    private HashMap classMap;
    private int flags;
    private String applicationName;
    private char[] dnDelims = null;
    static final int HIERARCHICAL = 1;
    static final int CONTAINER = 1;
    static final int CASE_SENSITIVE = 1;
    static final int MULTI_VALUED = 2;
    static final int NAMING = 4;
    static final int READ_ONLY = 8;
    static final int REQUIRED = 16;
    static final int STRING = 0;
    static final int TELENUMBER = 1;
    static final int INT = 2;
    static final int STATE = 3;
    static final int COUNTER = 4;
    static final int DN = 5;
    static final int INTERVAL = 6;
    static final int OCTET = 7;
    static final int TIME = 8;
    static final int STRUCTURED = 9;
    static final String[] typeTable = new String[]{"string", "teleNumber", "int", "state", "counter", "dn", "interval", "octet", "time", "structured"};

    AppSchema(Element element) throws VRDException {
        Object object;
        this.flags = element.getAttributeNS(null, "hierarchical").equals("false") ? 0 : 1;
        this.applicationName = element.getAttributeNS(null, "application-name");
        Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "class-def");
        this.classMap = new HashMap(elementArray.length);
        int n = 0;
        while (n < elementArray.length) {
            object = new ClassDef(elementArray[n]);
            this.classMap.put(new CaseIgnoreStringKey(((ClassDef)object).className), object);
            ++n;
        }
        object = element.getAttributeNS(null, "dn-format");
        if (((String)object).length() != 0) {
            String string = XdsDN.getDelims((String)object);
            if (string == null) {
                throw new VRDException(9034, object);
            }
            this.dnDelims = string.toCharArray();
        } else {
            char[] cArray;
            String string = element.getAttributeNS(null, "dn-delims");
            if (string.length() != 0 && !XdsDN.validateDelims((char[])(cArray = string.toCharArray()))) {
                throw new VRDException(9035, (Object)cArray);
            }
        }
    }

    static String mapType(int n) {
        if (n < 0 || n >= typeTable.length) {
            return "string";
        }
        return typeTable[n];
    }

    static int mapType(String string) {
        int n = 0;
        while (n < typeTable.length) {
            if (string.equalsIgnoreCase(typeTable[n])) {
                return n;
            }
            ++n;
        }
        return 0;
    }

    ClassDef getClassDef(String string) {
        return (ClassDef)this.classMap.get(new CaseIgnoreStringKey(string));
    }

    AttrDef getAttrDef(String string, String string2) {
        ClassDef classDef = this.getClassDef(string);
        if (classDef == null) {
            return null;
        }
        return (AttrDef)classDef.attrMap.get(new CaseIgnoreStringKey(string2));
    }

    char[] getDNDelims() {
        return this.dnDelims;
    }

    static class AttrDef {
        String attrName;
        String asn1id;
        int type;
        int flags;

        AttrDef(Element element) {
            this.attrName = element.getAttributeNS(null, "attr-name");
            this.asn1id = element.getAttributeNS(null, "asn1id");
            this.type = AppSchema.mapType(element.getAttributeNS(null, "type"));
            this.flags = element.getAttributeNS(null, "case-sensitive").equals("true") ? 1 : 0;
            this.flags |= element.getAttributeNS(null, "multi-valued").equals("false") ? 0 : 2;
            this.flags |= element.getAttributeNS(null, "naming").equals("true") ? 4 : 0;
            this.flags |= element.getAttributeNS(null, "read-only").equals("true") ? 8 : 0;
            this.flags |= element.getAttributeNS(null, "required").equals("true") ? 16 : 0;
        }
    }

    static class ClassDef {
        String className;
        String asn1id;
        int flags;
        HashMap attrMap;

        ClassDef(Element element) {
            this.className = element.getAttributeNS(null, "class-name");
            this.asn1id = element.getAttributeNS(null, "asn1id");
            this.flags = element.getAttributeNS(null, "container").equals("true") ? 1 : 0;
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "attr-def");
            this.attrMap = new HashMap(elementArray.length);
            int n = 0;
            while (n < elementArray.length) {
                AttrDef attrDef = new AttrDef(elementArray[n]);
                this.attrMap.put(new CaseIgnoreStringKey(attrDef.attrName), attrDef);
                ++n;
            }
        }
    }
}

