/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.driver.DriverShim;
import com.novell.nds.dirxml.driver.SubscriptionShim;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.engine.AppSchema;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.DriverEntry;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Events;
import com.novell.nds.dirxml.engine.NativeDriverShim;
import com.novell.nds.dirxml.engine.NdsConstants;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.Publisher;
import com.novell.nds.dirxml.engine.SchemaCache;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.StringUtil;
import com.novell.nds.dirxml.engine.Subscriber;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.ThreadVars;
import com.novell.nds.dirxml.engine.Trace_DOMWriter;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.WorkManager;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.cache.Transaction;
import com.novell.nds.dirxml.engine.classloader.OurLoader;
import com.novell.nds.dirxml.engine.event.DSEEventInfo;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.nds.io.NDSStreamAttributeOutputStream;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.util.ExpandedQName;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.server.UID;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import novell.jclient.JCContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Driver {
    public static final int CHANNEL_ENGINE = 0;
    public static final int CHANNEL_SUBSCRIBER = 1;
    public static final int CHANNEL_PUBLISHER = 2;
    public static final String GCV_TREENAME = "dirxml.auto.treename";
    public static final String GCV_DRIVERDN = "dirxml.auto.driverdn";
    public static final String GCV_DRIVERGUID = "dirxml.auto.driverguid";
    protected static final String WAITING_FOR_DRIVER_INIT_FOR_SHUTDOWN = "dt_wfdifs";
    protected static final String START_TRANSACTION = "dt_sxact";
    protected static final String DISCARDING_TRANSACTION_DISABLED = "dt_ddact";
    protected static final String DISCARDING_TRANSACTION_OPTIMIZE = "dt_doact";
    protected static final String DISCARDING_TRANSACTION_DELETED = "dt_ddent";
    protected static final String PROCESSING_TRANSACTION_EVENTS = "dt_pxact";
    protected static final String END_TRANSACTION = "dt_exact";
    protected static final String SHUTTING_DOWN_DRIVER = "dt_sddrv";
    protected static final String SHIM_SHUTDOWN_RETURNED = "dt_ssdret";
    protected static final String WAITING_FOR_PUBLISHER_TERMINATION = "dt_wfpth";
    protected static final String PUBLISHER_THREAD_NO_TERMINATE = "dt_pthnt";
    protected static final String PUBLISHER_THREAD_TERMINATED = "dt_ptht";
    protected static final String LOADING_JAVA_SHIM = "dt_ljshm";
    protected static final String LOADING_NATIVE_SHIM = "dt_lnshm";
    protected static final String INIT_DRIVER_SHIM = "dt_idrvshm";
    protected static final String DRIVER_SHIM_INIT_RETURNED = "dt_idrvret";
    protected static final String CALLING_GET_SCHEMA = "dt_cdrvgs";
    protected static final String GET_SCHEMA_RETURNED = "dt_drvgsret";
    protected static final String INJECTING_USER_AGENT_DOC = "dt_drvuadoc";
    protected static final String APP_DN_FORM = "dt_appdn";
    private static final int MAX_WAIT_ITERATIONS = 600;
    private static final int WAIT_SLEEP_TIME = 100;
    private static final int WAIT_TRACE_COUNT = 50;
    static final int DRIVER_EVENT_UPDATE_TRACE = 1;
    static final int DRIVER_EVENT_RELOAD = 2;
    static final int DRIVER_EVENT_UPDATE_LOG_LEVEL = 3;
    static final int INIT_STATE_DOWN = 0;
    static final int INIT_STATE_DRIVER_INIT = 1;
    static final int INIT_STATE_SUBSCRIBER_INIT = 2;
    static final int INIT_STATE_PUBLISHER_INIT = 4;
    static final int INIT_STATE_PUBLISHER_START = 8;
    static final int INIT_STATE_ABORT = 16;
    static final int INIT_STATE_UP = 15;
    protected DriverEntry driverEntry;
    protected ConfigAbstraction registry;
    protected boolean shuttingDown = false;
    protected boolean checkedDriverId = false;
    protected EngineTrace tracer;
    protected int initState = 0;
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.Driver");
    ThreadGroup driverGroup;
    Thread workerThread;
    protected Document ndsDoc = null;
    protected Element ndInput = null;
    protected DriverShim driverShim = null;
    protected SubscriptionShim subscriptionShim = null;
    protected Publisher publisher = null;
    protected Subscriber subscriber = null;
    protected JCContext context;
    protected Object sdGate = new Object();
    protected Date startTime = null;
    protected long replicatedMoveID = -1L;
    protected String driverName = null;
    WorkManager workManager = null;
    private boolean isTrustedDriver = false;
    private byte[] outKey = null;
    private byte[] inKey = null;
    private static String[] sensitiveAttrs = new String[]{"Private Key", "CA Private Key", "Passwords Used"};
    private static String[] nspmSensitiveAttrs = new String[]{"nspmPassword", "nspmDistributionPassword", "SAS:Login Configuration"};
    protected int appDNDelimsPriority = -1;
    protected char[] appDNDelims = null;
    protected char[] ndsDNDelims = NdsConstants.SLASH_DELIMS_ARRAY;
    private RuleStaticContext fromNDSStaticContext;
    private RuleStaticContext fromAppStaticContext;

    Driver(DriverEntry driverEntry, boolean bl) throws VRDException {
        this.driverEntry = driverEntry;
        this.registry = driverEntry.getRegistry();
        this.tracer = this.registry.getTracer();
        ThreadGroupVars.put("default-tracer", this.tracer);
        ThreadVars.put("default-tracer", this.tracer);
        this.driverGroup = Thread.currentThread().getThreadGroup();
        this.workerThread = Thread.currentThread();
        try {
            OurLoader.getLoader().refresh();
            OurLoader.getLoader().setAsCurrentThreadContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            SchemaCache.refresh(null);
            this.initialize(bl);
        }
        catch (Throwable throwable) {
            StatusLog.log(throwable);
            if (!(throwable instanceof VRDException)) {
                throw new VRDException(throwable);
            }
            throw (VRDException)throwable;
        }
    }

    protected void initialize(boolean bl) throws Throwable {
        boolean bl2 = false;
        try {
            if (bl) {
                this.getShimSchema(this.registry.loadAppSchemaDef());
                return;
            }
            this.startShim();
            bl2 = true;
            this.context = this.registry.getContext();
        }
        catch (Throwable throwable) {
            if (bl2) {
                try {
                    this.waitForDriverUp();
                    this.shutdown();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
            }
            this.setInitState(16);
            throw throwable;
        }
    }

    void waitForDriverUp() {
        try {
            int n;
            boolean bl = false;
            int n2 = 0;
            while ((n = this.getInitState()) != 0 && (n & 0xF) != 15 && (n & 0x10) == 0 && n2 < 600) {
                bl = true;
                if (n2++ % 50 == 0) {
                    this.tracer.trace(WAITING_FOR_DRIVER_INIT_FOR_SHUTDOWN, (MessageSource)messageSource);
                }
                Thread.sleep(100L);
            }
            if (n2 >= 600) {
                throw new VRDException(9055);
            }
            if (bl) {
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (VRDException vRDException) {
            StatusLog.log(vRDException);
        }
    }

    private boolean buildDocument(Transaction transaction) throws VRDException {
        DSEEventInfo dSEEventInfo;
        String string = (String)ThreadGroupVars.get(this.driverGroup, "vrDriverDN");
        DSEEventInfo dSEEventInfo2 = transaction.getEndTransaction();
        if (dSEEventInfo2 == null) {
            String string2 = "";
            Iterator iterator = transaction.iterator();
            if (iterator.hasNext()) {
                string2 = ((DSEEventInfo)iterator.next()).toString();
            }
            throw new VRDException(9017, string2);
        }
        if ((dSEEventInfo2.getFlags() & 1) != 0) {
            return this.specialMoveHandling(dSEEventInfo2);
        }
        Element[] elementArray = new Element[]{this.ndInput};
        Element[] elementArray2 = dSEEventInfo2.toXML(this.context, string, this.tracer, elementArray, dSEEventInfo2);
        if (dSEEventInfo2.getType() == 7 && transaction.iterator().next() != dSEEventInfo2) {
            dSEEventInfo = DSEEventInfo.constructModifyEntry(dSEEventInfo2.getObjectID().getEntryID(), dSEEventInfo2.getEventID(), dSEEventInfo2.getTimestamp());
            elementArray2 = dSEEventInfo.toXML(this.context, string, this.tracer, elementArray, dSEEventInfo);
        }
        if (dSEEventInfo2.getType() == 5) {
            this.saveDeleteAssociations(dSEEventInfo2);
        }
        if (elementArray2 == null || elementArray2.length < 1) {
            return false;
        }
        Iterator iterator = transaction.iterator();
        while (iterator.hasNext() && (dSEEventInfo = (DSEEventInfo)iterator.next()) != dSEEventInfo2) {
            if (dSEEventInfo.getAttrValue() != null && Driver.isSensitiveData(dSEEventInfo.getAttrValue().getAttrName())) {
                if (!this.isTrustedDriver) {
                    StatusLog.logWarning(8000, dSEEventInfo.getAttrValue().getAttrName());
                    continue;
                }
                dSEEventInfo.getAttrValue().encrypt(this.outKey);
            }
            dSEEventInfo.toXML(this.context, string, this.tracer, elementArray2, dSEEventInfo2);
        }
        return true;
    }

    private boolean specialMoveHandling(DSEEventInfo dSEEventInfo) throws VRDException {
        long l = dSEEventInfo.getObjectID().getEntryID();
        switch (dSEEventInfo.getType()) {
            case 6: {
                this.workManager.addReplicatedMove(l, dSEEventInfo.getOldDN());
                return false;
            }
            case 3: {
                String string = this.workManager.getReplicatedMove(l);
                if (string == null) {
                    return false;
                }
                Element[] elementArray = new Element[]{this.ndInput};
                String string2 = (String)ThreadGroupVars.get(this.driverGroup, "vrDriverDN");
                String string3 = dSEEventInfo.getEventID();
                DSEEventInfo dSEEventInfo2 = DSEEventInfo.constructMoveEntry(l, string, string3);
                Element[] elementArray2 = dSEEventInfo2.toXML(this.context, string2, this.tracer, elementArray, dSEEventInfo2);
                if (elementArray2 == null || elementArray2.length == 0) {
                    this.workManager.removeReplicatedMove(l);
                    return false;
                }
                this.replicatedMoveID = l;
                return true;
            }
        }
        return true;
    }

    private void saveDeleteAssociations(DSEEventInfo dSEEventInfo) throws VRDException {
        this.workManager.removeVariable("dirxml.engine.lastdeleted");
        DSEEventInfo.AssociationValue[] associationValueArray = dSEEventInfo.getObjectID().getAssociations();
        if (associationValueArray == null || associationValueArray.length == 0) {
            return;
        }
        String[] stringArray = new String[associationValueArray.length + 1];
        stringArray[0] = dSEEventInfo.getObjectID().getDN();
        int n = 0;
        while (n < associationValueArray.length) {
            stringArray[n + 1] = associationValueArray[n].getValue();
            ++n;
        }
        this.workManager.addVariable("dirxml.engine.lastdeleted", (Serializable)stringArray);
    }

    void initActivation() throws VRDException {
        if (!this.checkedDriverId) {
            try {
                this.subscriber.checkDriverId();
                this.checkedDriverId = true;
            }
            catch (VRDException vRDException) {
                if (!vRDException.isRetry()) {
                    this.checkedDriverId = true;
                    this.killDriver();
                } else {
                    this.driverEntry.setRetryDelay(30);
                }
                throw vRDException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void submitTransaction(Transaction transaction) throws VRDException {
        try {
            try {
                this.tracer.trace(START_TRANSACTION, (MessageSource)messageSource);
                transaction.optimize();
                if (!transaction.isEmpty()) {
                    this.ndInput = NdsDtd.createDoc("input");
                    this.ndsDoc = this.ndInput.getOwnerDocument();
                    if (this.buildDocument(transaction)) {
                        this.tracer.trace(PROCESSING_TRANSACTION_EVENTS, (MessageSource)messageSource);
                        this.subscriber.processEvents(this.ndsDoc);
                        this.tracer.trace(END_TRANSACTION, (MessageSource)messageSource);
                    }
                    this.tracer.trace(DISCARDING_TRANSACTION_DISABLED, (MessageSource)messageSource);
                }
                this.tracer.trace(DISCARDING_TRANSACTION_OPTIMIZE, (MessageSource)messageSource);
            }
            catch (VRDException vRDException) {
                if (vRDException.getErrorCode() == 9154) {
                    this.tracer.trace(DISCARDING_TRANSACTION_DELETED, (MessageSource)messageSource);
                    long l = transaction.getEndTransaction().getObjectID().getEntryID();
                    this.workManager.removeReplicatedMove(l);
                    Object var6_3 = null;
                    this.ndInput = null;
                    this.ndsDoc = null;
                    if (this.replicatedMoveID == -1L) return;
                    this.workManager.removeReplicatedMove(this.replicatedMoveID);
                    this.replicatedMoveID = -1L;
                    return;
                }
                if (!vRDException.isFatal()) {
                    if (!vRDException.isRetry()) throw vRDException;
                }
                this.replicatedMoveID = -1L;
                throw vRDException;
            }
            catch (Throwable throwable) {
                throw new VRDException(9080, throwable);
            }
            Object var6_2 = null;
            this.ndInput = null;
            this.ndsDoc = null;
            if (this.replicatedMoveID == -1L) return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.ndInput = null;
            this.ndsDoc = null;
            if (this.replicatedMoveID == -1L) throw throwable;
            this.workManager.removeReplicatedMove(this.replicatedMoveID);
            this.replicatedMoveID = -1L;
            throw throwable;
        }
        this.workManager.removeReplicatedMove(this.replicatedMoveID);
        this.replicatedMoveID = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Document submitAction(Document document) {
        Document document2;
        int n = 7;
        int n2 = 0;
        try {
            try {
                this.tracer.trace(INJECTING_USER_AGENT_DOC, (MessageSource)messageSource);
                document2 = this.subscriber.execute(document, true, true, true);
            }
            catch (VRDException vRDException) {
                document2 = NdsDtd.createStatusDocument(vRDException, null);
                n = 4;
                n2 = vRDException.getErrorCode();
                Object var8_6 = null;
                PersistentLog.logEvent(31, n, null, 0L, null, null, null, null, 0L, (long)n2, document.getDocumentElement());
                return document2;
            }
            catch (Throwable throwable) {
                document2 = NdsDtd.createStatusDocument(throwable, null);
                n = 4;
                n2 = 9010;
                Object var8_7 = null;
                PersistentLog.logEvent(31, n, null, 0L, null, null, null, null, 0L, (long)n2, document.getDocumentElement());
                return document2;
            }
            Object var8_5 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            PersistentLog.logEvent(31, n, null, 0L, null, null, null, null, 0L, (long)n2, document.getDocumentElement());
            throw throwable;
        }
        PersistentLog.logEvent(31, n, null, 0L, null, null, null, null, 0L, (long)n2, document.getDocumentElement());
        return document2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() throws VRDException {
        Object object;
        this.waitForDriverUp();
        String string = (String)ThreadGroupVars.get(this.driverGroup, "vrDriverDN");
        this.tracer.trace(SHUTTING_DOWN_DRIVER, (MessageSource)messageSource, string);
        Object object2 = this.sdGate;
        synchronized (object2) {
            this.shuttingDown = true;
        }
        if (this.driverShim != null) {
            object = null;
            if (object != null && this.tracer.getLevel() > 1) {
                this.tracer.trace((XmlDocument)object);
            }
            XmlDocument xmlDocument = this.driverShim.shutdown(null);
            if (this.tracer.getLevel() > 1) {
                this.tracer.trace(SHIM_SHUTDOWN_RETURNED, (MessageSource)messageSource);
                this.tracer.trace(xmlDocument);
            }
            if (xmlDocument != null) {
                try {
                    this.registry.writeDriverState(xmlDocument.getDocumentNS(), "output");
                }
                catch (Exception exception) {
                    StatusLog.log(exception);
                }
            }
            if (this.subscriber != null) {
                this.subscriber.shutdown();
                this.subscriber = null;
            }
            if (this.publisher != null) {
                this.tracer.trace(WAITING_FOR_PUBLISHER_TERMINATION, (MessageSource)messageSource);
                if (!this.publisher.waitForThreadEnd(30000L)) {
                    this.tracer.trace(PUBLISHER_THREAD_NO_TERMINATE, (MessageSource)messageSource);
                    this.shuttingDown = false;
                } else {
                    this.tracer.trace(PUBLISHER_THREAD_TERMINATED, (MessageSource)messageSource);
                }
                this.publisher.shutdown();
                this.publisher = null;
            }
            this.driverShim = null;
            this.registry.setAppSchema(null);
            ThreadGroupVars.remove("subscriber");
            ThreadGroupVars.remove("publisher");
            ThreadGroupVars.remove("default-tracer");
            if (this.context != null) {
                this.context.free();
                this.context = null;
            }
        }
        if (this.workManager != null) {
            this.workManager.cleanup();
            this.workManager = null;
        }
        object = this.sdGate;
        synchronized (object) {
            this.initState = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isShuttingDown() {
        boolean bl;
        Object object = this.sdGate;
        synchronized (object) {
            bl = this.shuttingDown;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getInitState() {
        Object object = this.sdGate;
        synchronized (object) {
            int n = this.initState;
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInitState(int n) {
        Object object = this.sdGate;
        synchronized (object) {
            this.initState |= n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isStarted() {
        int n;
        Object object = this.sdGate;
        synchronized (object) {
            n = this.initState;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isUp() {
        int n;
        Object object = this.sdGate;
        synchronized (object) {
            n = this.initState;
        }
        return (n & 0xF) == 15;
    }

    public static int checkShimError(XmlDocument xmlDocument, boolean bl) throws VRDException {
        if (xmlDocument != null) {
            return Driver.checkShimError(xmlDocument.getDocumentNS(), bl);
        }
        return 0;
    }

    public static int checkShimError(Document document, boolean bl) throws VRDException {
        Element element;
        if (document == null) {
            return 0;
        }
        NodeList nodeList = document.getElementsByTagNameNS(null, "status");
        if (nodeList.item(0) == null) {
            return 0;
        }
        int n = 0;
        int n2 = 0;
        while ((element = (Element)nodeList.item(n++)) != null) {
            int n3 = NdsDtd.getStatusLevel(element);
            if (bl && n3 != 0) {
                StatusLog.log(element);
            }
            if (n3 == 4) {
                throw new VRDException(9005, StatusLog.getStatusMessage(element));
            }
            if (n3 == 1) {
                throw new VRDException(9006, StatusLog.getStatusMessage(element));
            }
            if (n2 >= n3) continue;
            n2 = n3;
        }
        return n2;
    }

    protected void killDriver() {
        this.driverEntry.setRequestShutdown();
    }

    protected void setDriverRetryDelay() {
        this.driverEntry.setRetryDelay(this.registry.getECVs().getRetryInterval());
    }

    protected void writeDriverId(String string, int n) {
        this.driverEntry.writeDriverID(n, string);
    }

    synchronized void addWork(int n, Document document) {
        try {
            this.workManager.addWork(n, document);
        }
        catch (VRDException vRDException) {
            StatusLog.log(vRDException);
        }
    }

    void processWork() throws VRDException {
        if (this.driverEntry.inRetryDelay()) {
            return;
        }
        WorkManager.WorkEntry workEntry = this.workManager.getWork();
        if (workEntry != null) {
            try {
                this.subscriber.processWork(workEntry);
            }
            catch (Throwable throwable) {
                if (throwable instanceof VRDException) {
                    VRDException vRDException = (VRDException)throwable;
                    StatusLog.log(vRDException);
                    if (vRDException.isRetry()) {
                        this.setDriverRetryDelay();
                        return;
                    }
                }
                StatusLog.log(throwable);
            }
            this.workManager.removeWork();
        }
    }

    protected DriverShim loadShim() throws Exception {
        this.driverName = this.registry.getJavaDriverName();
        DriverShim driverShim = null;
        if (this.driverName != null) {
            this.tracer.trace(LOADING_JAVA_SHIM, (MessageSource)messageSource, this.driverName);
            Class<?> clazz = OurLoader.getLoader().loadClass(this.driverName);
            Class[] classArray = new Class[]{};
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            driverShim = (DriverShim)constructor.newInstance(new Object[0]);
            this.isTrustedDriver = this.driverName.equals("com.novell.nds.dirxml.driver.nds.DriverShimImpl") || this.driverName.equals("com.novell.nds.dirxml.driver.legacynds.LegacyNDSDriverShim");
        } else {
            this.driverName = this.registry.getCDriverName();
            if (this.driverName != null) {
                this.tracer.trace(LOADING_NATIVE_SHIM, (MessageSource)messageSource, this.driverName);
                driverShim = new NativeDriverShim(this.driverName, this.tracer);
            } else {
                throw new VRDException(9003);
            }
        }
        if (this.isTrustedDriver) {
            this.outKey = this.s0();
        }
        return driverShim;
    }

    protected void startShim() throws Exception {
        Object object;
        Element element;
        this.tracer.trace(INIT_DRIVER_SHIM, (MessageSource)messageSource);
        Element element2 = element = this.registry.loadAppSchemaDef();
        try {
            if (element2 == null || element2.getElementsByTagNameNS(null, "class-def").item(0) == null) {
                try {
                    element2 = this.getShimSchema(element2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (element2 == null) {
                StatusLog.logWarning(8001);
                element2 = element;
            } else if (element2.getElementsByTagNameNS(null, "class-def").item(0) == null) {
                StatusLog.logWarning(8001);
            }
            this.driverShim = this.loadShim();
            this.startTime = new Date();
            object = new XmlDocument(this.registry.getInitParams("driver-options", "driver-state"));
            this.tracer.trace((XmlDocument)object);
            XmlDocument xmlDocument = this.driverShim.init((XmlDocument)object);
            if (this.tracer.getLevel() > 1) {
                this.tracer.trace(DRIVER_SHIM_INIT_RETURNED, (MessageSource)messageSource);
                this.tracer.trace(xmlDocument);
            }
            if (xmlDocument != null) {
                Document document = xmlDocument.getDocumentNS();
                if (document != null) {
                    this.registry.writeDriverState(document, "output");
                }
                Driver.checkShimError(document, true);
                document = null;
            }
            this.setInitState(1);
        }
        catch (Exception exception) {
            if (this.driverShim != null && this.driverShim instanceof NativeDriverShim) {
                ((NativeDriverShim)this.driverShim).destroy();
                this.driverShim = null;
            }
            throw exception;
        }
        try {
            this.workManager = new WorkManager(this.driverEntry.getEntryID());
            this.subscriber = new Subscriber(this, this.registry, this.driverShim.getSubscriptionShim(), this.tracer);
            if (element2 != null && this.subscriber.inputMapper != null) {
                object = this.subscriber.inputMapper.applyRules(element2.getOwnerDocument(), this.subscriber.nullDynamicContext);
                element2 = XdsUtil.getFirstElementByTagNameNS((Node)object, null, "schema-def");
            }
            if (element2 != null) {
                this.registry.setAppSchema(new AppSchema(element2));
            }
            this.initAppDNDelims();
            this.publisher = new Publisher(this, this.registry, this.driverShim.getPublicationShim(), this.tracer);
            ThreadGroupVars.put("subscriber", this.subscriber);
            ThreadGroupVars.put("publisher", this.publisher);
            this.registry.setContext(true);
            this.publisher.start();
        }
        catch (Exception exception) {
            this.driverShim.shutdown(null);
            if (this.driverShim instanceof NativeDriverShim) {
                ((NativeDriverShim)this.driverShim).destroy();
                this.driverShim = null;
            }
            throw exception;
        }
    }

    protected Element getShimSchema(Element element) throws Exception {
        block5: {
            DriverShim driverShim = this.loadShim();
            try {
                Element element2;
                Document document;
                this.tracer.trace(CALLING_GET_SCHEMA, (MessageSource)messageSource);
                XmlDocument xmlDocument = new XmlDocument(this.registry.getInitParams("", ""));
                this.tracer.trace(xmlDocument);
                XmlDocument xmlDocument2 = driverShim.getSchema(xmlDocument);
                if (this.tracer.getLevel() > 1) {
                    this.tracer.trace(GET_SCHEMA_RETURNED, (MessageSource)messageSource);
                    this.tracer.trace(xmlDocument2);
                }
                Driver.checkShimError(xmlDocument2, true);
                if (xmlDocument2 != null && (document = xmlDocument2.getDocumentNS()) != null && (element2 = XdsUtil.getFirstElementByTagNameNS(document, null, "schema-def")) != null) {
                    if (element2.getAttributeNS(null, "dn-format").length() == 0 && element2.getAttributeNS(null, "dn-delims").length() == 0 && element != null) {
                        XdsUtil.copyAttributeNS(element, null, "dn-format", element2);
                        XdsUtil.copyAttributeNS(element, null, "dn-delims", element2);
                    }
                    NDSStreamAttributeOutputStream nDSStreamAttributeOutputStream = new NDSStreamAttributeOutputStream(this.registry.getContext(), this.registry.getDriverDN(), "DirXML-ApplicationSchema");
                    DOMWriter dOMWriter = new DOMWriter((Node)element2, (OutputStream)nDSStreamAttributeOutputStream, "UTF-8");
                    dOMWriter.setWriteDeclaration(true);
                    dOMWriter.setIndent(true);
                    dOMWriter.write();
                    nDSStreamAttributeOutputStream.close();
                    return element2;
                }
            }
            catch (Throwable throwable) {
                if (driverShim == null || !(driverShim instanceof NativeDriverShim)) break block5;
                ((NativeDriverShim)driverShim).destroy();
            }
        }
        return null;
    }

    static boolean isSensitiveData(String string) {
        if (string != null) {
            int n = 0;
            while (n < sensitiveAttrs.length) {
                if (string.equals(sensitiveAttrs[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    static boolean isSensitiveNSPMData(String string) {
        if (string != null) {
            int n = 0;
            while (n < nspmSensitiveAttrs.length) {
                if (string.equals(nspmSensitiveAttrs[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public static boolean isSensitiveAttr(String string) {
        return Driver.isSensitiveData(string) || Driver.isSensitiveNSPMData(string);
    }

    public boolean isTrustedDriver() {
        return this.isTrustedDriver;
    }

    byte[] getInKey() {
        return this.inKey;
    }

    void setInKey(byte[] byArray) {
        this.inKey = byArray;
    }

    byte[] getOutKey() {
        return this.outKey;
    }

    private byte[] s0() throws VRDException {
        InetAddress inetAddress;
        UID uID = new UID();
        try {
            inetAddress = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new VRDException(unknownHostException);
        }
        String string = uID.toString();
        byte[] byArray = string.getBytes();
        byte[] byArray2 = inetAddress.getAddress();
        byte[] byArray3 = new byte[(byArray.length + byArray2.length) * 2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        int n = byArray3.length;
        int n2 = n / 2;
        int n3 = n / 2 - 1;
        int n4 = 0;
        while (n2 < n) {
            byArray3[n2] = Driver.ror(byArray3[n3] ^ byArray3[n4], byArray3[n4]);
            ++n2;
            --n3;
            ++n4;
        }
        return byArray3;
    }

    private static byte ror(int n, int n2) {
        int n3 = n2 & 7;
        int n4 = n;
        while (n3-- > 0) {
            int n5 = (n4 & 1) != 0 ? 128 : 0;
            n4 >>= 1;
            n4 |= n5;
        }
        return (byte)n4;
    }

    RuleStaticContext getStaticContext(boolean bl) {
        if (bl) {
            if (this.fromNDSStaticContext == null) {
                this.fromNDSStaticContext = new RuleStaticContext(this.registry.getDriverDN(), this.ndsDNDelims, this.appDNDelims, true, OurLoader.getLoader(), this.tracer, this.registry.getGCVs(), this);
            }
            return this.fromNDSStaticContext;
        }
        if (this.fromAppStaticContext == null) {
            this.fromAppStaticContext = new RuleStaticContext(this.registry.getDriverDN(), this.appDNDelims, this.ndsDNDelims, false, OurLoader.getLoader(), this.tracer, this.registry.getGCVs(), this);
        }
        return this.fromAppStaticContext;
    }

    void setAppDNDelims(char[] cArray, int n) {
        if (n > this.appDNDelimsPriority) {
            this.appDNDelimsPriority = n;
            this.appDNDelims = cArray;
            if (this.fromNDSStaticContext != null) {
                this.fromNDSStaticContext.destDelims = cArray;
            }
            if (this.fromAppStaticContext != null) {
                this.fromAppStaticContext.srcDelims = cArray;
            }
            if (this.tracer.getLevel() > 1) {
                String string = XdsDN.getFormString((char[])cArray);
                this.tracer.trace(APP_DN_FORM, (MessageSource)messageSource, string);
            }
        }
    }

    void initAppDNDelims() throws VRDException {
        char[] cArray = null;
        AppSchema appSchema = this.registry.getAppSchema();
        int n = 0;
        if (appSchema != null && (cArray = appSchema.getDNDelims()) != null) {
            n = 2;
        } else {
            String string = this.registry.getDriverIdentityName();
            String string2 = string = string == null ? "" : string;
            if (this.driverName != null && (StringUtil.startsWithIgnoreCase(this.driverName, "addriver") || this.driverName.equals("com.novell.nds.dirxml.driver.jdbc.JDBCDriverShim") || this.driverName.equals("com.novell.nds.dirxml.driver.ldap.LDAPDriverShim")) || string.equals("JDBC") || string.equals("LDAP") || string.equals("AD")) {
                cArray = "10,,+=*\\\r<>#;\"".toCharArray();
                n = 1;
            } else if (StringUtil.startsWithIgnoreCase(this.driverName, "exch") || string.equals("EXCHANGE")) {
                cArray = "10./+=*\\".toCharArray();
                n = 1;
            } else {
                cArray = NdsConstants.SLASH_DELIMS_ARRAY;
                n = 0;
            }
        }
        this.setAppDNDelims(cArray, n);
    }

    public static String changeDNForm(String string) {
        ConfigAbstraction configAbstraction = (ConfigAbstraction)ThreadGroupVars.get("registry");
        if (configAbstraction == null || string == null || string.length() == 0 || configAbstraction.getECVs().getQualifiedDNValues()) {
            return string;
        }
        XdsDN xdsDN = new XdsDN(string, NdsConstants.QSLASH_DELIMS_ARRAY);
        return xdsDN.getDN(NdsConstants.SLASH_DELIMS_ARRAY);
    }

    static {
        Trace_DOMWriter.AttributeEntry[] attributeEntryArray = new Trace_DOMWriter.AttributeEntry[sensitiveAttrs.length + nspmSensitiveAttrs.length];
        int n = 0;
        while (n < sensitiveAttrs.length) {
            attributeEntryArray[n] = new Trace_DOMWriter.AttributeEntry("attr-name", sensitiveAttrs[n]);
            ++n;
        }
        n = 0;
        while (n < nspmSensitiveAttrs.length) {
            attributeEntryArray[n + Driver.sensitiveAttrs.length] = new Trace_DOMWriter.AttributeEntry("attr-name", nspmSensitiveAttrs[n]);
            ++n;
        }
        Trace_DOMWriter.ElementEntry[] elementEntryArray = new Trace_DOMWriter.ElementEntry[]{new Trace_DOMWriter.ElementEntry(new ExpandedQName("", "password"), null), new Trace_DOMWriter.ElementEntry(new ExpandedQName("", "check-password"), null), new Trace_DOMWriter.ElementEntry(new ExpandedQName("", "old-password"), null), new Trace_DOMWriter.ElementEntry(new ExpandedQName("", "add-attr"), attributeEntryArray), new Trace_DOMWriter.ElementEntry(new ExpandedQName("", "modify-attr"), attributeEntryArray), new Trace_DOMWriter.ElementEntry(new ExpandedQName("", "search-attr"), attributeEntryArray), new Trace_DOMWriter.ElementEntry(new ExpandedQName("", "attr"), attributeEntryArray)};
        HashMap<ExpandedQName, Trace_DOMWriter.ElementEntry> hashMap = new HashMap<ExpandedQName, Trace_DOMWriter.ElementEntry>();
        n = 0;
        while (n < elementEntryArray.length) {
            hashMap.put(elementEntryArray[n].getName(), elementEntryArray[n]);
            ++n;
        }
        EngineTrace.setSensitiveElements(hashMap);
        Events.setSensitiveElements(hashMap);
    }
}

