/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.driver.TraceInterface;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.ThreadVars;
import com.novell.nds.dirxml.engine.Trace_DOMWriter;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dstrace.DDSTrace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Stack;
import org.w3c.dom.Document;

public class EngineTrace
implements TraceInterface {
    public static final int DEFAULT_TRACE_LEVEL = 1;
    public static final int DEFAULT_XML_TRACE_LEVEL = 2;
    public static final int DEFAULT_RULE_TRACE_LEVEL = 3;
    protected long entryID;
    protected int traceLevel = 0;
    protected ThreadLocal prefix = new ThreadLocal();
    protected String traceFilename = null;
    protected PrintWriter traceFile = null;
    protected SizeOutputStream traceStream = null;
    protected long maxTraceFileSize = 0L;
    protected long maxFileSize = 0L;
    protected String[] filenameFmt = null;
    protected ThreadLocal indentCount = new ThreadLocalInt(0);
    protected ThreadLocal indentStack = new ThreadLocalStack();
    protected ThreadLocal color = new ThreadLocalInt(3);
    protected ThreadLocal colorStack = new ThreadLocalStack();
    protected Prefix defaultPrefix;
    protected String shortName;
    protected int shortNameRevision = 0;
    protected boolean disableDSTrace = false;
    protected static final String DEFAULT_TIME_FORMAT = "[MM/dd/yy HH:mm:ss.SS]: ";
    protected static final String TRACE_PREFIX = "et_pre";
    protected static final String TRACE_SUB_ID = "et_sid";
    protected static final String TRACE_PUB_ID = "et_pid";
    protected static final String TRACE_UNKNOWN_ID = "et_uknwn";
    protected static final String TRACE_ENG_ID = "et_eid";
    protected static final String TRACE_ENG = "et_eng";
    protected static final String TRACE_TIMEFORMAT = "et_timeformat";
    protected static final String TRACE_NULL_DOCUMENT = "et_nulldoc";
    protected static final String TRACE_ROLL_MSG = "et_rollmsg";
    protected static final String TAB = "  ";
    protected static final int MAX_COPY_BUFFER_SIZE = 524288;
    protected static LocalizedMessageSource messageSource;
    protected static Object gate;
    protected static String timeFormatString;
    protected static SimpleDateFormat timeFormat;
    protected static Map elementMap;
    protected static int initCount;
    public static EngineTrace staticTracer;

    public EngineTrace(long l) {
        this(l, null);
    }

    public EngineTrace(long l, String string) {
        String string2;
        this.entryID = l;
        switch ((int)l) {
            case 0: {
                this.shortName = messageSource.getMessageString(TRACE_ENG);
                string2 = messageSource.getMessageString(TRACE_ENG_ID);
                break;
            }
            case -1: {
                this.shortName = messageSource.getMessageString(TRACE_UNKNOWN_ID);
                string2 = "";
                break;
            }
            default: {
                this.shortName = string == null ? Long.toString(l) : string;
                string2 = "";
            }
        }
        this.defaultPrefix = new Prefix(string2);
        this.prefix.set(this.defaultPrefix);
    }

    static void initialize() {
        if (++initCount == 1) {
            staticTracer = new EngineTrace(0L);
            staticTracer.setLevel(ConfigAbstraction.getGlobalTraceLevel());
            staticTracer.setTraceFile(ConfigAbstraction.getGlobalTraceFilename());
            staticTracer.setMaxTraceFileSize(ConfigAbstraction.getGlobalTraceSizeLimit());
            ConfigAbstraction.initializeXSLTrace();
        }
    }

    static void cleanup() {
        if (--initCount == 0) {
            ConfigAbstraction.cleanupXSLTrace();
            if (staticTracer != null) {
                staticTracer.close();
            }
            staticTracer = null;
        }
        if (initCount < 0) {
            initCount = 0;
        }
    }

    void setSubscriberThread() {
        this.prefix.set(new Prefix(messageSource.getMessageString(TRACE_SUB_ID)));
    }

    void setPublisherThread() {
        this.prefix.set(new Prefix(messageSource.getMessageString(TRACE_PUB_ID)));
    }

    public int getIndent() {
        try {
            Integer n = (Integer)this.indentCount.get();
            return n;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    public void pushIndent(int n) {
        if (this.traceLevel > 0) {
            try {
                Stack stack = (Stack)this.indentStack.get();
                Integer n2 = (Integer)this.indentCount.get();
                stack.push(n2);
                this.indentCount.set(new Integer(n2 + n));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void popIndent() {
        if (this.traceLevel > 0) {
            try {
                this.indentCount.set((Integer)((Stack)this.indentStack.get()).pop());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void pushColor(int n) {
        if (this.traceLevel > 0) {
            this.pushColorAlways(n);
        }
    }

    public void pushColorAlways(int n) {
        try {
            Stack stack = (Stack)this.colorStack.get();
            stack.push((Integer)this.color.get());
            this.color.set(new Integer(n));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void popColor() {
        if (this.traceLevel > 0) {
            this.popColorAlways();
        }
    }

    public void popColorAlways() {
        try {
            this.color.set((Integer)((Stack)this.colorStack.get()).pop());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        PrintWriter printWriter;
        EngineTrace engineTrace = this;
        synchronized (engineTrace) {
            printWriter = this.traceFile;
        }
        if (printWriter != null) {
            printWriter.flush();
            printWriter.close();
        }
    }

    public void trace(String string) {
        if (this.traceLevel >= 1) {
            this.traceAlways(string);
        }
    }

    public void trace(int n, String string) {
        if (this.traceLevel >= n) {
            this.traceAlways(string);
        }
    }

    public void trace(int n, XmlDocument xmlDocument) {
        if (this.traceLevel >= n) {
            if (xmlDocument == null || xmlDocument.getDocumentNS() == null) {
                this.traceAlways(TRACE_NULL_DOCUMENT, (MessageSource)messageSource, null);
                return;
            }
            this.traceAlways(xmlDocument.getDocumentNS());
        }
    }

    public void trace(int n, Document document) {
        if (this.traceLevel >= n) {
            this.traceAlways(document);
        }
    }

    public void trace(String string, MessageSource messageSource) {
        if (this.traceLevel >= 1) {
            this.traceAlways(string, messageSource, null);
        }
    }

    public void trace(int n, String string, MessageSource messageSource) {
        if (this.traceLevel >= n) {
            this.traceAlways(string, messageSource, null);
        }
    }

    public void trace(XmlDocument xmlDocument) {
        if (this.traceLevel >= 2) {
            this.trace(2, xmlDocument);
        }
    }

    public void trace(Document document) {
        if (this.traceLevel >= 2) {
            this.traceAlways(document);
        }
    }

    public void trace(String string, MessageSource messageSource, Object object) {
        if (this.traceLevel >= 1) {
            this.traceAlways(string, messageSource, new Object[]{object});
        }
    }

    public void trace(int n, String string, MessageSource messageSource, Object object) {
        if (this.traceLevel >= n) {
            this.traceAlways(string, messageSource, new Object[]{object});
        }
    }

    public void trace(String string, MessageSource messageSource, Object object, Object object2) {
        if (this.traceLevel >= 1) {
            this.traceAlways(string, messageSource, new Object[]{object, object2});
        }
    }

    public void trace(int n, String string, MessageSource messageSource, Object object, Object object2) {
        if (this.traceLevel >= n) {
            this.traceAlways(string, messageSource, new Object[]{object, object2});
        }
    }

    public void trace(String string, MessageSource messageSource, Object object, Object object2, Object object3) {
        if (this.traceLevel >= 1) {
            this.traceAlways(string, messageSource, new Object[]{object, object2, object3});
        }
    }

    public void trace(int n, String string, MessageSource messageSource, Object object, Object object2, Object object3) {
        if (this.traceLevel >= n) {
            this.traceAlways(string, messageSource, new Object[]{object, object2, object3});
        }
    }

    public void trace(String string, MessageSource messageSource, Object[] objectArray) {
        if (this.traceLevel >= 1) {
            this.traceAlways(string, messageSource, objectArray);
        }
    }

    public void trace(int n, String string, MessageSource messageSource, Object[] objectArray) {
        if (this.traceLevel >= n) {
            this.traceAlways(string, messageSource, objectArray);
        }
    }

    protected void traceAlways(String string, MessageSource messageSource, Object[] objectArray) {
        this.traceAlways(messageSource.getMessage(string, objectArray));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void traceAlways(String string) {
        Prefix prefix = null;
        try {
            prefix = (Prefix)this.prefix.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (prefix == null) {
            prefix = this.defaultPrefix;
        }
        int n = (Integer)this.indentCount.get();
        StringBuffer stringBuffer = new StringBuffer(prefix.getPrefix(this).length() + string.length() + n);
        stringBuffer.append(prefix.getPrefix(this));
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(TAB);
            ++n2;
        }
        stringBuffer.append(string);
        string = stringBuffer.toString();
        try {
            PrintWriter printWriter;
            if (!this.disableDSTrace) {
                DDSTrace.trace((int)217, (int)((Integer)this.color.get()), (String)string);
            }
            string = EngineTrace.timeStampMessage(string);
            EngineTrace engineTrace = this;
            synchronized (engineTrace) {
                if (this.traceStream != null && this.maxFileSize != 0L && this.traceStream.getSize() + (long)string.length() > this.maxFileSize) {
                    this.rollFiles();
                }
                printWriter = this.traceFile;
            }
            if (printWriter != null) {
                printWriter.println(string);
            }
        }
        catch (Throwable throwable) {
            try {
                PrintWriter printWriter;
                if (!this.disableDSTrace) {
                    DDSTrace.trace((int)217, (int)12, (String)("Error generating trace message: " + DDSTrace.getStackTrace((Throwable)throwable)));
                }
                EngineTrace engineTrace = this;
                synchronized (engineTrace) {
                    printWriter = this.traceFile;
                }
                if (printWriter != null) {
                    String string2 = "Error generating trace message: " + throwable.toString();
                    printWriter.println(EngineTrace.timeStampMessage(string2));
                }
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
        }
    }

    protected void traceAlways(Document document) {
        if (document == null) {
            this.traceAlways(TRACE_NULL_DOCUMENT, (MessageSource)messageSource, null);
            return;
        }
        StringWriter stringWriter = new StringWriter();
        Trace_DOMWriter trace_DOMWriter = new Trace_DOMWriter(document, stringWriter);
        trace_DOMWriter.setIndent(true);
        trace_DOMWriter.setIndentString(TAB);
        trace_DOMWriter.setSensitiveElements(elementMap);
        try {
            stringWriter.write(10);
            trace_DOMWriter.write();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        stringWriter.flush();
        this.traceAlways(stringWriter.toString());
    }

    public int getLevel() {
        return this.traceLevel;
    }

    public void setLevel(int n) {
        this.traceLevel = n;
    }

    public void setShortName(String string) {
        this.shortName = string;
        ++this.shortNameRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setSensitiveElements(Map map) {
        Object object = gate;
        synchronized (object) {
            elementMap = map;
        }
    }

    public synchronized void setTraceFile(String string) {
        if (this.traceFile != null) {
            try {
                this.traceFile.flush();
                this.traceFile.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.traceFile = null;
            this.traceStream = null;
        }
        this.traceFilename = string;
        if (this.traceFilename != null) {
            try {
                if (string.equals("stderr")) {
                    this.traceStream = new SizeOutputStream(System.err, 0L);
                } else if (string.equals("stdout")) {
                    this.traceStream = new SizeOutputStream(System.out, 0L);
                } else {
                    File file = new File(this.traceFilename);
                    long l = file.length();
                    this.traceStream = new SizeOutputStream(new FileOutputStream(file, true), l);
                }
                this.traceFile = new PrintWriter(this.traceStream, true);
                this.maxFileSize = this.maxTraceFileSize / 10L;
                this.filenameFmt = new String[2];
                char c = '\u0000';
                int n = this.traceFilename.length() - 1;
                while (n > 0) {
                    c = this.traceFilename.charAt(n);
                    if (c == '.' || c == File.pathSeparatorChar) break;
                    --n;
                }
                if (c == '.') {
                    this.filenameFmt[0] = this.traceFilename.substring(0, n) + "_";
                    this.filenameFmt[1] = this.traceFilename.substring(n, this.traceFilename.length());
                } else {
                    this.filenameFmt[0] = this.traceFilename + "_";
                    this.filenameFmt[1] = new String();
                }
            }
            catch (Throwable throwable) {
                StatusLog.logError(9066, string, throwable);
                this.traceStream = null;
                this.traceFile = null;
            }
        }
    }

    public synchronized void setMaxTraceFileSize(long l) {
        this.maxTraceFileSize = l;
        this.maxFileSize = this.maxTraceFileSize / 10L;
    }

    public void setDisableDSTrace(boolean bl) {
        this.disableDSTrace = bl;
    }

    public boolean getDisableDSTrace() {
        return this.disableDSTrace;
    }

    public static EngineTrace getDefaultTracer() {
        EngineTrace engineTrace = (EngineTrace)ThreadVars.get("default-tracer");
        if (engineTrace == null && (engineTrace = (EngineTrace)ThreadGroupVars.get("default-tracer")) == null && (engineTrace = staticTracer) == null) {
            engineTrace = staticTracer = new EngineTrace(0L);
            engineTrace.setDisableDSTrace(true);
            engineTrace.setTraceFile("stderr");
            engineTrace.setLevel(0);
        }
        return engineTrace;
    }

    static int nativeTrace(String string) {
        int n = 0;
        EngineTrace engineTrace = EngineTrace.getDefaultTracer();
        if (engineTrace != null) {
            engineTrace.trace(string);
            n = engineTrace.getLevel();
        }
        return n;
    }

    static int nativeTraceLevel() {
        EngineTrace engineTrace = EngineTrace.getDefaultTracer();
        return engineTrace != null ? engineTrace.getLevel() : 0;
    }

    protected static String timeStampMessage(String string) {
        StringBuffer stringBuffer = new StringBuffer(timeFormatString.length() + string.length());
        stringBuffer.append(timeFormat.format(new Date()));
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    protected void rollFiles() {
        block5: {
            try {
                this.traceFile.write(10);
                this.traceFile.write(messageSource.getMessageString(TRACE_ROLL_MSG));
                this.traceFile.write(10);
                File file = null;
                int n = 8;
                while (n > 0) {
                    file = new File(this.filenameFmt[0] + n + this.filenameFmt[1]);
                    File file2 = new File(this.filenameFmt[0] + (n + 1) + this.filenameFmt[1]);
                    file2.delete();
                    file.renameTo(file2);
                    --n;
                }
                try {
                    this.traceFile.flush();
                    this.traceFile.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.traceFile = null;
                this.traceStream = null;
                EngineTrace.cp(new File(this.traceFilename), file);
                this.traceStream = new SizeOutputStream(new FileOutputStream(this.traceFilename, false), 0L);
                this.traceFile = new PrintWriter(this.traceStream, true);
            }
            catch (Throwable throwable) {
                if (this.disableDSTrace) break block5;
                DDSTrace.trace((int)217, (int)12, (String)("Error rolling trace files: " + DDSTrace.getStackTrace((Throwable)throwable)));
            }
        }
    }

    private static void cp(File file, File file2) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2, false);
        long l = file.length();
        byte[] byArray = new byte[l < 524288L ? (int)l : 524288];
        while ((n = ((InputStream)fileInputStream).read(byArray)) != -1) {
            ((OutputStream)fileOutputStream).write(byArray, 0, n);
        }
        ((OutputStream)fileOutputStream).close();
        ((InputStream)fileInputStream).close();
    }

    static {
        gate = new Object();
        elementMap = null;
        initCount = 0;
        staticTracer = null;
        try {
            messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.EngineTrace");
            timeFormatString = messageSource.getMessageString(TRACE_TIMEFORMAT);
            timeFormat = new SimpleDateFormat(timeFormatString);
        }
        catch (Throwable throwable) {
            timeFormatString = DEFAULT_TIME_FORMAT;
            timeFormat = new SimpleDateFormat(timeFormatString);
        }
    }

    private static class ThreadLocalStack
    extends ThreadLocal {
        private ThreadLocalStack() {
        }

        protected synchronized Object initialValue() {
            return new Stack();
        }
    }

    private static class ThreadLocalInt
    extends ThreadLocal {
        private int defaultValue;

        ThreadLocalInt(int n) {
            this.defaultValue = n;
        }

        protected synchronized Object initialValue() {
            return new Integer(this.defaultValue);
        }
    }

    private static class SizeOutputStream
    extends FilterOutputStream {
        private int depth = 0;
        private long size;

        SizeOutputStream(OutputStream outputStream, long l) {
            super(outputStream);
            this.size = l;
        }

        long getSize() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int n) throws IOException {
            ++this.depth;
            try {
                super.write(n);
                if (this.depth == 1) {
                    ++this.size;
                }
                Object var3_2 = null;
                --this.depth;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                --this.depth;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray) throws IOException {
            ++this.depth;
            try {
                super.write(byArray);
                if (this.depth == 1) {
                    this.size += (long)byArray.length;
                }
                Object var3_2 = null;
                --this.depth;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                --this.depth;
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] byArray, int n, int n2) throws IOException {
            ++this.depth;
            try {
                super.write(byArray, n, n2);
                if (this.depth == 1) {
                    this.size += (long)n2;
                }
                Object var5_4 = null;
                --this.depth;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                --this.depth;
                throw throwable;
            }
        }
    }

    protected static class Prefix {
        private String prefix;
        private String threadID;
        private int revision;

        Prefix(String string) {
            this.threadID = string;
            this.revision = 0;
        }

        String getPrefix(EngineTrace engineTrace) {
            if (this.prefix == null || this.revision < engineTrace.shortNameRevision) {
                this.prefix = messageSource.getMessage(EngineTrace.TRACE_PREFIX, (Object[])new String[]{engineTrace.shortName, this.threadID});
                this.revision = engineTrace.shortNameRevision;
            }
            return this.prefix;
        }
    }
}

