/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.LogSettings;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.Trace_DOMWriter;
import com.novell.nds.dirxml.engine.Warnings;
import com.novell.nds.dirxml.engine.XdsUtil;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Events {
    protected static Map elementMap = null;
    protected static Object gate = new Object();
    public static final int APPLICATION_ID = 196608;
    public static final int LOG_EMERGENCY = 1;
    public static final int LOG_ALERT = 2;
    public static final int LOG_CRITICAL = 3;
    public static final int LOG_ERROR = 4;
    public static final int LOG_WARNING = 5;
    public static final int LOG_NOTICE = 6;
    public static final int LOG_INFO = 7;
    public static final int LOG_DEBUG = 8;
    public static final long MIME_UNKNOWN = 0L;
    public static final long MIME_TEXT_PLAIN = 1L;
    public static final long MIME_TEXT_HTML = 2L;
    public static final long MIME_TEXT_XML = 3L;
    public static final long MIME_APPLICATION_OCTET_STREAM = 4L;
    public static final int MAX_TEXT_LENGTH = 256;
    static final int NONE = 0;
    public static final int SLASH_NOTATION = 1;
    public static final int DOT_NOTATION = 2;
    public static final int LDAP_NOTATION = 3;
    public static final int DIRXML_ASSOCIATION = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setSensitiveElements(Map map) {
        Object object = gate;
        synchronized (object) {
            elementMap = map;
        }
    }

    public static int ontarioEvent(int n) {
        return n + 196608;
    }

    public static int convertLevel(int n) {
        int n2;
        switch (n) {
            case 0: {
                n2 = 7;
                break;
            }
            case 1: {
                n2 = 6;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            case 4: {
                n2 = 1;
                break;
            }
            default: {
                n2 = 6;
            }
        }
        return n2;
    }

    public static int convertToIDMLevel(int n) {
        int n2;
        switch (n) {
            case 7: {
                n2 = 0;
                break;
            }
            case 6: {
                n2 = 1;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 2;
            }
        }
        return n2;
    }

    public static int getStatusEventID(String string) {
        if (string.equals("success")) {
            return 1;
        }
        if (string.equals("retry")) {
            return 2;
        }
        if (string.equals("warning")) {
            return 3;
        }
        if (string.equals("error")) {
            return 4;
        }
        if (string.equals("fatal")) {
            return 5;
        }
        return 6;
    }

    public static int getEventIDFromOperation(String string, String string2) {
        if (string.equals("query")) {
            return 7;
        }
        if (string.equals("add")) {
            return 8;
        }
        if (string.equals("delete")) {
            return 9;
        }
        if (string.equals("modify")) {
            return 10;
        }
        if (string.equals("rename")) {
            return 11;
        }
        if (string.equals("move")) {
            return 12;
        }
        if (string.equals("add-association")) {
            return 13;
        }
        if (string.equals("remove-association")) {
            return 14;
        }
        if (string.equals("modify-association")) {
            return 13;
        }
        if (string.equals("status")) {
            return Events.getStatusEventID(string2);
        }
        if (string.equals("query-schema")) {
            return 15;
        }
        if (string.equals("check-password")) {
            return 16;
        }
        if (string.equals("check-object-password")) {
            return 17;
        }
        if (string.equals("modify-password")) {
            return 18;
        }
        if (string.equals("get-named-password")) {
            return 45;
        }
        return 40;
    }

    public static String Component(int n) {
        String string = null;
        string = n == 0 ? new String("\\Engine") : new String("\\Driver");
        return string;
    }

    public static ArrayList getOperationEvents(int n, Element element, int n2) {
        return Events.getOperationEvents(n, element, null, n2);
    }

    public static ArrayList getOperationEvents(int n, Element element, String string, int n2) {
        ArrayList<LogEvent> arrayList;
        block24: {
            LogSettings logSettings;
            LogEvent logEvent;
            long l;
            String string2;
            String string3;
            long l2;
            String string4;
            block23: {
                Element element2 = null;
                string4 = null;
                l2 = 0L;
                String string5 = null;
                String string6 = null;
                string3 = null;
                string2 = null;
                l = 0L;
                long l3 = 0L;
                arrayList = new ArrayList<LogEvent>();
                if (n != 15 && n != 13 && n != 14) {
                    string4 = element.getAttributeNS(null, "dest-dn");
                    l2 = 1L;
                    if (string4 == null || string4.length() == 0) {
                        string4 = XdsUtil.getAssociationValue(element);
                        l2 = 4L;
                    }
                }
                switch (n) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        StatusLog.log(element);
                        return null;
                    }
                    case 7: {
                        string5 = element.getAttributeNS(null, "scope");
                        string6 = element.getAttributeNS(null, "class-name");
                        string2 = element.getAttributeNS(null, "event-id");
                        break;
                    }
                    case 8: 
                    case 9: 
                    case 10: 
                    case 18: {
                        string5 = "Object Class";
                        string6 = element.getAttributeNS(null, "class-name");
                        string3 = element.getAttributeNS(null, "src-dn");
                        string2 = element.getAttributeNS(null, "event-id");
                        break;
                    }
                    case 15: {
                        string2 = element.getAttributeNS(null, "event-id");
                        break;
                    }
                    case 17: {
                        string2 = element.getAttributeNS(null, "event-id");
                        break;
                    }
                    case 11: {
                        string5 = element.getAttributeNS(null, "class-name");
                        element2 = XdsUtil.getFirstChildElementByTagNameNS(element, null, "new-name");
                        if (element2 != null) {
                            string6 = XdsUtil.getChildText(element2);
                        }
                        string3 = element.getAttributeNS(null, "src-dn");
                        string2 = element.getAttributeNS(null, "event-id");
                        break;
                    }
                    case 12: {
                        element2 = XdsUtil.getFirstChildElementByTagNameNS(element, null, "parent");
                        if (element2 != null) {
                            string5 = element2.getAttributeNS(null, "dest-dn");
                            string6 = XdsUtil.getAssociationValue(element2);
                        }
                        string3 = element.getAttributeNS(null, "src-dn");
                        string2 = element.getAttributeNS(null, "event-id");
                        break;
                    }
                    case 13: {
                        string4 = element.getAttributeNS(null, "dest-dn");
                        l2 = 1L;
                        string5 = "DirXML-Associations";
                        string6 = XdsUtil.getChildText(element);
                        string2 = element.getAttributeNS(null, "event-id");
                        break;
                    }
                    case 14: {
                        string5 = "DirXML-Associations";
                        string6 = XdsUtil.getChildText(element);
                        string2 = element.getAttributeNS(null, "event-id");
                        break;
                    }
                    case 16: {
                        string4 = string;
                        l2 = 1L;
                        break;
                    }
                    case 45: {
                        string6 = XdsUtil.getChildText(element);
                        string2 = element.getAttributeNS(null, "event-id");
                        break;
                    }
                }
                logEvent = new LogEvent(n, string4, l2, string5, string6, string3, string2, l, element);
                arrayList.add(logEvent);
                logSettings = PersistentLog.getChannelSettings(n2);
                if (n != 8 || !logSettings.filter(47)) break block23;
                Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "add-attr");
                int n3 = 0;
                while (n3 < elementArray.length) {
                    Element[] elementArray2 = XdsUtil.getChildElementsByTagNameNS(elementArray[n3], null, "value");
                    String string7 = elementArray[n3].getAttributeNS(null, "attr-name");
                    int n4 = 0;
                    while (n4 < elementArray2.length) {
                        String string8 = null;
                        l = 0L;
                        string8 = string7.equalsIgnoreCase("nspmDistributionPassword") ? Warnings.getMessage(8000, "nspmDistributionPassword") : (string7.equalsIgnoreCase("SAS:Login Configuration") ? Warnings.getMessage(8000, "SAS:Login Configuration") : Events.getElementContent(null, elementArray2[n4], false));
                        logEvent = new LogEvent(47, string4, l2, string7, string8, string3, string2, l, string8);
                        arrayList.add(logEvent);
                        ++n4;
                    }
                    ++n3;
                }
                break block24;
            }
            if (n != 10 || !logSettings.filter(41) && !logSettings.filter(42) && !logSettings.filter(43)) break block24;
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "modify-attr");
            int n5 = 0;
            while (n5 < elementArray.length) {
                Element element3;
                Element element4 = elementArray[n5];
                String string9 = element4.getAttributeNS(null, "attr-name");
                if (XdsUtil.getFirstChildElementByTagNameNS(element4, null, "remove-all-values") != null) {
                    logEvent = new LogEvent(41, string4, l2, string9, null, string3, string2, l, null);
                    arrayList.add(logEvent);
                }
                NodeList nodeList = element4.getElementsByTagNameNS(null, "value");
                int n6 = 0;
                while ((element3 = (Element)nodeList.item(n6++)) != null) {
                    l = 0L;
                    Element element5 = (Element)element3.getParentNode();
                    String string10 = element5.getNodeName();
                    int n7 = 42;
                    if (string10.equals("remove-value")) {
                        n7 = 43;
                    }
                    String string11 = null;
                    string11 = string9.equalsIgnoreCase("nspmDistributionPassword") ? Warnings.getMessage(8000, "nspmDistributionPassword") : (string9.equalsIgnoreCase("SAS:Login Configuration") ? Warnings.getMessage(8000, "SAS:Login Configuration") : Events.getElementContent(string9, element3, false));
                    logEvent = new LogEvent(n7, string4, l2, string9, string11, string3, string2, l, string11);
                    arrayList.add(logEvent);
                }
                ++n5;
            }
        }
        return arrayList;
    }

    public static String getElementContent(String string, Element element, boolean bl) {
        Node node;
        String string2 = null;
        if (string != null && Driver.isSensitiveAttr(string)) {
            return null;
        }
        Document document = element.getOwnerDocument();
        DocumentFragment documentFragment = document.createDocumentFragment();
        if (!bl) {
            node = element.getFirstChild();
            if (node == null) {
                return null;
            }
            do {
                if (node.getNodeType() == 1 && node.getNamespaceURI() == null && node.getLocalName().equals("operation-data")) continue;
                XdsUtil.graftSubtree(documentFragment, node);
            } while ((node = node.getNextSibling()) != null);
        } else {
            XdsUtil.graftSubtree(documentFragment, element);
        }
        node = documentFragment.getFirstChild();
        if (node == null) {
            return null;
        }
        if (!bl && node == documentFragment.getLastChild() && node.getNodeType() == 3) {
            string2 = node.getNodeValue();
        } else {
            StringWriter stringWriter = new StringWriter();
            Trace_DOMWriter trace_DOMWriter = new Trace_DOMWriter(documentFragment, stringWriter);
            trace_DOMWriter.setWriteDeclaration(false);
            trace_DOMWriter.setIndent(true);
            trace_DOMWriter.setSensitiveElements(elementMap);
            try {
                trace_DOMWriter.write();
                string2 = stringWriter.toString();
            }
            catch (IOException iOException) {
                string2 = null;
            }
        }
        return string2;
    }

    public static class LogEvent {
        protected String target;
        protected long targetType;
        protected String subTarget;
        protected String text1;
        protected String text2;
        protected String text3;
        protected long value1;
        protected int eventID;
        protected int level;
        protected Object blob;

        public LogEvent(int n, String string, long l, String string2, String string3, String string4, String string5, long l2, Object object) {
            this.eventID = n;
            this.level = -1;
            this.target = string;
            this.targetType = l;
            this.subTarget = string2;
            this.text1 = string3;
            this.text2 = string4;
            this.text3 = string5;
            this.value1 = l2;
            this.blob = object;
        }

        public LogEvent(int n, int n2, String string, String string2) {
            this.eventID = n;
            this.level = n2;
            this.target = null;
            this.targetType = 0L;
            this.subTarget = string;
            this.text1 = string2;
            this.text2 = null;
            this.text3 = null;
            this.value1 = 0L;
            this.blob = string2;
        }

        public LogEvent(int n, int n2, String string, long l, String string2, String string3, String string4, String string5, long l2, Object object) {
            this.eventID = n;
            this.level = this.level;
            this.target = string;
            this.targetType = l;
            this.subTarget = string2;
            this.text1 = string3;
            this.text2 = string4;
            this.text3 = string5;
            this.value1 = l2;
            this.blob = object;
        }

        public String getTarget() {
            return this.target;
        }

        public String getSubTarget() {
            return this.subTarget;
        }

        public long getTargetType() {
            return this.targetType;
        }

        public String getText1() {
            return this.text1;
        }

        public String getText2() {
            return this.text2;
        }

        public String getText3() {
            return this.text3;
        }

        public long getValue1() {
            return this.value1;
        }

        public int getEventID() {
            return this.eventID;
        }

        public int getLevel() {
            return this.level;
        }

        public Object getData() {
            return this.blob;
        }
    }
}

