/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.util.DxConst;
import java.util.Date;

class LogSettings {
    public static final int LOG_ERRORS = 0;
    public static final int LOG_WARNINGS = 1;
    public static final int LOG_TIME_ONLY = 2;
    public static final int LOG_TURNED_OFF = 3;
    public static final int LOG_ALL_STATUS_MESSAGES = 4;
    public static final int LOG_SPECIFIC_EVENTS = 5;
    public static final int DEFAULT_LOG_LIMIT = 50;
    public static final int MAX_LOG_LIMIT = 500;
    protected int level;
    protected int limit;
    protected boolean[] eventList = new boolean[DxConst.getLogEventListSize()];
    protected static Object eventGate = new Object();
    protected static LogTimestamp lastTS;

    LogSettings() {
        int n = 0;
        while (n < this.eventList.length) {
            this.eventList[n] = false;
            ++n;
        }
        this.level = 3;
    }

    void setLevel(int n) {
        if (this.level != n) {
            this.level = n;
            this.clearEventList();
        }
        if (n == 5) {
            return;
        }
        if (n == 0) {
            this.eventList[38] = true;
            this.eventList[4] = true;
            this.eventList[5] = true;
        } else if (n == 1) {
            this.eventList[38] = true;
            this.eventList[39] = true;
            this.eventList[4] = true;
            this.eventList[5] = true;
            this.eventList[3] = true;
            this.eventList[35] = true;
        } else if (n == 4) {
            this.eventList[38] = true;
            this.eventList[39] = true;
            this.eventList[4] = true;
            this.eventList[5] = true;
            this.eventList[3] = true;
            this.eventList[1] = true;
            this.eventList[2] = true;
            this.eventList[6] = true;
            this.eventList[35] = true;
            this.eventList[34] = true;
        }
    }

    void setLimit(int n) {
        this.limit = n;
    }

    void addEvent(int n) {
        if (n > DxConst.getMaxLogEventNumber() || n < 0) {
            return;
        }
        this.eventList[n] = true;
        if (n == 42) {
            this.eventList[47] = true;
        }
    }

    void setEventList(boolean[] blArray) {
        if (blArray == null) {
            return;
        }
        int n = 0;
        while (n < blArray.length) {
            if (n >= this.eventList.length) {
                return;
            }
            this.eventList[n] = blArray[n];
            ++n;
        }
    }

    void clearEventList() {
        int n = 0;
        while (n < this.eventList.length) {
            this.eventList[n] = false;
            ++n;
        }
    }

    int getLevel() {
        return this.level;
    }

    int getLimit() {
        return this.limit;
    }

    boolean[] getEventList() {
        return this.eventList;
    }

    boolean filter(int n) {
        if (n >= 1000 && n <= 1999) {
            return true;
        }
        if (this.level == 3 || this.level == 2) {
            return false;
        }
        return this.eventList[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogTimestamp getLogTimestamp() {
        LogTimestamp logTimestamp = new LogTimestamp();
        Object object = eventGate;
        synchronized (object) {
            if (lastTS != null && logTimestamp.getSeconds() == lastTS.getSeconds()) {
                logTimestamp.setTickCount(lastTS.getTickCount() + 1L);
            }
            lastTS = logTimestamp;
        }
        return logTimestamp;
    }

    public static class LogTimestamp {
        private long seconds;
        private long tickCount;

        LogTimestamp() {
            Date date = new Date();
            this.seconds = date.getTime();
            this.tickCount = 0L;
        }

        public long getSeconds() {
            return this.seconds;
        }

        public long getTickCount() {
            return this.tickCount;
        }

        public void setTickCount(long l) {
            this.tickCount = l;
        }
    }
}

