/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.engine.CaseIgnoreStringKey;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.events.EventHandler;
import com.novell.nds.events.EventNotification;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import novell.jclient.JCAttributeDef;
import novell.jclient.JCClassDef;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JCReferral;
import novell.jclient.JClient;

public abstract class SchemaCache {
    private static HashMap classMap = null;
    private static HashMap attrMap = null;
    private static boolean needsRefresh = true;
    private static EventHandler eventHandler = null;
    private static final int[] SCHEMA_EVENTS = new int[]{68, 69, 116, 117, 118, 119, 120};

    public static synchronized JCAttributeDef getAttributeDef(String string) {
        JCAttributeDef jCAttributeDef = null;
        AttrEntry attrEntry = (AttrEntry)attrMap.get(new CaseIgnoreStringKey(string));
        if (attrEntry != null) {
            jCAttributeDef = attrEntry.attrDef;
        }
        return jCAttributeDef;
    }

    public static synchronized JCClassDef getClassDef(String string) {
        JCClassDef jCClassDef = null;
        ClassEntry classEntry = (ClassEntry)classMap.get(new CaseIgnoreStringKey(string));
        if (classEntry != null) {
            jCClassDef = classEntry.classDef;
        }
        return jCClassDef;
    }

    public static synchronized HashSet getClassAttrs(String string) {
        ClassEntry classEntry = (ClassEntry)classMap.get(new CaseIgnoreStringKey(string));
        if (classEntry != null) {
            return classEntry.attrs;
        }
        return null;
    }

    public static synchronized HashSet getAttrAuxClasses(String string) {
        AttrEntry attrEntry = (AttrEntry)attrMap.get(new CaseIgnoreStringKey(string));
        if (attrEntry != null) {
            return attrEntry.auxClasses;
        }
        return null;
    }

    public static synchronized JCClassDef[] getClassDefs() {
        JCClassDef[] jCClassDefArray = new JCClassDef[classMap.size()];
        Iterator iterator = classMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            jCClassDefArray[n++] = ((ClassEntry)iterator.next()).classDef;
        }
        return jCClassDefArray;
    }

    public static synchronized JCAttributeDef[] getAttrDefs() {
        JCAttributeDef[] jCAttributeDefArray = new JCAttributeDef[attrMap.size()];
        Iterator iterator = attrMap.values().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            jCAttributeDefArray[n++] = ((AttrEntry)iterator.next()).attrDef;
        }
        return jCAttributeDefArray;
    }

    /*
     * Unable to fully structure code
     */
    public static synchronized void init(JCContext var0) throws VRDException {
        if (var0 == null && SchemaCache.eventHandler == null) {
            block7: {
                var1_1 = -1;
                SchemaCache.eventHandler = new SchemaEventHandler();
                try {
                    var1_1 = 0;
                    while (var1_1 < SchemaCache.SCHEMA_EVENTS.length) {
                        EventNotification.registerForEvent((int)2, (int)SchemaCache.SCHEMA_EVENTS[var1_1], (int)0, (EventHandler)SchemaCache.eventHandler);
                        ++var1_1;
                    }
                    break block7;
                }
                catch (Throwable var2_2) {
                    ** while (--var1_1 >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        EventNotification.unregisterForEvent((int)2, (int)SchemaCache.SCHEMA_EVENTS[var1_1], (EventHandler)SchemaCache.eventHandler);
                    }
                    catch (Throwable var3_3) {
                        // empty catch block
                    }
                    continue;
                }
lbl19:
                // 1 sources

                SchemaCache.eventHandler = null;
                throw new VRDException(var2_2);
            }
            SchemaCache.refresh(var0);
        }
    }

    public static synchronized void cleanup() {
        if (eventHandler != null) {
            int n = SCHEMA_EVENTS.length - 1;
            while (n >= 0) {
                try {
                    EventNotification.unregisterForEvent((int)2, (int)SCHEMA_EVENTS[n], (EventHandler)eventHandler);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                --n;
            }
            eventHandler = null;
        }
        classMap = null;
        attrMap = null;
        needsRefresh = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void refresh(JCContext jCContext) throws VRDException {
        if (!needsRefresh) {
            return;
        }
        JCContext jCContext2 = null;
        try {
            try {
                AttrEntry attrEntry;
                JCClassDef[] jCClassDefArray;
                classMap = new HashMap();
                attrMap = new HashMap();
                if (jCContext == null) {
                    jCContext = jCContext2 = new JCContext();
                    jCContext.connect(0L, (JCReferral)null);
                }
                JCAttributeDef[] jCAttributeDefArray = JClient.readAttributeDef((JCContext)jCContext, (long)1L, null);
                int n = 0;
                while (n < jCAttributeDefArray.length) {
                    jCClassDefArray = jCAttributeDefArray[n];
                    CaseIgnoreStringKey caseIgnoreStringKey = new CaseIgnoreStringKey(jCClassDefArray.getName());
                    attrEntry = new AttrEntry();
                    attrEntry.attrDef = jCClassDefArray;
                    attrMap.put(caseIgnoreStringKey, attrEntry);
                    ++n;
                }
                jCClassDefArray = JClient.readClassDef((JCContext)jCContext, (long)2L, null);
                int n2 = 0;
                while (n2 < jCClassDefArray.length) {
                    attrEntry = jCClassDefArray[n2];
                    CaseIgnoreStringKey caseIgnoreStringKey = new CaseIgnoreStringKey(attrEntry.getName());
                    ClassEntry classEntry = new ClassEntry();
                    classEntry.classDef = attrEntry;
                    classEntry.attrs = new HashSet();
                    SchemaCache.addClassAttributesToSet(classEntry.attrs, (JCClassDef)attrEntry);
                    classMap.put(caseIgnoreStringKey, classEntry);
                    if ((attrEntry.getCharacteristics() & 0x20L) != 0L) {
                        Iterator iterator = classEntry.attrs.iterator();
                        while (iterator.hasNext()) {
                            AttrEntry attrEntry2 = (AttrEntry)attrMap.get(iterator.next());
                            if (attrEntry2 == null) continue;
                            if (attrEntry2.auxClasses == null) {
                                attrEntry2.auxClasses = new HashSet();
                            }
                            attrEntry2.auxClasses.add(caseIgnoreStringKey);
                        }
                    }
                    ++n2;
                }
                needsRefresh = false;
            }
            catch (JCException jCException) {
                throw new VRDException(jCException);
            }
            Object var12_13 = null;
            if (jCContext2 == null) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (jCContext2 == null) throw throwable;
            jCContext2.free();
            throw throwable;
        }
        jCContext2.free();
    }

    private static void addClassAttributesToSet(HashSet hashSet, JCClassDef jCClassDef) {
        String[][] stringArrayArray = new String[][]{jCClassDef.getMandatoryAttributes(), jCClassDef.getOptionalAttributes()};
        int n = 0;
        while (n < stringArrayArray.length) {
            int n2 = 0;
            while (n2 < stringArrayArray[n].length) {
                String string = stringArrayArray[n][n2];
                JCAttributeDef jCAttributeDef = SchemaCache.getAttributeDef(string);
                long l = jCAttributeDef.getConstraints();
                if ((l & 0x18L) == 0L) {
                    hashSet.add(new CaseIgnoreStringKey(string));
                }
                ++n2;
            }
            ++n;
        }
    }

    private static class SchemaEventHandler
    implements EventHandler {
        private SchemaEventHandler() {
        }

        public int handleEvent(int n, byte[] byArray, long l, int n2, boolean bl) {
            needsRefresh = true;
            return 0;
        }
    }

    private static class AttrEntry {
        JCAttributeDef attrDef = null;
        HashSet auxClasses = null;

        private AttrEntry() {
        }
    }

    private static class ClassEntry {
        JCClassDef classDef = null;
        HashSet attrs = null;

        private ClassEntry() {
        }
    }
}

