/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.engine.DirXML;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Errors;
import com.novell.nds.dirxml.engine.Events;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.ThreadVars;
import com.novell.nds.dirxml.engine.Transformer;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.Warnings;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.nds.dstrace.DDSTrace;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class StatusLog {
    protected static final String EVENT_HEADER = "sl_eh";
    protected static final String DRIVER_DN_LABEL = "sl_ddnlbl";
    protected static final String CHANNEL_LABEL = "sl_clbl";
    protected static final String OBJECT_DN_LABEL = "sl_odnlbl";
    protected static final String STATUS_LABEL = "sl_slbl";
    protected static final String MESSAGE_LABEL = "sl_mlbl";
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.StatusLog");
    protected static final int[] LEVEL_TO_COLOR_MAP = new int[]{10, 14, 14, 12, 12};

    public static void log(Throwable throwable) {
        VRDException vRDException = !(throwable instanceof VRDException) ? new VRDException(throwable) : (VRDException)throwable;
        String string = vRDException.getLocalizedMessage();
        if (string == null || string.length() == 0) {
            string = vRDException.toString();
        }
        StatusLog.logInternal(vRDException.getSeverity(), string);
        if (DirXML.isExternal()) {
            return;
        }
        int n = 38;
        if (vRDException.getSeverity() == 2 || vRDException.getSeverity() == 1) {
            n = 39;
        }
        PersistentLog.logEvent(n, Events.convertLevel(vRDException.getSeverity()), (String)ThreadVars.get("currentObject"), 0L, null, string, null, null, vRDException.getErrorCode(), 0L);
    }

    public static void log(Document document) {
        if (document != null) {
            Element element;
            NodeList nodeList = document.getElementsByTagNameNS(null, "status");
            int n = 0;
            while ((element = (Element)nodeList.item(n++)) != null) {
                StatusLog.log(element);
            }
        }
    }

    public static void log(Element element) {
        String string;
        int n = NdsDtd.getStatusLevel(element);
        String string2 = Events.getElementContent(null, element, false);
        if (StatusLog.traceFilter(n)) {
            StatusLog.logInternal(n, string2);
        }
        if (DirXML.isExternal()) {
            return;
        }
        StatusLog.addLogDataElements(element);
        int n2 = Events.getStatusEventID(element.getAttributeNS(null, "level"));
        String string3 = XdsUtil.getAssociationValue(element);
        long l = 4L;
        if (string3 == null || string3.length() == 0) {
            string3 = (String)ThreadVars.get("currentObject");
            l = 0L;
        }
        String string4 = element.getAttributeNS(null, "level");
        String string5 = element.getAttributeNS(null, "text1");
        if (string5 == null || string5.equals("")) {
            string5 = element.getAttributeNS(null, "type");
        }
        if ((string = element.getAttributeNS(null, "text2")) == null || string.equals("")) {
            string = string2;
        }
        String string6 = element.getAttributeNS(null, "event-id");
        Long l2 = new Long(0L);
        try {
            String string7 = element.getAttributeNS(null, "value1");
            if (string7 != null) {
                l2 = new Long(string7);
            }
        }
        catch (NumberFormatException numberFormatException) {
            l2 = new Long(0L);
        }
        PersistentLog.logEvent(n2, Events.convertLevel(n), string3, l, string4, string5, string, string6, (long)l2, 0L, element);
    }

    public static void logWarning(int n) {
        StatusLog.logWarning(n, null);
    }

    public static void logWarning(int n, Object object) {
        StatusLog.logWarning(n, new Object[]{object});
    }

    public static void logWarning(int n, Object object, Object object2) {
        StatusLog.logWarning(n, new Object[]{object, object2});
    }

    public static void logWarning(int n, Object[] objectArray) {
        String string = Warnings.getMessage(n, objectArray);
        StatusLog.logInternal(2, string);
        PersistentLog.logEvent(39, 5, (String)ThreadVars.get("currentObject"), 0L, null, string, null, null, n, 0L);
    }

    public static void logError(int n) {
        StatusLog.logError(n, (Object[])null);
    }

    public static void logError(int n, Throwable throwable) {
        StatusLog.logError(n, new Object[]{throwable.getLocalizedMessage()});
    }

    public static void logError(int n, Object object) {
        StatusLog.logError(n, new Object[]{object});
    }

    public static void logError(int n, Object object, Object object2) {
        StatusLog.logError(n, new Object[]{object, object2});
    }

    public static void logError(int n, Object[] objectArray) {
        String string = Errors.getMessage(n, objectArray);
        StatusLog.logInternal(3, string);
        if (DirXML.isExternal()) {
            return;
        }
        PersistentLog.logEvent(38, 4, (String)ThreadVars.get("currentObject"), 0L, null, string, null, null, n, 0L);
    }

    public static String getTextValue(Node node) {
        if (node != null) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                if (node2.getNodeType() == 3) {
                    return node2.getNodeValue();
                }
                node2 = node2.getNextSibling();
            }
        }
        return null;
    }

    public static String getStatusMessage(Element element) {
        return Events.getElementContent(null, element, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void logInternal(int n, String string) {
        String string2;
        String string3;
        if (!StatusLog.traceFilter(n)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Transformer transformer = (Transformer)ThreadVars.get("channel");
        stringBuffer.append('\n');
        stringBuffer.append(messageSource.getMessageString(EVENT_HEADER));
        String string4 = (String)ThreadGroupVars.get("vrDriverDN");
        if (string4 != null && string4.length() != 0) {
            stringBuffer.append('\n');
            stringBuffer.append(messageSource.getMessageString(DRIVER_DN_LABEL));
            stringBuffer.append(string4);
        }
        String string5 = string3 = transformer == null ? null : transformer.getChannelName();
        if (string3 != null && string3.length() != 0) {
            stringBuffer.append('\n');
            stringBuffer.append(messageSource.getMessageString(CHANNEL_LABEL));
            stringBuffer.append(string3);
        }
        if ((string2 = (String)ThreadVars.get("currentObject")) != null && string2.length() != 0) {
            stringBuffer.append('\n');
            stringBuffer.append(messageSource.getMessageString(OBJECT_DN_LABEL));
            stringBuffer.append(string2);
        }
        stringBuffer.append('\n');
        stringBuffer.append(messageSource.getMessageString(STATUS_LABEL));
        stringBuffer.append(NdsDtd.getLocalizedLevelString(n));
        if (string != null && string.length() != 0) {
            stringBuffer.append('\n');
            stringBuffer.append(messageSource.getMessageString(MESSAGE_LABEL));
            stringBuffer.append(string);
        }
        int n2 = StatusLog.mapLevelToColor(n);
        try {
            EngineTrace engineTrace = EngineTrace.getDefaultTracer();
            engineTrace.pushColorAlways(n2);
            try {
                engineTrace.trace(0, stringBuffer.toString());
                Object var10_10 = null;
                engineTrace.popColorAlways();
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                engineTrace.popColorAlways();
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            try {
                DDSTrace.trace((int)217, (int)n2, (String)stringBuffer.toString());
                DDSTrace.trace((int)217, (int)12, (String)Errors.getMessage(9121, throwable));
            }
            catch (Throwable throwable2) {
                System.err.println(stringBuffer.toString());
            }
        }
    }

    protected static boolean traceFilter(int n) {
        if (n != 0) {
            return true;
        }
        EngineTrace engineTrace = EngineTrace.getDefaultTracer();
        return engineTrace != null;
    }

    protected static int mapLevelToColor(int n) {
        try {
            return LEVEL_TO_COLOR_MAP[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 12;
        }
    }

    public static void addLogDataElements(Element element) {
        Object object;
        Object object2;
        String string = (String)ThreadVars.get("currentObject");
        Transformer transformer = (Transformer)ThreadVars.get("channel");
        int n = transformer != null ? transformer.getChannelID() : 0;
        if (XdsUtil.getFirstElementByTagNameNS(element, null, "application") == null) {
            object2 = element.getOwnerDocument().createElementNS(null, "application");
            element.appendChild((Node)object2);
            object2.appendChild(element.getOwnerDocument().createTextNode("DirXML"));
        }
        if (XdsUtil.getFirstElementByTagNameNS(element, null, "module") == null && (object2 = (String)ThreadGroupVars.get("vrDriverDN")) != null && ((String)object2).length() > 0) {
            object = "00.\\+=*'".toCharArray();
            XdsDN xdsDN = new XdsDN((String)object2, (char[])object);
            String string2 = xdsDN.getRDN((char[])object, 1);
            Element element2 = element.getOwnerDocument().createElementNS(null, "module");
            element.appendChild(element2);
            element2.appendChild(element.getOwnerDocument().createTextNode(string2));
        }
        if (XdsUtil.getFirstElementByTagNameNS(element, null, "object-dn") == null) {
            object2 = element.getOwnerDocument().createElementNS(null, "object-dn");
            element.appendChild((Node)object2);
            object2.appendChild(element.getOwnerDocument().createTextNode(string));
        }
        if (XdsUtil.getFirstElementByTagNameNS(element, null, "component") == null) {
            object2 = Transformer.getChannelName(n);
            object = element.getOwnerDocument().createElementNS(null, "component");
            element.appendChild((Node)object);
            object.appendChild(element.getOwnerDocument().createTextNode((String)object2));
        }
    }
}

