/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import java.io.IOException;
import java.util.Comparator;

public class StringUtil {
    private static CaseIgnoreComparator caseIgnoreComparator = new CaseIgnoreComparator();
    private static final char[] binToAscii = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final int[] asciiToBinLo = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 0, 0, 0, 0, 0, 0, 0, 10, 11, 12, 13, 14, 15};
    private static final int[] asciiToBinHi = new int[]{0, 16, 32, 48, 64, 80, 96, 112, 128, 144, 0, 0, 0, 0, 0, 0, 0, 160, 176, 192, 208, 224, 240};

    public static String toUpperCaseChars(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = Character.toUpperCase(string.charAt(n2));
            ++n2;
        }
        return new String(cArray);
    }

    public static String toLowerCaseChars(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = Character.toLowerCase(string.charAt(n2));
            ++n2;
        }
        return new String(cArray);
    }

    public static boolean equalIgnoreCase(char c, char c2) {
        return c == c2 || (c = Character.toUpperCase(c)) == (c2 = Character.toUpperCase(c2)) || (c = Character.toLowerCase(c)) == (c2 = Character.toLowerCase(c2));
    }

    public static int indexOfIgnoreCase(String string, char c) {
        return StringUtil.indexOfIgnoreCase(string, c, 0);
    }

    public static int indexOfIgnoreCase(String string, char c, int n) {
        int n2 = string.length();
        if (n < 0) {
            n = 0;
        }
        int n3 = n;
        while (n3 < n2) {
            if (StringUtil.equalIgnoreCase(string.charAt(n3), c)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return StringUtil.indexOfIgnoreCase(string, string2, 0);
    }

    public static int indexOfIgnoreCase(String string, String string2, int n) {
        int n2 = string.length();
        int n3 = string2.length();
        if (n3 + n > n2) {
            return -1;
        }
        if (n >= n2) {
            return n3 == 0 ? n2 : -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n3 == 0) {
            return n;
        }
        int n4 = n2 - n3;
        int n5 = 0;
        while (n5 <= n4) {
            if (string.regionMatches(true, n5, string2, 0, n3)) {
                return n5;
            }
            ++n5;
        }
        return -1;
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        if (n2 > n) {
            return false;
        }
        return string.regionMatches(true, 0, string2, 0, n2);
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        if (n2 > n) {
            return false;
        }
        return string.regionMatches(true, n - n2, string2, 0, n2);
    }

    public static String substring(String string, int n, int n2) {
        int n3;
        int n4 = string.length();
        if (n2 < 0 && (n2 = n4 + 1 + n2) < 0) {
            n2 = 0;
        }
        if (n < 0 && (n += n4) < 0) {
            n = 0;
        }
        if ((n3 = n + n2) > n4) {
            n3 = n4;
        }
        return string.substring(n, n3);
    }

    public static String substringBefore(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String substringBeforeIgnoreCase(String string, String string2) {
        int n = StringUtil.indexOfIgnoreCase(string, string2);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }

    public static String substringAfter(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == -1) {
            return "";
        }
        return string.substring(n + string2.length());
    }

    public static String substringAfterIgnoreCase(String string, String string2) {
        int n = StringUtil.indexOfIgnoreCase(string, string2);
        if (n == -1) {
            return "";
        }
        return string.substring(n + string2.length());
    }

    public static Comparator getCaseIgnoreComparator() {
        return caseIgnoreComparator;
    }

    public static String GUIDToString(byte[] byArray) throws IOException {
        String string = StringUtil.encodeAsciiHex(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append(string.substring(6, 8));
        stringBuffer.append(string.substring(4, 6));
        stringBuffer.append(string.substring(2, 4));
        stringBuffer.append(string.substring(0, 2));
        stringBuffer.append('-');
        stringBuffer.append(string.substring(10, 12));
        stringBuffer.append(string.substring(8, 10));
        stringBuffer.append('-');
        stringBuffer.append(string.substring(14, 16).toLowerCase());
        stringBuffer.append(string.substring(12, 14).toLowerCase());
        stringBuffer.append('-');
        stringBuffer.append(string.substring(16, 20));
        stringBuffer.append('-');
        stringBuffer.append(string.substring(20));
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static byte[] stringToGUID(String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string.substring(7, 9));
        stringBuffer.append(string.substring(5, 7));
        stringBuffer.append(string.substring(3, 5));
        stringBuffer.append(string.substring(1, 3));
        stringBuffer.append(string.substring(12, 14));
        stringBuffer.append(string.substring(10, 12));
        stringBuffer.append(string.substring(17, 19));
        stringBuffer.append(string.substring(15, 17));
        stringBuffer.append(string.substring(20, 24));
        stringBuffer.append(string.substring(25, 37));
        return StringUtil.decodeAsciiHex(stringBuffer.toString());
    }

    public static byte[] decodeAsciiHex(String string) {
        string = string.toUpperCase();
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byArray[n2++] = (byte)(asciiToBinHi[string.charAt(n3) - 48] + asciiToBinLo[string.charAt(n3 + 1) - 48]);
            n3 += 2;
        }
        return byArray;
    }

    public static String encodeAsciiHex(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            stringBuffer.append(binToAscii[by >> 4 & 0xF]);
            stringBuffer.append(binToAscii[by & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private static class CaseIgnoreComparator
    implements Comparator {
        private CaseIgnoreComparator() {
        }

        public int compare(Object object, Object object2) {
            return object.toString().compareToIgnoreCase(object2.toString());
        }
    }
}

