/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.driver.TraceInterface;
import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.ThreadVars;
import com.novell.nds.dirxml.engine.Transformer;

public class TraceImpl
implements TraceInterface {
    protected EngineTrace tracer;

    public TraceImpl() {
        Transformer transformer = (Transformer)ThreadVars.get("channel");
        if (transformer != null) {
            this.tracer = transformer.getTracer();
        } else {
            this.tracer = (EngineTrace)ThreadVars.get("default-tracer");
            if (this.tracer == null) {
                this.tracer = new EngineTrace(-1L);
                this.tracer.setLevel(ConfigAbstraction.getGlobalTraceLevel());
                this.tracer.setTraceFile(ConfigAbstraction.getGlobalTraceFilename());
                this.tracer.setMaxTraceFileSize(ConfigAbstraction.getGlobalTraceSizeLimit());
            }
        }
    }

    public void trace(int n, String string) {
        this.tracer.trace(n, string);
    }

    public void trace(int n, XmlDocument xmlDocument) {
        this.tracer.trace(n, xmlDocument);
    }

    public int getLevel() {
        return this.tracer.getLevel();
    }
}

