/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.Association;
import com.novell.nds.dirxml.engine.CaseIgnoreStringKey;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.NdsConstants;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.OperationData;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.SchemaCache;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.StringUtil;
import com.novell.nds.dirxml.engine.SyntaxProviderImpl;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsQueryProcessor;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueFactory;
import com.novell.nds.dirxml.engine.rules.DirXMLScriptProcessor;
import com.novell.nds.dirxml.engine.rules.Filter;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleProcessor;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.XSLTRuleProcessor;
import com.novell.nds.dirxml.engine.rules.util.RuleUpgrader;
import com.novell.nds.dirxml.engine.rules.util.SyntaxProvider;
import com.novell.nds.dirxml.engine.rules.util.UpgradeException;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.NamespaceName;
import com.novell.xsl.Stylesheet;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import novell.jclient.JCClassDef;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JCPathValue;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Transformer {
    protected Driver driver = null;
    protected ConfigAbstraction registry;
    protected Element rootElement;
    protected JCContext context = null;
    protected EngineTrace tracer;
    protected Filter filter;
    protected final int channel;
    protected final int filterChannel;
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.Transformer");
    protected static final String ENGINE_CHANNEL = "tt_engchan";
    protected static final String SUBSCRIBER_CHANNEL = "tt_subchan";
    protected static final String PUBLISHER_CHANNEL = "tt_pubchan";
    protected static final String LOADING_INPUT_TRANSFORM = "tt_lixform";
    protected static final String LOADING_OUTPUT_TRANSFORM = "tt_loxform";
    protected static final String LOADING_MAPPING_TRANSFORM = "tt_lmxform";
    protected static final String LOADING_CREATE_TRANSFORM = "tt_lcxform";
    protected static final String LOADING_MATCH_TRANSFORM = "tt_laxform";
    protected static final String LOADING_PLACEMENT_TRANSFORM = "tt_lpxform";
    protected static final String LOADING_EVENT_TRANSFORM = "tt_lexform";
    protected static final String LOADING_COMMAND_TRANSFORM = "tt_ldxform";
    protected static final String APPLYING_INPUT_TRANSFORM = "tt_aixform";
    protected static final String APPLYING_OUTPUT_TRANSFORM = "tt_aoxform";
    protected static final String APPLYING_INPUT_MAPPING_RULE = "tt_aimxform";
    protected static final String APPLYING_OUTPUT_MAPPING_RULE = "tt_aomxform";
    protected static final String NO_INPUT_TRANSFORM = "tt_nixform";
    protected static final String NO_OUTPUT_TRANSFORM = "tt_noxform";
    protected static final String NO_MAPPING_RULE = "tt_nmxform";
    protected static final String APPLYING_COMMAND_TRANSFORM = "tt_acxform";
    protected static final String NO_COMMAND_TRANSFORM = "tt_ncxform";
    protected static final String RESOLVING_ASSOCIATION_REFS = "tt_rassref";
    protected static final String FIXING_UP_ASSOCIATION_REFS = "tt_fuassref";
    protected static final String FOUND_RULE = "tt_frul";
    protected static final String FOUND_DIRXMLSCRIPT_RULE = "tt_fdsrul";
    protected static final String FOUND_STYLESHEET_RULE = "tt_fsrul";
    protected static final String ERROR_INIT_RULE_PROCESSOR = "tt_eirulp";
    protected static final String RULE_NOT_FOUND = "tt_rulnf";
    protected static final String PERFORMING_FILTERED_READ = "tt_pfilrd";
    protected static final String FILTERED_RESULT = "tt_filrdr";
    protected static final String SYNTHETIC_ADD = "tt_synadd";
    protected static final String APPLYING_EVENT_TRANSFORM = "tt_aexform";
    protected static final String NO_EVENT_TRANSFORM = "tt_nexform";
    protected static final String APPLYING_MATCHING_RULE = "tt_amrule";
    protected static final String NO_MATCHING_RULE = "tt_nmrule";
    protected static final String MATCH_FOUND = "tt_mchfnd";
    protected static final String NO_MATCH_FOUND = "tt_nmchfnd";
    protected static final String APPLYING_CREATE_RULE = "tt_acrule";
    protected static final String NO_CREATE_RULE = "tt_ncrule";
    protected static final String APPLYING_PLACEMENT_RULE = "tt_aprule";
    protected static final String NO_PLACEMENT_RULE = "tt_nprule";
    protected static final String DO_MERGE = "tt_merge";
    protected static final String MERGE_UPDATE_NDS = "tt_updnds";
    protected static final String MERGE_UPDATE_APP = "tt_updapp";
    protected static final String UPGRADING_RULE = "tt_upgrule";
    protected static final String FILTERING_NOTIFY = "tt_fltntfy";
    protected static final String RESET_UPDATE_NDS = "tt_rstnds";
    protected static final String RESET_UPDATE_APP = "tt_rstapp";
    protected static final String FOUND_NON_CLASS_ATTR = "tt_aacfa";
    protected static final String REJECTING_AUX_CLASS = "tt_aacrc";
    protected static final String ADDING_AUX_CLASS = "tt_aacac";
    protected static final String[] MAPPING_RULE = new String[]{"com.novell.nds.dirxml.engine.rules.SchemaMappingRuleProcessor", "DirXML-MappingRule"};
    protected static final String[] EVENT_TRANSFORMATION_RULE = new String[]{"com.novell.nds.dirxml.engine.rules.DirXMLScriptProcessor", "DirXML-EventTransformationRule"};
    protected static final String[] MATCHING_RULE = new String[]{"com.novell.nds.dirxml.engine.rules.DirXMLScriptProcessor", "DirXML-MatchingRule"};
    protected static final String[] CREATE_RULE = new String[]{"com.novell.nds.dirxml.engine.rules.DirXMLScriptProcessor", "DirXML-CreateRule"};
    protected static final String[] PLACEMENT_RULE = new String[]{"com.novell.nds.dirxml.engine.rules.DirXMLScriptProcessor", "DirXML-PlacementRule"};
    protected static final String[] COMMAND_TRANSFORMATION_RULE = new String[]{"com.novell.nds.dirxml.engine.rules.DirXMLScriptProcessor", "DirXML-CommandTransformationRule"};
    protected static final String[] INPUT_TRANSFORMATION_RULE = new String[]{"com.novell.nds.dirxml.engine.rules.DirXMLScriptProcessor", "DirXML-InputTransform"};
    protected static final String[] OUTPUT_TRANSFORMATION_RULE = new String[]{"com.novell.nds.dirxml.engine.rules.DirXMLScriptProcessor", "DirXML-OutputTransform"};
    protected static final String PUBLIC_KEY = "Public Key";
    protected RuleProcessor inputTransformation = null;
    protected RuleProcessor outputTransformation = null;
    protected RuleProcessor eventTransformationRule = null;
    protected RuleProcessor matchingRule = null;
    protected RuleProcessor createRule = null;
    protected RuleProcessor placementRule = null;
    protected RuleProcessor commandTransformationRule = null;
    protected RuleProcessor inputMapper = null;
    protected RuleProcessor outputMapper = null;
    private String channelName;
    private String rootDN;
    private int iErrorCount;
    private int iWarningCount;
    protected static final String[][] refElementsTypes = new String[][]{{"value", "type", "dn"}, {"component", "name", "serverDn"}, {"component", "name", "holdEntryDn"}, {"component", "name", "trustee"}, {"component", "name", "volume"}, {"component", "name", "server"}, {"component", "name", "dn"}};
    protected static final String[] specialTrustees = new String[]{"\\[Root]", "\\[Inheritance Mask]", "\\[Public]", "\\[Self]", "\\[Creator]"};

    Transformer(Driver driver, ConfigAbstraction configAbstraction, int n, EngineTrace engineTrace) throws VRDException {
        this.driver = driver;
        this.registry = configAbstraction;
        this.channel = n;
        int n2 = this.filterChannel = this.channel == 1 ? 0 : 1;
        if (this.channel != 1 && this.channel != 2) {
            throw new IllegalArgumentException("Transformer: channel must be CHANNEL_SUBSCRIBER or CHANNEL_PUBLISHER");
        }
        this.filter = this.registry.getFilter();
        this.channelName = Transformer.getChannelName(this.channel);
        this.tracer = engineTrace;
        this.initTransformer();
        this.rootElement = null;
        this.rootDN = "\\" + this.registry.getTreeName();
    }

    void setRegistry(ConfigAbstraction configAbstraction) {
        this.registry = configAbstraction;
    }

    public int getChannelID() {
        return this.channel;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public static String getChannelName(int n) {
        String string;
        switch (n) {
            case 1: {
                string = SUBSCRIBER_CHANNEL;
                break;
            }
            case 2: {
                string = PUBLISHER_CHANNEL;
                break;
            }
            default: {
                string = ENGINE_CHANNEL;
            }
        }
        return messageSource.getMessageString(string);
    }

    public EngineTrace getTracer() {
        return this.tracer;
    }

    protected void initTransformer() throws VRDException {
        this.context = this.registry.getContext();
    }

    protected void loadDriverRules() throws VRDException {
        long[] lArray = new long[1];
        this.tracer.trace(LOADING_INPUT_TRANSFORM, (MessageSource)messageSource, this.channelName);
        this.inputTransformation = this.newRuleProcessor(INPUT_TRANSFORMATION_RULE, this.registry.getDriver(), false);
        this.tracer.trace(LOADING_OUTPUT_TRANSFORM, (MessageSource)messageSource, this.channelName);
        this.outputTransformation = this.newRuleProcessor(OUTPUT_TRANSFORMATION_RULE, this.registry.getDriver(), true);
        this.tracer.trace(LOADING_MAPPING_TRANSFORM, (MessageSource)messageSource, this.channelName);
        this.inputMapper = this.newRuleProcessor(MAPPING_RULE, this.registry.getDriver(), false);
        this.outputMapper = this.newRuleProcessor(MAPPING_RULE, this.registry.getDriver(), true);
    }

    protected void loadChannelRules(Entry entry, boolean bl) throws VRDException {
        if (entry != null) {
            this.tracer.trace(LOADING_EVENT_TRANSFORM, (MessageSource)messageSource, this.channelName);
            this.eventTransformationRule = this.newRuleProcessor(EVENT_TRANSFORMATION_RULE, entry, bl);
            this.tracer.trace(LOADING_MATCH_TRANSFORM, (MessageSource)messageSource, this.channelName);
            this.matchingRule = this.newRuleProcessor(MATCHING_RULE, entry, bl);
            this.tracer.trace(LOADING_CREATE_TRANSFORM, (MessageSource)messageSource, this.channelName);
            this.createRule = this.newRuleProcessor(CREATE_RULE, entry, bl);
            this.tracer.trace(LOADING_PLACEMENT_TRANSFORM, (MessageSource)messageSource, this.channelName);
            this.placementRule = this.newRuleProcessor(PLACEMENT_RULE, entry, bl);
            this.tracer.trace(LOADING_COMMAND_TRANSFORM, (MessageSource)messageSource, this.channelName);
            this.commandTransformationRule = this.newRuleProcessor(COMMAND_TRANSFORMATION_RULE, entry, bl);
        }
    }

    Document applyInputTransformation(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Document document2 = document;
        if (this.inputTransformation != null) {
            this.tracer.trace(APPLYING_INPUT_TRANSFORM, (MessageSource)messageSource);
            document2 = this.inputTransformation.applyRules(document2, ruleDynamicContext);
            PersistentLog.logEvent(21, 7, document2.getDocumentElement());
        } else {
            this.tracer.trace(NO_INPUT_TRANSFORM, (MessageSource)messageSource);
            PersistentLog.logEvent(21, 7, messageSource.getMessageString(NO_INPUT_TRANSFORM));
        }
        if (this.inputMapper != null) {
            this.tracer.trace(APPLYING_INPUT_MAPPING_RULE, (MessageSource)messageSource);
            document2 = this.inputMapper.applyRules(document2, ruleDynamicContext);
            PersistentLog.logEvent(26, 7, document2.getDocumentElement());
        } else {
            this.tracer.trace(NO_MAPPING_RULE, (MessageSource)messageSource);
            PersistentLog.logEvent(26, 7, messageSource.getMessageString(NO_MAPPING_RULE));
        }
        this.tracer.trace(RESOLVING_ASSOCIATION_REFS, (MessageSource)messageSource);
        this.resolveAssociationRefs(document2, true);
        return document2;
    }

    Document applyOutputTransformation(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        Document document2 = document;
        this.tracer.trace(FIXING_UP_ASSOCIATION_REFS, (MessageSource)messageSource);
        this.addAssociationRefs(document, false);
        if (this.outputMapper != null) {
            this.tracer.trace(APPLYING_OUTPUT_MAPPING_RULE, (MessageSource)messageSource);
            document2 = this.outputMapper.applyRules(document2, ruleDynamicContext);
            PersistentLog.logEvent(27, 7, document2.getDocumentElement());
        } else {
            this.tracer.trace(NO_MAPPING_RULE, (MessageSource)messageSource);
            PersistentLog.logEvent(27, 7, messageSource.getMessageString(NO_MAPPING_RULE));
        }
        if (this.outputTransformation != null) {
            this.tracer.trace(APPLYING_OUTPUT_TRANSFORM, (MessageSource)messageSource);
            document2 = this.outputTransformation.applyRules(document2, ruleDynamicContext);
            PersistentLog.logEvent(22, 7, document2.getDocumentElement());
        } else {
            this.tracer.trace(NO_OUTPUT_TRANSFORM, (MessageSource)messageSource);
            PersistentLog.logEvent(22, 7, messageSource.getMessageString(NO_OUTPUT_TRANSFORM));
        }
        return document2;
    }

    RuleProcessor newRuleProcessor(String[] stringArray, Entry entry, boolean bl) throws VRDException {
        String string = stringArray[0];
        String string2 = stringArray[1];
        long[] lArray = new long[1];
        Object object = null;
        Object object2 = null;
        HashSet<Long> hashSet = new HashSet<Long>();
        RuleStaticContext ruleStaticContext = this.driver.getStaticContext(bl);
        while (true) {
            Object object3;
            lArray[0] = -1L;
            Document document = this.registry.getRule(entry, string2, lArray);
            if (lArray[0] != -1L) {
                object3 = new Long(lArray[0]);
                if (hashSet.contains(object3)) {
                    throw new VRDException(9023, string);
                }
                hashSet.add((Long)object3);
            }
            if (document == null) break;
            try {
                document = this.checkUpgradeRule(document, bl);
                if (this.isStyleSheet(document)) {
                    this.tracer.trace(FOUND_STYLESHEET_RULE, (MessageSource)messageSource);
                    object3 = new XSLTRuleProcessor(document.getDocumentElement(), ruleStaticContext);
                } else if (this.isDirXMLScript(document)) {
                    this.tracer.trace(FOUND_DIRXMLSCRIPT_RULE, (MessageSource)messageSource);
                    object3 = new DirXMLScriptProcessor(document.getDocumentElement(), ruleStaticContext);
                } else {
                    this.tracer.trace(FOUND_RULE, (MessageSource)messageSource);
                    Class[] classArray = new Class[]{Class.forName("org.w3c.dom.Element"), Class.forName("com.novell.nds.dirxml.engine.rules.RuleStaticContext")};
                    Class<?> clazz = Class.forName(string);
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    try {
                        object3 = (RuleProcessor)constructor.newInstance(document.getDocumentElement(), ruleStaticContext);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        throw invocationTargetException.getTargetException();
                    }
                }
                if (object == null) {
                    object = object3;
                }
                if (object2 != null) {
                    object2.setNextRule((RuleProcessor)object3);
                }
                object2 = object3;
                entry = new Entry(lArray[0]);
                string2 = "DirXML-NextTransformation";
            }
            catch (VRDException vRDException) {
                this.tracer.trace(ERROR_INIT_RULE_PROCESSOR, (MessageSource)messageSource);
                throw vRDException;
            }
            catch (Throwable throwable) {
                this.tracer.trace(ERROR_INIT_RULE_PROCESSOR, (MessageSource)messageSource);
                throw new VRDException(throwable);
            }
        }
        if (object == null) {
            this.tracer.trace(RULE_NOT_FOUND, (MessageSource)messageSource);
        }
        return object;
    }

    boolean isStyleSheet(Document document) {
        Element element = document.getDocumentElement();
        NamespaceName namespaceName = DOMUtil.getNamespaceName((Node)element);
        String string = DOMUtil.getLocalName((Node)element);
        return namespaceName.equals(Stylesheet.NAMESPACE) && (string.equals("stylesheet") || string.equals("transform"));
    }

    boolean isDirXMLScript(Document document) {
        Element element = document.getDocumentElement();
        NamespaceName namespaceName = DOMUtil.getNamespaceName((Node)element);
        String string = DOMUtil.getLocalName((Node)element);
        return element.getNamespaceURI() == null && element.getLocalName().equals("policy");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Document checkUpgradeRule(Document document, boolean bl) throws VRDException {
        Element element = document.getDocumentElement();
        if (element.getNamespaceURI() == null && (element.getLocalName().equals("create-rules") || element.getLocalName().equals("placement-rules") || element.getLocalName().equals("matching-rules"))) {
            if (element.getLocalName().equals("placement-rules")) {
                this.extractDNFormat(element, bl);
            }
            this.tracer.trace(UPGRADING_RULE, (MessageSource)messageSource);
            this.tracer.pushIndent(1);
            try {
                try {
                    Document document2 = new RuleUpgrader((SyntaxProvider)new SyntaxProviderImpl()).upgradeRules(document);
                    Object var7_6 = null;
                    this.tracer.popIndent();
                    return document2;
                }
                catch (UpgradeException upgradeException) {
                    String string = "";
                    if (document instanceof NodeImpl) {
                        string = ((NodeImpl)document).getBaseURI();
                    }
                    throw new VRDException(9132, string, (Object)upgradeException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                this.tracer.popIndent();
                throw throwable;
            }
        }
        return document;
    }

    void extractDNFormat(Element element, boolean bl) throws VRDException {
        char[] cArray = null;
        String string = element.getAttributeNS(null, bl ? "dest-dn-format" : "src-dn-format");
        if (string.length() != 0) {
            String string2 = XdsDN.getDelims((String)string);
            if (string2 == null) {
                throw new VRDException(9034, string);
            }
            cArray = string2.toCharArray();
        } else {
            String string3 = element.getAttributeNS(null, bl ? "dest-dn-delims" : "src-dn-delims");
            if (string3.length() != 0) {
                char[] cArray2 = string3.toCharArray();
                if (!XdsDN.validateDelims((char[])cArray2)) {
                    throw new VRDException(9035, string3);
                }
                cArray = cArray2;
            }
        }
        if (cArray != null) {
            this.driver.setAppDNDelims(cArray, 3);
        }
    }

    Document applyNotifyAndResetFilters(Document document, RuleDynamicContext ruleDynamicContext) {
        ArrayList arrayList = new ArrayList();
        this.tracer.trace(FILTERING_NOTIFY, (MessageSource)messageSource);
        Document document2 = this.filter.filterNotifyAttrs(document, this.filterChannel, arrayList);
        if (arrayList.size() > 0) {
            this.generateAttrResets(arrayList, ruleDynamicContext);
        }
        return document2;
    }

    void generateAttrResets(List list, RuleDynamicContext ruleDynamicContext) {
        int n = 0;
        while (n < list.size()) {
            block9: {
                Document document;
                Filter.ResetItem resetItem;
                block10: {
                    resetItem = (Filter.ResetItem)list.get(n);
                    Document document2 = null;
                    if (resetItem.getOpName().equals("add")) {
                        document2 = DocumentFactory.newDocument();
                        document2.appendChild(document2.createElementNS(null, "instance"));
                    }
                    try {
                        document = this.createSingleInputMergeDocument(resetItem.getEntry(), resetItem.getAssociation(), resetItem.getClassName(), resetItem.getAttrNames(), ruleDynamicContext.destQueryProcessor0, this.filterChannel == 1, document2, null);
                    }
                    catch (VRDException vRDException) {
                        break block9;
                    }
                    if (this.filterChannel != 0) break block10;
                    try {
                        document = this.optimizeModify(document, ruleDynamicContext.srcQueryProcessor0, true);
                    }
                    catch (VRDException vRDException) {
                        // empty catch block
                    }
                    if (document == null) break block9;
                }
                this.processReset(document, resetItem.getEntry(), ruleDynamicContext);
            }
            ++n;
        }
    }

    protected abstract void processReset(Document var1, Entry var2, RuleDynamicContext var3);

    Document convertModifyToAdd(Document document, XdsQueryProcessor xdsQueryProcessor, boolean bl, OperationData operationData) throws VRDException {
        JCTimestamp jCTimestamp = null;
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "modify");
        if (element != null) {
            Element element2 = (Element)element.getParentNode();
            Entry entry = null;
            String string = null;
            String string2 = element.getAttributeNS(null, "class-name");
            String string3 = element.getAttributeNS(null, "event-id");
            jCTimestamp = XdsUtil.getJCTimestamp(element);
            if (bl) {
                string = XdsUtil.getAssociationValue(element);
            } else {
                entry = XdsUtil.getSrcEntry(element);
            }
            Document document2 = this.readObject(entry, string, string2, this.filter.getClassAttrs(string2, this.filterChannel, 2, false), xdsQueryProcessor, false);
            Element element3 = XdsUtil.getFirstElementByTagNameNS(document2, null, "instance");
            if (element3.getAttributeNS(null, "src-dn").length() == 0) {
                element3.setAttributeNS(null, "src-dn", element.getAttributeNS(null, "src-dn"));
            }
            element3 = (Element)XdsUtil.cloneSubtree(document, element3);
            if (string3.length() > 0) {
                element3.setAttributeNS(null, "event-id", string3);
            }
            element2.replaceChild(element3, element);
            DOMUtil.addNamespaceDecls((Node)element3);
            document = this.convertInstanceToAdd(document, jCTimestamp, operationData);
        }
        return document;
    }

    Document convertInstanceToAdd(Document document, JCTimestamp jCTimestamp, OperationData operationData) {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "instance");
        if (element != null) {
            Element element2;
            while ((element2 = XdsUtil.getFirstChildElementByTagNameNS(element, null, "attr")) != null) {
                if (jCTimestamp != null) {
                    Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element2, null, "value");
                    int n = elementArray.length;
                    int n2 = 0;
                    while (n2 < elementArray.length) {
                        JCTimestamp jCTimestamp2 = XdsUtil.getJCTimestamp(elementArray[n2]);
                        if (jCTimestamp2 != null && !elementArray[n2].getAttributeNS(null, "naming").equals("true") && (jCTimestamp2.seconds.after(jCTimestamp.seconds) || jCTimestamp2.seconds.equals(jCTimestamp.seconds) && jCTimestamp2.event > jCTimestamp.event)) {
                            element2.removeChild(elementArray[n2]);
                            --n;
                        }
                        ++n2;
                    }
                    if (n == 0) {
                        element.removeChild(element2);
                        continue;
                    }
                }
                XdsUtil.renameElementNS(element2, null, "add-attr");
            }
            element.removeAttributeNS(null, "event-id");
            if (operationData != null) {
                operationData.setTo(element);
            }
            XdsUtil.renameElementNS(element, null, "add");
        }
        if (this.tracer.getLevel() > 1) {
            this.tracer.trace(SYNTHETIC_ADD, (MessageSource)messageSource);
            this.tracer.trace(document);
        }
        return document;
    }

    /*
     * Unable to fully structure code
     */
    Document convertAddToInstance(Document var1_1) {
        ** GOTO lbl8
        {
            XdsUtil.renameElementNS(var3_3, null, "attr");
            do {
                if ((var3_3 = XdsUtil.getFirstChildElementByTagNameNS(var2_2, null, "add-attr")) != null) continue block0;
                XdsUtil.renameElementNS(var2_2, null, "instance");
lbl8:
                // 2 sources

            } while ((var2_2 = XdsUtil.getFirstElementByTagNameNS(var1_1, null, "add")) != null);
        }
        return var1_1;
    }

    Document readObject(Entry entry, String string, String string2, String[] stringArray, XdsQueryProcessor xdsQueryProcessor, boolean bl) throws VRDException {
        Object object;
        Node node;
        Element element = NdsDtd.createDoc("input");
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, "query");
        element.appendChild(element2);
        element2.setAttributeNS(null, "scope", "entry");
        if (entry != null) {
            XdsUtil.setDestEntry(element2, entry);
        }
        if (string != null) {
            node = document.createElementNS(null, "association");
            XdsUtil.setNodeText(node, string);
            element2.appendChild(node);
        }
        if (string2 != null) {
            element2.setAttributeNS(null, "class-name", string2);
            if (stringArray != null) {
                int n = 0;
                while (n < stringArray.length) {
                    object = document.createElementNS(null, "read-attr");
                    object.setAttributeNS(null, "attr-name", stringArray[n]);
                    element2.appendChild((Node)object);
                    ++n;
                }
                if (bl) {
                    object = document.createElementNS(null, "read-attr");
                    object.setAttributeNS(null, "attr-name", "Object Class");
                    element2.appendChild((Node)object);
                }
            }
        }
        this.tracer.trace(PERFORMING_FILTERED_READ, (MessageSource)messageSource, entry != null ? entry.getDN() : string);
        this.tracer.trace(document);
        node = xdsQueryProcessor.query(document);
        if (node == null || XdsUtil.getFirstElementByTagNameNS(node, null, "instance") == null) {
            object = "";
            object = entry != null ? entry.getDN() : string;
            Element element3 = XdsUtil.getFirstElementByTagNameWithAttrValueNS(node, null, "status", null, "level", "retry");
            if (element3 != null) {
                throw new VRDException(9006, XdsUtil.getNodeText(element3));
            }
            throw new VRDException(9024, object);
        }
        if (this.tracer.getLevel() > 1) {
            this.tracer.trace(FILTERED_RESULT, (MessageSource)messageSource);
            this.tracer.trace((Document)node);
        }
        return node;
    }

    Document[] createMergeDocuments(Entry entry, XdsQueryProcessor xdsQueryProcessor, Document document, String string, XdsQueryProcessor xdsQueryProcessor2, Document document2, String string2, OperationData operationData) throws VRDException {
        int n;
        String[] stringArray = this.filter.getClassAttrs(string2, 0, 0, true);
        String[] stringArray2 = this.filter.getClassAttrs(string2, 1, 0, true);
        int n2 = stringArray.length;
        if (n2 == 1 && stringArray[0].length() == 0) {
            n2 = 0;
        }
        if ((n = stringArray2.length) == 1 && stringArray2[0].length() == 0) {
            n = 0;
        }
        Document[] documentArray = new Document[]{null, null};
        if (n2 > 0 && n == 0) {
            documentArray[1] = this.createSingleInputMergeDocument(entry, string, string2, stringArray, xdsQueryProcessor, true, document, operationData);
        }
        if (n2 == 0 && n > 0) {
            documentArray[0] = this.createSingleInputMergeDocument(entry, string, string2, stringArray2, xdsQueryProcessor2, false, document2, operationData);
        }
        if (n2 > 0 && n > 0) {
            Element[] elementArray = new Element[]{null};
            Element[] elementArray2 = new Element[]{null};
            HashMap hashMap = this.readAttributesIntoTable(entry, string, string2, stringArray, xdsQueryProcessor, true, document, false, elementArray2);
            HashMap hashMap2 = this.readAttributesIntoTable(entry, string, string2, stringArray2, xdsQueryProcessor2, false, document2, false, elementArray);
            this.removeDuplicateValues(hashMap, hashMap2, string2, true);
            HashMap[] hashMapArray = this.createRemoveAllTables(string2);
            this.encryptSensitiveData(hashMap2, true);
            this.encryptSensitiveData(hashMap, false);
            documentArray[0] = this.modifyFromTables(null, hashMapArray[0], hashMap2, entry, null, string2, operationData, false, true, elementArray[0]);
            documentArray[1] = this.modifyFromTables(null, hashMapArray[1], hashMap, entry, string, string2, operationData, true, true, elementArray2[0]);
        }
        if (documentArray[0] != null) {
            documentArray[0] = this.optimizeModify(documentArray[0], xdsQueryProcessor, true);
        }
        return documentArray;
    }

    private boolean isAttrSingleValued(String string, String string2, boolean bl) {
        try {
            if (bl) {
                return (SchemaCache.getAttributeDef(string2).getConstraints() & 1L) != 0L;
            }
            return (this.registry.getAppSchema().getAttrDef((String)string, (String)string2).flags & 2) == 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private Document createSingleInputMergeDocument(Entry entry, String string, String string2, String[] stringArray, XdsQueryProcessor xdsQueryProcessor, boolean bl, Document document, OperationData operationData) throws VRDException {
        Object object;
        Element[] elementArray;
        Document document2 = document;
        if (document2 == null) {
            document2 = bl ? this.readObject(entry, null, string2, stringArray, xdsQueryProcessor, false) : this.readObject(null, string, string2, stringArray, xdsQueryProcessor, false);
        }
        Element element = XdsUtil.getFirstElementByTagNameNS(document2, null, "instance");
        HashSet<Object> hashSet = new HashSet<Object>();
        Element element2 = NdsDtd.createDoc("input");
        Document document3 = element2.getOwnerDocument();
        Element element3 = document3.createElementNS(null, "modify");
        element3.setAttributeNS(null, "class-name", string2);
        element2.appendChild(element3);
        if (bl) {
            elementArray = document3.createElementNS(null, "association");
            XdsUtil.setNodeText((Node)elementArray, string);
            element3.appendChild((Node)elementArray);
            XdsUtil.setSrcEntry(element3, entry);
            XdsUtil.copyAttributeNS(element, null, "qualified-src-dn", element3);
        } else {
            XdsUtil.setDestEntry(element3, entry);
            elementArray = XdsUtil.getFirstChildElementByTagNameNS(element, null, "association");
            if (elementArray != null) {
                XdsUtil.graftSubtree(element3, (Node)elementArray);
            }
            XdsUtil.copyAttributeNS(element, null, "src-dn", element3);
            XdsUtil.copyAttributeNS(element, null, "src-entry-id", element3);
            XdsUtil.copyAttributeNS(element, null, "qualified-src-dn", element3);
        }
        elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "attr");
        int n = 0;
        while (n < elementArray.length) {
            block14: {
                Element element4;
                boolean bl2;
                block13: {
                    String string3;
                    block12: {
                        string3 = elementArray[n].getAttributeNS(null, "attr-name");
                        object = new CaseIgnoreStringKey(string3);
                        bl2 = this.isAttrSingleValued(string2, string3, !bl);
                        if (hashSet.contains(object)) break block12;
                        element4 = document3.createElementNS(null, "modify-attr");
                        element4.setAttributeNS(null, "attr-name", string3);
                        element3.appendChild(element4);
                        hashSet.add(object);
                        element4.appendChild(document3.createElementNS(null, "remove-all-values"));
                        break block13;
                    }
                    element4 = XdsUtil.getFirstChildElementByTagNameWithAttrValueIgnoreCaseNS(element3, null, "modify-attr", null, "attr-name", string3);
                    if (bl2 && XdsUtil.getFirstElementByTagNameNS(element4, null, "value") != null) break block14;
                }
                Element element5 = document3.createElementNS(null, "add-value");
                element4.appendChild(element5);
                Element[] elementArray2 = XdsUtil.getChildElementsByTagNameNS(elementArray[n], null, "value");
                int n2 = 0;
                while (n2 < elementArray2.length) {
                    XdsUtil.graftSubtree(element5, elementArray2[n2]);
                    if (bl2) break;
                    ++n2;
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (!hashSet.contains(new CaseIgnoreStringKey(stringArray[n3]))) {
                object = document3.createElementNS(null, "modify-attr");
                object.setAttributeNS(null, "attr-name", stringArray[n3]);
                element3.appendChild((Node)object);
                object.appendChild(document3.createElementNS(null, "remove-all-values"));
            }
            ++n3;
        }
        element3.setAttributeNS(null, "from-merge", "true");
        if (operationData != null) {
            operationData.setTo(element3);
        }
        DOMUtil.addNamespaceDecls((Node)element3);
        return document3;
    }

    private HashMap readAttributesIntoTable(Entry entry, String string, String string2, String[] stringArray, XdsQueryProcessor xdsQueryProcessor, boolean bl, Document document, boolean bl2, Element[] elementArray) throws VRDException {
        Document document2 = document;
        if (document2 == null) {
            document2 = bl ? this.readObject(entry, null, string2, stringArray, xdsQueryProcessor, bl2) : this.readObject(null, string, string2, stringArray, xdsQueryProcessor, bl2);
        }
        Element element = XdsUtil.getFirstElementByTagNameNS(document2, null, "instance");
        if (elementArray != null) {
            elementArray[0] = element;
        }
        HashMap<CaseIgnoreStringKey, AttrEntry> hashMap = new HashMap<CaseIgnoreStringKey, AttrEntry>();
        Element[] elementArray2 = XdsUtil.getChildElementsByTagNameNS(element, null, "attr");
        Element element2 = null;
        int n = 0;
        while (n < elementArray2.length) {
            AttrEntry attrEntry;
            String string3 = elementArray2[n].getAttributeNS(null, "attr-name");
            CaseIgnoreStringKey caseIgnoreStringKey = new CaseIgnoreStringKey(string3);
            boolean bl3 = Driver.isSensitiveData(string3);
            if (bl3 && element2 == null) {
                element2 = document2.createElementNS(null, "bogus");
            }
            if ((attrEntry = (AttrEntry)hashMap.get(caseIgnoreStringKey)) == null) {
                attrEntry = new AttrEntry(string3, document2.createDocumentFragment());
                hashMap.put(caseIgnoreStringKey, attrEntry);
            }
            Element[] elementArray3 = XdsUtil.getChildElementsByTagNameNS(elementArray2[n], null, "value");
            int n2 = 0;
            while (n2 < elementArray3.length) {
                if (bl3) {
                    DSEAttributeValue dSEAttributeValue = DSEAttributeValueFactory.createValue(string3, elementArray3[n2]);
                    dSEAttributeValue.decrypt(bl ? this.driver.getOutKey() : this.driver.getInKey());
                    dSEAttributeValue.toXML(element2);
                    Element element3 = (Element)element2.getFirstChild();
                    element2.removeChild(element3);
                    if (string3.equalsIgnoreCase("ACL")) {
                        this.normalizeACL(element3);
                    }
                    attrEntry.addValue(element3);
                } else {
                    if (string3.equalsIgnoreCase("ACL")) {
                        this.normalizeACL(elementArray3[n2]);
                    }
                    attrEntry.addValue(elementArray3[n2]);
                }
                ++n2;
            }
            ++n;
        }
        return hashMap;
    }

    private void normalizeACL(Element element) {
        Element element2 = XdsUtil.getFirstChildElementByTagNameWithAttrValueNS(element, null, "component", null, "name", "trustee");
        if (element2 != null) {
            String string = XdsUtil.getNodeText(element2);
            if (string.equalsIgnoreCase(this.rootDN)) {
                XdsUtil.setNodeText(element2, "\\[Root]");
            } else {
                Element element3 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "src-dn");
                if (element3 != null && string.equalsIgnoreCase(element3.getAttributeNS(null, "src-dn"))) {
                    XdsUtil.setNodeText(element2, "\\[Self]");
                }
            }
        }
    }

    private void removeDuplicateValues(HashMap hashMap, HashMap hashMap2, String string, boolean bl) throws VRDException {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            CaseIgnoreStringKey caseIgnoreStringKey = (CaseIgnoreStringKey)iterator.next();
            AttrEntry attrEntry = (AttrEntry)hashMap.get(caseIgnoreStringKey);
            AttrEntry attrEntry2 = (AttrEntry)hashMap2.get(caseIgnoreStringKey);
            if (attrEntry2 == null) continue;
            boolean bl2 = false;
            Element element = (Element)attrEntry.xmlValues.getFirstChild();
            while (element != null) {
                Element element2 = (Element)element.getNextSibling();
                if (attrEntry2.removeValue(element)) {
                    bl2 = true;
                    attrEntry.removeValue(element);
                }
                element = element2;
            }
            if (!bl) continue;
            boolean bl3 = this.isAttrSingleValued(string, caseIgnoreStringKey.toString(), true);
            boolean bl4 = this.isAttrSingleValued(string, caseIgnoreStringKey.toString(), false);
            if (bl3 && bl4) {
                if (bl2) continue;
                attrEntry2.removeAllValues();
                continue;
            }
            if (bl3) {
                attrEntry2.removeAllValues();
                continue;
            }
            if (!bl4) continue;
            attrEntry.removeAllValues();
        }
    }

    private HashMap[] createRemoveAllTables(String string) {
        HashMap[] hashMapArray = new HashMap[]{new HashMap(), new HashMap()};
        Document document = NdsDtd.createDoc("input").getOwnerDocument();
        Filter.ClassEntry classEntry = this.filter.getClassEntry(string);
        if (classEntry != null) {
            Iterator iterator = classEntry.getAttrIterator();
            while (iterator.hasNext()) {
                Filter.AttrEntry attrEntry = (Filter.AttrEntry)iterator.next();
                boolean bl = attrEntry.isMergeSource(0);
                boolean bl2 = attrEntry.isMergeSource(1);
                if (bl2 && !bl) {
                    hashMapArray[0].put(new CaseIgnoreStringKey(attrEntry.getName()), document.createElementNS(null, "remove-all-values"));
                    continue;
                }
                if (!bl || bl2) continue;
                hashMapArray[1].put(new CaseIgnoreStringKey(attrEntry.getName()), document.createElementNS(null, "remove-all-values"));
            }
        }
        return hashMapArray;
    }

    private Document modifyFromTables(Element element, HashMap hashMap, HashMap hashMap2, Entry entry, String string, String string2, OperationData operationData, boolean bl, boolean bl2, Element element2) {
        Element element3;
        Element element4;
        Object object;
        CaseIgnoreStringKey caseIgnoreStringKey;
        Document document;
        Object object2;
        if (!(hashMap != null && hashMap.size() != 0 || hashMap2 != null && hashMap2.size() != 0)) {
            return null;
        }
        boolean bl3 = false;
        HashSet<CaseIgnoreStringKey> hashSet = new HashSet<CaseIgnoreStringKey>();
        if (element == null) {
            object2 = NdsDtd.createDoc("input");
            document = object2.getOwnerDocument();
            element = document.createElementNS(null, "modify");
            element.setAttributeNS(null, "class-name", string2);
            object2.appendChild(element);
        } else {
            document = element.getOwnerDocument();
        }
        if (bl2) {
            element.setAttributeNS(null, "from-merge", "true");
        }
        if (string != null) {
            object2 = document.createElementNS(null, "association");
            XdsUtil.setNodeText((Node)object2, string);
            element.appendChild((Node)object2);
            XdsUtil.setSrcEntry(element, entry);
            if (element2 != null) {
                XdsUtil.copyAttributeNS(element2, null, "qualified-src-dn", element);
            }
        } else {
            XdsUtil.setDestEntry(element, entry);
            if (element2 != null) {
                object2 = XdsUtil.getFirstChildElementByTagNameNS(element2, null, "association");
                if (object2 != null) {
                    XdsUtil.graftSubtree(element, object2);
                }
                XdsUtil.copyAttributeNS(element2, null, "src-dn", element);
                XdsUtil.copyAttributeNS(element2, null, "src-entry-id", element);
                XdsUtil.copyAttributeNS(element2, null, "qualified-src-dn", element);
            }
        }
        if (hashMap != null) {
            object2 = hashMap.keySet().iterator();
            while (object2.hasNext()) {
                Node node;
                caseIgnoreStringKey = (CaseIgnoreStringKey)object2.next();
                object = hashMap.get(caseIgnoreStringKey);
                hashSet.add(caseIgnoreStringKey);
                if (object instanceof AttrEntry) {
                    node = ((AttrEntry)object).xmlValues;
                    if (node.getFirstChild() == null) continue;
                    element4 = document.createElementNS(null, "modify-attr");
                    element4.setAttributeNS(null, "attr-name", caseIgnoreStringKey.toString());
                    element.appendChild(element4);
                    element3 = document.createElementNS(null, "remove-value");
                    element4.appendChild(element3);
                    XdsUtil.graftSubtree(element3, node);
                    bl3 = true;
                    continue;
                }
                if (!(object instanceof Node)) continue;
                node = (Node)object;
                element4 = document.createElementNS(null, "modify-attr");
                element4.setAttributeNS(null, "attr-name", caseIgnoreStringKey.toString());
                element.appendChild(element4);
                XdsUtil.graftSubtree(element4, node);
                bl3 = true;
            }
        }
        if (hashMap2 != null) {
            object2 = hashMap2.keySet().iterator();
            while (object2.hasNext()) {
                caseIgnoreStringKey = (CaseIgnoreStringKey)object2.next();
                object = ((AttrEntry)hashMap2.get((Object)caseIgnoreStringKey)).xmlValues;
                if (object.getFirstChild() == null) continue;
                boolean bl4 = this.isAttrSingleValued(string2, caseIgnoreStringKey.toString(), string == null);
                element4 = document.createElementNS(null, "modify-attr");
                element4.setAttributeNS(null, "attr-name", caseIgnoreStringKey.toString());
                element.appendChild(element4);
                if (bl4 && !hashSet.contains(caseIgnoreStringKey)) {
                    element4.appendChild(document.createElementNS(null, "remove-all-values"));
                }
                element3 = document.createElementNS(null, "add-value");
                element4.appendChild(element3);
                if (bl4) {
                    XdsUtil.graftSubtree(element3, object.getFirstChild());
                } else {
                    XdsUtil.graftSubtree(element3, (Node)object);
                }
                bl3 = true;
            }
        }
        if (!bl3) {
            document = null;
        } else {
            if (operationData != null) {
                operationData.setTo(element);
            }
            DOMUtil.addNamespaceDecls((Node)element);
        }
        return document;
    }

    Document optimizeModify(Document document, XdsQueryProcessor xdsQueryProcessor, boolean bl) throws VRDException {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "modify");
        if (element != null) {
            AttrEntry attrEntry;
            Object object;
            Object object2;
            Object object3;
            AttrEntry attrEntry2;
            HashSet<Object> hashSet;
            Object object4;
            Object object5;
            Element element2 = (Element)element.getParentNode();
            Entry entry = XdsUtil.getDestEntry(element);
            String string = XdsUtil.getAssociationValue(element);
            OperationData operationData = new OperationData(element);
            String string2 = element.getAttributeNS(null, "class-name");
            boolean bl2 = element.getAttributeNS(null, "from-merge").equals("true");
            DocumentFragment documentFragment = document.createDocumentFragment();
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "modify-attr");
            TreeSet<Object> treeSet = new TreeSet<Object>(StringUtil.getCaseIgnoreComparator());
            int n = 0;
            while (n < elementArray.length) {
                element.removeChild(elementArray[n]);
                object5 = elementArray[n].getAttributeNS(null, "attr-name");
                if (((String)object5).length() != 0) {
                    object4 = this.filter.getAttrEntry(string2, (String)object5);
                    if (((String)object5).equalsIgnoreCase(PUBLIC_KEY) || object4 != null && !((Filter.AttrEntry)object4).getOptimizeModify(bl ? 1 : 0)) {
                        documentFragment.appendChild(elementArray[n]);
                        elementArray[n] = null;
                    } else {
                        treeSet.add(object5);
                    }
                }
                ++n;
            }
            object5 = this.readAttributesIntoTable(entry, string, string2, treeSet.toArray(new String[treeSet.size()]), xdsQueryProcessor, bl, null, bl, null);
            object4 = new HashMap();
            Iterator iterator = ((HashMap)object5).keySet().iterator();
            while (iterator.hasNext()) {
                hashSet = (HashSet<Object>)iterator.next();
                attrEntry2 = (AttrEntry)((HashMap)object5).get(hashSet);
                object3 = attrEntry2.xmlValues;
                object2 = new AttrEntry(((Object)hashSet).toString(), (DocumentFragment)object3.cloneNode(false));
                object = (Element)object3.getFirstChild();
                while (object != null) {
                    ((AttrEntry)object2).addValue((Element)object.cloneNode(true));
                    object = (Element)object.getNextSibling();
                }
                ((HashMap)object4).put(hashSet, object2);
            }
            hashSet = null;
            if (bl) {
                hashSet = new HashSet<Object>();
                attrEntry2 = (AttrEntry)((HashMap)object5).get(new CaseIgnoreStringKey("Object Class"));
                if (attrEntry2 != null) {
                    object3 = attrEntry2.xmlValues.getFirstChild();
                    while (object3 != null) {
                        object2 = XdsUtil.getNodeText((Node)object3);
                        object = new CaseIgnoreStringKey((String)object2);
                        attrEntry = SchemaCache.getClassDef((String)object2);
                        if (attrEntry != null && (attrEntry.getCharacteristics() & 0x20L) != 0L) {
                            hashSet.add(object);
                        }
                        object3 = object3.getNextSibling();
                    }
                }
            }
            int n2 = 0;
            while (n2 < elementArray.length) {
                if (elementArray[n2] != null) {
                    object3 = elementArray[n2].getAttributeNS(null, "attr-name");
                    boolean bl3 = Driver.isSensitiveData((String)object3);
                    object = new CaseIgnoreStringKey((String)object3);
                    attrEntry = (AttrEntry)((HashMap)object4).get(object);
                    if (attrEntry == null) {
                        attrEntry = new AttrEntry(((CaseIgnoreStringKey)object).toString(), document.createDocumentFragment());
                        ((HashMap)object4).put(object, attrEntry);
                    }
                    Element[] elementArray2 = XdsUtil.getChildElements(elementArray[n2]);
                    int n3 = 0;
                    while (n3 < elementArray2.length) {
                        Object object6;
                        Object object7;
                        Element element3;
                        int n4;
                        Element[] elementArray3;
                        String string3 = elementArray2[n3].getNodeName();
                        if (string3.equals("remove-all-values")) {
                            attrEntry.removeAllValues();
                            if (hashSet != null && ((CaseIgnoreStringKey)object).equals("Object Class")) {
                                hashSet.clear();
                            }
                        } else if (string3.equals("remove-value")) {
                            elementArray3 = XdsUtil.getChildElementsByTagNameNS(elementArray2[n3], null, "value");
                            n4 = 0;
                            while (n4 < elementArray3.length) {
                                element3 = elementArray3[n4];
                                if (bl3 && this.driver.isTrustedDriver()) {
                                    object7 = DSEAttributeValueFactory.createValue((String)object3, element3);
                                    object7.decrypt(bl ? this.driver.getInKey() : this.driver.getOutKey());
                                    object6 = document.createElementNS(null, "hack");
                                    object7.toXML((Element)object6);
                                    element3 = (Element)object6.getFirstChild();
                                }
                                attrEntry.removeValue(element3);
                                if (hashSet != null && ((CaseIgnoreStringKey)object).equals("Object Class")) {
                                    object7 = XdsUtil.getNodeText(element3);
                                    object6 = new CaseIgnoreStringKey((String)object7);
                                    hashSet.remove(object6);
                                }
                                ++n4;
                            }
                        } else if (string3.equals("add-value")) {
                            elementArray3 = XdsUtil.getChildElementsByTagNameNS(elementArray2[n3], null, "value");
                            n4 = 0;
                            while (n4 < elementArray3.length) {
                                if (this.isAttrSingleValued(string2, (String)object3, bl)) {
                                    attrEntry.removeAllValues();
                                }
                                element3 = elementArray3[n4];
                                if (bl3 && this.driver.isTrustedDriver()) {
                                    object7 = DSEAttributeValueFactory.createValue((String)object3, element3);
                                    object7.decrypt(bl ? this.driver.getInKey() : this.driver.getOutKey());
                                    object6 = document.createElementNS(null, "hack");
                                    object7.toXML((Element)object6);
                                    element3 = (Element)object6.getFirstChild();
                                }
                                attrEntry.addValue((Element)XdsUtil.cloneSubtree(attrEntry.xmlValues.getOwnerDocument(), element3));
                                if (hashSet != null && ((CaseIgnoreStringKey)object).equals("Object Class")) {
                                    object7 = XdsUtil.getNodeText(element3);
                                    object6 = new CaseIgnoreStringKey((String)object7);
                                    JCClassDef jCClassDef = SchemaCache.getClassDef((String)object7);
                                    if (jCClassDef != null && (jCClassDef.getCharacteristics() & 0x20L) != 0L) {
                                        hashSet.add(object6);
                                    }
                                }
                                ++n4;
                            }
                        }
                        ++n3;
                    }
                    if (attrEntry.xmlValues.getFirstChild() == null) {
                        ((HashMap)object4).remove(object3);
                    }
                }
                ++n2;
            }
            this.removeDuplicateValues((HashMap)object5, (HashMap)object4, string2, false);
            this.encryptSensitiveData((HashMap)object5, bl);
            this.encryptSensitiveData((HashMap)object4, bl);
            object3 = bl ? this.modifyFromTables(element, (HashMap)object5, (HashMap)object4, entry, null, string2, operationData, !bl, bl2, null) : this.modifyFromTables(element, (HashMap)object5, (HashMap)object4, XdsUtil.getSrcEntry(element), string, string2, operationData, !bl, bl2, null);
            if (documentFragment.getFirstChild() != null) {
                object3 = document;
                element.appendChild(documentFragment);
            }
            if (bl && object3 != null) {
                this.addAuxClassesToModify((Document)object3, hashSet);
            }
            return object3;
        }
        return null;
    }

    protected void addAuxClassesToModify(Document document, HashSet hashSet) throws VRDException {
        Iterator iterator;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl = false;
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "modify");
        if (element == null) {
            return;
        }
        String string = element.getAttributeNS(null, "class-name");
        HashSet hashSet2 = SchemaCache.getClassAttrs(string);
        HashSet<String[]> hashSet3 = new HashSet<String[]>();
        HashSet<CaseIgnoreStringKey> hashSet4 = new HashSet<CaseIgnoreStringKey>();
        if (hashSet2 == null) {
            return;
        }
        NodeList nodeList = element.getElementsByTagNameNS(null, "add-value");
        int n = 0;
        while (n < nodeList.getLength()) {
            block14: {
                object4 = (Element)nodeList.item(n);
                object3 = ((Element)object4.getParentNode()).getAttributeNS(null, "attr-name");
                object2 = new CaseIgnoreStringKey((String)object3);
                hashSet3.add((String[])object2);
                if (!hashSet2.contains(object2)) {
                    this.tracer.trace(3, FOUND_NON_CLASS_ATTR, (MessageSource)messageSource, object3);
                    object = SchemaCache.getAttrAuxClasses((String)object3);
                    if (object != null) {
                        CaseIgnoreStringKey caseIgnoreStringKey;
                        iterator = ((HashSet)object).iterator();
                        while (iterator.hasNext()) {
                            caseIgnoreStringKey = (CaseIgnoreStringKey)iterator.next();
                            if (!hashSet.contains(caseIgnoreStringKey)) {
                                continue;
                            }
                            break block14;
                        }
                        iterator = ((HashSet)object).iterator();
                        while (iterator.hasNext()) {
                            caseIgnoreStringKey = (CaseIgnoreStringKey)iterator.next();
                            hashSet4.add(caseIgnoreStringKey);
                        }
                    }
                }
            }
            ++n;
        }
        iterator = hashSet4.iterator();
        block3: while (iterator.hasNext()) {
            object4 = (CaseIgnoreStringKey)iterator.next();
            object3 = SchemaCache.getClassDef(((CaseIgnoreStringKey)object4).toString());
            object2 = object3.getMandatoryAttributes();
            if (object2 == null || ((String[])object2).length <= 0) continue;
            if (!bl) {
                this.addPresentAttributeNames(XdsUtil.getDestEntry(element), hashSet3);
                bl = true;
            }
            int n2 = 0;
            while (n2 < ((String[])object2).length) {
                if (!hashSet3.contains(new CaseIgnoreStringKey(object2[n2]))) {
                    this.tracer.trace(3, REJECTING_AUX_CLASS, (MessageSource)messageSource, (Object)((CaseIgnoreStringKey)object4).toString(), object2[n2]);
                    iterator.remove();
                    continue block3;
                }
                ++n2;
            }
        }
        if (hashSet4.size() > 0) {
            object4 = document.createElementNS(null, "modify-attr");
            element.appendChild((Node)object4);
            object4.setAttributeNS(null, "attr-name", "Object Class");
            object3 = document.createElementNS(null, "add-value");
            object4.appendChild((Node)object3);
            iterator = hashSet4.iterator();
            while (iterator.hasNext()) {
                object2 = (CaseIgnoreStringKey)iterator.next();
                this.tracer.trace(3, ADDING_AUX_CLASS, (MessageSource)messageSource, (Object)((CaseIgnoreStringKey)object2).toString());
                object = document.createElementNS(null, "value");
                object3.appendChild((Node)object);
                XdsUtil.setNodeText((Node)object, ((CaseIgnoreStringKey)object2).toString());
                hashSet.add(object2);
            }
        }
    }

    protected void addAuxClassesToAdd(Document document) throws VRDException {
        Iterator iterator;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "add");
        if (element == null) {
            return;
        }
        String string = element.getAttributeNS(null, "class-name");
        HashSet hashSet = SchemaCache.getClassAttrs(string);
        HashSet<CaseIgnoreStringKey> hashSet2 = new HashSet<CaseIgnoreStringKey>();
        HashSet<Object> hashSet3 = new HashSet<Object>();
        HashSet<CaseIgnoreStringKey> hashSet4 = new HashSet<CaseIgnoreStringKey>();
        if (hashSet == null) {
            return;
        }
        NodeList nodeList = element.getElementsByTagNameNS(null, "add-attr");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element2 = (Element)nodeList.item(n);
            object4 = element2.getAttributeNS(null, "attr-name");
            if (((String)object4).equalsIgnoreCase("Object Class")) {
                object3 = element2.getElementsByTagNameNS(null, "value");
                int n2 = 0;
                while (n2 < object3.getLength()) {
                    object2 = object3.item(n2);
                    object = XdsUtil.getNodeText((Node)object2);
                    CaseIgnoreStringKey caseIgnoreStringKey = new CaseIgnoreStringKey((String)object);
                    JCClassDef jCClassDef = SchemaCache.getClassDef((String)object);
                    if (jCClassDef != null && (jCClassDef.getCharacteristics() & 0x20L) != 0L) {
                        hashSet4.add(caseIgnoreStringKey);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < nodeList.getLength()) {
            block17: {
                object4 = (Element)nodeList.item(n3);
                object3 = object4.getAttributeNS(null, "attr-name");
                CaseIgnoreStringKey caseIgnoreStringKey = new CaseIgnoreStringKey((String)object3);
                hashSet2.add(caseIgnoreStringKey);
                if (!hashSet.contains(caseIgnoreStringKey)) {
                    this.tracer.trace(3, FOUND_NON_CLASS_ATTR, (MessageSource)messageSource, object3);
                    object2 = SchemaCache.getAttrAuxClasses((String)object3);
                    if (object2 != null) {
                        iterator = ((HashSet)object2).iterator();
                        while (iterator.hasNext()) {
                            object = (CaseIgnoreStringKey)iterator.next();
                            if (!hashSet4.contains(object)) {
                                continue;
                            }
                            break block17;
                        }
                        iterator = ((HashSet)object2).iterator();
                        while (iterator.hasNext()) {
                            object = (CaseIgnoreStringKey)iterator.next();
                            hashSet3.add(object);
                        }
                    }
                }
            }
            ++n3;
        }
        iterator = hashSet3.iterator();
        block5: while (iterator.hasNext()) {
            object4 = (CaseIgnoreStringKey)iterator.next();
            object3 = SchemaCache.getClassDef(((CaseIgnoreStringKey)object4).toString());
            String[] stringArray = object3.getMandatoryAttributes();
            if (stringArray == null || stringArray.length <= 0) continue;
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (!hashSet2.contains(new CaseIgnoreStringKey(stringArray[n4]))) {
                    this.tracer.trace(3, REJECTING_AUX_CLASS, (MessageSource)messageSource, (Object)((CaseIgnoreStringKey)object4).toString(), (Object)stringArray[n4]);
                    iterator.remove();
                    continue block5;
                }
                ++n4;
            }
        }
        if (hashSet3.size() > 0) {
            object4 = document.createElementNS(null, "add-attr");
            element.appendChild((Node)object4);
            object4.setAttributeNS(null, "attr-name", "Object Class");
            iterator = hashSet3.iterator();
            while (iterator.hasNext()) {
                object3 = (CaseIgnoreStringKey)iterator.next();
                this.tracer.trace(3, ADDING_AUX_CLASS, (MessageSource)messageSource, (Object)((CaseIgnoreStringKey)object3).toString());
                Element element3 = document.createElementNS(null, "value");
                object4.appendChild(element3);
                XdsUtil.setNodeText(element3, ((CaseIgnoreStringKey)object3).toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addPresentAttributeNames(Entry entry, HashSet hashSet) throws VRDException {
        JCContext jCContext = null;
        try {
            try {
                jCContext = this.context.duplicate();
                entry.goTo(jCContext);
                JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)0L, null);
                int n = 0;
                while (n < jCValueArray.length) {
                    hashSet.add(new CaseIgnoreStringKey(jCValueArray[n].attributeName));
                    ++n;
                }
            }
            catch (JCException jCException) {
                throw new VRDException(jCException);
            }
            Object var7_7 = null;
            if (jCContext == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
    }

    protected void addAssociationRefs(Node node, boolean bl) {
        int n = 0;
        while (n < refElementsTypes.length) {
            Element[] elementArray = XdsUtil.getElementsByTagNameWithAttrValueNS(node, null, refElementsTypes[n][0], null, refElementsTypes[n][1], refElementsTypes[n][2]);
            int n2 = 0;
            while (n2 < elementArray.length) {
                this.addAssociationRef(elementArray[n2], bl);
                ++n2;
            }
            ++n;
        }
    }

    private void addAssociationRef(Element element, boolean bl) {
        String string = element.getAttributeNS(null, "association-ref");
        if (string.length() > 0) {
            return;
        }
        if (this.checkForSpecialTrustees(element, true)) {
            return;
        }
        boolean bl2 = false;
        try {
            JCValue[] jCValueArray = Association.getAssociations(this.context, this.registry.getDriverDN(), new Entry(XdsUtil.getNodeText(element)));
            if (jCValueArray != null) {
                int n = 0;
                while (n < jCValueArray.length) {
                    String string2 = ((JCPathValue)jCValueArray[n]).getVolumePath();
                    if (string2 != null && string2.length() != 0) {
                        if (bl2) {
                            element = this.appendValueClone(element);
                        } else {
                            bl2 = true;
                        }
                        element.setAttributeNS(null, "association-ref", string2);
                    }
                    ++n;
                }
            }
        }
        catch (VRDException vRDException) {
            try {
                XdsDN xdsDN;
                XdsDN xdsDN2;
                String[] stringArray = (String[])this.driver.workManager.getVariable("dirxml.engine.lastdeleted");
                if (stringArray != null && (xdsDN2 = new XdsDN(stringArray[0], NdsConstants.QSLASH_DELIMS_ARRAY)).equals(xdsDN = new XdsDN(XdsUtil.getNodeText(element), NdsConstants.QSLASH_DELIMS_ARRAY))) {
                    int n = 1;
                    while (n < stringArray.length) {
                        if (stringArray[n] != null && stringArray[n].length() != 0) {
                            if (bl2) {
                                element = this.appendValueClone(element);
                            } else {
                                bl2 = true;
                            }
                            element.setAttributeNS(null, "association-ref", stringArray[n]);
                        }
                        ++n;
                    }
                }
            }
            catch (VRDException vRDException2) {
                // empty catch block
            }
        }
        if (!bl2) {
            this.issueReferenceWarning(element);
            if (bl) {
                this.stripValue(element);
            }
        }
    }

    private boolean checkForSpecialTrustees(Element element, boolean bl) {
        if (element.getNodeName().equals("component") && element.getAttributeNS(null, "name").equals("trustee")) {
            String string = XdsUtil.getNodeText(element);
            int n = 0;
            while (n < specialTrustees.length) {
                if (string.equals(specialTrustees[n])) {
                    return true;
                }
                ++n;
            }
            if (bl && string.equalsIgnoreCase(this.rootDN)) {
                XdsUtil.setNodeText(element, "\\[Root]");
                return true;
            }
            Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "src-dn");
            if (element2 != null && string.equalsIgnoreCase(element2.getAttributeNS(null, "src-dn"))) {
                XdsUtil.setNodeText(element, "\\[Self]");
                return true;
            }
        }
        return false;
    }

    protected void resolveAssociationRefs(Node node, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < refElementsTypes.length) {
                Element[] elementArray = XdsUtil.getElementsByTagNameWithAttrValueNS(node, null, refElementsTypes[n][0], null, refElementsTypes[n][1], refElementsTypes[n][2]);
                int n2 = 0;
                while (n2 < elementArray.length) {
                    if (elementArray[n2].getAttributeNS(null, "association-ref").length() == 0 && !this.checkForSpecialTrustees(elementArray[n2], false)) {
                        this.issueReferenceWarning(elementArray[n2]);
                        this.stripValue(elementArray[n2]);
                    }
                    ++n2;
                }
                ++n;
            }
        }
        Element[] elementArray = XdsUtil.getElementsByTagNameWithAttrNS(node, "*", "*", null, "association-ref");
        int n = 0;
        while (n < elementArray.length) {
            this.resolveAssociationRef(elementArray[n], bl);
            ++n;
        }
    }

    private void resolveAssociationRef(Element element, boolean bl) {
        boolean bl2 = false;
        try {
            Entry[] entryArray;
            String string = element.getAttributeNS(null, "association-ref");
            if (string.length() > 0 && (entryArray = Association.lookupEntry(this.context, this.registry.getDriverDN(), string)) != null) {
                int n = 0;
                while (n < entryArray.length) {
                    if (bl2) {
                        element = this.appendValueClone(element);
                    } else {
                        bl2 = true;
                        element.removeAttributeNS(null, "association-ref");
                    }
                    int n2 = this.registry.getECVs().getQualifiedDNValues() ? 16 : 0;
                    XdsUtil.setNodeText(element, DDSServ.getLocalEntryName((long)entryArray[n].getEntryID(), (int)n2));
                    ++n;
                }
            }
        }
        catch (DSErr dSErr) {
        }
        catch (VRDException vRDException) {
            // empty catch block
        }
        if (!bl2 && !this.checkForSpecialTrustees(element, false)) {
            this.issueReferenceWarning(element);
            if (bl) {
                this.stripValue(element);
            }
        }
    }

    protected void stripValue(Element element) {
        Node node;
        String string;
        if (element.getNodeName().equals("component")) {
            element = (Element)element.getParentNode();
        }
        Node node2 = element.getParentNode();
        node2.removeChild(element);
        while (((string = node2.getNodeName()).equals("add-value") || string.equals("remove-value") || string.equals("modify-attr") || string.equals("add-attr") || string.equals("attr")) && XdsUtil.getFirstChildElement(node2) == null && (node = node2.getParentNode()) != null) {
            node.removeChild(node2);
            node2 = node;
        }
    }

    protected void issueReferenceWarning(Element element) {
        Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
        String string = element2 != null ? element2.getAttributeNS(null, "attr-name") : "<Unknown>";
        StatusLog.logWarning(8003, XdsUtil.getNodeText(element), string);
    }

    protected Element appendValueClone(Element element) {
        if (element.getNodeName().equals("value")) {
            Element element2 = (Element)element.cloneNode(true);
            element.getParentNode().insertBefore(element2, element.getNextSibling());
            DOMUtil.addNamespaceDecls((Node)element2);
            return element2;
        }
        Element element3 = (Element)element.getParentNode();
        Element element4 = (Element)element3.cloneNode(true);
        element3.getParentNode().insertBefore(element4, element3.getNextSibling());
        DOMUtil.addNamespaceDecls((Node)element4);
        return XdsUtil.getFirstChildElementByTagNameWithAttrValueIgnoreCaseNS(element4, null, "component", null, "name", element.getAttributeNS(null, "name"));
    }

    protected void addOperationIDs(Document document) {
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
        if (element != null) {
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, "*", "*");
            HashSet<String> hashSet = new HashSet<String>();
            int n = 0;
            boolean bl = false;
            while (n < elementArray.length) {
                String string = elementArray[n].getAttributeNS(null, "event-id");
                if (string != null && !string.equals("")) {
                    hashSet.add(string);
                }
                ++n;
            }
            int n2 = 0;
            int n3 = 0;
            while (n2 < elementArray.length) {
                String string = elementArray[n2].getAttributeNS(null, "event-id");
                if (string == null || string.equals("")) {
                    boolean bl2;
                    while (!(bl2 = hashSet.add(string = String.valueOf(n3++)))) {
                    }
                    elementArray[n2].setAttributeNS(null, "event-id", string);
                }
                ++n2;
            }
        }
    }

    protected void shutdown() {
        if (this.context != null) {
            this.context.free();
        }
        this.inputTransformation = null;
        this.outputTransformation = null;
        this.registry = null;
        this.rootElement = null;
        this.context = null;
        this.eventTransformationRule = null;
        this.matchingRule = null;
        this.createRule = null;
        this.placementRule = null;
        this.commandTransformationRule = null;
        this.inputMapper = null;
        this.outputMapper = null;
    }

    private void encryptSensitiveData(HashMap hashMap, boolean bl) throws VRDException {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            CaseIgnoreStringKey caseIgnoreStringKey = (CaseIgnoreStringKey)iterator.next();
            if (!Driver.isSensitiveData(caseIgnoreStringKey.toString())) continue;
            DocumentFragment documentFragment = ((AttrEntry)hashMap.get((Object)caseIgnoreStringKey)).xmlValues;
            Element element = (Element)documentFragment.getFirstChild();
            while (element != null) {
                DSEAttributeValue dSEAttributeValue = DSEAttributeValueFactory.createValue(caseIgnoreStringKey.toString(), element);
                dSEAttributeValue.encrypt(bl ? this.driver.getInKey() : this.driver.getOutKey());
                Element element2 = documentFragment.getOwnerDocument().createElementNS(null, "hack");
                dSEAttributeValue.toXML(element2);
                element2 = (Element)element2.getFirstChild();
                documentFragment.replaceChild(element2, element);
                element = (Element)element2.getNextSibling();
            }
        }
    }

    protected static class AttrEntry {
        DocumentFragment xmlValues;
        HashMap valueMap;
        String name;

        AttrEntry(String string, DocumentFragment documentFragment) {
            this.name = string;
            this.xmlValues = documentFragment;
            this.valueMap = new HashMap();
        }

        boolean addValue(Element element) throws VRDException {
            AttrValueKey attrValueKey = new AttrValueKey(this.name, element);
            if (!this.valueMap.containsKey(attrValueKey)) {
                this.valueMap.put(attrValueKey, element);
                this.xmlValues.appendChild(element);
                return true;
            }
            return false;
        }

        boolean removeValue(Element element) throws VRDException {
            AttrValueKey attrValueKey = new AttrValueKey(this.name, element);
            Element element2 = (Element)this.valueMap.remove(attrValueKey);
            if (element2 != null) {
                element2.getParentNode().removeChild(element2);
                return true;
            }
            return false;
        }

        void removeAllValues() {
            this.valueMap.clear();
            XdsUtil.removeAllChildren(this.xmlValues);
        }
    }

    protected static class AttrValueKey {
        int hash;
        Element valueElement;
        DSEAttributeValue dseValue;

        AttrValueKey(String string, Element element) throws VRDException {
            this.valueElement = element;
            this.dseValue = DSEAttributeValueFactory.createValue(string, this.valueElement);
            this.hash = this.dseValue.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof AttrValueKey) {
                return this.dseValue.equals(((AttrValueKey)object).valueElement);
            }
            if (object instanceof Element) {
                return this.dseValue.equals((Element)object);
            }
            return false;
        }
    }
}

