/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.engine.Errors;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import novell.jclient.JCException;

public class VRDException
extends Exception {
    private int iErrorCode;
    private Object[] msgParms = null;

    public VRDException(int n) {
        this.iErrorCode = n;
    }

    public VRDException(int n, Object object) {
        this(n, new Object[]{object});
    }

    public VRDException(int n, Object object, Object object2) {
        this(n, new Object[]{object, object2});
    }

    public VRDException(int n, Object object, Object object2, Object object3) {
        this(n, new Object[]{object, object2, object3});
    }

    public VRDException(int n, Object object, Object object2, Object object3, Object object4) {
        this(n, new Object[]{object, object2, object3, object4});
    }

    public VRDException(int n, Object[] objectArray) {
        this.iErrorCode = n;
        this.msgParms = objectArray;
    }

    public VRDException(int n, Throwable throwable) {
        super(throwable);
        this.iErrorCode = n;
        this.msgParms = new Object[]{throwable.toString()};
    }

    public VRDException(int n, Throwable throwable, Object object) {
        super(throwable);
        this.iErrorCode = n;
        this.msgParms = new Object[]{throwable.toString(), object};
    }

    public VRDException(int n, Throwable throwable, Object[] objectArray) {
        super(throwable);
        this.iErrorCode = n;
        this.msgParms = objectArray;
    }

    public VRDException(Throwable throwable) {
        super(throwable);
        if (throwable instanceof JCException) {
            this.checkWrappedJCException((JCException)throwable);
        } else {
            this.iErrorCode = 9010;
        }
    }

    public String getMessage() {
        Throwable throwable = this.getCause();
        if (this.iErrorCode == 9010 && throwable != null) {
            String string = throwable instanceof JCException ? throwable.toString() : VRDException.getStackTraceString(throwable);
            return Errors.getMessage(this.iErrorCode, new Object[]{string});
        }
        if (this.msgParms == null && throwable != null) {
            return Errors.getMessage(this.iErrorCode, new Object[]{throwable.toString()});
        }
        return Errors.getMessage(this.iErrorCode, this.msgParms);
    }

    public void printStackTrace() {
        Throwable throwable = this.getCause();
        if (throwable != null) {
            throwable.printStackTrace();
        } else {
            super.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream printStream) {
        Throwable throwable = this.getCause();
        if (throwable != null) {
            throwable.printStackTrace(printStream);
        } else {
            super.printStackTrace(printStream);
        }
    }

    public void printStackTrace(PrintWriter printWriter) {
        Throwable throwable = this.getCause();
        if (throwable != null) {
            throwable.printStackTrace(printWriter);
        } else {
            super.printStackTrace(printWriter);
        }
    }

    public String toString() {
        Throwable throwable = this.getCause();
        if (throwable != null) {
            return throwable.toString();
        }
        return super.toString();
    }

    public int getErrorCode() {
        return this.iErrorCode;
    }

    public int getSeverity() {
        if (Errors.isDriverFatalCode(this.iErrorCode)) {
            return 4;
        }
        if (Errors.isRetryCode(this.iErrorCode)) {
            return 1;
        }
        return 3;
    }

    public boolean isFatal() {
        return Errors.isDriverFatalCode(this.iErrorCode);
    }

    public boolean isRetry() {
        return Errors.isRetryCode(this.iErrorCode);
    }

    private void checkWrappedJCException(JCException jCException) {
        switch (jCException.getErrorCode()) {
            case -774: 
            case -685: 
            case -684: 
            case -673: 
            case -663: 
            case -659: 
            case -654: 
            case -637: 
            case -635: 
            case -634: 
            case -626: 
            case -625: {
                this.iErrorCode = 9011;
                break;
            }
            default: {
                this.iErrorCode = 9010;
            }
        }
    }

    private static String getStackTraceString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.toString();
    }
}

