/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.NdsConstants;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueFactory;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.xml.dom.DOMUtil;
import com.novell.xsl.util.Util;
import java.util.ArrayList;
import java.util.Date;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class XdsUtil {
    public static final String TAG_WILDCARD = "*";

    public static String getNodeText(Node node) {
        return Util.getXSLStringValue((Node)node);
    }

    public static String getChildText(Node node) {
        Node node2 = node.getFirstChild();
        if (node2 == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(256);
        do {
            switch (node2.getNodeType()) {
                case 3: 
                case 4: {
                    stringBuffer.append(node2.getNodeValue());
                    break;
                }
            }
        } while ((node2 = node2.getNextSibling()) != null);
        return stringBuffer.toString();
    }

    public static void setNodeText(Node node, String string) {
        XdsUtil.removeAllChildren(node);
        if (string != null && string.length() != 0) {
            Document document = node.getOwnerDocument();
            node.appendChild(document.createTextNode(string));
        }
    }

    public static Element getFirstChildElement(Node node) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element) break;
            node2 = node2.getNextSibling();
        }
        return (Element)node2;
    }

    public static Element getFirstChildElementByTagNameNS(Node node, String string, String string2) {
        Node node2 = node.getFirstChild();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        while (node2 != null) {
            if (!(!(node2 instanceof Element) || !bl2 && !DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI()) || !bl && !DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName()))) break;
            node2 = node2.getNextSibling();
        }
        return (Element)node2;
    }

    public static Element getFirstChildElementByTagNameWithAttrValueNS(Node node, String string, String string2, String string3, String string4, String string5) {
        Node node2 = node.getFirstChild();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        while (node2 != null) {
            if (!(!(node2 instanceof Element) || !bl2 && !DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI()) || !bl && !DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName()) || !((Element)node2).getAttributeNS(string3, string4).equals(string5))) break;
            node2 = node2.getNextSibling();
        }
        return (Element)node2;
    }

    public static Element getFirstChildElementByTagNameWithAttrValueIgnoreCaseNS(Node node, String string, String string2, String string3, String string4, String string5) {
        Node node2 = node.getFirstChild();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        while (node2 != null) {
            if (!(!(node2 instanceof Element) || !bl2 && !DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI()) || !bl && !DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName()) || !((Element)node2).getAttributeNS(string3, string4).equalsIgnoreCase(string5))) break;
            node2 = node2.getNextSibling();
        }
        return (Element)node2;
    }

    public static Element[] getChildElements(Node node) {
        Node node2 = node.getFirstChild();
        ArrayList<Node> arrayList = new ArrayList<Node>();
        while (node2 != null) {
            if (node2 instanceof Element) {
                arrayList.add(node2);
            }
            node2 = node2.getNextSibling();
        }
        return XdsUtil.elementArrayListToElementArray(arrayList);
    }

    public static Element[] getChildElementsByTagNameNS(Node node, String string, String string2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element && (bl2 || DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI())) && (bl || DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName()))) {
                arrayList.add(node2);
            }
            node2 = node2.getNextSibling();
        }
        return XdsUtil.elementArrayListToElementArray(arrayList);
    }

    public static Element[] getChildElementsByTagNameWithAttrNS(Node node, String string, String string2, String string3, String string4) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element && (bl2 || DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI())) && (bl || DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName())) && ((Element)node2).getAttributeNS(string3, string4).length() != 0) {
                arrayList.add(node2);
            }
            node2 = node2.getNextSibling();
        }
        return XdsUtil.elementArrayListToElementArray(arrayList);
    }

    public static Element[] getChildElementsByTagNameWithAttrValueNS(Node node, String string, String string2, String string3, String string4, String string5) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element && (bl2 || DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI())) && (bl || DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName())) && ((Element)node2).getAttributeNS(string3, string4).equals(string5)) {
                arrayList.add(node2);
            }
            node2 = node2.getNextSibling();
        }
        return XdsUtil.elementArrayListToElementArray(arrayList);
    }

    public static Element[] getChildElementsByTagNameWithAttrValueIgnoreCaseNS(Node node, String string, String string2, String string3, String string4, String string5) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element && (bl2 || DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI())) && (bl || DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName())) && ((Element)node2).getAttributeNS(string3, string4).equalsIgnoreCase(string5)) {
                arrayList.add(node2);
            }
            node2 = node2.getNextSibling();
        }
        return XdsUtil.elementArrayListToElementArray(arrayList);
    }

    public static NodeList getElementsByTagNameNS(Node node, String string, String string2) {
        if (node instanceof Document) {
            return ((Document)node).getElementsByTagNameNS(string, string2);
        }
        if (node instanceof Element) {
            return ((Element)node).getElementsByTagNameNS(string, string2);
        }
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Node node2 = node.getFirstChild();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        while (node2 != null) {
            if (node2 instanceof Element) {
                if ((bl2 || DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI())) && (bl || DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName()))) {
                    arrayList.add(node2);
                }
                NodeList nodeList = ((Element)node2).getElementsByTagNameNS(string, string2);
                int n = 0;
                while (n < nodeList.getLength()) {
                    arrayList.add(nodeList.item(n));
                    ++n;
                }
            }
            node2 = node2.getNextSibling();
        }
        return new ArrayListNodeList(arrayList);
    }

    public static Element[] getElementsByTagNameWithAttrNS(Node node, String string, String string2, String string3, String string4) {
        NodeList nodeList = XdsUtil.getElementsByTagNameNS(node, string, string2);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (((Element)nodeList.item(n)).getAttributeNS(string3, string4).length() != 0) {
                arrayList.add(nodeList.item(n));
            }
            ++n;
        }
        return XdsUtil.elementArrayListToElementArray(arrayList);
    }

    public static Element[] getElementsByTagNameWithAttrValueNS(Node node, String string, String string2, String string3, String string4, String string5) {
        NodeList nodeList = XdsUtil.getElementsByTagNameNS(node, string, string2);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        int n = 0;
        while (n < nodeList.getLength()) {
            if (((Element)nodeList.item(n)).getAttributeNS(string3, string4).equals(string5)) {
                arrayList.add(nodeList.item(n));
            }
            ++n;
        }
        return XdsUtil.elementArrayListToElementArray(arrayList);
    }

    public static void removeChildElementsByTagNameNS(Node node, String string, String string2) {
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            Node node3 = node2.getNextSibling();
            if (node2 instanceof Element && (bl2 || DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI())) && (bl || DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName()))) {
                node.removeChild(node2);
            }
            node2 = node3;
        }
    }

    public static Element getFirstElementByTagNameNS(Node node, String string, String string2) {
        NodeList nodeList = XdsUtil.getElementsByTagNameNS(node, string, string2);
        return (Element)nodeList.item(0);
    }

    public static Element getFirstElementByTagNameWithAttrValueNS(Node node, String string, String string2, String string3, String string4, String string5) {
        Element element;
        NodeList nodeList = XdsUtil.getElementsByTagNameNS(node, string, string2);
        int n = 0;
        while ((element = (Element)nodeList.item(n)) != null) {
            if (element.getAttributeNS(string3, string4).equals(string5)) {
                return (Element)nodeList.item(n);
            }
            ++n;
        }
        return null;
    }

    public static Node cloneSubtree(Document document, Node node) {
        try {
            if (document.getImplementation().hasFeature("Core", "2.0")) {
                return document.importNode(node, true);
            }
            switch (node.getNodeType()) {
                case 1: {
                    Object object;
                    Element element = (Element)node;
                    Element element2 = document.createElement(element.getNodeName());
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    int n = 0;
                    while (n < namedNodeMap.getLength()) {
                        object = (Attr)namedNodeMap.item(n);
                        element2.setAttributeNS(null, object.getName(), object.getValue());
                        ++n;
                    }
                    object = element.getChildNodes();
                    int n2 = 0;
                    while (n2 < object.getLength()) {
                        element2.appendChild(XdsUtil.cloneSubtree(document, object.item(n2)));
                        ++n2;
                    }
                    return element2;
                }
                case 2: {
                    Attr attr = document.createAttribute(((Attr)node).getName());
                    attr.setValue(((Attr)node).getValue());
                    return attr;
                }
                case 3: {
                    return document.createTextNode(((Text)node).getData());
                }
                case 4: {
                    return document.createCDATASection(((CDATASection)node).getData());
                }
                case 5: {
                    return document.createEntityReference(node.getNodeName());
                }
                case 7: {
                    return document.createProcessingInstruction(node.getNodeName(), node.getNodeValue());
                }
                case 8: {
                    return document.createComment(node.getNodeValue());
                }
                case 11: {
                    DocumentFragment documentFragment = document.createDocumentFragment();
                    NodeList nodeList = node.getChildNodes();
                    int n = 0;
                    while (n < nodeList.getLength()) {
                        documentFragment.appendChild(XdsUtil.cloneSubtree(document, nodeList.item(n)));
                        ++n;
                    }
                    return documentFragment;
                }
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        return null;
    }

    public static void graftSubtree(Node node, Node node2) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        node.appendChild(XdsUtil.cloneSubtree(document, node2));
        DOMUtil.addNamespaceDecls((Node)node.getLastChild());
    }

    public static Document cloneDocument(Document document) {
        return DOMUtil.cloneDocument((Document)document);
    }

    public static Element renameElementNS(Element element, String string, String string2) {
        Node node;
        Element element2 = element.getOwnerDocument().createElementNS(string, string2);
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            node = (Attr)namedNodeMap.item(n);
            element2.setAttributeNS(node.getNamespaceURI(), node.getName(), node.getValue());
            ++n;
        }
        while (element.hasChildNodes()) {
            element2.appendChild(element.removeChild(element.getFirstChild()));
        }
        node = element.getParentNode();
        if (node != null) {
            node.replaceChild(element2, element);
        }
        return element2;
    }

    public static void removeAllChildren(Node node) {
        Node node2;
        while ((node2 = node.getFirstChild()) != null) {
            node.removeChild(node2);
        }
    }

    public static Element getFirstAncestorElementByTagNameNS(Node node, String string, String string2) {
        Node node2 = node.getParentNode();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        while (node2 != null) {
            if (!(!(node2 instanceof Element) || !bl2 && !DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI()) || !bl && !DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName()))) break;
            node2 = node2.getParentNode();
        }
        return (Element)node2;
    }

    public static Element getFirstAncestorElementByTagNameWithAttrNS(Node node, String string, String string2, String string3, String string4) {
        Node node2 = node.getParentNode();
        boolean bl = string2.equals(TAG_WILDCARD);
        boolean bl2 = string != null && string.equals(TAG_WILDCARD);
        while (node2 != null) {
            if (!(!(node2 instanceof Element) || !bl2 && !DOMUtil.stringsEqual((String)string, (String)node2.getNamespaceURI()) || !bl && !DOMUtil.stringsEqual((String)string2, (String)node2.getLocalName()) || ((Element)node2).getAttributeNS(string3, string4).length() == 0)) break;
            node2 = node2.getParentNode();
        }
        return (Element)node2;
    }

    public static Node[] nodeListToNodeArray(NodeList nodeList) {
        Node[] nodeArray = new Node[nodeList.getLength()];
        int n = 0;
        while (n < nodeArray.length) {
            nodeArray[n] = nodeList.item(n);
            ++n;
        }
        return nodeArray;
    }

    public static Element[] elementArrayListToElementArray(ArrayList arrayList) {
        Element[] elementArray = new Element[arrayList.size()];
        arrayList.toArray(elementArray);
        return elementArray;
    }

    public static String getAssociationValue(Element element) {
        Element element2 = XdsUtil.getFirstChildElementByTagNameNS(element, null, "association");
        return element2 == null ? "" : XdsUtil.getChildText(element2);
    }

    public static String getAssociationState(Element element) {
        Element element2 = XdsUtil.getFirstChildElementByTagNameNS(element, null, "association");
        return element2 == null ? "not-associated" : element2.getAttributeNS(null, "state");
    }

    public static boolean compareValues(String string, Element element, Element element2) {
        try {
            DSEAttributeValue dSEAttributeValue = DSEAttributeValueFactory.createValue(element);
            return dSEAttributeValue.equals(element2);
        }
        catch (VRDException vRDException) {
            return false;
        }
    }

    public static Element getFirstMatchingChildValue(Node node, String string, Element element) {
        try {
            DSEAttributeValue dSEAttributeValue = DSEAttributeValueFactory.createValue(string, element);
            return XdsUtil.getFirstMatchingChildValue(node, dSEAttributeValue);
        }
        catch (VRDException vRDException) {
            return null;
        }
    }

    public static Element getFirstMatchingChildValue(Node node, Element element) {
        try {
            DSEAttributeValue dSEAttributeValue = DSEAttributeValueFactory.createValue(element);
            return XdsUtil.getFirstMatchingChildValue(node, dSEAttributeValue);
        }
        catch (VRDException vRDException) {
            return null;
        }
    }

    public static Element getFirstMatchingChildValue(Node node, DSEAttributeValue dSEAttributeValue) {
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            if (node2 instanceof Element && node2.getNodeName().equals("value") && dSEAttributeValue.equals((Element)node2)) {
                return (Element)node2;
            }
            node2 = node2.getNextSibling();
        }
        return null;
    }

    public static Element getFirstMatchingValue(Node node, String string, Element element) {
        try {
            DSEAttributeValue dSEAttributeValue = DSEAttributeValueFactory.createValue(string, element);
            return XdsUtil.getFirstMatchingValue(node, dSEAttributeValue);
        }
        catch (VRDException vRDException) {
            return null;
        }
    }

    public static Element getFirstMatchingValue(Node node, Element element) {
        try {
            DSEAttributeValue dSEAttributeValue = DSEAttributeValueFactory.createValue(element);
            return XdsUtil.getFirstMatchingValue(node, dSEAttributeValue);
        }
        catch (VRDException vRDException) {
            return null;
        }
    }

    public static Element getFirstMatchingValue(Node node, DSEAttributeValue dSEAttributeValue) {
        Element element;
        NodeList nodeList = XdsUtil.getElementsByTagNameNS(node, null, "value");
        String string = ((JCValue)dSEAttributeValue).attributeName;
        int n = 0;
        while ((element = (Element)nodeList.item(n)) != null) {
            Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, null, TAG_WILDCARD, null, "attr-name");
            if (element2 != null && element2.getAttributeNS(null, "attr-name").equalsIgnoreCase(string) && dSEAttributeValue.equals(element)) {
                return element;
            }
            ++n;
        }
        return null;
    }

    public static Element getFirstValue(Node node, String string) {
        Element element;
        NodeList nodeList = XdsUtil.getElementsByTagNameNS(node, null, "value");
        int n = 0;
        while ((element = (Element)nodeList.item(n)) != null) {
            Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, null, TAG_WILDCARD, null, "attr-name");
            if (element2 != null && element2.getAttributeNS(null, "attr-name").equalsIgnoreCase(string)) {
                return element;
            }
            ++n;
        }
        return null;
    }

    private static Entry getEntry(Element element, String string, String string2) throws VRDException {
        String string3 = null;
        string3 = element.getAttributeNS(null, string);
        if (string3.length() == 0) {
            string3 = null;
        }
        long l = -1L;
        String string4 = element.getAttributeNS(null, string2);
        if (string4.length() > 0) {
            try {
                l = Long.parseLong(string4);
            }
            catch (NumberFormatException numberFormatException) {
                throw new VRDException(9036, string4);
            }
        }
        if (string3 == null && l == -1L) {
            return null;
        }
        return new Entry(string3, l);
    }

    public static Entry getSrcEntry(Element element) throws VRDException {
        return XdsUtil.getEntry(element, "src-dn", "src-entry-id");
    }

    public static Entry getDestEntry(Element element) throws VRDException {
        return XdsUtil.getEntry(element, "dest-dn", "dest-entry-id");
    }

    private static void setEntry(Element element, Entry entry, String string, String string2) {
        String string3 = entry.getDN();
        if (string3 != null && string3.length() != 0) {
            element.setAttributeNS(null, string, string3);
        } else {
            element.removeAttributeNS(null, string);
        }
        long l = entry.getEntryID();
        if (l != -1L) {
            element.setAttributeNS(null, string2, String.valueOf(l));
        } else {
            element.removeAttributeNS(null, string2);
        }
    }

    public static void setSrcEntry(Element element, Entry entry) {
        XdsUtil.setEntry(element, entry, "src-dn", "src-entry-id");
    }

    public static void setDestEntry(Element element, Entry entry) {
        XdsUtil.setEntry(element, entry, "dest-dn", "dest-entry-id");
    }

    public static Date getTimestamp(Element element) {
        Date date = null;
        String string = element.getAttributeNS(null, "timestamp");
        int n = string.indexOf(35);
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.length() > 0) {
            try {
                date = new Date(Long.parseLong(string) * 1000L);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return date;
    }

    public static int getTimestampEventCount(Element element) {
        String string = element.getAttributeNS(null, "timestamp");
        int n = string.indexOf(35);
        if (n != -1 && n != string.length() - 1 && (string = string.substring(n + 1)).length() > 0) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static JCTimestamp getJCTimestamp(Element element) {
        Date date = XdsUtil.getTimestamp(element);
        JCTimestamp jCTimestamp = null;
        if (date != null && date.getTime() != 0L) {
            jCTimestamp = new JCTimestamp(date, 0, XdsUtil.getTimestampEventCount(element));
        }
        return jCTimestamp;
    }

    public static boolean copyAttributeNS(Element element, String string, String string2, Element element2) {
        String string3 = element.getAttributeNS(string, string2);
        if (string3 != null && string3.length() > 0) {
            Attr attr = element.getAttributeNodeNS(string, string2);
            element2.setAttributeNS(string, attr.getNodeName(), string3);
            return true;
        }
        return false;
    }

    public static boolean copyAttributeNS(Element element, String string, String string2, Element element2, String string3, String string4) {
        String string5 = element.getAttributeNS(string, string2);
        if (string5 != null && string5.length() > 0) {
            element2.setAttributeNS(string3, string4, string5);
            return true;
        }
        return false;
    }

    public static String[] getDNForms(String string) {
        String[] stringArray = new String[2];
        XdsDN xdsDN = new XdsDN(string, NdsConstants.QSLASH_DELIMS_ARRAY);
        stringArray[0] = xdsDN.getDN(NdsConstants.SLASH_DELIMS_ARRAY);
        xdsDN.removeTreeName();
        stringArray[1] = xdsDN.getDN(NdsConstants.QSLASH_DELIMS_ARRAY);
        return stringArray;
    }

    private static class ArrayListNodeList
    implements NodeList {
        private ArrayList arrayList;

        ArrayListNodeList(ArrayList arrayList) {
            this.arrayList = arrayList;
        }

        public Node item(int n) {
            try {
                return (Node)this.arrayList.get(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        public int getLength() {
            return this.arrayList.size();
        }
    }
}

