/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dhutil.NMASSimplePwd;
import com.novell.nds.dhutil.SPMAgent;
import com.novell.nds.dirxml.engine.Association;
import com.novell.nds.dirxml.engine.CaseIgnoreStringKey;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.Events;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.MoveUtil;
import com.novell.nds.dirxml.engine.NDSReader;
import com.novell.nds.dirxml.engine.NdsConstants;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.OperationData;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.SchemaCache;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.ThreadVars;
import com.novell.nds.dirxml.engine.Transformer;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.VRSchema;
import com.novell.nds.dirxml.engine.Warnings;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueFactory;
import com.novell.nds.dirxml.engine.event.DSEObjectACL;
import com.novell.nds.dirxml.engine.event.DSEPath;
import com.novell.nds.dirxml.engine.event.DSEStream;
import com.novell.nds.dirxml.engine.rules.Filter;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.xml.dom.DOMQuery;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import novell.jclient.JCAclValue;
import novell.jclient.JCBooleanValue;
import novell.jclient.JCCIstringValue;
import novell.jclient.JCClassDef;
import novell.jclient.JCClassnameValue;
import novell.jclient.JCContext;
import novell.jclient.JCCounterValue;
import novell.jclient.JCDistnameValue;
import novell.jclient.JCEntryInfo;
import novell.jclient.JCEntryInfoEmptyFieldException;
import novell.jclient.JCException;
import novell.jclient.JCIntegerValue;
import novell.jclient.JCLong;
import novell.jclient.JCPathValue;
import novell.jclient.JCReadFilter;
import novell.jclient.JCStreamValue;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import novell.jclient.NWFile;
import novell.jclient.NWFileRestriction;
import novell.jclient.NWFileTrustee;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XmlInputProcessor {
    private JCContext context;
    private JCContext orig_context;
    private JCContext tempContext;
    private JCLong lConstraint = new JCLong();
    private JCLong lLowerLimit = new JCLong();
    private JCLong lUpperLimit = new JCLong();
    private String driverDN = "";
    private String ldapDriverDN = null;
    private Driver driver;
    protected EngineTrace tracer;
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.XmlInputProcessor");
    private boolean queryOnly = false;
    private ArrayList warnings = new ArrayList();
    private ArrayList logEvents = new ArrayList();
    private static Map nameToOpMap;
    private int replicationWaitMax = 180;
    protected static final String PUMPING_XDS = "xit_pump";
    protected static final String PERFORMING_OP_FOR = "xit_pfmopf";
    protected static final String SKIPPING_REMOVE_ALL_OC = "xit_skraoc";
    protected static final String SKIPPING_REMOVE_NAMING = "xit_skrnma";
    protected static final String FIXING_LINK_FROM = "xit_fixlnk";
    protected static final String IGNORING_EXTRA_PASSWORDS = "xit_igxpwe";
    protected static final String ADDING_ENTRY = "xit_addent";
    protected static final String CREATING_RDN = "xit_crdn";
    protected static final String SETTING_INITIAL_PASSWORD = "xit_sipwd";
    protected static final String USING_TEMPLATE = "xit_utmpl";
    protected static final String CREATING_HOME_DIRECTORY = "xit_crthd";
    protected static final String GRANTING_DIRECTORY_RIGHTS = "xit_grhdr";
    protected static final String RETRYING_DIRECTORY_RIGHTS = "xit_rgrhdr";
    protected static final String TIMED_OUT_DIRECTORY_RIGHTS = "xit_tgrhdr";
    protected static final String GRANTING_RIGHTS_TO = "xit_grrght";
    protected static final String RETRYING_GRANTING_RIGHTS_TO = "xit_rgrrght";
    protected static final String TIMED_OUT_GRANTING_RIGHTS_TO = "xit_tgrrght";
    protected static final String SETTING_VOLUME_SPACE_RESTRICTION = "xit_svsres";
    protected static final String RETRYING_VOLUME_SPACE_RESTRICTION = "xit_rvsres";
    protected static final String TIMED_OUT_VOLUME_SPACE_RESTRICTION = "xit_tvsres";
    protected static final String REMOVING_ENTRY = "xit_rmvent";
    protected static final String MODIFYING_ENTRY = "xit_modent";
    protected static final String RENAME_NOT_NEEDED = "xit_rennn";
    protected static final String RENAMING_ENTRY = "xit_renent";
    protected static final String MODIFYING_PASSWORD_FOR_ENTRY = "xit_modpwd";
    protected static final String MOVE_NOT_NEEDED = "xit_movnn";
    protected static final String MOVING_ENTRY = "xit_movent";
    protected static final String WAITING_SYNCED_TO_MASTER = "xit_wastm";
    protected static final String WAITING_SYNCED_FROM_MASTER = "xit_wamvr";
    protected static final String OPTIMIZE_PASSWORD = "xit_oppwd";
    private static final String HOME_DIRECTORY = "Home Directory";
    private static final String MEMBERS_OF_TEMPLATE = "Members Of Template";
    private static final String UNIQUE_ID = "uniqueID";
    private static final String NEW_OBJECTS_DS_RIGHTS = "New Object's DS Rights";
    private static final String NEW_OBJECTS_FS_RIGHTS = "New Object's FS Rights";
    private static final String NEW_OBJECTS_SELF_RIGHTS = "New Object's Self Rights";
    private static final String TRUSTEES_OF_NEW_OBJECT = "Trustees Of New Object";
    private static final String HOME_DIR_RIGHTS = "Home Directory Rights";
    private static final String VOLUME_SPACE_RESTRICTIONS = "Volume Space Restrictions";
    private static final String ACL = "ACL";
    private static final String LOGIN_GRACE_LIMIT = "Login Grace Limit";
    private static final String LOGIN_GRACE_REMAINING = "Login Grace Remaining";
    private static final String HOST_SERVER = "Host Server";
    private static final String HOST_RESOURCE_NAME = "Host Resource Name";
    private static final String PRIVATE_KEY = "Private Key";
    private static final String LOGIN_DISABLED = "Login Disabled";
    private static final String LOCKED_BY_INTRUDER = "Locked By Intruder";
    private static final String GUID = "GUID";
    private static final String CREATORS_NAME = "creatorsName";
    private static final String MODIFIERS_NAME = "modifiersName";
    private static final char[] delims;
    private static final CaseIgnoreStringKey[] templateIgnoreAttrs;
    static final int[] QUERY_ALLOWED;

    public XmlInputProcessor(Driver driver, EngineTrace engineTrace) {
        this.context = null;
        this.orig_context = null;
        this.driver = driver;
        this.tracer = engineTrace;
        if (driver != null) {
            this.replicationWaitMax = driver.registry.getECVs().getReplicationWait();
        }
    }

    public XmlInputProcessor(JCContext jCContext, Driver driver, EngineTrace engineTrace) {
        this.context = jCContext;
        this.orig_context = null;
        this.driver = driver;
        this.tracer = engineTrace;
        if (driver != null) {
            this.replicationWaitMax = driver.registry.getECVs().getReplicationWait();
        }
    }

    protected void shutdown() {
        if (this.context != null) {
            this.context.free();
        }
    }

    public void setQueryOnly(boolean bl) {
        this.queryOnly = bl;
    }

    public boolean getQueryOnly() {
        return this.queryOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDriverDN(String string) {
        this.driverDN = string;
        this.ldapDriverDN = null;
        if (this.driverDN == null) return;
        if (this.driverDN.length() == 0) return;
        JCContext jCContext = null;
        try {
            try {
                jCContext = this.context.duplicate();
                jCContext.setBaseDN(null, "10.\\+=*'");
                jCContext.nameToID(1, this.driverDN);
                JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)jCContext, (int)8192);
                String string2 = jCContext.standardizeDN(jCEntryInfo.getEntryDN().toString(), null);
                XdsDN xdsDN = new XdsDN(string2, "10.\\+=*'".toCharArray());
                xdsDN.removeTreeName();
                this.ldapDriverDN = xdsDN.getDN("10,,+=*\\\r<>#;\"".toCharArray());
            }
            catch (Exception exception) {
                Object var7_8 = null;
                if (jCContext == null) return;
                jCContext.free();
                return;
            }
            Object var7_7 = null;
            if (jCContext == null) return;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
    }

    public String getDriverDN() {
        return this.driverDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document process(Document document) {
        Element element = NdsDtd.createDoc("output");
        int n = 38;
        int n2 = 0;
        int n3 = 0;
        this.tracer.trace(PUMPING_XDS, (MessageSource)messageSource);
        Element element2 = XdsUtil.getFirstElementByTagNameNS(document, null, "input");
        if (element2 == null) {
            NdsDtd.addStatusElement(element, 2, null, Warnings.getMessage(8020, "input"));
            return element.getOwnerDocument();
        }
        Node node = element2.getFirstChild();
        while (true) {
            block16: {
                if (node == null) {
                    return element.getOwnerDocument();
                }
                if (node.getNodeType() == 1) {
                    Object var16_17;
                    OperationData operationData = new OperationData((Element)node);
                    int n4 = 0;
                    try {
                        try {
                            Object var14_16;
                            String string = node.getNodeName();
                            n4 = this.getOperationFromString(string);
                            this.warnings.clear();
                            this.logEvents.clear();
                            String string2 = null;
                            if (string.equals("status")) {
                                Element element3 = (Element)node;
                                string2 = element3.getAttributeNS(null, "level");
                            }
                            n = Events.getEventIDFromOperation(string, string2);
                            n2 = 0;
                            n3 = 0;
                            this.setThreadEventID(operationData);
                            try {
                                this.processOperationElement(element, (Element)node, n4);
                                var14_16 = null;
                                this.resetThreadEventID();
                            }
                            catch (Throwable throwable) {
                                var14_16 = null;
                                this.resetThreadEventID();
                                throw throwable;
                            }
                            NdsDtd.addStatusElement(element, 0, operationData, null);
                            int n5 = 0;
                            while (n5 < this.warnings.size()) {
                                NdsDtd.addStatusElement(element, 2, operationData, (String)this.warnings.get(n5));
                                if (n4 == 55) {
                                    ((Element)element.getLastChild()).setAttributeNS(null, "type", "password-set-operation");
                                }
                                ++n5;
                            }
                        }
                        catch (VRDException vRDException) {
                            n2 = vRDException.getErrorCode();
                            n3 = vRDException.getSeverity();
                            PersistentLog.logEvent(38, Events.convertLevel(n3), (String)ThreadVars.get("currentObject"), 0L, null, vRDException.getMessage(), null, null, (long)n2, 0L, "");
                            NdsDtd.addStatusElement(element, vRDException, operationData);
                            if (n4 == 55) {
                                ((Element)element.getLastChild()).setAttributeNS(null, "type", "password-set-operation");
                            }
                            var16_17 = null;
                            this.warnings.clear();
                            if (this.driver != null && this.logEvents.size() > 0) {
                                PersistentLog.logEvents(this.logEvents, Events.convertLevel(n3), n2);
                                this.logEvents.clear();
                            }
                            break block16;
                        }
                        var16_17 = null;
                        this.warnings.clear();
                        if (this.driver == null || this.logEvents.size() <= 0) break block16;
                    }
                    catch (Throwable throwable) {
                        var16_17 = null;
                        this.warnings.clear();
                        if (this.driver != null && this.logEvents.size() > 0) {
                            PersistentLog.logEvents(this.logEvents, Events.convertLevel(n3), n2);
                            this.logEvents.clear();
                        }
                        throw throwable;
                    }
                    PersistentLog.logEvents(this.logEvents, Events.convertLevel(n3), n2);
                    this.logEvents.clear();
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void setThreadEventID(OperationData operationData) {
        if (this.driver != null) {
            try {
                String string = operationData.getOperationID();
                boolean bl = false;
                if (string != null && string.length() > 0) {
                    int n = 0;
                    while (n < string.length()) {
                        char c = string.charAt(n);
                        if (c > '9' || c < '0') {
                            bl = true;
                            break;
                        }
                        ++n;
                    }
                }
                if (!bl) {
                    String string2;
                    Transformer transformer = (Transformer)ThreadVars.get("channel");
                    String string3 = string2 = transformer == null ? "" : transformer.getChannelName() + '#';
                    if (string == null || string.length() == 0) {
                        string = Long.toString(new Date().getTime());
                    }
                    string = (String)ThreadGroupVars.get("vrDriverRDN") + '#' + string2 + string;
                }
                ConfigAbstraction.setThreadEventID(string);
            }
            catch (DSErr dSErr) {
                StatusLog.logWarning(8027);
            }
        }
    }

    protected void resetThreadEventID() {
        if (this.driver != null) {
            try {
                ConfigAbstraction.setThreadEventID(null);
            }
            catch (DSErr dSErr) {
                // empty catch block
            }
        }
    }

    protected int getOperationFromString(String string) throws VRDException {
        try {
            return (Integer)nameToOpMap.get(string);
        }
        catch (NullPointerException nullPointerException) {
            throw new VRDException(9038, string, (Object)"input");
        }
    }

    protected void processOperationElement(Element element, Node node, int n) throws VRDException {
        Element element2 = (Element)node;
        if (n == -100) {
            return;
        }
        Entry entry = XdsUtil.getDestEntry(element2);
        String string = element2.getAttributeNS(null, "class-name");
        if (this.tracer.getLevel() > 0) {
            this.tracer.trace(PERFORMING_OP_FOR, (MessageSource)messageSource, element2.getNodeName(), (Object)(entry != null ? entry.getDN() : ""));
        }
        Entry[] entryArray = null;
        if (this.queryOnly) {
            int n2 = 0;
            while (n2 < QUERY_ALLOWED.length) {
                if (QUERY_ALLOWED[n2] == n) break;
                ++n2;
            }
            if (n2 >= QUERY_ALLOWED.length) {
                return;
            }
        }
        switch (n) {
            case -6: 
            case -5: 
            case 6: 
            case 8: 
            case 9: {
                if (entry != null) {
                    entryArray = new Entry[]{entry};
                    break;
                }
                entryArray = this.lookupAssociation(element2);
                if (entryArray != null && entryArray.length != 0) break;
                if (n == 6 && XdsUtil.getAssociationValue(element2).length() == 0) {
                    entryArray = new Entry[]{new Entry("\\")};
                    break;
                }
                throw new VRDException(9039, element2.getNodeName());
            }
            default: {
                entryArray = new Entry[]{entry};
            }
        }
        OperationProcessor operationProcessor = null;
        switch (n) {
            case 6: {
                operationProcessor = new SearchProcessor();
                break;
            }
            case 7: {
                operationProcessor = new AddProcessor();
                break;
            }
            case 8: {
                operationProcessor = new DeleteProcessor();
                break;
            }
            case 9: {
                operationProcessor = new ModifyProcessor();
                break;
            }
            case -6: {
                operationProcessor = new RenameProcessor();
                break;
            }
            case -5: {
                operationProcessor = new MoveProcessor();
                break;
            }
            case -1: {
                operationProcessor = new AddAssociationProcessor();
                break;
            }
            case -2: {
                operationProcessor = new RemoveAssociationProcessor();
                break;
            }
            case -3: {
                operationProcessor = new ModifyAssociationProcessor();
                break;
            }
            case -4: {
                operationProcessor = new StatusProcessor();
                break;
            }
            case -7: {
                operationProcessor = new QuerySchemaProcessor();
                break;
            }
            case -8: {
                operationProcessor = new CheckPasswordProcessor();
                break;
            }
            case -9: {
                operationProcessor = new CheckObjectPasswordProcessor();
                break;
            }
            case 55: {
                operationProcessor = new ModifyPasswordProcessor();
                break;
            }
            case -10: {
                operationProcessor = new GetNamedPasswordProcessor();
                break;
            }
            default: {
                return;
            }
        }
        int n3 = 0;
        while (n3 < entryArray.length) {
            operationProcessor.process(element, element2, entryArray[n3], string);
            ++n3;
        }
    }

    Entry[] lookupAssociation(Element element) throws VRDException {
        String string = XdsUtil.getAssociationValue(element);
        if (string.length() == 0) {
            return null;
        }
        return Association.lookupEntry(this.context, this.driverDN, string);
    }

    static {
        delims = "10.\\+=*'".toCharArray();
        templateIgnoreAttrs = new CaseIgnoreStringKey[]{new CaseIgnoreStringKey("Object Class"), new CaseIgnoreStringKey("DirXML-Associations"), new CaseIgnoreStringKey(UNIQUE_ID), new CaseIgnoreStringKey(MEMBERS_OF_TEMPLATE)};
        QUERY_ALLOWED = new int[]{6, -9, -10, -7};
        nameToOpMap = new HashMap();
        nameToOpMap.put("query", new Integer(6));
        nameToOpMap.put("add", new Integer(7));
        nameToOpMap.put("delete", new Integer(8));
        nameToOpMap.put("modify", new Integer(9));
        nameToOpMap.put("rename", new Integer(-6));
        nameToOpMap.put("move", new Integer(-5));
        nameToOpMap.put("add-association", new Integer(-1));
        nameToOpMap.put("remove-association", new Integer(-2));
        nameToOpMap.put("modify-association", new Integer(-3));
        nameToOpMap.put("status", new Integer(-4));
        nameToOpMap.put("query-schema", new Integer(-7));
        nameToOpMap.put("check-password", new Integer(-8));
        nameToOpMap.put("check-object-password", new Integer(-9));
        nameToOpMap.put("get-named-password", new Integer(-10));
        nameToOpMap.put("init-params", new Integer(-100));
        nameToOpMap.put("modify-password", new Integer(55));
    }

    class GetNamedPasswordProcessor
    extends OperationProcessor {
        GetNamedPasswordProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            String string2 = XPathUtil.getNodeValue((Node)element2);
            if (string2 == null || string2.length() == 0) {
                throw new VRDException(9152);
            }
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(45, element2, 2);
            }
            String string3 = ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.getNamedPassword(string2);
            Document document = element.getOwnerDocument();
            Element element3 = document.createElementNS(null, "password");
            element.appendChild(element3);
            Text text = document.createTextNode(string3);
            element3.appendChild(text);
        }

        protected void doJClientCall() throws JCException, VRDException {
        }
    }

    class ModifyPasswordProcessor
    extends OperationProcessor {
        String newPassword;
        String oldPassword;

        ModifyPasswordProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            Element element3;
            super.process(element, element2, entry, string);
            this.oldPassword = null;
            this.newPassword = null;
            Element element4 = XdsUtil.getFirstChildElementByTagNameNS(element2, null, "old-password");
            if (element4 != null) {
                this.oldPassword = XdsUtil.getChildText(element4);
            }
            if ((element3 = XdsUtil.getFirstChildElementByTagNameNS(element2, null, "password")) != null) {
                this.newPassword = XdsUtil.getChildText(element3);
            }
            if (this.newPassword != null) {
                if (XmlInputProcessor.this.driver != null) {
                    XmlInputProcessor.this.logEvents.clear();
                    XmlInputProcessor.this.logEvents = Events.getOperationEvents(18, element2, 2);
                }
                this.makeCall();
            }
        }

        protected void doJClientCall() throws JCException, VRDException {
            XmlInputProcessor.this.tracer.trace(XmlInputProcessor.MODIFYING_PASSWORD_FOR_ENTRY, (MessageSource)messageSource, this.strDN);
            this.entry.goTo(XmlInputProcessor.this.tempContext);
            if (!this.checkRights(XmlInputProcessor.this.tempContext, "[Entry Rights]", 16L)) {
                throw new JCException(this.oldPassword == null ? "generateKeyPair" : "changePassword", -672);
            }
            if (this.oldPassword != null) {
                try {
                    if (!XmlInputProcessor.this.tempContext.verifyPassword(this.newPassword)) {
                        XmlInputProcessor.this.tempContext.changePassword(this.oldPassword, this.newPassword);
                    }
                    XmlInputProcessor.this.tracer.trace(XmlInputProcessor.OPTIMIZE_PASSWORD, (MessageSource)messageSource);
                }
                catch (JCException jCException) {
                    if (jCException.getErrorCode() == -602) {
                        XmlInputProcessor.this.tempContext.generateKeyPair(this.newPassword);
                    }
                    throw jCException;
                }
            } else if (!XmlInputProcessor.this.tempContext.verifyPassword(this.newPassword)) {
                XmlInputProcessor.this.tempContext.generateKeyPair(this.newPassword);
            } else {
                XmlInputProcessor.this.tracer.trace(XmlInputProcessor.OPTIMIZE_PASSWORD, (MessageSource)messageSource);
            }
        }
    }

    class CheckObjectPasswordProcessor
    extends OperationProcessor {
        protected String passwordValue = null;

        CheckObjectPasswordProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            if (entry == null) {
                throw new VRDException(9047, element2.getNodeName());
            }
            super.process(element, element2, entry, string);
            Element element3 = XdsUtil.getFirstChildElementByTagNameNS(element2, null, "password");
            if (element3 == null) {
                throw new VRDException(9042, element2.getNodeName(), (Object)"password");
            }
            this.passwordValue = XdsUtil.getChildText(element3);
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(17, element2, 2);
            }
            this.makeCall();
        }

        protected void doJClientCall() throws JCException, VRDException {
            this.entry.goTo(XmlInputProcessor.this.tempContext);
            if (!this.objectCanLogin(XmlInputProcessor.this.tempContext)) {
                throw new VRDException(9048, this.ndOp.getNodeName());
            }
            if (!XmlInputProcessor.this.tempContext.verifyPassword(this.passwordValue)) {
                throw new VRDException(9046, this.ndOp.getNodeName());
            }
        }

        protected boolean objectCanLogin(JCContext jCContext) throws JCException {
            String[] stringArray = new String[]{XmlInputProcessor.LOGIN_DISABLED};
            try {
                JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)new JCReadFilter(false, new JCTimestamp(), stringArray));
                return !((JCBooleanValue)jCValueArray[0]).getState();
            }
            catch (JCException jCException) {
                if (jCException.getErrorCode() == -602 || jCException.getErrorCode() == -603) {
                    return true;
                }
                throw jCException;
            }
        }
    }

    class CheckPasswordProcessor
    extends OperationProcessor {
        protected String passwordValue;

        CheckPasswordProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            this.passwordValue = XdsUtil.getChildText(element2);
            if (XmlInputProcessor.this.driverDN == null) {
                throw new VRDException(9045, element2.getNodeName());
            }
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(17, element2, XmlInputProcessor.this.driverDN, 2);
            }
            this.makeCall();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doJClientCall() throws JCException, VRDException {
            XmlInputProcessor.this.tempContext.nameToID(1, XmlInputProcessor.this.driverDN);
            if (XmlInputProcessor.this.driver != null) {
                ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.lockBaseKeyPair();
            }
            try {
                if (!XmlInputProcessor.this.tempContext.verifyPassword(this.passwordValue)) {
                    throw new VRDException(9046, this.ndOp.getNodeName());
                }
                Object var2_1 = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (XmlInputProcessor.this.driver != null) {
                    ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.unlockBaseKeyPair();
                }
                throw throwable;
            }
            if (XmlInputProcessor.this.driver != null) {
                ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.unlockBaseKeyPair();
            }
        }
    }

    class QuerySchemaProcessor
    extends OperationProcessor {
        QuerySchemaProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(15, element2, 2);
            }
            this.makeCall();
        }

        protected void doJClientCall() throws JCException, VRDException {
            NDSReader.readSchema(XmlInputProcessor.this.tempContext, this.output);
        }
    }

    class StatusProcessor
    extends OperationProcessor {
        StatusProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            StatusLog.log(element2);
        }

        protected void doJClientCall() throws JCException, VRDException {
        }
    }

    class ModifyAssociationProcessor
    extends OperationProcessor {
        ModifyAssociationProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element2, null, "association");
            if (elementArray.length != 2) {
                throw new VRDException(9044, element2.getNodeName());
            }
            if (XmlInputProcessor.this.driver != null) {
                Events.LogEvent logEvent = new Events.LogEvent(14, this.strDN, 1L, "DirXML-Associations", XdsUtil.getChildText(elementArray[0]), null, element2.getAttributeNS(null, "event-id"), 0L, element2);
                XmlInputProcessor.this.logEvents.add(logEvent);
                logEvent = new Events.LogEvent(13, this.strDN, 1L, "DirXML-Associations", XdsUtil.getChildText(elementArray[1]), null, element2.getAttributeNS(null, "event-id"), 0L, element2);
                XmlInputProcessor.this.logEvents.add(logEvent);
            }
            Association.modifyAssociation(XmlInputProcessor.this.context, XmlInputProcessor.this.driverDN, XdsUtil.getChildText(elementArray[0]), XdsUtil.getChildText(elementArray[1]), 1);
        }

        protected void doJClientCall() throws JCException, VRDException {
        }
    }

    class RemoveAssociationProcessor
    extends OperationProcessor {
        RemoveAssociationProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(14, element2, 2);
            }
            Association.modifyAssociation(XmlInputProcessor.this.context, XmlInputProcessor.this.driverDN, XdsUtil.getChildText(element2), null, 0);
        }

        protected void doJClientCall() throws JCException, VRDException {
        }
    }

    class AddAssociationProcessor
    extends OperationProcessor {
        AddAssociationProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            if (entry == null) {
                throw new VRDException(9040, element2.getNodeName(), (Object)"dest-dn");
            }
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(13, element2, 2);
            }
            Association.addAssociation(XmlInputProcessor.this.context, XmlInputProcessor.this.driverDN, entry, XdsUtil.getChildText(element2), 1);
        }

        protected void doJClientCall() throws JCException, VRDException {
        }
    }

    class MoveProcessor
    extends OperationProcessor {
        Entry parentEntry;

        MoveProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            Element element3 = XdsUtil.getFirstChildElementByTagNameNS(element2, null, "parent");
            if (element3 == null) {
                throw new VRDException(9042, element2.getNodeName(), (Object)"parent");
            }
            this.parentEntry = XdsUtil.getDestEntry(element3);
            Entry[] entryArray = XmlInputProcessor.this.lookupAssociation(element3);
            if (entryArray != null) {
                if (entryArray.length > 1) {
                    throw new VRDException(9043, element3.getNodeName());
                }
                if (entryArray.length == 1) {
                    this.parentEntry = entryArray[0];
                }
            }
            if (this.parentEntry == null) {
                throw new VRDException(9039, element3.getNodeName());
            }
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(12, element2, 2);
            }
            this.makeCall();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void doJClientCall() throws JCException, VRDException {
            JCContext jCContext2 = null;
            JCContext jCContext = XmlInputProcessor.this.tempContext;
            String string = XmlInputProcessor.this.tempContext.standardizeDN(this.entry.getDN(), null);
            String string2 = XmlInputProcessor.this.tempContext.standardizeDN(this.parentEntry.getDN(), null);
            JCContext jCContext3 = null;
            try {
                block19: {
                    try {
                        this.entry.goTo(XmlInputProcessor.this.tempContext);
                        jCContext2 = XmlInputProcessor.this.context.duplicate();
                        this.parentEntry.goTo(jCContext2);
                        JCEntryInfo jCEntryInfo = JClient.getEntryInfo((JCContext)XmlInputProcessor.this.tempContext, (int)1280);
                        JCEntryInfo jCEntryInfo2 = JClient.getEntryInfo((JCContext)jCContext2, (int)1024);
                        if ((long)jCEntryInfo.getParentID() != this.parentEntry.getEntryID()) {
                            int n;
                            int n2 = jCEntryInfo.getReplicaType();
                            int n3 = jCEntryInfo2.getReplicaType();
                            if (!this.checkRights(XmlInputProcessor.this.tempContext, "[Entry Rights]", 4L)) throw new JCException("moveEntry", -672);
                            if (!this.checkRights(jCContext2, "[Entry Rights]", 2L)) throw new JCException("moveEntry", -672);
                            if (n2 == 2) throw new JCException("moveEntry", -672);
                            if (n3 == 5) throw new JCException("moveEntry", -672);
                            if (n2 == 2) throw new JCException("moveEntry", -672);
                            if (n3 == 5) {
                                throw new JCException("moveEntry", -672);
                            }
                            if (XmlInputProcessor.this.driver != null && n2 != 0 || n3 != 0) {
                                jCContext3 = this.getRemoteContext();
                                if (n2 != 0) {
                                    jCContext = jCContext3.duplicate();
                                    n = 0;
                                    while (n < XmlInputProcessor.this.replicationWaitMax && !MoveUtil.isSyncedToMaster(XmlInputProcessor.this.tempContext, jCContext, XmlInputProcessor.this.replicationWaitMax)) {
                                        try {
                                            XmlInputProcessor.this.tracer.trace(XmlInputProcessor.WAITING_SYNCED_TO_MASTER, (MessageSource)messageSource, string);
                                            Thread.sleep(1000L);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                        ++n;
                                    }
                                    jCContext.resolve(8, string);
                                    ConfigAbstraction.stubbornAuthenticate(jCContext, XmlInputProcessor.this.replicationWaitMax);
                                }
                                if (n3 != 0) {
                                    jCContext2.free();
                                    jCContext2 = jCContext3.duplicate();
                                    jCContext2.resolve(8, string2);
                                    ConfigAbstraction.stubbornAuthenticate(jCContext2, XmlInputProcessor.this.replicationWaitMax);
                                }
                            }
                            XmlInputProcessor.this.tracer.trace(XmlInputProcessor.MOVING_ENTRY, (MessageSource)messageSource, string, (Object)string2);
                            JClient.moveEntry((JCContext)jCContext, (JCContext)jCContext2, (long)0L, null);
                            if (n3 == 0) break block19;
                            this.cleanupRemoteContext();
                            n = 0;
                            while (n < XmlInputProcessor.this.replicationWaitMax && !MoveUtil.hasMoved(XmlInputProcessor.this.tempContext, string)) {
                                try {
                                    XmlInputProcessor.this.tracer.trace(XmlInputProcessor.WAITING_SYNCED_FROM_MASTER, (MessageSource)messageSource, string2);
                                    Thread.sleep(2000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                ++n;
                            }
                            break block19;
                        }
                        XmlInputProcessor.this.tracer.trace(XmlInputProcessor.MOVE_NOT_NEEDED, (MessageSource)messageSource);
                    }
                    catch (JCEntryInfoEmptyFieldException jCEntryInfoEmptyFieldException) {
                        throw new VRDException(jCEntryInfoEmptyFieldException);
                    }
                }
                Object var13_15 = null;
                if (jCContext2 != null) {
                    jCContext2.free();
                }
                if (jCContext != null && jCContext != XmlInputProcessor.this.tempContext) {
                    jCContext.free();
                }
                this.cleanupRemoteContext();
                return;
            }
            catch (Throwable throwable) {
                Object var13_16 = null;
                if (jCContext2 != null) {
                    jCContext2.free();
                }
                if (jCContext != null && jCContext != XmlInputProcessor.this.tempContext) {
                    jCContext.free();
                }
                this.cleanupRemoteContext();
                throw throwable;
            }
        }
    }

    class RenameProcessor
    extends OperationProcessor {
        String newNameString;
        boolean removeOldName;

        RenameProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            Element element3 = XdsUtil.getFirstElementByTagNameNS(element2, null, "new-name");
            if (element3 == null) {
                throw new VRDException(9042, element2.getNodeName(), (Object)"new-name");
            }
            this.newNameString = XdsUtil.getChildText(element3);
            String string2 = element2.getAttributeNS(null, "dest-dn");
            long l = 1L;
            if (string2 == null || string2.length() == 0) {
                string2 = XdsUtil.getAssociationValue(element2);
                l = 4L;
            }
            if (this.newNameString.equals(this.name)) {
                XmlInputProcessor.this.tracer.trace(XmlInputProcessor.RENAME_NOT_NEEDED, (MessageSource)messageSource);
                if (XmlInputProcessor.this.driver != null) {
                    Events.LogEvent logEvent = new Events.LogEvent(39, 6, element2.getAttributeNS(null, "dest-dn"), l, null, messageSource.getMessageString(XmlInputProcessor.RENAME_NOT_NEEDED), element2.getAttributeNS(null, "src-dn"), element2.getAttributeNS(null, "event-id"), 0L, element2);
                    XmlInputProcessor.this.logEvents.add(logEvent);
                }
            } else {
                if (XmlInputProcessor.this.driver != null) {
                    XmlInputProcessor.this.logEvents.clear();
                    XmlInputProcessor.this.logEvents = Events.getOperationEvents(11, element2, 2);
                }
                this.removeOldName = !element2.getAttributeNS(null, "remove-old-name").equals("false");
                this.makeCall();
            }
        }

        protected void doJClientCall() throws JCException, VRDException {
            XmlInputProcessor.this.tracer.trace(XmlInputProcessor.RENAMING_ENTRY, (MessageSource)messageSource, this.strDN, (Object)this.newNameString);
            this.entry.goTo(XmlInputProcessor.this.tempContext);
            if (!this.checkRights(XmlInputProcessor.this.tempContext, "[Entry Rights]", 8L)) {
                throw new JCException("modifyRDN", -672);
            }
            JClient.modifyRDN((JCContext)XmlInputProcessor.this.tempContext, (String)this.newNameString, (boolean)this.removeOldName);
        }
    }

    class ModifyProcessor
    extends OperationProcessor {
        ModifyProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(10, element2, 2);
            }
            try {
                NodeSet nodeSet = DOMQuery.query((Node)element2, (String)"(.//value)|(.//remove-all-values)");
                this.fillValueArray(nodeSet);
                if (this.values.size() > 0 || this.streamValues.size() > 0 || this.distPassword != null || this.simplePassword != null) {
                    this.makeCall();
                }
            }
            catch (XPathEvaluationException xPathEvaluationException) {
                throw new VRDException(xPathEvaluationException);
            }
        }

        protected Element doGetAttrNodeFromValue(Element element) {
            return (Element)element.getParentNode().getParentNode();
        }

        protected int doSetValueOperation(Element element, String string) {
            String string2 = element.getParentNode().getNodeName();
            if (string2.equals("remove-value")) {
                return 7;
            }
            if (string2.equals("add-value")) {
                return 5;
            }
            return 0;
        }

        protected void doJClientCall() throws JCException, VRDException {
            int n;
            XmlInputProcessor.this.tracer.trace(XmlInputProcessor.MODIFYING_ENTRY, (MessageSource)messageSource, this.strDN);
            this.entry.goTo(XmlInputProcessor.this.tempContext);
            if (!this.checkRights(XmlInputProcessor.this.tempContext, "[Entry Rights]", 16L)) {
                Object object;
                n = this.values.size() - 1;
                while (n >= 0) {
                    String string = ((JCValue)this.values.get((int)n)).attributeName;
                    if (!this.checkRights(XmlInputProcessor.this.tempContext, string, 4L)) {
                        this.values.remove(n);
                        object = new JCException("modifyEntry", -672);
                        XmlInputProcessor.this.warnings.add(Warnings.getMessage(8014, object.toString(), this.strDN, string));
                    }
                    --n;
                }
                int n2 = this.streamValues.size() - 1;
                while (n2 >= 0) {
                    object = ((JCValue)this.streamValues.get((int)n2)).attributeName;
                    if (!this.checkRights(XmlInputProcessor.this.tempContext, (String)object, 4L)) {
                        this.streamValues.remove(n2);
                        JCException jCException = new JCException("modifyEntry", -672);
                        XmlInputProcessor.this.warnings.add(Warnings.getMessage(8014, jCException.toString(), this.strDN, object));
                    }
                    --n2;
                }
                if (this.values.size() == 0 && this.streamValues.size() == 0 && this.distPassword == null && this.simplePassword == null) {
                    throw new VRDException(new JCException("modifyEntry", -672));
                }
            }
            if (XmlInputProcessor.this.driver != null) {
                n = this.values.size() - 1;
                while (n >= 0) {
                    if (this.values.get(n) instanceof JCCounterValue) {
                        JCCounterValue jCCounterValue = (JCCounterValue)this.values.get(n);
                        switch (jCCounterValue.operation) {
                            case 7: {
                                jCCounterValue.operation = 6;
                                break;
                            }
                            case 2: 
                            case 5: {
                                if (n != 0 && ((JCValue)this.values.get((int)(n - 1))).operation == 6 && !((JCValue)this.values.get((int)(n - 1))).attributeName.equalsIgnoreCase(jCCounterValue.attributeName)) break;
                                this.values.add(n, new JCCounterValue(jCCounterValue.attributeName, 6, 0L, new JCTimestamp(), 0));
                                ++n;
                            }
                        }
                    }
                    --n;
                }
            }
            if (this.values.size() > 0) {
                JClient.modifyEntry((JCContext)XmlInputProcessor.this.tempContext, (JCValue[])this.getValuesArray());
            }
            this.writeStreamValues();
            this.writePasswordValue(true);
            this.writeSimplePasswordValue();
            this.processSpecialValues();
        }
    }

    class DeleteProcessor
    extends OperationProcessor {
        DeleteProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            super.process(element, element2, entry, string);
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(9, element2, 2);
            }
            this.makeCall();
        }

        protected void doJClientCall() throws JCException, VRDException {
            XmlInputProcessor.this.tracer.trace(XmlInputProcessor.REMOVING_ENTRY, (MessageSource)messageSource, this.strDN);
            this.entry.goTo(XmlInputProcessor.this.tempContext);
            if (!this.checkRights(XmlInputProcessor.this.tempContext, "[Entry Rights]", 4L)) {
                throw new JCException("modifyRDN", -672);
            }
            JClient.removeEntry((JCContext)XmlInputProcessor.this.tempContext);
        }
    }

    class AddProcessor
    extends OperationProcessor {
        protected ArrayList specialTemplateValues = null;
        String templateDN = null;
        String password = null;
        Filter.ClassEntry filterClassEntry;

        AddProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            if (entry == null) {
                throw new VRDException(9040, element2.getNodeName(), (Object)"dest-dn");
            }
            super.process(element, element2, entry, string);
            this.filterClassEntry = XmlInputProcessor.this.driver != null ? ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.getFilter().getClassEntry(string) : null;
            if (this.specialTemplateValues == null) {
                this.specialTemplateValues = new ArrayList();
            } else {
                this.specialTemplateValues.clear();
            }
            this.templateDN = null;
            this.password = null;
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(8, element2, 2);
            }
            NodeList nodeList = element2.getElementsByTagNameNS(null, "value");
            String string2 = XdsUtil.getAssociationValue(element2);
            this.values.add(new JCClassnameValue("Object Class", 5, 0L, new JCTimestamp(), string));
            this.fillValueArray(nodeList);
            if (XmlInputProcessor.this.driverDN != null && XmlInputProcessor.this.driverDN.length() > 0 && string2.length() > 0) {
                this.values.add(new JCPathValue("DirXML-Associations", 5, 0L, new JCTimestamp(), XmlInputProcessor.this.driverDN, string2, 1));
            }
            this.addAttributesFromTemplate();
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element2, null, "password");
            if (elementArray.length > 0) {
                if (elementArray.length > 1) {
                    XmlInputProcessor.this.tracer.trace(XmlInputProcessor.IGNORING_EXTRA_PASSWORDS, (MessageSource)messageSource);
                }
                this.password = XdsUtil.getChildText(elementArray[0]);
            }
            this.makeCall();
        }

        protected void doJClientCall() throws JCException, VRDException {
            XmlInputProcessor.this.tracer.trace(XmlInputProcessor.ADDING_ENTRY, (MessageSource)messageSource, this.strDN);
            XdsDN xdsDN = new XdsDN(this.strDN, delims);
            String[] stringArray = xdsDN.split(delims);
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (string.length() == 0) {
                string = ".";
            }
            this.strDN = xdsDN.getDN(delims);
            if (XmlInputProcessor.this.tracer.getLevel() > 0) {
                XmlInputProcessor.this.tracer.trace(XmlInputProcessor.CREATING_RDN, (MessageSource)messageSource, string2, (Object)(string != null ? string : "[Root]"));
            }
            XmlInputProcessor.this.tempContext.nameToID(1, string);
            if (!this.checkRights(XmlInputProcessor.this.tempContext, "[Entry Rights]", 2L)) {
                throw new JCException("createEntry", -672);
            }
            if (string2.length() > 128) {
                throw new JCException("createEntry", -334);
            }
            JClient.createEntry((JCContext)XmlInputProcessor.this.tempContext, (String)string2, (JCValue[])this.getValuesArray());
            XmlInputProcessor.this.tempContext.nameToID(1, this.strDN);
            if (this.password != null) {
                XmlInputProcessor.this.tracer.trace(XmlInputProcessor.SETTING_INITIAL_PASSWORD, (MessageSource)messageSource);
                XmlInputProcessor.this.tempContext.generateKeyPair(this.password);
            }
            if (XmlInputProcessor.this.ldapDriverDN != null && XmlInputProcessor.this.ldapDriverDN.length() > 0) {
                JClient.modifyEntry((JCContext)XmlInputProcessor.this.tempContext, (JCValue[])new JCValue[]{new JCCIstringValue(XmlInputProcessor.CREATORS_NAME, 5, 0L, new JCTimestamp(), XmlInputProcessor.this.ldapDriverDN)});
            }
            this.writeStreamValues();
            this.writePasswordValue(false);
            this.writeSimplePasswordValue();
            this.processSpecialValues();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void addAttributesFromTemplate() {
            int n = -1;
            int n2 = -1;
            this.templateDN = this.ndOp.getAttributeNS(null, "template-dn");
            if (this.templateDN.length() == 0) {
                return;
            }
            JCContext jCContext = null;
            try {
                block26: {
                    try {
                        Object object;
                        JCClassDef jCClassDef;
                        String string;
                        XmlInputProcessor.this.tracer.trace(XmlInputProcessor.USING_TEMPLATE, (MessageSource)messageSource, this.templateDN);
                        Entry entry = new Entry(this.templateDN);
                        jCContext = XmlInputProcessor.this.context.duplicate();
                        entry.goTo(jCContext);
                        jCContext.setFlags(128, 0);
                        JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)0L, (JCReadFilter)JCReadFilter.allAttributes());
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int n3 = 0;
                        while (n3 < jCValueArray.length) {
                            if (!jCValueArray[n3].attributeName.equalsIgnoreCase(XmlInputProcessor.MEMBERS_OF_TEMPLATE) && !jCValueArray[n3].attributeName.equalsIgnoreCase(XmlInputProcessor.ACL)) {
                                arrayList.add(jCValueArray[n3].attributeName);
                            }
                            ++n3;
                        }
                        JCValue[] jCValueArray2 = JClient.readEntry((JCContext)jCContext, (long)3L, (JCReadFilter)new JCReadFilter(false, new JCTimestamp(), arrayList.toArray(new String[arrayList.size()])));
                        JCClassDef jCClassDef2 = SchemaCache.getClassDef(this.strClass);
                        HashSet hashSet = (HashSet)SchemaCache.getClassAttrs(this.strClass).clone();
                        int n4 = 0;
                        while (n4 < jCValueArray2.length) {
                            JCValue jCValue = jCValueArray2[n4];
                            string = jCValue.attributeName;
                            if (string.equalsIgnoreCase("Object Class") && ((jCClassDef = SchemaCache.getClassDef((String)(object = ((JCClassnameValue)jCValue).getClassname()))).getCharacteristics() & 0x20L) != 0L) {
                                hashSet.addAll(SchemaCache.getClassAttrs(this.strClass));
                                jCValue.operation = 5;
                                this.values.add(jCValue);
                            }
                            ++n4;
                        }
                        int n5 = 0;
                        while (n5 < this.values.size()) {
                            string = ((JCValue)this.values.get((int)n5)).attributeName;
                            if (XmlInputProcessor.this.driver != null) {
                                object = new Events.LogEvent(41, -1, string, null);
                                XmlInputProcessor.this.logEvents.add(object);
                            }
                            hashSet.remove(new CaseIgnoreStringKey(string));
                            ++n5;
                        }
                        int n6 = 0;
                        while (n6 < templateIgnoreAttrs.length) {
                            hashSet.remove(templateIgnoreAttrs[n6]);
                            ++n6;
                        }
                        int n7 = 0;
                        while (n7 < jCValueArray2.length) {
                            jCClassDef = jCValueArray2[n7];
                            String string2 = jCClassDef.attributeName;
                            if (string2.equalsIgnoreCase(XmlInputProcessor.NEW_OBJECTS_DS_RIGHTS) || string2.equalsIgnoreCase(XmlInputProcessor.NEW_OBJECTS_FS_RIGHTS) || string2.equalsIgnoreCase(XmlInputProcessor.NEW_OBJECTS_SELF_RIGHTS) || string2.equalsIgnoreCase(XmlInputProcessor.HOME_DIR_RIGHTS) || string2.equalsIgnoreCase(XmlInputProcessor.VOLUME_SPACE_RESTRICTIONS)) {
                                this.specialTemplateValues.add(jCClassDef);
                            } else {
                                Object object2;
                                if (string2.equalsIgnoreCase(XmlInputProcessor.TRUSTEES_OF_NEW_OBJECT)) {
                                    string2 = XmlInputProcessor.ACL;
                                    jCValueArray2[n7].attributeName = XmlInputProcessor.ACL;
                                } else if (string2.equalsIgnoreCase(XmlInputProcessor.HOME_DIRECTORY) && jCClassDef instanceof JCPathValue) {
                                    JCPathValue jCPathValue = (JCPathValue)jCClassDef;
                                    object2 = jCPathValue.getVolumePath();
                                    if (!((String)object2).endsWith("\\")) {
                                        object2 = (String)object2 + "\\";
                                    }
                                    jCPathValue.setVolumePath((String)object2 + this.name);
                                }
                                if (hashSet.contains(new CaseIgnoreStringKey(string2)) && (jCClassDef.flags & 1L) == 0L) {
                                    Object object3;
                                    Element element = NdsDtd.createDoc("value");
                                    object2 = DSEAttributeValueFactory.createValue((JCValue)jCClassDef);
                                    object2.toXML(element);
                                    if (XmlInputProcessor.this.driver != null) {
                                        object3 = Events.getElementContent(jCClassDef.attributeName, element, false);
                                        Events.LogEvent logEvent = new Events.LogEvent(47, -1, jCClassDef.attributeName, (String)object3);
                                        XmlInputProcessor.this.logEvents.add(logEvent);
                                    }
                                    if (jCClassDef instanceof JCStreamValue) {
                                        object3 = new DSEStream((JCStreamValue)jCClassDef);
                                        ((DSEStream)object3).readValue(jCContext);
                                        this.values.add(object3);
                                        this.streamValues.add(object3);
                                    } else {
                                        if (string2.equalsIgnoreCase(XmlInputProcessor.LOGIN_GRACE_LIMIT)) {
                                            n = (int)((JCIntegerValue)jCClassDef).getInteger();
                                        } else if (string2.equalsIgnoreCase(XmlInputProcessor.LOGIN_GRACE_REMAINING)) {
                                            n2 = ((JCCounterValue)jCClassDef).getCounter();
                                        }
                                        jCClassDef.operation = 5;
                                        this.values.add(jCClassDef);
                                    }
                                }
                            }
                            ++n7;
                        }
                        if (!hashSet.contains(new CaseIgnoreStringKey(XmlInputProcessor.LOGIN_GRACE_REMAINING)) || n <= -1 || n2 != -1) break block26;
                        this.values.add(new JCCounterValue(XmlInputProcessor.LOGIN_GRACE_REMAINING, 5, 0L, new JCTimestamp(), n));
                    }
                    catch (Exception exception) {
                        XmlInputProcessor.this.warnings.add(Warnings.getMessage(8005, this.templateDN));
                        Object var22_28 = null;
                        if (jCContext == null) return;
                        jCContext.free();
                        return;
                    }
                }
                Object var22_27 = null;
                if (jCContext == null) return;
                jCContext.free();
                return;
            }
            catch (Throwable throwable) {
                Object var22_29 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void processSpecialValues() throws JCException, VRDException {
            super.processSpecialValues();
            if (this.templateDN != null && this.templateDN.length() > 0) {
                this.addTemplateMember();
            }
            try {
                String string;
                int n = this.values.size();
                int n2 = 0;
                while (n2 < n) {
                    JCValue jCValue = (JCValue)this.values.get(n2);
                    string = jCValue.attributeName;
                    if (string.equalsIgnoreCase(XmlInputProcessor.HOME_DIRECTORY) && jCValue instanceof JCPathValue) {
                        this.addHomeDirectory((JCPathValue)jCValue);
                    }
                    ++n2;
                }
                n = this.specialTemplateValues.size();
                int n3 = 0;
                while (n3 < n) {
                    Events.LogEvent logEvent;
                    String string2;
                    DSEAttributeValue dSEAttributeValue;
                    string = (JCValue)this.specialTemplateValues.get(n3);
                    String string3 = ((JCValue)string).attributeName;
                    Element element = NdsDtd.createDoc("value");
                    if (string3.equalsIgnoreCase(XmlInputProcessor.NEW_OBJECTS_DS_RIGHTS)) {
                        dSEAttributeValue = new DSEObjectACL((JCAclValue)string);
                        ((DSEObjectACL)dSEAttributeValue).toXML(element);
                        if (XmlInputProcessor.this.driver != null) {
                            string2 = Events.getElementContent(string3, element, false);
                            logEvent = new Events.LogEvent(47, -1, string3, string2);
                            XmlInputProcessor.this.logEvents.add(logEvent);
                        }
                        this.addTemplateRights((JCAclValue)string);
                    } else if (string3.equalsIgnoreCase(XmlInputProcessor.NEW_OBJECTS_SELF_RIGHTS)) {
                        dSEAttributeValue = new DSEObjectACL((JCAclValue)string);
                        ((DSEObjectACL)dSEAttributeValue).toXML(element);
                        if (XmlInputProcessor.this.driver != null) {
                            string2 = Events.getElementContent(string3, element, false);
                            logEvent = new Events.LogEvent(47, -1, string3, string2);
                            XmlInputProcessor.this.logEvents.add(logEvent);
                        }
                        string2 = (JCAclValue)string;
                        this.addTemplateRights(new JCAclValue(((JCAclValue)string2).attributeName, 5, 0L, new JCTimestamp(), string2.getAttributeName(), this.entry.getDN(), string2.getPrivileges()));
                    } else if (string3.equalsIgnoreCase(XmlInputProcessor.NEW_OBJECTS_FS_RIGHTS)) {
                        dSEAttributeValue = new DSEPath((JCPathValue)string);
                        ((DSEPath)dSEAttributeValue).toXML(element);
                        if (XmlInputProcessor.this.driver != null) {
                            string2 = Events.getElementContent(string3, element, false);
                            logEvent = new Events.LogEvent(47, -1, string3, string2);
                            XmlInputProcessor.this.logEvents.add(logEvent);
                        }
                        this.addTemplateFSRights((JCPathValue)string);
                    } else if (string3.equalsIgnoreCase(XmlInputProcessor.VOLUME_SPACE_RESTRICTIONS)) {
                        dSEAttributeValue = new DSEPath((JCPathValue)string);
                        ((DSEPath)dSEAttributeValue).toXML(element);
                        string2 = Events.getElementContent(string3, element, false);
                        if (XmlInputProcessor.this.driver != null) {
                            logEvent = new Events.LogEvent(47, -1, string3, string2);
                            XmlInputProcessor.this.logEvents.add(logEvent);
                        }
                        this.addTemplateVolumeSpaceRestrictions((JCPathValue)string);
                    }
                    ++n3;
                }
                Object var11_11 = null;
            }
            catch (Throwable throwable) {
                Object var11_12 = null;
                this.cleanupRemoteContext();
                throw throwable;
            }
            this.cleanupRemoteContext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void addTemplateRights(JCAclValue jCAclValue) {
            JCContext jCContext = null;
            try {
                try {
                    JCValue[] jCValueArray = new JCValue[]{new JCAclValue(XmlInputProcessor.ACL, 5, 0L, new JCTimestamp(), jCAclValue.getAttributeName(), this.entry.getDN(), jCAclValue.getPrivileges())};
                    jCContext = XmlInputProcessor.this.tempContext.duplicate();
                    jCContext.nameToID(1, jCAclValue.getTrusteeDN());
                    JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
                }
                catch (JCException jCException) {
                    XmlInputProcessor.this.warnings.add(Warnings.getMessage(8012, jCException.toString(), jCAclValue.getTrusteeDN() + '#' + jCAclValue.getAttributeName()));
                    Object var5_6 = null;
                    if (jCContext == null) return;
                    jCContext.free();
                    return;
                }
                Object var5_5 = null;
                if (jCContext == null) return;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void addTemplateMember() throws JCException {
            if (this.filterClassEntry == null) return;
            if (!this.filterClassEntry.getPubTrackTemplate()) return;
            JCContext jCContext = null;
            try {
                try {
                    JCValue[] jCValueArray = new JCValue[]{new JCDistnameValue(XmlInputProcessor.MEMBERS_OF_TEMPLATE, 5, 0L, new JCTimestamp(), this.strDN)};
                    jCContext = XmlInputProcessor.this.tempContext.duplicate();
                    jCContext.nameToID(1, this.templateDN);
                    JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
                }
                catch (JCException jCException) {
                    XmlInputProcessor.this.warnings.add(Warnings.getMessage(8013, jCException.toString(), this.templateDN, XmlInputProcessor.MEMBERS_OF_TEMPLATE));
                    Object var4_5 = null;
                    if (jCContext == null) return;
                    jCContext.free();
                    return;
                }
                Object var4_4 = null;
                if (jCContext == null) return;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void addHomeDirectory(JCPathValue jCPathValue) {
            if (this.filterClassEntry != null) {
                if (!this.filterClassEntry.getPubCreateHomeDir()) return;
            }
            JCContext jCContext = null;
            try {
                try {
                    int n;
                    jCContext = this.getRemoteContext().duplicate();
                    String string2 = this.getVolumeNameAndConnectToServer(jCContext, jCPathValue.getVolumeDN());
                    String string = jCPathValue.getVolumePath();
                    string = string.replace('/', '\\');
                    while (true) {
                        if (!string.startsWith("\\")) {
                            string = string2 + ":" + string;
                            XmlInputProcessor.this.tracer.trace(XmlInputProcessor.CREATING_HOME_DIRECTORY, (MessageSource)messageSource, string);
                            try {
                                n = NWFile.open((JCContext)jCContext, (String)string, (byte)8, (short)16, (int)16, (short)507);
                                break;
                            }
                            catch (JCException jCException) {
                                if (jCException.getErrorCode() == -255) break;
                                throw jCException;
                            }
                        }
                        string = string.substring(1);
                    }
                    n = 0;
                    int n2 = this.specialTemplateValues.size();
                    short s = 0;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n2) {
                            if (n == 0) {
                                s = 507;
                            }
                            break;
                        }
                        JCValue jCValue = (JCValue)this.specialTemplateValues.get(n3);
                        String string3 = jCValue.attributeName;
                        if (string3.equalsIgnoreCase(XmlInputProcessor.HOME_DIR_RIGHTS) && jCValue instanceof JCIntegerValue) {
                            n = 1;
                            s = (short)(s | (short)((JCIntegerValue)jCValue).getInteger());
                        }
                        ++n3;
                    }
                    XmlInputProcessor.this.tracer.trace(XmlInputProcessor.GRANTING_DIRECTORY_RIGHTS, (MessageSource)messageSource);
                    int n4 = 0;
                    while (true) {
                        try {
                            NWFile.addTrustees((JCContext)jCContext, (String)string, (short)16, (NWFileTrustee[])new NWFileTrustee[]{new NWFileTrustee(this.entry.getDN(), s)});
                            break;
                        }
                        catch (JCException jCException) {
                            if (jCException.getErrorCode() != -601) break;
                            if (n4++ > XmlInputProcessor.this.replicationWaitMax) {
                                XmlInputProcessor.this.tracer.trace(XmlInputProcessor.TIMED_OUT_DIRECTORY_RIGHTS, (MessageSource)messageSource);
                                throw jCException;
                            }
                            try {
                                Thread.sleep(1000L);
                                XmlInputProcessor.this.tracer.trace(XmlInputProcessor.RETRYING_DIRECTORY_RIGHTS, (MessageSource)messageSource);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                    }
                    Object var13_16 = null;
                    if (jCContext == null) return;
                }
                catch (Exception exception) {
                    XmlInputProcessor.this.warnings.add(Warnings.getMessage(8006, exception.toString()));
                    Object var13_17 = null;
                    if (jCContext == null) return;
                    jCContext.free();
                    return;
                }
                jCContext.free();
                return;
            }
            catch (Throwable throwable) {
                Object var13_18 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void addTemplateFSRights(JCPathValue jCPathValue) {
            int n;
            short s;
            String string2;
            JCContext jCContext = null;
            try {
                try {
                    jCContext = this.getRemoteContext().duplicate();
                    String string = this.getVolumeNameAndConnectToServer(jCContext, jCPathValue.getVolumeDN());
                    string2 = jCPathValue.getVolumePath();
                    s = (short)jCPathValue.getNameSpace();
                    string2 = string2.replace('/', '\\');
                    while (true) {
                        if (!string2.startsWith("\\")) {
                            string2 = string + ":" + string2;
                            XmlInputProcessor.this.tracer.trace(XmlInputProcessor.GRANTING_RIGHTS_TO, (MessageSource)messageSource, string2);
                            n = 0;
                            break;
                        }
                        string2 = string2.substring(1);
                    }
                }
                catch (Exception exception) {
                    XmlInputProcessor.this.warnings.add(Warnings.getMessage(8007, jCPathValue.getVolumePath(), exception.toString()));
                    Object var10_11 = null;
                    if (jCContext == null) return;
                    jCContext.free();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
            while (true) {
                try {
                    NWFile.addTrustees((JCContext)jCContext, (String)string2, (short)16, (NWFileTrustee[])new NWFileTrustee[]{new NWFileTrustee(this.entry.getDN(), s)});
                    break;
                }
                catch (JCException jCException) {
                    if (jCException.getErrorCode() != -601) break;
                    if (n++ > XmlInputProcessor.this.replicationWaitMax) {
                        XmlInputProcessor.this.tracer.trace(XmlInputProcessor.TIMED_OUT_GRANTING_RIGHTS_TO, (MessageSource)messageSource, string2);
                        throw jCException;
                    }
                    try {
                        Thread.sleep(1000L);
                        XmlInputProcessor.this.tracer.trace(XmlInputProcessor.RETRYING_GRANTING_RIGHTS_TO, (MessageSource)messageSource, string2);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
            }
            Object var10_10 = null;
            if (jCContext == null) return;
            jCContext.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void addTemplateVolumeSpaceRestrictions(JCPathValue jCPathValue) {
            JCContext jCContext = null;
            try {
                try {
                    jCContext = this.getRemoteContext().duplicate();
                    String string = this.getVolumeNameAndConnectToServer(jCContext, jCPathValue.getVolumeDN());
                    int n = jCPathValue.getNameSpace() / 4;
                    if (XmlInputProcessor.this.tracer.getLevel() > 0) {
                        XmlInputProcessor.this.tracer.trace(XmlInputProcessor.SETTING_VOLUME_SPACE_RESTRICTION, (MessageSource)messageSource, jCPathValue.getVolumeDN(), (Object)new Integer(n * 4));
                    }
                    int n2 = 0;
                    while (true) {
                        try {
                            NWFile.addDiskSpaceRestrictions((JCContext)jCContext, (String)string, (NWFileRestriction[])new NWFileRestriction[]{new NWFileRestriction(this.entry.getDN(), n)});
                            break;
                        }
                        catch (JCException jCException) {
                            if (jCException.getErrorCode() != -601) break;
                            if (n2++ > XmlInputProcessor.this.replicationWaitMax) {
                                if (XmlInputProcessor.this.tracer.getLevel() <= 0) throw jCException;
                                XmlInputProcessor.this.tracer.trace(XmlInputProcessor.TIMED_OUT_VOLUME_SPACE_RESTRICTION, (MessageSource)messageSource, jCPathValue.getVolumeDN(), (Object)new Integer(n * 4));
                                throw jCException;
                            }
                            try {
                                Thread.sleep(1000L);
                                if (XmlInputProcessor.this.tracer.getLevel() <= 0) continue;
                                XmlInputProcessor.this.tracer.trace(XmlInputProcessor.RETRYING_VOLUME_SPACE_RESTRICTION, (MessageSource)messageSource, jCPathValue.getVolumeDN(), (Object)new Integer(n * 4));
                                continue;
                            }
                            catch (InterruptedException interruptedException) {}
                            break;
                        }
                    }
                    Object var9_9 = null;
                    if (jCContext == null) return;
                }
                catch (Exception exception) {
                    XmlInputProcessor.this.warnings.add(Warnings.getMessage(8008, jCPathValue.getVolumeDN(), exception.toString()));
                    Object var9_10 = null;
                    if (jCContext == null) return;
                    jCContext.free();
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
        }

        String getVolumeNameAndConnectToServer(JCContext jCContext, String string) throws JCException, VRDException {
            jCContext.resolve(2, string);
            JCReadFilter jCReadFilter = new JCReadFilter(false, new JCTimestamp(), new String[]{XmlInputProcessor.HOST_SERVER, XmlInputProcessor.HOST_RESOURCE_NAME});
            JCValue[] jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
            String string2 = null;
            String string3 = null;
            int n = 0;
            while (n < jCValueArray.length) {
                if (string2 == null && jCValueArray[n].attributeName.equalsIgnoreCase(XmlInputProcessor.HOST_SERVER) && jCValueArray[n] instanceof JCDistnameValue) {
                    string2 = ((JCDistnameValue)jCValueArray[n]).getDistname();
                } else if (string2 == null && jCValueArray[n].attributeName.equalsIgnoreCase(XmlInputProcessor.HOST_RESOURCE_NAME) && jCValueArray[n] instanceof JCCIstringValue) {
                    string3 = ((JCCIstringValue)jCValueArray[n]).getString();
                }
                ++n;
            }
            if (string2 == null || string3 == null) {
                throw new VRDException(9041, string);
            }
            jCContext.setFlags(2, 0);
            jCContext.connect(string2);
            ConfigAbstraction.stubbornAuthenticate(jCContext, XmlInputProcessor.this.replicationWaitMax);
            jCContext.licenseConnection();
            return string3;
        }

        protected int doSetValueOperation(Element element, String string) {
            return 5;
        }
    }

    class SearchProcessor
    extends OperationProcessor {
        protected String[] attNames;
        protected int scope;
        protected OperationData opData;
        protected Map interpretationMap = null;

        SearchProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            int n;
            Object object;
            super.process(element, element2, entry, string);
            this.attNames = null;
            this.opData = new OperationData(element2);
            String string2 = element2.getAttributeNS(null, "scope");
            this.scope = string2.equals("entry") ? 0 : (string2.equals("subordinates") ? 1 : (string2.equals("subtree") ? 2 : 2));
            if (XmlInputProcessor.this.driver != null) {
                XmlInputProcessor.this.logEvents.clear();
                XmlInputProcessor.this.logEvents = Events.getOperationEvents(7, element2, 2);
            }
            NodeList nodeList = element2.getElementsByTagNameNS(null, "value");
            this.fillValueArray(nodeList);
            if (XmlInputProcessor.this.warnings.size() > 0) {
                throw new VRDException(9053, (String)XmlInputProcessor.this.warnings.get(0));
            }
            Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element2, null, "search-class");
            int n2 = 0;
            while (n2 < elementArray.length) {
                object = elementArray[n2].getAttributeNS(null, "class-name");
                if (((String)object).length() != 0) {
                    JCClassnameValue jCClassnameValue = new JCClassnameValue("Object Class", 17, 0L, new JCTimestamp(), (String)object);
                    this.values.add(jCClassnameValue);
                }
                ++n2;
            }
            if (this.interpretationMap != null) {
                this.interpretationMap.clear();
            }
            if ((n = (object = element2.getElementsByTagNameNS(null, "read-attr")).getLength()) > 0) {
                this.attNames = new String[n];
                int n3 = 0;
                while (n3 < n) {
                    Element element3 = (Element)object.item(n3);
                    this.attNames[n3] = element3.getAttributeNS(null, "attr-name");
                    String string3 = element3.getAttributeNS(null, "type");
                    if (string3 != null && string3.equals("xml")) {
                        if (this.interpretationMap == null) {
                            this.interpretationMap = new HashMap();
                        }
                        this.interpretationMap.put(this.attNames[n3], new Integer(1));
                    }
                    ++n3;
                }
            }
            this.makeCall();
        }

        protected int doSetValueOperation(Element element, String string) {
            return NdsConstants.getPseudoAttrSearchOperator(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doJClientCall() throws JCException, VRDException {
            DocumentFragment documentFragment = this.output.getOwnerDocument().createDocumentFragment();
            boolean bl = false;
            if (XmlInputProcessor.this.driver != null && this.entry.getEntryID() == ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.getDriverID()) {
                ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.lockBaseKeyPair();
            }
            try {
                NDSReader.readObjects(XmlInputProcessor.this.tempContext, this.entry, this.getValuesArray(), this.attNames, this.scope, (Node)documentFragment, this.opData, this.interpretationMap, XmlInputProcessor.this.driver);
                Object var4_3 = null;
                if (bl) {
                    ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.unlockBaseKeyPair();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (bl) {
                    ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.unlockBaseKeyPair();
                }
                throw throwable;
            }
            if (XmlInputProcessor.this.driverDN != null && XmlInputProcessor.this.driverDN.length() > 0 && XmlInputProcessor.this.driver != null) {
                ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.getFilter().filterByDriverRights(XmlInputProcessor.this.tempContext, XmlInputProcessor.this.driverDN, documentFragment);
            }
            this.output.appendChild(documentFragment);
        }
    }

    abstract class OperationProcessor {
        protected ArrayList values = null;
        protected ArrayList streamValues = null;
        protected String strDN = null;
        protected Entry entry = null;
        protected String strClass = null;
        protected Element output = null;
        protected Element ndOp = null;
        protected String name = null;
        protected SPMAgent.PasswordInfo distPassword = null;
        protected SPMAgent.PasswordInfo simplePassword = null;
        protected JCContext remoteContext = null;

        OperationProcessor() {
        }

        protected void process(Element element, Element element2, Entry entry, String string) throws VRDException {
            this.output = element;
            this.ndOp = element2;
            if (entry != null) {
                this.strDN = entry.getDN();
                if (this.strDN != null) {
                    XdsDN xdsDN = new XdsDN(this.strDN, delims);
                    this.name = xdsDN.getName(delims);
                } else {
                    this.name = null;
                }
            } else {
                this.strDN = null;
                this.name = null;
            }
            this.strClass = string;
            this.entry = entry;
            if (this.values == null) {
                this.values = new ArrayList();
            } else {
                this.values.clear();
            }
            if (this.distPassword != null) {
                this.distPassword = null;
            }
            if (this.simplePassword != null) {
                this.simplePassword = null;
            }
            if (this.streamValues == null) {
                this.streamValues = new ArrayList();
            } else {
                this.streamValues.clear();
            }
            this.remoteContext = null;
        }

        protected JCValue[] getValuesArray() {
            JCValue[] jCValueArray = new JCValue[this.values.size()];
            this.values.toArray(jCValueArray);
            return jCValueArray;
        }

        protected Element doGetAttrNodeFromValue(Element element) {
            return (Element)element.getParentNode();
        }

        protected int doSetValueOperation(Element element, String string) {
            return 0;
        }

        protected abstract void doJClientCall() throws JCException, VRDException;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void makeCall() throws VRDException {
            try {
                try {
                    XmlInputProcessor.this.tempContext = XmlInputProcessor.this.context.duplicate();
                    this.doJClientCall();
                }
                catch (JCException jCException) {
                    throw new VRDException(jCException);
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                if (XmlInputProcessor.this.tempContext == null) throw throwable;
                XmlInputProcessor.this.tempContext.free();
                throw throwable;
            }
            if (XmlInputProcessor.this.tempContext == null) return;
            XmlInputProcessor.this.tempContext.free();
        }

        protected void fillValueArray(NodeList nodeList) throws VRDException {
            int n = 0;
            while (n < nodeList.getLength()) {
                this.fillValueSlot((Element)nodeList.item(n));
                ++n;
            }
        }

        protected void fillValueArray(NodeSet nodeSet) throws VRDException {
            Node node = nodeSet.first();
            while (node != null) {
                this.fillValueSlot((Element)node);
                node = nodeSet.next();
            }
        }

        protected void fillValueSlot(Element element) throws VRDException {
            JCAclValue jCAclValue;
            String string;
            DSEAttributeValue dSEAttributeValue;
            block20: {
                boolean bl = false;
                try {
                    dSEAttributeValue = DSEAttributeValueFactory.createValue(element);
                    if (element.getNodeName().equals("remove-all-values") || !Driver.isSensitiveData(((JCValue)dSEAttributeValue).attributeName)) break block20;
                    if (XmlInputProcessor.this.driver != null && XmlInputProcessor.this.driver.isTrustedDriver()) {
                        dSEAttributeValue.decrypt(XmlInputProcessor.this.driver.getInKey());
                        break block20;
                    }
                    XmlInputProcessor.this.warnings.add(Warnings.getMessage(8000, ((JCValue)dSEAttributeValue).attributeName));
                    return;
                }
                catch (VRDException vRDException) {
                    Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
                    if (element2 != null) {
                        XmlInputProcessor.this.warnings.add(Warnings.getMessage(8009, element2.getNodeName(), vRDException.toString()));
                    } else {
                        XmlInputProcessor.this.warnings.add(vRDException.toString());
                    }
                    return;
                }
            }
            if (element.getNodeName().equals("remove-all-values")) {
                if (((JCValue)dSEAttributeValue).attributeName.equalsIgnoreCase("Object Class")) {
                    if (XmlInputProcessor.this.driver != null) {
                        Events.LogEvent logEvent = new Events.LogEvent(39, 6, "Object Class", messageSource.getMessageString(XmlInputProcessor.SKIPPING_REMOVE_ALL_OC));
                        XmlInputProcessor.this.logEvents.add(logEvent);
                    }
                    XmlInputProcessor.this.tracer.trace(XmlInputProcessor.SKIPPING_REMOVE_ALL_OC, (MessageSource)messageSource);
                    return;
                }
                ((JCValue)dSEAttributeValue).operation = 6;
            } else {
                ((JCValue)dSEAttributeValue).operation = this.doSetValueOperation(element, ((JCValue)dSEAttributeValue).attributeName);
            }
            if (element.getAttributeNS(null, "naming").equals("true") && element.getParentNode().getNodeName().equals("remove-value")) {
                Events.LogEvent logEvent = new Events.LogEvent(39, 6, ((JCValue)dSEAttributeValue).attributeName, messageSource.getMessageString(XmlInputProcessor.SKIPPING_REMOVE_NAMING));
                XmlInputProcessor.this.tracer.trace(XmlInputProcessor.SKIPPING_REMOVE_NAMING, (MessageSource)messageSource);
                return;
            }
            if (((JCValue)dSEAttributeValue).attributeName.equalsIgnoreCase("nspmDistributionPassword")) {
                this.distPassword = new SPMAgent.PasswordInfo(element, (long)((JCValue)dSEAttributeValue).operation);
                return;
            }
            if (((JCValue)dSEAttributeValue).attributeName.equalsIgnoreCase("SAS:Login Configuration")) {
                this.simplePassword = new SPMAgent.PasswordInfo(element, (long)((JCValue)dSEAttributeValue).operation);
                return;
            }
            if (((JCValue)dSEAttributeValue).syntax == 17 && (string = (jCAclValue = (JCAclValue)dSEAttributeValue).getAttributeName()) != null && SchemaCache.getAttributeDef(string) == null && !string.equals("[All Attributes Rights]") && !string.equals("[Entry Rights]")) {
                XmlInputProcessor.this.warnings.add(Warnings.getMessage(8028, string, this.strDN, jCAclValue.attributeName));
                return;
            }
            if (dSEAttributeValue instanceof DSEStream) {
                switch (((JCValue)dSEAttributeValue).operation) {
                    case 6: 
                    case 7: {
                        ((JCValue)dSEAttributeValue).operation = 6;
                        this.values.add(dSEAttributeValue);
                        break;
                    }
                    case 2: 
                    case 5: {
                        if (this instanceof AddProcessor) {
                            this.values.add(dSEAttributeValue);
                        }
                        this.streamValues.add(dSEAttributeValue);
                    }
                }
            } else {
                this.values.add(dSEAttributeValue);
            }
        }

        void doPasswordWriteBack(String string, String string2) {
            Node node;
            Element element;
            Element element2 = NdsDtd.createDoc("input");
            Document document = element2.getOwnerDocument();
            Element element3 = document.createElementNS(null, "modify");
            if (this.distPassword.getSrcDN() != null) {
                element3.setAttributeNS(null, "dest-dn", this.distPassword.getSrcDN());
            }
            if (this.distPassword.getDestDN() != null) {
                element3.setAttributeNS(null, "src-dn", this.distPassword.getDestDN());
            }
            if (this.distPassword.getClassName() != null) {
                element3.setAttributeNS(null, "class-name", this.distPassword.getClassName());
            }
            element2.appendChild(element3);
            if (this.distPassword.getAssociation() != null) {
                element = document.createElementNS(null, "association");
                element3.appendChild(element);
                node = document.createTextNode(this.distPassword.getAssociation());
                element.appendChild(node);
            }
            element = document.createElementNS(null, "modify-attr");
            element.setAttributeNS(null, "failed-sync", "true");
            element.setAttributeNS(null, "attr-name", "nspmDistributionPassword");
            element3.appendChild(element);
            node = document.createElementNS(null, "remove-value");
            element.appendChild(node);
            Element element4 = document.createElementNS(null, "value");
            node.appendChild(element4);
            Text text = document.createTextNode(this.distPassword.getPassword(true));
            element4.appendChild(text);
            Element element5 = document.createElementNS(null, "add-value");
            element.appendChild(element5);
            element4 = document.createElementNS(null, "value");
            element5.appendChild(element4);
            try {
                SPMAgent.PasswordInfo passwordInfo = SPMAgent.getSPMDistPassword((String)"Agent Dirxml", (String)XmlInputProcessor.this.driverDN, (String)string, (String)string2, (long)0L);
                Text text2 = document.createTextNode(passwordInfo.getPassword());
                element4.appendChild(text2);
                XmlInputProcessor.this.tracer.trace(document);
                ThreadVars.put("pwdWriteBack", document);
            }
            catch (DSErr dSErr) {
                ThreadVars.remove("pwdWriteBack");
                XmlInputProcessor.this.warnings.add(Warnings.getMessage(8021, dSErr.toString()));
            }
            PersistentLog.logEvent(37, 7, this.distPassword.getDestDN(), 1L, "nspmDistributionPassword", Warnings.getMessage(8000, "nspmDistributionPassword"), this.distPassword.getSrcDN(), null, 0L, 0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void writePasswordValue(boolean bl) {
            int n = 7;
            if (this.distPassword == null) {
                return;
            }
            long l = this.distPassword.getSetFlags();
            String string = this.distPassword.getPassword(true);
            JCContext jCContext = null;
            String string2 = this.strDN;
            try {
                try {
                    jCContext = XmlInputProcessor.this.context.duplicate();
                    String string3 = MiscDS.getTreeName();
                    String string4 = string3.toLowerCase();
                    String string5 = this.strDN.toLowerCase();
                    if (!string5.startsWith(string4, 1)) {
                        string2 = jCContext.standardizeDN(string2, null);
                    }
                    SPMAgent.PasswordInfo passwordInfo = null;
                    if (bl) {
                        try {
                            passwordInfo = SPMAgent.getSPMDistPassword((String)"Agent Dirxml", (String)XmlInputProcessor.this.driverDN, (String)string3, (String)string2, (long)0L);
                        }
                        catch (Throwable throwable) {
                            passwordInfo = null;
                        }
                    }
                    if (passwordInfo == null || !passwordInfo.getPassword().equals(string)) {
                        int n2 = SPMAgent.setSPMDistPassword((String)"Agent Dirxml", (String)XmlInputProcessor.this.driverDN, (String)string3, (String)string2, (String)string, (long)l);
                        if (n2 != 0) {
                            Integer n3 = new Integer(n2);
                            XmlInputProcessor.this.warnings.add(Warnings.getMessage(8021, n3.toString()));
                            n = 5;
                            this.doPasswordWriteBack(string3, string2);
                        }
                        PersistentLog.logEvent(36, n, string2, 1L, "nspmDistributionPassword", Warnings.getMessage(8000, "nspmDistributionPassword"), null, null, 0L, n2);
                    }
                    XmlInputProcessor.this.tracer.trace(XmlInputProcessor.OPTIMIZE_PASSWORD, (MessageSource)messageSource);
                }
                catch (Throwable throwable) {
                    XmlInputProcessor.this.warnings.add(Warnings.getMessage(8021, throwable.toString()));
                    Object var16_16 = null;
                    if (jCContext == null) return;
                    jCContext.free();
                    return;
                }
                Object var16_15 = null;
                if (jCContext == null) return;
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void writeSimplePasswordValue() {
            String string;
            int n;
            int n2;
            block12: {
                n2 = 0;
                n = 7;
                byte[] byArray = null;
                JCContext jCContext = null;
                if (this.simplePassword == null) {
                    return;
                }
                long l = this.simplePassword.getSetFlags();
                string = this.strDN;
                try {
                    block11: {
                        try {
                            byArray = this.simplePassword.getSimpleData();
                            String string2 = MiscDS.getTreeName();
                            jCContext = new JCContext(0x800000, string2, "00.\\+=*'");
                            String string3 = string2.toLowerCase();
                            String string4 = this.strDN.toLowerCase();
                            if (!string4.startsWith(string3, 1)) {
                                string = XmlInputProcessor.this.tempContext.standardizeDN(string, null);
                            }
                            int n3 = SPMAgent.extractDClientContext((JCContext)jCContext);
                            try {
                                n2 = SPMAgent.deleteSimplePassword((int)n3, (String)string, (int[])NMASSimplePwd.METHOD_ID, (String)"Password Hash");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            if (this.simplePassword.getPassword(true) != null) {
                                n2 = SPMAgent.setSimplePassword((int)n3, (String)string, (int[])NMASSimplePwd.METHOD_ID, (String)"Password Hash", (byte[])byArray);
                            }
                            if (n2 == 0) break block11;
                            Integer n4 = new Integer(n2);
                            XmlInputProcessor.this.warnings.add(Warnings.getMessage(8021, n4.toString()));
                            n = 5;
                        }
                        catch (Throwable throwable) {
                            XmlInputProcessor.this.warnings.add(Warnings.getMessage(8021, throwable.toString()));
                            Object var14_15 = null;
                            if (jCContext != null) {
                                jCContext.free();
                            }
                            break block12;
                        }
                    }
                    Object var14_14 = null;
                    if (jCContext == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var14_16 = null;
                    if (jCContext != null) {
                        jCContext.free();
                    }
                    throw throwable;
                }
                jCContext.free();
            }
            PersistentLog.logEvent(36, n, string, 1L, "SAS:Login Configuration", Warnings.getMessage(8000, "SAS:Login Configuration"), null, null, 0L, n2);
        }

        void writeStreamValues() {
            int n = this.streamValues.size();
            int n2 = 0;
            while (n2 < n) {
                DSEStream dSEStream = (DSEStream)this.streamValues.get(n2);
                try {
                    dSEStream.writeValue(XmlInputProcessor.this.tempContext);
                }
                catch (JCException jCException) {
                    XmlInputProcessor.this.warnings.add(Warnings.getMessage(8010, jCException.toString(), dSEStream.attributeName));
                }
                ++n2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void processLinkBack(JCDistnameValue jCDistnameValue, String string, int n) {
            JCContext jCContext = null;
            try {
                try {
                    if (XmlInputProcessor.this.tracer.getLevel() > 0) {
                        XmlInputProcessor.this.tracer.trace(XmlInputProcessor.FIXING_LINK_FROM, (MessageSource)messageSource, this.entry.getDN() + '#' + jCDistnameValue.attributeName);
                    }
                    JCValue[] jCValueArray = new JCValue[]{new JCDistnameValue(string, n, 0L, new JCTimestamp(), this.entry.getDN())};
                    jCContext = XmlInputProcessor.this.tempContext.duplicate();
                    jCContext.nameToID(1, jCDistnameValue.getDistname());
                    if (!this.checkRights(jCContext, string, 4L)) {
                        throw new JCException("modifyEntry", -672);
                    }
                    JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
                }
                catch (JCException jCException) {
                    XmlInputProcessor.this.warnings.add(Warnings.getMessage(8011, jCException.toString(), jCDistnameValue.getDistname(), string));
                    Object var7_8 = null;
                    if (jCContext == null) return;
                    jCContext.free();
                    return;
                }
                Object var7_7 = null;
                if (jCContext == null) return;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
        }

        void processSpecialValues() throws JCException, VRDException {
            int n = this.values.size();
            int n2 = 0;
            while (n2 < n) {
                JCValue jCValue = (JCValue)this.values.get(n2);
                String string = jCValue.attributeName;
                if (jCValue.operation != 6) {
                    int n3 = 0;
                    while (n3 < VRSchema.CROSS_REFERENCE_ATTRIBUTES.length) {
                        if (string.equalsIgnoreCase(VRSchema.CROSS_REFERENCE_ATTRIBUTES[n3][0])) {
                            this.processLinkBack((JCDistnameValue)jCValue, VRSchema.CROSS_REFERENCE_ATTRIBUTES[n3][1], jCValue.operation);
                            break;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }

        boolean checkRights(JCContext jCContext, String string, long l) throws JCException {
            if (XmlInputProcessor.this.driverDN != null && XmlInputProcessor.this.driverDN.length() > 0) {
                return (jCContext.getEffectivePrivileges(XmlInputProcessor.this.driverDN, string) & l) == l;
            }
            return true;
        }

        protected JCContext getRemoteContext() throws VRDException {
            if (this.remoteContext == null) {
                try {
                    this.remoteContext = XmlInputProcessor.this.driver != null ? ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.getRemoteContext() : XmlInputProcessor.this.context.duplicate();
                }
                catch (Throwable throwable) {
                    throw new VRDException(throwable);
                }
            }
            return this.remoteContext;
        }

        protected void cleanupRemoteContext() throws VRDException {
            if (this.remoteContext != null) {
                if (XmlInputProcessor.this.driver != null) {
                    ((XmlInputProcessor)XmlInputProcessor.this).driver.registry.releaseRemoteContext();
                } else {
                    this.remoteContext.free();
                }
                this.remoteContext = null;
            }
        }
    }
}

