/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine;

import com.novell.nds.dirxml.engine.Association;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import novell.jclient.JCContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlOutputProcessor {
    private JCContext context;
    private String driverDN = "";
    protected EngineTrace tracer;
    protected static final int RETRY_MAX = 60;
    protected static final int RETRY_INTERVAL = 5;
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.XmlOutputProcessor");
    protected static final String NO_DOCUMENT_RETURNED = "xot_ndocr";
    protected static final String NO_TAG = "xot_notag";
    protected static final String PROCESSING_RETURNED_DOCUMENT = "xot_pretdoc";
    protected static final String PROCESSING_OPERATION_FOR = "xot_popfor";
    protected static final String RETRYING_OPERATION_FOR = "xot_ropfor";

    public XmlOutputProcessor(JCContext jCContext, EngineTrace engineTrace) {
        this.context = jCContext;
        this.tracer = engineTrace;
    }

    protected void shutdown() {
        if (this.context != null) {
            this.context.free();
        }
    }

    public void setDriverDN(String string) {
        this.driverDN = string;
    }

    public String getDriverDN() {
        return this.driverDN;
    }

    public void process(Document document) throws VRDException {
        if (document == null) {
            this.tracer.trace(NO_DOCUMENT_RETURNED, (MessageSource)messageSource);
            return;
        }
        Element element = XdsUtil.getFirstElementByTagNameNS(document, null, "output");
        if (element == null) {
            this.tracer.trace(NO_TAG, (MessageSource)messageSource, "output");
            return;
        }
        this.tracer.trace(PROCESSING_RETURNED_DOCUMENT, (MessageSource)messageSource);
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                try {
                    this.processOperationElement((Element)node);
                }
                catch (VRDException vRDException) {
                    if (!vRDException.isRetry() && !vRDException.isFatal()) {
                        StatusLog.log(vRDException);
                    }
                    throw vRDException;
                }
            }
            node = node.getNextSibling();
        }
    }

    protected void processOperationElement(Element element) throws VRDException {
        String string = element.getNodeName();
        String string2 = element.getAttributeNS(null, "dest-dn");
        String string3 = element.getAttributeNS(null, "class-name");
        this.tracer.trace(PROCESSING_OPERATION_FOR, (MessageSource)messageSource, string, (Object)string2);
        int n = 0;
        while (true) {
            try {
                if (string.equals("add-association")) {
                    Entry entry = XdsUtil.getDestEntry(element);
                    if (entry == null) {
                        throw new VRDException(9040, element.getNodeName(), (Object)"dest-dn");
                    }
                    Association.addAssociation(this.context, this.driverDN, entry, XdsUtil.getChildText(element), 1);
                    break;
                }
                if (string.equals("modify-association")) {
                    Element[] elementArray = XdsUtil.getChildElementsByTagNameNS(element, null, "association");
                    if (elementArray.length != 2) {
                        throw new VRDException(9044, string);
                    }
                    Association.modifyAssociation(this.context, this.driverDN, XdsUtil.getChildText(elementArray[0]), XdsUtil.getChildText(elementArray[1]), 1);
                    break;
                }
                if (string.equals("remove-association")) {
                    Association.modifyAssociation(this.context, this.driverDN, XdsUtil.getChildText(element), null, 0);
                    break;
                }
                if (!string.equals("status")) break;
                StatusLog.log(element);
            }
            catch (VRDException vRDException) {
                block11: {
                    if (n < 60 && vRDException.isRetry()) {
                        try {
                            StatusLog.log(vRDException);
                            Thread.sleep(5000L);
                            this.tracer.trace(RETRYING_OPERATION_FOR, (MessageSource)messageSource, string, (Object)string2);
                            break block11;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    throw vRDException;
                }
                ++n;
                continue;
            }
            break;
        }
    }
}

