/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.act;

import com.novell.act.ActCredentialHandle;
import com.novell.nds.dirxml.engine.act.DirXMLAct;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.dom.DocumentFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class Credential {
    private static final String TAG_ACTIVATION_INFO = "activation-info";
    private static final String TAG_TAG = "tag";
    private static final String TAG_NAME = "name";
    private static final String TAG_VALUE = "value";
    private static final String UTF_8 = "UTF-8";
    private List components = new LinkedList();
    private byte[] credential;
    private ActCredentialHandle credentialHandle;
    private byte[] domain;
    private int units;
    private boolean valid;
    private Document clientData;
    private String companyName = "";
    private boolean limitedEngine = false;

    Credential(byte[] byArray) {
        this.credential = byArray;
    }

    boolean checkForProduct(String string, int n) {
        if (this.valid) {
            Iterator iterator = this.components.iterator();
            while (iterator.hasNext()) {
                Component component = (Component)iterator.next();
                if (!component.getProductString().equals(string) || n > component.getVersion()) continue;
                return true;
            }
        }
        return false;
    }

    byte[] getCredential() {
        return this.credential;
    }

    ActCredentialHandle getCredentialHandle() {
        return this.credentialHandle;
    }

    void setCredentialHandle(ActCredentialHandle actCredentialHandle) {
        this.credentialHandle = actCredentialHandle;
    }

    byte[] getDomain() {
        return this.domain;
    }

    void setDomain(byte[] byArray) {
        this.domain = byArray;
    }

    int getUnits() {
        return this.units;
    }

    void setUnits(int n) {
        this.units = n;
    }

    String getCompanyName() {
        return this.companyName;
    }

    void setCompanyName(String string) {
        this.companyName = string;
    }

    boolean isValid() {
        return this.valid;
    }

    void setValid(boolean bl) {
        this.valid = bl;
    }

    boolean isLimitedEngine() {
        return this.limitedEngine;
    }

    void setLimitedEngine(boolean bl) {
        this.limitedEngine = bl;
    }

    void initClientData() {
        this.clientData = DocumentFactory.newDocument();
        this.clientData.appendChild(this.clientData.createElementNS(null, TAG_ACTIVATION_INFO));
    }

    void addClientData(String string, String string2) {
        if (this.clientData == null) {
            return;
        }
        Element element = this.clientData.getDocumentElement();
        Element element2 = this.clientData.createElementNS(null, TAG_TAG);
        element.appendChild(element2);
        Element element3 = this.clientData.createElementNS(null, TAG_NAME);
        element2.appendChild(element3);
        element3.appendChild(this.clientData.createTextNode(string));
        Element element4 = this.clientData.createElementNS(null, TAG_VALUE);
        element2.appendChild(element4);
        element4.appendChild(this.clientData.createTextNode(string2));
    }

    boolean hasClientData() {
        return this.clientData != null;
    }

    byte[] getClientDataBytes() {
        if (this.clientData == null) {
            return null;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DOMWriter dOMWriter = new DOMWriter((Node)this.clientData, (OutputStream)byteArrayOutputStream, UTF_8);
            dOMWriter.setWriteDeclaration(true);
            dOMWriter.setEncoding(UTF_8);
            dOMWriter.setIndent(true);
            dOMWriter.write();
            dOMWriter.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    void destroyClientData() {
        this.clientData = null;
    }

    void addComponent(String string) {
        this.components.add(new Component(string));
    }

    private static class Component {
        private String tagValue;
        private String productString = null;
        private int version = 0;

        Component(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            this.version = 0;
            int n = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                switch (n) {
                    case 0: {
                        try {
                            this.version = Integer.parseInt(string2);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.version = 0;
                        }
                        break;
                    }
                    case 1: {
                        this.productString = string2;
                        break;
                    }
                    case 5: {
                        if (string2.length() == 0 || string2.equals(DirXMLAct.platformString)) break;
                        this.productString = "";
                        break;
                    }
                }
                ++n;
            }
            if (this.productString == null) {
                this.productString = "";
            }
        }

        String getTagValue() {
            return this.tagValue;
        }

        String getProductString() {
            return this.productString;
        }

        int getVersion() {
            return this.version;
        }
    }
}

