/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.cache;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.cache.CacheInputStream;
import com.novell.nds.dirxml.engine.cache.CheckAbort;
import com.novell.nds.dirxml.engine.cache.CorruptCacheException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.cache.Transaction;
import com.novell.nds.dirxml.engine.event.DSEEventInfo;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;

public class DriverCache {
    private long entryID;
    private CacheInputStream is;
    private Transaction lastTransaction = null;
    private CheckAbort checkAbort = null;
    private EngineTrace tracer;
    private boolean autoAbort = true;
    private static Map cacheLocks = new TreeMap();

    public DriverCache(long l, EngineTrace engineTrace) {
        this.entryID = l;
        this.is = new CacheInputStream(l);
        this.tracer = engineTrace;
    }

    public void setCheckAbort(CheckAbort checkAbort) {
        this.checkAbort = checkAbort;
        this.is.setCheckAbort(checkAbort);
    }

    public void setAutoAbort(boolean bl) {
        this.autoAbort = bl;
    }

    public void setStartPosition(long l) throws IOException, CorruptCacheException {
        if (l != 0L) {
            this.is.skip(l);
            if (this.is.available() == 0) {
                return;
            }
            try {
                if (!DSEEventInfo.isValidEventStart(new DxEventInputStream(this.is))) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                throw new CorruptCacheException("Position in cache is invalid");
            }
        }
    }

    public Transaction getTransaction() {
        if (this.autoAbort && this.lastTransaction != null && !this.lastTransaction.isCommitted() && !this.lastTransaction.isAborted()) {
            try {
                this.lastTransaction.abort();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.lastTransaction = new Transaction(this.entryID, this.is, this.tracer);
        this.lastTransaction.setCheckAbort(this.checkAbort);
        return this.lastTransaction;
    }

    public void writeBytes(byte[] byArray, long l) throws DSErr {
        DriverCache.writeCacheBlock(this.entryID, byArray, l);
    }

    private static native void writeCacheBlock(long var0, byte[] var2, long var3) throws DSErr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean lock(long l) {
        Long l2 = new Long(l);
        Map map = cacheLocks;
        synchronized (map) {
            block4: {
                Thread thread = (Thread)cacheLocks.get(l2);
                if (thread == null) break block4;
                boolean bl = thread == Thread.currentThread();
                return bl;
            }
            cacheLocks.put(l2, Thread.currentThread());
            boolean bl = true;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unlock(long l) {
        Long l2 = new Long(l);
        Map map = cacheLocks;
        synchronized (map) {
            cacheLocks.remove(l2);
        }
    }
}

