/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.cache;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DxEventInputStream
extends InputStream {
    public static final byte STRING_ENCODING_MASK = 1;
    public static final byte STRING_ENCODING_UTF8 = 0;
    public static final byte STRING_ENCODING_UTF16 = 1;
    protected InputStream is;
    protected int dataSize;
    protected int markPos = -1;

    public DxEventInputStream(InputStream inputStream) throws IOException {
        this.is = inputStream;
        inputStream.mark(Integer.MAX_VALUE);
        this.dataSize = 4;
        try {
            this.dataSize = this.read_uint32();
            this.dataSize += 4;
            inputStream.reset();
        }
        catch (IOException iOException) {
            inputStream.reset();
            throw iOException;
        }
    }

    protected int readOne() throws IOException {
        int n = this.read();
        if (n == -1) {
            throw new EOFException();
        }
        return n;
    }

    public byte read_uint8() throws IOException {
        return (byte)this.readOne();
    }

    public char read_uint16() throws IOException {
        return (char)(this.readOne() << 8 | this.readOne());
    }

    public int read_uint32() throws IOException {
        return this.readOne() << 24 | this.readOne() << 16 | this.readOne() << 8 | this.readOne();
    }

    public long readEntryID() throws IOException {
        return (long)this.read_uint32() & 0xFFFFFFFFFFFFFFFFL;
    }

    public long readSchemaID() throws IOException {
        return (long)this.read_uint32() & 0xFFFFFFFFFFFFFFFFL;
    }

    public int readUTF8Length() throws IOException {
        int n = this.readOne();
        if ((n & 0x80) != 0) {
            if ((n & 0xE0) == 192) {
                n = (n & 0x1F) << 6;
                n |= this.readOne() & 0x3F;
            } else if ((n & 0xF0) == 224) {
                n = (n & 0xF) << 12;
                n |= (this.readOne() & 0x3F) << 6;
                n |= this.readOne() & 0x3F;
            } else if ((n & 0xF8) == 240) {
                n = (n & 7) << 18;
                n |= (this.readOne() & 0x3F) << 12;
                n |= (this.readOne() & 0x3F) << 6;
                n |= this.readOne() & 0x3F;
            } else if ((n & 0xFC) == 248) {
                n = (n & 3) << 24;
                n |= (this.readOne() & 0x3F) << 18;
                n |= (this.readOne() & 0x3F) << 12;
                n |= (this.readOne() & 0x3F) << 6;
                n |= this.readOne() & 0x3F;
            } else {
                n = (n & 1) << 30;
                n |= (this.readOne() & 0x3F) << 24;
                n |= (this.readOne() & 0x3F) << 18;
                n |= (this.readOne() & 0x3F) << 12;
                n |= (this.readOne() & 0x3F) << 6;
                n |= this.readOne() & 0x3F;
            }
        }
        return n;
    }

    public String readString() throws IOException {
        byte by = this.read_uint8();
        boolean bl = (by & 1) == 1;
        int n = this.readUTF8Length();
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(n /= 2);
            while (n-- > 0) {
                stringBuffer.append(this.read_uint16());
            }
            return stringBuffer.toString();
        }
        byte[] byArray = new byte[n];
        this.readAll(byArray);
        return new String(byArray, "UTF-8");
    }

    public byte[] readOctets() throws IOException {
        int n = this.readUTF8Length();
        byte[] byArray = new byte[n];
        this.readAll(byArray);
        return byArray;
    }

    public String readTimestamp() throws IOException {
        int n = this.read_uint32();
        int n2 = this.read_uint16() & 0xFFFF;
        return Integer.toString(n) + '#' + Integer.toString(n2);
    }

    public void readAll(byte[] byArray) throws IOException {
        int n;
        int n2 = byArray.length;
        int n3 = 0;
        do {
            n = this.read(byArray, n3, n2);
            n3 += n;
        } while (n != 0 && (n2 -= n) > 0);
        if (n2 > 0) {
            throw new EOFException();
        }
    }

    public int read() throws IOException {
        if (this.dataSize > 0) {
            --this.dataSize;
            return this.is.read();
        }
        return -1;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.is.read(byArray, n, n2 <= this.dataSize ? n2 : this.dataSize);
        this.dataSize -= n3;
        return n3;
    }

    public long skip(long l) throws IOException {
        int n = (int)this.is.skip(l <= (long)this.dataSize ? l : (long)this.dataSize);
        this.dataSize -= n;
        return n;
    }

    public int available() throws IOException {
        int n = this.is.available();
        return n <= this.dataSize ? n : this.dataSize;
    }

    public void close() throws IOException {
        this.dataSize = 0;
        this.is.close();
    }

    public void mark(int n) {
        this.markPos = this.dataSize;
        this.is.mark(n <= this.dataSize ? n : this.dataSize);
    }

    public void reset() throws IOException {
        if (this.markPos != -1) {
            this.dataSize = this.markPos;
            this.markPos = -1;
            this.is.reset();
        }
    }

    public boolean markSupported() {
        return this.is.markSupported();
    }
}

