/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.cache;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dirxml.engine.DriverEntry;
import com.novell.nds.dirxml.engine.DriverList;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.cache.AbortedIOException;
import com.novell.nds.dirxml.engine.cache.CacheInputStream;
import com.novell.nds.dirxml.engine.cache.CheckAbort;
import com.novell.nds.dirxml.engine.cache.CorruptCacheException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSECaseIgnoreString;
import com.novell.nds.dirxml.engine.event.DSEEventInfo;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Transaction {
    protected static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.cache.Transaction");
    protected static final String STARTING_CACHE_RECOVERY = "tt_scchr";
    protected static final String CACHE_RECOVERY_PROCEEDING = "tt_cchrp";
    protected static final String VALID_EVENT_FOUND = "tt_cchrv";
    protected static final String END_OF_CACHE_DATA = "tt_cchrd";
    protected static final String CACHE_RECOVERY_COMPLETED = "tt_cchrc";
    protected static final String INITIATING_RESYNC = "tt_cchir";
    private static final String PUBLIC_KEY_NAME = "Public Key";
    private static final String RESYNC_EVENT_ID_PREAMBLE = "CacheCorruptionRecovery_";
    protected static final char[] QSLASH_DELIMS = "10.\\+=*'".toCharArray();
    private static final long RECOVERY_MESSAGE_INTERVAL = 5000L;
    private long entryID;
    private CacheInputStream is;
    private boolean endTransactionReached = false;
    private boolean moreData = false;
    private boolean committed = false;
    private CheckAbort checkAbort;
    private EngineTrace tracer;
    private List events = new LinkedList();
    private long startPos = -1L;
    private long endPos = -1L;

    Transaction(long l, CacheInputStream cacheInputStream, EngineTrace engineTrace) {
        this.entryID = l;
        this.is = cacheInputStream;
        this.tracer = engineTrace;
        cacheInputStream.setTracer(engineTrace);
        this.startPos = this.endPos = cacheInputStream.position();
    }

    public Transaction(long l, List list) {
        this.entryID = l;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.events.add((DSEEventInfo)iterator.next());
        }
        if (!this.events.isEmpty()) {
            this.endTransactionReached = this.isEndTransaction((DSEEventInfo)this.events.get(this.events.size() - 1));
        }
    }

    public Iterator iterator() {
        return this.events.iterator();
    }

    public DSEEventInfo getEndTransaction() {
        if (!this.endTransactionReached) {
            return null;
        }
        return this.events.isEmpty() ? null : (DSEEventInfo)this.events.get(this.events.size() - 1);
    }

    public boolean isEmpty() {
        return this.events.isEmpty();
    }

    public void setCheckAbort(CheckAbort checkAbort) {
        this.checkAbort = checkAbort;
        this.is.setCheckAbort(checkAbort);
    }

    public boolean getEvent() throws IOException {
        try {
            DSEEventInfo dSEEventInfo;
            if (this.endTransactionReached) {
                return false;
            }
            try {
                do {
                    DxEventInputStream dxEventInputStream;
                    if ((dSEEventInfo = DSEEventInfo.construct(dxEventInputStream = new DxEventInputStream(this.is))) == null || dSEEventInfo.getType() != 0 || this.events.size() != 0) continue;
                    this.startPos = this.endPos = this.is.position();
                } while (dSEEventInfo != null && dSEEventInfo.getType() == 0);
            }
            catch (CorruptCacheException corruptCacheException) {
                StatusLog.logError(9113, corruptCacheException);
                this.events.clear();
                this.recoverCacheCorruption(this.is);
                this.is.commit();
                this.endTransactionReached = true;
                return true;
            }
            this.endTransactionReached = this.isEndTransaction(dSEEventInfo);
            if (this.endTransactionReached) {
                this.endPos = this.is.position();
            }
            this.events.add(dSEEventInfo);
            return true;
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    public boolean isDataAvailable() {
        if (this.is == null) {
            return this.moreData;
        }
        try {
            return this.is.isDataAvailable();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public long getStartPosition() {
        return this.startPos;
    }

    public long getEndPosition() {
        return this.endPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws IOException {
        if (this.is == null) {
            return;
        }
        try {
            this.moreData = this.is.isDataAvailable();
            this.is.commit();
            this.committed = true;
            Object var2_1 = null;
            this.is = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.is = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() throws IOException {
        if (this.is == null) {
            return;
        }
        this.moreData = true;
        try {
            this.is.abort();
            Object var2_1 = null;
            this.is = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.is = null;
            throw throwable;
        }
    }

    public void optimize() {
        Object object;
        Object object2;
        DSEEventInfo dSEEventInfo;
        int n;
        if (!this.isEndTransaction()) {
            return;
        }
        DSEEventInfo dSEEventInfo2 = this.getEndTransaction();
        int n2 = n = dSEEventInfo2 == null ? -1 : dSEEventInfo2.getType();
        if (n != 3 && n != 4 && n != 7) {
            return;
        }
        HashMap hashMap = new HashMap();
        Iterator<Object> iterator = this.events.iterator();
        long l = 0L;
        while (iterator.hasNext()) {
            dSEEventInfo = (DSEEventInfo)iterator.next();
            long l2 = dSEEventInfo.getTimestamp();
            if (dSEEventInfo.getType() == 1 && l < l2) {
                l = l2;
            }
            if ((object2 = dSEEventInfo.getAttrValue()) == null) continue;
            if (hashMap.containsKey(object2.getAttrName())) {
                boolean bl = false;
                object = (List)hashMap.get(object2.getAttrName());
                if (object2.getSyntax() != 21 && object2.getSyntax() != 22 && object2.getSyntax() != 26 && !object2.getAttrName().equals(PUBLIC_KEY_NAME)) {
                    ListIterator listIterator = object.listIterator();
                    while (!bl && listIterator.hasNext()) {
                        DSEEventInfo dSEEventInfo3 = (DSEEventInfo)listIterator.next();
                        if (!dSEEventInfo3.getAttrValue().equals(dSEEventInfo.getAttrValue())) continue;
                        if (dSEEventInfo3.getType() == dSEEventInfo.getType()) {
                            listIterator.remove();
                            object.add(dSEEventInfo);
                        } else {
                            listIterator.remove();
                        }
                        bl = true;
                        if (!object.isEmpty()) continue;
                        hashMap.remove(object2.getAttrName());
                    }
                }
                if (bl) continue;
                object.add(dSEEventInfo);
                continue;
            }
            object = new LinkedList<DSEEventInfo>();
            object.add(dSEEventInfo);
            hashMap.put(object2.getAttrName(), object);
        }
        iterator = hashMap.values().iterator();
        if (iterator.hasNext()) {
            Object object3;
            this.events.clear();
            dSEEventInfo = null;
            XdsDN xdsDN = null;
            if (n == 7) {
                object3 = dSEEventInfo2.getObjectID().getDN();
                if (object3 != null) {
                    xdsDN = new XdsDN((String)object3, QSLASH_DELIMS);
                }
                dSEEventInfo = new XdsDN(dSEEventInfo2.getOldDN(), QSLASH_DELIMS);
            }
            while (iterator.hasNext()) {
                object3 = (List)iterator.next();
                object2 = object3.listIterator();
                while (object2.hasNext()) {
                    object = (DSEEventInfo)object2.next();
                    if (n == 7 && (Transaction.checkRenameAttr(((DSEEventInfo)object).getAttrValue(), (XdsDN)dSEEventInfo) || Transaction.checkRenameAttr(((DSEEventInfo)object).getAttrValue(), xdsDN))) continue;
                    this.events.add(object);
                }
            }
            this.events.add(dSEEventInfo2);
            long l3 = dSEEventInfo2.getTimestamp();
            if (l3 < l) {
                dSEEventInfo2.setTimestamp(l);
            }
        } else {
            this.events.clear();
            if (n != 4) {
                this.events.add(dSEEventInfo2);
                long l4 = dSEEventInfo2.getTimestamp();
                if (l4 < l) {
                    dSEEventInfo2.setTimestamp(l);
                }
            }
        }
    }

    private static boolean checkRenameAttr(DSEAttributeValue dSEAttributeValue, XdsDN xdsDN) {
        if (xdsDN == null || dSEAttributeValue == null || !(dSEAttributeValue instanceof DSECaseIgnoreString)) {
            return false;
        }
        int n = xdsDN.getComponentCount() - 1;
        if (n < 0) {
            return false;
        }
        XdsDN.DNComponent dNComponent = xdsDN.getComponent(n);
        while (dNComponent != null) {
            if (dNComponent.getType().equalsIgnoreCase(dSEAttributeValue.getAttrName()) && dNComponent.getValue().equalsIgnoreCase(((DSECaseIgnoreString)dSEAttributeValue).getString())) {
                return true;
            }
            dNComponent = dNComponent.getNext();
        }
        return false;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isAborted() {
        return !this.committed && this.is == null;
    }

    public boolean isEndTransaction() {
        return this.endTransactionReached;
    }

    private boolean isEndTransaction(DSEEventInfo dSEEventInfo) {
        switch (dSEEventInfo.getType()) {
            case 1: 
            case 2: {
                return false;
            }
        }
        return true;
    }

    private boolean checkAbort() {
        return this.checkAbort == null ? false : this.checkAbort.abort();
    }

    private String buildMsg(String string) {
        String string2 = MiscDS.getEntryRDN(this.entryID);
        StringBuffer stringBuffer = new StringBuffer(string.length() + string2.length() + 16);
        stringBuffer.append('<');
        stringBuffer.append(string2);
        stringBuffer.append("> ");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverCacheCorruption(InputStream inputStream) throws IOException {
        long l;
        long l2 = l = new Date().getTime();
        byte[] byArray = new byte[DSEEventInfo.MAGIC_MARKER.length];
        if (this.tracer != null && this.tracer.getLevel() > 0) {
            this.tracer.pushColor(14);
            this.tracer.trace(STARTING_CACHE_RECOVERY, (MessageSource)messageSource);
            this.tracer.pushIndent(1);
        }
        try {
            try {
                inputStream.mark(Integer.MAX_VALUE);
                inputStream.skip(4L);
                while (true) {
                    int n;
                    long l3 = new Date().getTime();
                    if (this.checkAbort()) {
                        throw new AbortedIOException(this.buildMsg("aborted cache recovery. Elapsed time " + this.getElapsedTime(l3, l) + " seconds."));
                    }
                    if (l3 - l2 >= 5000L) {
                        if (this.tracer != null && this.tracer.getLevel() > 0) {
                            this.tracer.trace(CACHE_RECOVERY_PROCEEDING, (MessageSource)messageSource, new Integer(this.getElapsedTime(l3, l)));
                        }
                        l2 = l3;
                    }
                    int n2 = byArray.length;
                    int n3 = 0;
                    do {
                        n = inputStream.read(byArray, n3, n2);
                        n3 += n;
                    } while ((n2 -= n) > 0 && n > 0);
                    if (n2 > 0) {
                        throw new EOFException();
                    }
                    if (Arrays.equals(DSEEventInfo.MAGIC_MARKER, byArray)) {
                        inputStream.reset();
                        try {
                            DxEventInputStream dxEventInputStream = new DxEventInputStream(inputStream);
                            DSEEventInfo.validate(dxEventInputStream);
                            if (this.tracer != null && this.tracer.getLevel() > 0) {
                                this.tracer.trace(VALID_EVENT_FOUND, (MessageSource)messageSource);
                            }
                            Object var14_12 = null;
                            if (this.tracer != null && this.tracer.getLevel() > 0) {
                                long l4 = new Date().getTime();
                                this.tracer.trace(CACHE_RECOVERY_COMPLETED, (MessageSource)messageSource, new Integer(this.getElapsedTime(l4, l)));
                                this.tracer.popIndent();
                                this.tracer.popColor();
                            }
                            return;
                        }
                        catch (CorruptCacheException corruptCacheException) {
                            this.resyncEntry(inputStream);
                        }
                    } else {
                        inputStream.reset();
                    }
                    inputStream.skip(1L);
                    inputStream.mark(Integer.MAX_VALUE);
                    inputStream.skip(4L);
                }
            }
            catch (EOFException eOFException) {
                if (this.tracer != null && this.tracer.getLevel() > 0) {
                    this.tracer.trace(END_OF_CACHE_DATA, (MessageSource)messageSource);
                }
                inputStream.mark(Integer.MAX_VALUE);
                inputStream.reset();
                Object var14_13 = null;
                if (this.tracer != null && this.tracer.getLevel() > 0) {
                    long l5 = new Date().getTime();
                    this.tracer.trace(CACHE_RECOVERY_COMPLETED, (MessageSource)messageSource, new Integer(this.getElapsedTime(l5, l)));
                    this.tracer.popIndent();
                    this.tracer.popColor();
                }
            }
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (this.tracer != null && this.tracer.getLevel() > 0) {
                long l6 = new Date().getTime();
                this.tracer.trace(CACHE_RECOVERY_COMPLETED, (MessageSource)messageSource, new Integer(this.getElapsedTime(l6, l)));
                this.tracer.popIndent();
                this.tracer.popColor();
            }
            throw throwable;
        }
    }

    private int getElapsedTime(long l, long l2) {
        return (int)((l - l2) / 1000L);
    }

    private void resyncEntry(InputStream inputStream) {
        try {
            inputStream.mark(Integer.MAX_VALUE);
            inputStream.skip(4 + DSEEventInfo.MAGIC_MARKER.length);
            int n = inputStream.read();
            if (n < 0 || n > 10) {
                throw new Exception();
            }
            switch (n) {
                case 3: 
                case 4: 
                case 6: 
                case 7: {
                    break;
                }
                default: {
                    throw new Exception();
                }
            }
            inputStream.skip(7L);
            long l = 0L;
            int n2 = 0;
            while (n2 < 4) {
                int n3 = this.is.read();
                if (n3 == -1) {
                    throw new EOFException();
                }
                l |= (long)(n3 << (3 - n2) * 8);
                ++n2;
            }
            if (l != 0L && l != -1L) {
                String string = DDSServ.getLocalEntryName((long)l, (int)0);
                if (this.tracer != null && this.tracer.getLevel() > 0) {
                    this.tracer.trace(INITIATING_RESYNC, (MessageSource)messageSource, string);
                }
                Date date = new Date();
                String string2 = RESYNC_EVENT_ID_PREAMBLE + date.getTime() / 1000L + '#' + date.getTime() % 1000L;
                DSEEventInfo dSEEventInfo = DSEEventInfo.constructResyncEntry(l, string2);
                DriverEntry driverEntry = DriverList.findEntry(this.entryID);
                if (driverEntry != null) {
                    driverEntry.queueEvent(dSEEventInfo);
                }
            }
            inputStream.reset();
        }
        catch (Throwable throwable) {
            try {
                inputStream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

