/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.command;

import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.command.CmdDriverGetSchema;
import com.novell.nds.dirxml.engine.command.CmdDriverStart;
import com.novell.nds.dirxml.engine.command.CmdDriverStop;
import com.novell.nds.dirxml.engine.command.CommandHandler;
import com.novell.nds.dirxml.engine.command.CommandProcessor;
import com.novell.nds.events.EventNotification;
import com.novell.nds.events.ValueEventHandler;
import com.novell.nds.events.values.DSEValueInfo;
import com.novell.nds.events.values.DSEValueOctetString;
import com.novell.nds.events.values.DSEValueTimeStamp;
import java.util.ArrayList;
import java.util.Date;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import novell.jclient.JCOctetstringValue;
import novell.jclient.JCReadFilter;
import novell.jclient.JCTimestamp;
import novell.jclient.JCValue;
import novell.jclient.JClient;

public abstract class DirXMLCommands {
    private static final long MAX_RESPONSE_AGE = 86400000L;
    private static int initCount = 0;
    private static JCContext context = null;
    private static long driverSetID = -1L;
    private static CommandProcessor processor = null;
    private static CommandEventHandler eventHandler = null;

    public static void initialize() throws Throwable {
        if (++initCount != 1) {
            return;
        }
        try {
            context = MiscDS.createLocalContext();
            driverSetID = MiscDS.getDriverSetID(context);
            processor = new CommandProcessor();
            DirXMLCommands.addHandler(new CmdDriverStart());
            DirXMLCommands.addHandler(new CmdDriverStop());
            DirXMLCommands.addHandler(new CmdDriverGetSchema());
            eventHandler = new CommandEventHandler();
            EventNotification.registerForValueEvent((int)2, (int)5, (int)0, (ValueEventHandler)eventHandler, (String)"DirXML-DriverSet", (String)"DirXML-Command");
        }
        catch (Throwable throwable) {
            processor = null;
            eventHandler = null;
            if (context != null) {
                context.free();
                context = null;
            }
            StatusLog.logError(9115, throwable);
            --initCount;
            throw throwable;
        }
    }

    public static void addHandler(CommandHandler commandHandler) {
        if (initCount <= 0 || processor == null) {
            throw new RuntimeException("DirXMLCommands not initialized");
        }
        processor.addHandler(commandHandler);
    }

    public static void removeHandler(CommandHandler commandHandler) {
        if (initCount <= 0 || processor == null) {
            throw new RuntimeException("DirXMLCommands not initialized");
        }
        processor.removeHandler(commandHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        if (--initCount != 0) {
            if (initCount < 0) {
                initCount = 0;
            }
            return;
        }
        try {
            EventNotification.unregisterForValueEvent((int)2, (int)5, (ValueEventHandler)eventHandler, (String)"DirXML-DriverSet", (String)"DirXML-Command");
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (context != null) {
                context.free();
                context = null;
            }
            processor = null;
            eventHandler = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void processCommands() {
        JCContext jCContext;
        block12: {
            block11: {
                if (initCount <= 0) {
                    return;
                }
                DirXMLCommands.removeOldResponses();
                jCContext = null;
                try {
                    try {
                        JCValue[] jCValueArray;
                        block14: {
                            block13: {
                                block10: {
                                    jCContext = context.duplicate();
                                    jCContext.setEntryID(driverSetID);
                                    JCReadFilter jCReadFilter = new JCReadFilter();
                                    jCReadFilter.attributeNames = new String[]{"DirXML-Command"};
                                    jCValueArray = null;
                                    try {
                                        jCValueArray = JClient.readEntry((JCContext)jCContext, (long)1L, (JCReadFilter)jCReadFilter);
                                    }
                                    catch (JCException jCException) {
                                        if (jCException.getErrorCode() == -603) break block10;
                                        throw jCException;
                                    }
                                }
                                if (jCValueArray == null) break block13;
                                if (jCValueArray.length != 0) break block14;
                            }
                            Object var7_6 = null;
                            if (jCContext == null) return;
                            break block11;
                        }
                        int n = 0;
                        while (n < jCValueArray.length) {
                            JCOctetstringValue jCOctetstringValue = (JCOctetstringValue)jCValueArray[n];
                            JCTimestamp jCTimestamp = jCOctetstringValue.timestamp;
                            DirXMLCommands.processCommandDocument(jCContext, new DSEValueTimeStamp(jCTimestamp.seconds, jCTimestamp.replicaNumber, jCTimestamp.event), jCOctetstringValue.getOctets());
                            ++n;
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        StatusLog.logError(9116, throwable);
                        Object var7_8 = null;
                        if (jCContext == null) return;
                        jCContext.free();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (jCContext == null) throw throwable;
                    jCContext.free();
                    throw throwable;
                }
            }
            jCContext.free();
            return;
        }
        Object var7_7 = null;
        if (jCContext == null) return;
        jCContext.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void removeOldResponses() {
        JCContext jCContext;
        block17: {
            block16: {
                block15: {
                    jCContext = null;
                    try {
                        try {
                            JCValue[] jCValueArray;
                            block19: {
                                block18: {
                                    block14: {
                                        jCContext = context.duplicate();
                                        jCContext.setEntryID(driverSetID);
                                        JCReadFilter jCReadFilter = new JCReadFilter();
                                        jCReadFilter.attributeNames = new String[]{"DirXML-Response"};
                                        jCValueArray = null;
                                        try {
                                            jCValueArray = JClient.readEntry((JCContext)jCContext, (long)3L, (JCReadFilter)jCReadFilter);
                                        }
                                        catch (JCException jCException) {
                                            if (jCException.getErrorCode() == -603) break block14;
                                            throw jCException;
                                        }
                                    }
                                    if (jCValueArray == null) break block18;
                                    if (jCValueArray.length != 0) break block19;
                                }
                                Object var8_6 = null;
                                if (jCContext == null) return;
                                break block15;
                            }
                            Date date = new Date(new Date().getTime() - 86400000L);
                            ArrayList<JCOctetstringValue> arrayList = new ArrayList<JCOctetstringValue>(jCValueArray.length);
                            int n = 0;
                            while (true) {
                                if (n >= jCValueArray.length) {
                                    if (!arrayList.isEmpty()) break;
                                    break block16;
                                }
                                JCOctetstringValue jCOctetstringValue = (JCOctetstringValue)jCValueArray[n];
                                if (jCOctetstringValue.timestamp.seconds.compareTo(date) <= 0) {
                                    arrayList.add(jCOctetstringValue);
                                }
                                ++n;
                            }
                            jCValueArray = new JCValue[arrayList.size()];
                            n = 0;
                            while (true) {
                                if (n >= jCValueArray.length) {
                                    JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
                                    break block17;
                                }
                                jCValueArray[n] = (JCOctetstringValue)arrayList.get(n);
                                jCValueArray[n].operation = 3;
                                ++n;
                            }
                        }
                        catch (Throwable throwable) {
                            StatusLog.logError(9117, throwable);
                            Object var8_9 = null;
                            if (jCContext == null) return;
                            jCContext.free();
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        if (jCContext == null) throw throwable;
                        jCContext.free();
                        throw throwable;
                    }
                }
                jCContext.free();
                return;
            }
            Object var8_7 = null;
            if (jCContext == null) return;
            jCContext.free();
            return;
        }
        Object var8_8 = null;
        if (jCContext == null) return;
        jCContext.free();
    }

    private static void processCommandDocument(JCContext jCContext, DSEValueTimeStamp dSEValueTimeStamp, byte[] byArray) {
        try {
            byte[] byArray2 = processor.processCommand(byArray, dSEValueTimeStamp);
            JCOctetstringValue jCOctetstringValue = new JCOctetstringValue();
            jCOctetstringValue.attributeName = "DirXML-Response";
            jCOctetstringValue.operation = 2;
            jCOctetstringValue.setOctets(byArray2);
            JCValue[] jCValueArray = new JCValue[]{jCOctetstringValue};
            try {
                JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
            }
            catch (JCException jCException) {
                StatusLog.logError(9118, jCException);
            }
            jCOctetstringValue = new JCOctetstringValue();
            jCOctetstringValue.attributeName = "DirXML-Command";
            jCOctetstringValue.operation = 3;
            jCOctetstringValue.setOctets(byArray);
            jCValueArray[0] = jCOctetstringValue;
            try {
                JClient.modifyEntry((JCContext)jCContext, (JCValue[])jCValueArray);
            }
            catch (JCException jCException) {
                StatusLog.logError(9119, jCException);
            }
        }
        catch (Throwable throwable) {
            StatusLog.logError(9120, throwable);
        }
    }

    private static class CommandEventHandler
    implements ValueEventHandler {
        CommandEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int handleEvent(int n, DSEValueInfo dSEValueInfo, int n2) {
            if (dSEValueInfo.getEntryID() != driverSetID) {
                return 0;
            }
            if (dSEValueInfo.getSyntax() != 9) {
                return 0;
            }
            DirXMLCommands.removeOldResponses();
            JCContext jCContext = null;
            try {
                try {
                    jCContext = context.duplicate();
                    jCContext.setEntryID(dSEValueInfo.getEntryID());
                    DirXMLCommands.processCommandDocument(jCContext, dSEValueInfo.getTimeStamp(), ((DSEValueOctetString)dSEValueInfo.getValue()).getBytes());
                }
                catch (Throwable throwable) {
                    StatusLog.logError(9120, throwable);
                    Object var7_6 = null;
                    if (jCContext == null) return 0;
                    jCContext.free();
                    return 0;
                }
                Object var7_5 = null;
                if (jCContext == null) return 0;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
            jCContext.free();
            return 0;
        }
    }
}

