/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.controls;

import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.controls.ControlValue;
import com.novell.nds.dirxml.engine.controls.DNValueForm;
import com.novell.nds.dirxml.engine.controls.ReplicationWait;
import com.novell.nds.dirxml.engine.controls.RetryInterval;
import com.novell.nds.dirxml.engine.controls.XSLTBrokenMode;
import com.novell.nds.dirxml.engine.gcv.EngineControls;
import com.novell.nds.dirxml.engine.gcv.GCVException;
import com.novell.nds.dirxml.engine.gcv.GCValue;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.io.JCIOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import org.w3c.dom.Document;

public class ControlValues {
    private static LocalizedMessageSource defaultMessageSource;
    private static LocalizedMessageSource messageSource;
    private static final int RETRY_INTERVAL = 0;
    private static final int DN_VALUE_FORM = 1;
    private static final int REPLICATION_WAIT = 2;
    private static final int XSLT_BROKEN_MODE = 3;
    private static final int CONTROL_COUNT = 4;
    private static final String UPDATING_CONTROL_VALUES = "cvt_upd";
    private ControlValue[] controlValues;
    private Map valuesByName;
    private Map nameToIndex;
    private EngineTrace tracer;

    public ControlValues(EngineTrace engineTrace) {
        this.tracer = engineTrace;
        this.controlValues = new ControlValue[4];
        this.controlValues[0] = new RetryInterval();
        this.controlValues[1] = new DNValueForm();
        this.controlValues[2] = new ReplicationWait();
        this.controlValues[3] = new XSLTBrokenMode();
        this.valuesByName = new HashMap();
        this.nameToIndex = new HashMap();
        int n = 0;
        while (n < this.controlValues.length) {
            this.valuesByName.put(this.controlValues[n].getName(), this.controlValues[n]);
            this.nameToIndex.put(this.controlValues[n].getName(), new Integer(n));
            ++n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFromDriver(long l) throws VRDException {
        JCContext jCContext = null;
        try {
            try {
                block11: {
                    try {
                        jCContext = MiscDS.createLocalContext();
                        Entry entry = new Entry(l);
                        Document document = ConfigAbstraction.getAttributeXML(jCContext, entry, "DirXML-EngineControlValues", this.tracer);
                        if (document == null) {
                            this.writeToDriver(l);
                            break block11;
                        }
                        EngineControls engineControls = EngineControls.constructFromDocument((Document)document);
                        if (!this.examineControlDefs(engineControls, l)) {
                            this.writeToDriver(l);
                        }
                    }
                    catch (GCVException gCVException) {
                        StatusLog.logWarning(8023, MiscDS.getEntryDN(l), gCVException.getMessage());
                        this.writeToDriver(l);
                    }
                    catch (VRDException vRDException) {
                        StatusLog.logWarning(8023, MiscDS.getEntryDN(l), vRDException.getMessage());
                        this.writeToDriver(l);
                    }
                    catch (JCIOException jCIOException) {
                        JCException jCException = (JCException)jCIOException.getCause();
                        if (jCException.getErrorCode() == -603 || jCException.getErrorCode() != -602) break block11;
                        this.writeToDriver(l);
                    }
                }
                Object var9_11 = null;
                if (jCContext == null) return;
            }
            catch (Throwable throwable) {
                throw new VRDException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeToDriver(long l) throws VRDException {
        JCContext jCContext = null;
        try {
            try {
                if (this.tracer.getLevel() > 0) {
                    this.tracer.trace(UPDATING_CONTROL_VALUES, (MessageSource)messageSource, MiscDS.getEntryDN(l));
                }
                try {
                    EngineControls engineControls = new EngineControls();
                    int n = 0;
                    while (true) {
                        Document document;
                        if (n >= this.controlValues.length) {
                            document = engineControls.toXml();
                            jCContext = MiscDS.createLocalContext();
                            Entry entry = new Entry(l);
                            ConfigAbstraction.setAttributeXML(jCContext, entry, "DirXML-EngineControlValues", document, this.tracer);
                            break;
                        }
                        document = this.controlValues[n].createGCValue();
                        engineControls.appendValue((GCValue)document);
                        ++n;
                    }
                }
                catch (JCIOException jCIOException) {
                    JCException jCException = (JCException)jCIOException.getCause();
                    if (jCException.getErrorCode() != -603) throw jCIOException;
                }
                Object var9_10 = null;
                if (jCContext == null) return;
            }
            catch (Throwable throwable) {
                throw new VRDException(throwable);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
    }

    private boolean examineControlDefs(EngineControls engineControls, long l) {
        boolean bl = false;
        boolean[] blArray = new boolean[this.controlValues.length];
        Arrays.fill(blArray, false);
        Iterator iterator = engineControls.iterator();
        while (iterator.hasNext()) {
            GCValue gCValue = (GCValue)iterator.next();
            String string = gCValue.getName();
            ControlValue controlValue = (ControlValue)this.valuesByName.get(string);
            if (controlValue != null) {
                blArray[((Integer)this.nameToIndex.get((Object)string)).intValue()] = true;
                if (controlValue.validateGCValue(gCValue)) {
                    controlValue.setFromGCValue(gCValue);
                    continue;
                }
                StatusLog.logWarning(8024, new Object[]{MiscDS.getEntryDN(l), string, gCValue.getDisplayName()});
                bl = true;
                continue;
            }
            StatusLog.logWarning(8025, new Object[]{MiscDS.getEntryDN(l), string, gCValue.getDisplayName()});
            bl = true;
        }
        int n = 0;
        while (n < blArray.length) {
            if (!blArray[n]) {
                StatusLog.logWarning(8026, MiscDS.getEntryDN(l));
                bl = true;
                break;
            }
            ++n;
        }
        return !bl;
    }

    public int getRetryInterval() {
        return this.controlValues[0].getIntValue();
    }

    public boolean getQualifiedDNValues() {
        return ((DNValueForm)this.controlValues[1]).getBooleanValue();
    }

    public int getReplicationWait() {
        return ((ReplicationWait)this.controlValues[2]).getIntValue();
    }

    public boolean getXSLTBrokenMode() {
        return ((XSLTBrokenMode)this.controlValues[3]).getBooleanValue();
    }

    static LocalizedMessageSource getMessageSource() {
        return defaultMessageSource;
    }

    static {
        messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.controls.ControlValues");
        defaultMessageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.gcv.EngineControls", Locale.ENGLISH);
    }
}

