/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.NdsConstants;
import com.novell.nds.dirxml.engine.SchemaCache;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.cache.CorruptCacheException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEBackLink;
import com.novell.nds.dirxml.engine.event.DSEBoolean;
import com.novell.nds.dirxml.engine.event.DSECaseExactString;
import com.novell.nds.dirxml.engine.event.DSECaseIgnoreList;
import com.novell.nds.dirxml.engine.event.DSECaseIgnoreString;
import com.novell.nds.dirxml.engine.event.DSEClassName;
import com.novell.nds.dirxml.engine.event.DSECounter;
import com.novell.nds.dirxml.engine.event.DSEDistinguishedName;
import com.novell.nds.dirxml.engine.event.DSEEMailAddress;
import com.novell.nds.dirxml.engine.event.DSEFAXNumber;
import com.novell.nds.dirxml.engine.event.DSEHold;
import com.novell.nds.dirxml.engine.event.DSEInteger;
import com.novell.nds.dirxml.engine.event.DSEInterval;
import com.novell.nds.dirxml.engine.event.DSENetAddress;
import com.novell.nds.dirxml.engine.event.DSENumericString;
import com.novell.nds.dirxml.engine.event.DSEObjectACL;
import com.novell.nds.dirxml.engine.event.DSEOctetList;
import com.novell.nds.dirxml.engine.event.DSEOctetString;
import com.novell.nds.dirxml.engine.event.DSEPath;
import com.novell.nds.dirxml.engine.event.DSEPostalAddress;
import com.novell.nds.dirxml.engine.event.DSEPrintableString;
import com.novell.nds.dirxml.engine.event.DSEReplicaPointer;
import com.novell.nds.dirxml.engine.event.DSEStream;
import com.novell.nds.dirxml.engine.event.DSETelephoneNumber;
import com.novell.nds.dirxml.engine.event.DSETime;
import com.novell.nds.dirxml.engine.event.DSETimestamp;
import com.novell.nds.dirxml.engine.event.DSETypedName;
import com.novell.nds.dirxml.engine.event.DSEUnknown;
import java.io.IOException;
import novell.jclient.JCAclValue;
import novell.jclient.JCAttributeDef;
import novell.jclient.JCBacklinkValue;
import novell.jclient.JCBooleanValue;
import novell.jclient.JCCEstringValue;
import novell.jclient.JCCIlistValue;
import novell.jclient.JCCIstringValue;
import novell.jclient.JCClassnameValue;
import novell.jclient.JCCounterValue;
import novell.jclient.JCDistnameValue;
import novell.jclient.JCEmailValue;
import novell.jclient.JCException;
import novell.jclient.JCFaxnumberValue;
import novell.jclient.JCHoldValue;
import novell.jclient.JCIntegerValue;
import novell.jclient.JCIntervalValue;
import novell.jclient.JCNUstringValue;
import novell.jclient.JCNetaddressValue;
import novell.jclient.JCOctetlistValue;
import novell.jclient.JCOctetstringValue;
import novell.jclient.JCPRstringValue;
import novell.jclient.JCPathValue;
import novell.jclient.JCPostaladdressValue;
import novell.jclient.JCReplicapointerValue;
import novell.jclient.JCStreamValue;
import novell.jclient.JCTelnumberValue;
import novell.jclient.JCTimeValue;
import novell.jclient.JCTimestampValue;
import novell.jclient.JCTypednameValue;
import novell.jclient.JCUnknownValue;
import novell.jclient.JCValue;
import org.w3c.dom.Element;

public final class DSEAttributeValueFactory {
    public static DSEAttributeValue createValue(DxEventInputStream dxEventInputStream) throws IOException {
        String string;
        byte by = dxEventInputStream.read_uint8();
        long l = dxEventInputStream.readSchemaID();
        try {
            string = DDSIndirect.getLocalSchemaName(l);
        }
        catch (DSErr dSErr) {
            string = "Unknown";
            StatusLog.logWarning(8022, new Integer((int)l));
        }
        switch (by) {
            case 0: {
                return new DSEUnknown(dxEventInputStream, string);
            }
            case 1: {
                return new DSEDistinguishedName(dxEventInputStream, string);
            }
            case 2: {
                return new DSECaseExactString(dxEventInputStream, string);
            }
            case 3: {
                return new DSECaseIgnoreString(dxEventInputStream, string);
            }
            case 4: {
                return new DSEPrintableString(dxEventInputStream, string);
            }
            case 5: {
                return new DSENumericString(dxEventInputStream, string);
            }
            case 6: {
                return new DSECaseIgnoreList(dxEventInputStream, string);
            }
            case 7: {
                return new DSEBoolean(dxEventInputStream, string);
            }
            case 8: {
                return new DSEInteger(dxEventInputStream, string);
            }
            case 9: {
                return new DSEOctetString(dxEventInputStream, string);
            }
            case 10: {
                return new DSETelephoneNumber(dxEventInputStream, string);
            }
            case 11: {
                return new DSEFAXNumber(dxEventInputStream, string);
            }
            case 12: {
                return new DSENetAddress(dxEventInputStream, string);
            }
            case 13: {
                return new DSEOctetList(dxEventInputStream, string);
            }
            case 14: {
                return new DSEEMailAddress(dxEventInputStream, string);
            }
            case 15: {
                return new DSEPath(dxEventInputStream, string);
            }
            case 16: {
                return new DSEReplicaPointer(dxEventInputStream, string);
            }
            case 17: {
                return new DSEObjectACL(dxEventInputStream, string);
            }
            case 18: {
                return new DSEPostalAddress(dxEventInputStream, string);
            }
            case 19: {
                return new DSETimestamp(dxEventInputStream, string);
            }
            case 20: {
                return new DSEClassName(dxEventInputStream, string);
            }
            case 21: {
                return new DSEStream(dxEventInputStream, string);
            }
            case 22: {
                return new DSECounter(dxEventInputStream, string);
            }
            case 23: {
                return new DSEBackLink(dxEventInputStream, string);
            }
            case 24: {
                return new DSETime(dxEventInputStream, string);
            }
            case 25: {
                return new DSETypedName(dxEventInputStream, string);
            }
            case 26: {
                return new DSEHold(dxEventInputStream, string);
            }
            case 27: {
                return new DSEInterval(dxEventInputStream, string);
            }
        }
        throw new CorruptCacheException("Unknown syntax specified is: " + Integer.toString(by));
    }

    public static DSEAttributeValue createValue(int n, String string) throws VRDException {
        switch (n) {
            case 0: {
                return new DSEUnknown(string);
            }
            case 1: {
                return new DSEDistinguishedName(string);
            }
            case 2: {
                return new DSECaseExactString(string);
            }
            case 3: {
                return new DSECaseIgnoreString(string);
            }
            case 4: {
                return new DSEPrintableString(string);
            }
            case 5: {
                return new DSENumericString(string);
            }
            case 6: {
                return new DSECaseIgnoreList(string);
            }
            case 7: {
                return new DSEBoolean(string);
            }
            case 8: {
                return new DSEInteger(string);
            }
            case 9: {
                return new DSEOctetString(string);
            }
            case 10: {
                return new DSETelephoneNumber(string);
            }
            case 11: {
                return new DSEFAXNumber(string);
            }
            case 12: {
                return new DSENetAddress(string);
            }
            case 13: {
                return new DSEOctetList(string);
            }
            case 14: {
                return new DSEEMailAddress(string);
            }
            case 15: {
                return new DSEPath(string);
            }
            case 16: {
                return new DSEReplicaPointer(string);
            }
            case 17: {
                return new DSEObjectACL(string);
            }
            case 18: {
                return new DSEPostalAddress(string);
            }
            case 19: {
                return new DSETimestamp(string);
            }
            case 20: {
                return new DSEClassName(string);
            }
            case 21: {
                return new DSEStream(string);
            }
            case 22: {
                return new DSECounter(string);
            }
            case 23: {
                return new DSEBackLink(string);
            }
            case 24: {
                return new DSETime(string);
            }
            case 25: {
                return new DSETypedName(string);
            }
            case 26: {
                return new DSEHold(string);
            }
            case 27: {
                return new DSEInterval(string);
            }
        }
        throw new VRDException(9002, Integer.toString(n));
    }

    public static DSEAttributeValue createValue(JCValue jCValue) throws VRDException {
        switch (jCValue.syntax) {
            case 0: {
                return new DSEUnknown((JCUnknownValue)jCValue);
            }
            case 1: {
                return new DSEDistinguishedName((JCDistnameValue)jCValue);
            }
            case 2: {
                return new DSECaseExactString((JCCEstringValue)jCValue);
            }
            case 3: {
                return new DSECaseIgnoreString((JCCIstringValue)jCValue);
            }
            case 4: {
                return new DSEPrintableString((JCPRstringValue)jCValue);
            }
            case 5: {
                return new DSENumericString((JCNUstringValue)jCValue);
            }
            case 6: {
                return new DSECaseIgnoreList((JCCIlistValue)jCValue);
            }
            case 7: {
                return new DSEBoolean((JCBooleanValue)jCValue);
            }
            case 8: {
                return new DSEInteger((JCIntegerValue)jCValue);
            }
            case 9: {
                return new DSEOctetString((JCOctetstringValue)jCValue);
            }
            case 10: {
                return new DSETelephoneNumber((JCTelnumberValue)jCValue);
            }
            case 11: {
                return new DSEFAXNumber((JCFaxnumberValue)jCValue);
            }
            case 12: {
                return new DSENetAddress((JCNetaddressValue)jCValue);
            }
            case 13: {
                return new DSEOctetList((JCOctetlistValue)jCValue);
            }
            case 14: {
                return new DSEEMailAddress((JCEmailValue)jCValue);
            }
            case 15: {
                return new DSEPath((JCPathValue)jCValue);
            }
            case 16: {
                return new DSEReplicaPointer((JCReplicapointerValue)jCValue);
            }
            case 17: {
                return new DSEObjectACL((JCAclValue)jCValue);
            }
            case 18: {
                return new DSEPostalAddress((JCPostaladdressValue)jCValue);
            }
            case 19: {
                return new DSETimestamp((JCTimestampValue)jCValue);
            }
            case 20: {
                return new DSEClassName((JCClassnameValue)jCValue);
            }
            case 21: {
                return new DSEStream((JCStreamValue)jCValue);
            }
            case 22: {
                return new DSECounter((JCCounterValue)jCValue);
            }
            case 23: {
                return new DSEBackLink((JCBacklinkValue)jCValue);
            }
            case 24: {
                return new DSETime((JCTimeValue)jCValue);
            }
            case 25: {
                return new DSETypedName((JCTypednameValue)jCValue);
            }
            case 26: {
                return new DSEHold((JCHoldValue)jCValue);
            }
            case 27: {
                return new DSEInterval((JCIntervalValue)jCValue);
            }
        }
        throw new VRDException(9002, Integer.toString(jCValue.syntax));
    }

    public static DSEAttributeValue createValue(Element element) throws VRDException {
        Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
        if (element2 == null) {
            throw new VRDException(9040, element.getNodeName(), (Object)"attr-name");
        }
        return DSEAttributeValueFactory.createValue(element2.getAttributeNS(null, "attr-name"), element);
    }

    public static DSEAttributeValue createValue(String string, Element element) throws VRDException {
        int n;
        JCAttributeDef jCAttributeDef = SchemaCache.getAttributeDef(string);
        if (jCAttributeDef == null) {
            n = NdsConstants.getPseudoAttrSyntax(string);
            if (n == 0) {
                throw new VRDException(new JCException("getAttributeDef(" + string + ")", -603));
            }
        } else {
            n = jCAttributeDef.getSyntax();
        }
        DSEAttributeValue dSEAttributeValue = DSEAttributeValueFactory.createValue(n, string);
        if (element.getTagName().equals("value")) {
            dSEAttributeValue.fromXML(element);
        }
        return dSEAttributeValue;
    }

    public static String getTypeName(int n) {
        switch (n) {
            case 0: {
                return "structured";
            }
            case 1: {
                return "dn";
            }
            case 2: {
                return "string";
            }
            case 3: {
                return "string";
            }
            case 4: {
                return "string";
            }
            case 5: {
                return "string";
            }
            case 6: {
                return "structured";
            }
            case 7: {
                return "state";
            }
            case 8: {
                return "int";
            }
            case 9: {
                return "octet";
            }
            case 10: {
                return "teleNumber";
            }
            case 11: {
                return "structured";
            }
            case 12: {
                return "structured";
            }
            case 13: {
                return "structured";
            }
            case 14: {
                return "structured";
            }
            case 15: {
                return "structured";
            }
            case 16: {
                return "structured";
            }
            case 17: {
                return "structured";
            }
            case 18: {
                return "structured";
            }
            case 19: {
                return "structured";
            }
            case 20: {
                return "className";
            }
            case 21: {
                return "octet";
            }
            case 22: {
                return "counter";
            }
            case 23: {
                return "structured";
            }
            case 24: {
                return "time";
            }
            case 25: {
                return "structured";
            }
            case 26: {
                return "structured";
            }
            case 27: {
                return "interval";
            }
        }
        return "structured";
    }
}

