/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCBacklinkValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEBackLink
extends JCBacklinkValue
implements DSEAttributeValue {
    private static final String[] strAllowed = new String[]{"serverDn", "remoteId"};

    protected DSEBackLink(String string) {
        this.attributeName = string;
        this.syntax = 23;
    }

    protected DSEBackLink(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 23;
        long l = dxEventInputStream.readEntryID();
        String string2 = dxEventInputStream.readString();
        this.setRemoteID(dxEventInputStream.readEntryID());
        try {
            string2 = DDSIndirect.getLocalEntryName(l, 16);
        }
        catch (DSErr dSErr) {
            // empty catch block
        }
        this.setServerDN(Driver.changeDNForm(string2));
    }

    public DSEBackLink(JCBacklinkValue jCBacklinkValue) {
        super(jCBacklinkValue.attributeName, jCBacklinkValue.operation, jCBacklinkValue.flags, jCBacklinkValue.timestamp, jCBacklinkValue.getRemoteID(), Driver.changeDNForm(jCBacklinkValue.getServerDN()));
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        String[] stringArray = new String[]{"serverDn", "remoteId"};
        String[] stringArray2 = new String[]{this.getServerDN(), Long.toString(this.getRemoteID())};
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        try {
            String[] stringArray = new String[2];
            int[] nArray = new int[2];
            DSEUtil.validate2(element, strAllowed, nArray, stringArray);
            return stringArray[nArray[0]].equals(this.getServerDN()) && Long.valueOf(stringArray[nArray[1]]).longValue() == this.getRemoteID();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        try {
            String[] stringArray = new String[2];
            int[] nArray = new int[2];
            DSEUtil.validate2(element, strAllowed, nArray, stringArray);
            this.setServerDN(stringArray[nArray[0]]);
            this.setRemoteID(Long.valueOf(stringArray[nArray[1]]));
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRDException(numberFormatException);
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setServerDN(DSEUtil.encrypt(this.getServerDN(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setServerDN(DSEUtil.decrypt(this.getServerDN(), byArray));
    }

    public int hashCode() {
        int n = 0;
        String string = this.getServerDN();
        if (string != null) {
            n += string.toUpperCase().hashCode();
        }
        n = (int)((long)n + this.getRemoteID());
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCBacklinkValue jCBacklinkValue = (JCBacklinkValue)object;
        n = this.getServerDN().compareTo(jCBacklinkValue.getServerDN());
        if (n == 0) {
            long l = this.getRemoteID() - jCBacklinkValue.getRemoteID();
            n = l < 0L ? -1 : (l > 0L ? 1 : 0);
        }
        return n;
    }
}

