/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.cache.DxEventInputStream;
import com.novell.nds.dirxml.engine.event.DDSIndirect;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEUtil;
import java.io.IOException;
import novell.jclient.JCAclValue;
import novell.jclient.JCValue;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public final class DSEObjectACL
extends JCAclValue
implements DSEAttributeValue {
    private static final String[] strAllowed = new String[]{"protectedName", "trustee", "privileges"};

    protected DSEObjectACL(String string) {
        this.attributeName = string;
        this.syntax = 17;
    }

    protected DSEObjectACL(DxEventInputStream dxEventInputStream, String string) throws IOException {
        this.attributeName = string;
        this.syntax = 17;
        long l = dxEventInputStream.readEntryID();
        String string2 = dxEventInputStream.readString();
        long l2 = dxEventInputStream.readSchemaID();
        this.setPrivileges(dxEventInputStream.read_uint32());
        try {
            String string3 = DDSIndirect.getLocalSchemaName(l2, true);
            this.setAttributeName(string3);
        }
        catch (DSErr dSErr) {
            this.setAttributeName("Unknown");
            StatusLog.logWarning(8022, new Integer((int)l2));
        }
        try {
            string2 = DDSIndirect.getLocalEntryName(l, 16);
        }
        catch (DSErr dSErr) {
            // empty catch block
        }
        this.setTrusteeDN(Driver.changeDNForm(string2));
    }

    public DSEObjectACL(JCAclValue jCAclValue) {
        super(jCAclValue.attributeName, jCAclValue.operation, jCAclValue.flags, jCAclValue.timestamp, jCAclValue.getAttributeName(), Driver.changeDNForm(jCAclValue.getTrusteeDN()), jCAclValue.getPrivileges());
    }

    public String getAttrName() {
        return this.attributeName;
    }

    public void toXML(Element element) throws DOMException {
        String[] stringArray = new String[]{"protectedName", "trustee", "privileges"};
        String[] stringArray2 = new String[]{this.getAttributeName(), this.getTrusteeDN(), Long.toString(this.getPrivileges())};
        DSEUtil.createAggregateValueElement(element, stringArray, stringArray2);
    }

    public boolean equals(Element element) {
        try {
            String[] stringArray = new String[3];
            int[] nArray = new int[3];
            DSEUtil.validate3(element, strAllowed, nArray, stringArray);
            return stringArray[nArray[0]].equals(this.getAttributeName()) && stringArray[nArray[1]].equals(this.getTrusteeDN()) && Long.valueOf(stringArray[nArray[2]]).longValue() == this.getPrivileges();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void fromXML(Element element) throws DOMException, VRDException {
        try {
            String[] stringArray = new String[3];
            int[] nArray = new int[3];
            DSEUtil.validate3(element, strAllowed, nArray, stringArray);
            this.setAttributeName(stringArray[nArray[0]]);
            this.setTrusteeDN(stringArray[nArray[1]]);
            this.setPrivileges(Long.valueOf(stringArray[nArray[2]]));
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRDException(numberFormatException);
        }
    }

    public void encrypt(byte[] byArray) throws VRDException {
        this.setAttributeName(DSEUtil.encrypt(this.getAttributeName(), byArray));
        this.setTrusteeDN(DSEUtil.encrypt(this.getTrusteeDN(), byArray));
    }

    public void decrypt(byte[] byArray) throws VRDException {
        this.setAttributeName(DSEUtil.decrypt(this.getAttributeName(), byArray));
        this.setTrusteeDN(DSEUtil.decrypt(this.getTrusteeDN(), byArray));
    }

    public int hashCode() {
        String string;
        int n = 0;
        String string2 = this.getTrusteeDN();
        if (string2 != null) {
            n += string2.toUpperCase().hashCode();
        }
        if ((string = this.getAttributeName()) != null) {
            n += string.hashCode();
        }
        n = (int)((long)n + this.getPrivileges());
        return n;
    }

    public int getSyntax() {
        return this.syntax;
    }

    public boolean equals(DSEAttributeValue dSEAttributeValue) {
        return this.compareTo(dSEAttributeValue) == 0;
    }

    public int compareTo(Object object) {
        if (!(object instanceof JCValue)) {
            return -1;
        }
        int n = this.syntax - ((JCValue)object).syntax;
        if (n != 0) {
            return n;
        }
        JCAclValue jCAclValue = (JCAclValue)object;
        n = this.getAttributeName().compareTo(jCAclValue.getAttributeName());
        if (n == 0) {
            n = this.getTrusteeDN().compareTo(jCAclValue.getTrusteeDN());
        }
        if (n == 0) {
            n = (int)this.getPrivileges() - (int)jCAclValue.getPrivileges();
        }
        return n;
    }
}

