/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.event;

import com.novell.io.Base64InputStream;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.event.DOMExceptionImpl;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import com.novell.xml.util.Base64Codec;
import com.novell.xsl.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class DSEUtil {
    private static String _NULL_STRING = "<//<null>\\\\>";
    private static String _EMPTY_STRING = "<//<empty>\\\\>";

    public static void validate2(Element element, String[] stringArray, int[] nArray, String[] stringArray2) throws VRDException {
        DSEUtil.checkValueType(element, "structured", element.getAttributeNS(null, "type"));
        NodeList nodeList = element.getElementsByTagNameNS(null, "component");
        if (nodeList.getLength() != 2) {
            Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
            String string = element2 != null ? element2.getNodeName() : element.getNodeName();
            throw new VRDException(9001, new Object[]{string, new Integer(2), new Integer(nodeList.getLength())});
        }
        String[] stringArray3 = new String[]{((Element)nodeList.item(0)).getAttributeNS(null, "name"), ((Element)nodeList.item(1)).getAttributeNS(null, "name")};
        DSEUtil.checkValueComponents2(element, stringArray, stringArray3, nArray);
        stringArray2[0] = Util.getXSLStringValue((Node)nodeList.item(0));
        stringArray2[1] = Util.getXSLStringValue((Node)nodeList.item(1));
    }

    public static void validate3(Element element, String[] stringArray, int[] nArray, String[] stringArray2) throws VRDException {
        DSEUtil.checkValueType(element, "structured", element.getAttributeNS(null, "type"));
        NodeList nodeList = element.getElementsByTagNameNS(null, "component");
        if (nodeList.getLength() != 3) {
            Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
            String string = element2 != null ? element2.getNodeName() : element.getNodeName();
            throw new VRDException(9001, new Object[]{string, new Integer(3), new Integer(nodeList.getLength())});
        }
        String[] stringArray3 = new String[]{((Element)nodeList.item(0)).getAttributeNS(null, "name"), ((Element)nodeList.item(1)).getAttributeNS(null, "name"), ((Element)nodeList.item(2)).getAttributeNS(null, "name")};
        DSEUtil.checkValueComponents3(element, stringArray, stringArray3, nArray);
        stringArray2[0] = Util.getXSLStringValue((Node)nodeList.item(0));
        stringArray2[1] = Util.getXSLStringValue((Node)nodeList.item(1));
        stringArray2[2] = Util.getXSLStringValue((Node)nodeList.item(2));
    }

    public static byte[] validateOctet(Element element) throws VRDException {
        NodeList nodeList = element.getElementsByTagNameNS(null, "component");
        String string = element.getAttributeNS(null, "type");
        if (nodeList.getLength() > 0) {
            Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
            String string2 = element2 != null ? element2.getNodeName() : element.getNodeName();
            throw new VRDException(9001, new Object[]{string2, new Integer(0), new Integer(nodeList.getLength())});
        }
        String string3 = Util.getXSLStringValue((Node)element);
        if (string.equals("octet")) {
            try {
                return Base64InputStream.decode((String)string3);
            }
            catch (IOException iOException) {
                throw new VRDException(iOException);
            }
        }
        if (string.length() != 0) {
            try {
                return string3.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    return string3.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    return string3.getBytes();
                }
            }
        }
        try {
            return Base64InputStream.decode((String)string3);
        }
        catch (IOException iOException) {
            try {
                return string3.getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                try {
                    return string3.getBytes("UTF8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException3) {
                    return string3.getBytes();
                }
            }
        }
    }

    public static String validateString(Element element) throws VRDException {
        NodeList nodeList = element.getElementsByTagNameNS(null, "component");
        String string = element.getAttributeNS(null, "type");
        if (nodeList.getLength() > 0) {
            Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
            String string2 = element2 != null ? element2.getNodeName() : element.getNodeName();
            throw new VRDException(9001, new Object[]{string2, new Integer(0), new Integer(nodeList.getLength())});
        }
        String string3 = Util.getXSLStringValue((Node)element);
        if (string.equals("octet")) {
            try {
                byte[] byArray = Base64InputStream.decode((String)string3);
                try {
                    return new String(byArray, "UTF-8");
                }
                catch (Exception exception) {
                    try {
                        return new String(byArray, "UTF8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return new String(byArray);
                    }
                }
            }
            catch (IOException iOException) {
                throw new VRDException(iOException);
            }
        }
        return string3;
    }

    public static long validateNumber(Element element) throws VRDException {
        String string = DSEUtil.validateString(element);
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new VRDException(numberFormatException);
        }
    }

    public static void checkValueType(Element element, String string, String string2) throws VRDException {
        if (string2 != null && !string2.equals("") && !string2.equals(string)) {
            Element element2 = XdsUtil.getFirstAncestorElementByTagNameWithAttrNS(element, "*", "*", null, "attr-name");
            String string3 = element2 == null ? "" : element2.getAttributeNS(null, "attr-name");
            throw new VRDException(9000, new Object[]{element.getNodeName(), string3, string2, string});
        }
    }

    public static void checkValueComponents2(Element element, String[] stringArray, String[] stringArray2, int[] nArray) throws VRDException {
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -1;
            ++n;
        }
        if (stringArray2[0].equals(stringArray[0])) {
            nArray[0] = 0;
            if (stringArray2[1].equals(stringArray[1])) {
                nArray[1] = 1;
            }
        } else if (stringArray2[1].equals(stringArray[0])) {
            nArray[0] = 1;
            if (stringArray2[0].equals(stringArray[1])) {
                nArray[1] = 0;
            }
        }
        if (nArray[0] == -1 || nArray[1] == -1) {
            throw new VRDException(9000, new Object[]{element.getNodeName(), "name", stringArray2[0] + " " + stringArray2[1], stringArray[0] + " " + stringArray[1]});
        }
    }

    public static void checkValueComponents3(Element element, String[] stringArray, String[] stringArray2, int[] nArray) throws VRDException {
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = -1;
            ++n;
        }
        if (stringArray2[0].equals(stringArray[0])) {
            nArray[0] = 0;
            if (stringArray2[1].equals(stringArray[1])) {
                nArray[1] = 1;
                if (stringArray2[2].equals(stringArray[2])) {
                    nArray[2] = 2;
                }
            } else if (stringArray2[2].equals(stringArray[1])) {
                nArray[1] = 2;
                if (stringArray2[1].equals(stringArray[2])) {
                    nArray[2] = 1;
                }
            }
        } else if (stringArray2[1].equals(stringArray[0])) {
            nArray[0] = 1;
            if (stringArray2[0].equals(stringArray[1])) {
                nArray[1] = 0;
                if (stringArray2[2].equals(stringArray[2])) {
                    nArray[2] = 2;
                }
            } else if (stringArray2[2].equals(stringArray[1])) {
                nArray[1] = 2;
                if (stringArray2[0].equals(stringArray[2])) {
                    nArray[2] = 0;
                }
            }
        } else if (stringArray2[2].equals(stringArray[0])) {
            nArray[0] = 2;
            if (stringArray2[0].equals(stringArray[1])) {
                nArray[1] = 0;
                if (stringArray2[1].equals(stringArray[2])) {
                    nArray[2] = 1;
                }
            } else if (stringArray2[1].equals(stringArray[1])) {
                nArray[1] = 1;
                if (stringArray2[0].equals(stringArray[2])) {
                    nArray[2] = 0;
                }
            }
        }
        if (nArray[0] == -1 || nArray[1] == -1 || nArray[2] == -1) {
            throw new VRDException(9000, new Object[]{element.getNodeName(), "name", stringArray2[0] + " " + stringArray2[1] + " " + stringArray2[2], stringArray[0] + " " + stringArray[1] + " " + stringArray[2]});
        }
    }

    public static void createValueElement(Element element, String string, String string2) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, "value");
        element2.setAttributeNS(null, "type", string);
        element.appendChild(element2);
        Text text = document.createTextNode(string2);
        element2.appendChild(text);
    }

    public static void createAggregateValueElement(Element element, String[] stringArray, String[] stringArray2) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElementNS(null, "value");
        element2.setAttributeNS(null, "type", "structured");
        element.appendChild(element2);
        int n = 0;
        while (n < stringArray.length) {
            Element element3 = document.createElementNS(null, "component");
            element3.setAttributeNS(null, "name", stringArray[n]);
            element2.appendChild(element3);
            Text text = document.createTextNode(stringArray2[n]);
            element3.appendChild(text);
            ++n;
        }
    }

    public static void asXML(byte[] byArray, Element element, String string) throws DOMException {
        XMLParser xMLParser = XMLParserFactory.newParser();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Document document = xMLParser.parse((InputStream)byteArrayInputStream);
        if (xMLParser.anyErrors()) {
            throw new DOMExceptionImpl("NDS attribute '" + string + "' treated as XML failed to parse:\n" + xMLParser.getErrorMsgString());
        }
        if (document.getDocumentElement() != null) {
            Document document2 = element.getOwnerDocument();
            Element element2 = (Element)XdsUtil.cloneSubtree(document2, document.getDocumentElement());
            Element element3 = document2.createElementNS(null, "value");
            element3.setAttributeNS(null, "type", "xml");
            element.appendChild(element3);
            element3.appendChild(element2);
        }
    }

    static byte[] encrypt(byte[] byArray, byte[] byArray2) throws VRDException {
        try {
            return DSEUtil.s1(byArray, byArray2);
        }
        catch (DSErr dSErr) {
            throw new VRDException(dSErr);
        }
    }

    static byte[] decrypt(byte[] byArray, byte[] byArray2) throws VRDException {
        try {
            return DSEUtil.s2(byArray, byArray2);
        }
        catch (DSErr dSErr) {
            throw new VRDException(dSErr);
        }
    }

    static String encrypt(String string, byte[] byArray) throws VRDException {
        if (string == null) {
            string = _NULL_STRING;
        } else if (string.length() == 0) {
            string = _EMPTY_STRING;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray2 = new byte[cArray.length * 2];
        int n = 0;
        int n2 = 0;
        while (n < cArray.length) {
            byArray2[n2] = (byte)(cArray[n] & 0xFF);
            byArray2[n2 + 1] = (byte)(cArray[n] >> 8 & 0xFF);
            ++n;
            n2 += 2;
        }
        try {
            byArray2 = DSEUtil.s1(byArray2, byArray);
        }
        catch (DSErr dSErr) {
            throw new VRDException(dSErr);
        }
        cArray = Base64Codec.encode((byte[])byArray2);
        return new String(cArray);
    }

    static String decrypt(String string, byte[] byArray) throws VRDException {
        try {
            byte[] byArray2 = Base64Codec.decode((String)string);
            try {
                byArray2 = DSEUtil.s2(byArray2, byArray);
            }
            catch (DSErr dSErr) {
                throw new VRDException(dSErr);
            }
            char[] cArray = new char[byArray2.length / 2];
            int n = 0;
            int n2 = 0;
            while (n < cArray.length) {
                cArray[n] = (char)(byArray2[n2] | byArray2[n2 + 1] << 8);
                ++n;
                n2 += 2;
            }
            String string2 = new String(cArray);
            if (string2.equals(_NULL_STRING)) {
                return null;
            }
            if (string2.equals(_EMPTY_STRING)) {
                return "";
            }
            return string2;
        }
        catch (IOException iOException) {
            throw new VRDException(iOException);
        }
    }

    private static native byte[] s1(byte[] var0, byte[] var1) throws DSErr, VRDException;

    private static native byte[] s2(byte[] var0, byte[] var1) throws DSErr, VRDException;

    static native byte[] s3(byte[] var0) throws DSErr, VRDException;

    public static int hashCode(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        int n4 = 0;
        while (n4 < n3) {
            n = 31 * n + byArray[n2++];
            ++n4;
        }
        return n;
    }

    public static int compareTo(byte[] byArray, byte[] byArray2) {
        if (byArray == null) {
            return -1;
        }
        if (byArray2 == null) {
            return 1;
        }
        if (Arrays.equals(byArray, byArray2)) {
            return 0;
        }
        int n = 0;
        while (n < byArray.length && n < byArray2.length) {
            int n2 = byArray[n] - byArray2[n];
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return byArray.length - byArray2.length;
    }
}

