/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.ActionSet;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.engine.rules.Token;
import com.novell.nds.dirxml.engine.rules.TokenLocalVariable;
import com.novell.nds.dirxml.engine.rules.TokenPassword;
import com.novell.nds.dirxml.engine.rules.TokenText;
import com.novell.nds.dirxml.engine.rules.TokenXPath;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.XPathUtil;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

class Arg
implements RuleConstants {
    private int type;
    private Object[] contents = null;
    private String name = null;
    String location;
    private String display;
    private RuleStaticContext staticContext;
    private static final String suppressedString = RuleConstants.messageSource.getMessageString("rct_suppressed");

    Arg(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        this.staticContext = ruleStaticContext;
        ArrayList<RuleConstants> arrayList = new ArrayList<RuleConstants>();
        this.location = RuleUtil.getNodeLocation(element);
        this.display = RuleConstants.displayString.getArgString(element);
        if (element.getNamespaceURI() != null) {
            throw new VRDException(9124, RuleUtil.getNodeLocation(element), element.getNodeName(), element.getParentNode().getNodeName());
        }
        String string = element.getLocalName();
        if (string.equals("arg-actions")) {
            this.type = 0;
        } else if (string.equals("arg-association")) {
            this.type = 1;
        } else if (string.equals("arg-component")) {
            this.type = 2;
            this.name = RuleUtil.getAttrString(element, "name", null);
        } else if (string.equals("arg-dn")) {
            this.type = 3;
        } else if (string.equals("arg-match-attr")) {
            this.type = 4;
            this.name = RuleUtil.getAttrString(element, "name", null);
        } else if (string.equals("arg-node-set")) {
            this.type = 5;
        } else if (string.equals("arg-string")) {
            this.type = 6;
            this.display = "arg-string(" + this.display + ')';
            this.name = RuleUtil.getAttrString(element, "name", "");
        } else if (string.equals("arg-value")) {
            this.name = element.getAttributeNS(null, "type");
            this.type = this.name.equals("structured") ? 8 : 7;
            this.display = "arg-string(" + this.display + ')';
        } else if (string.equals("arg-object")) {
            this.type = 10;
        } else if (string.equals("token-escape-for-dest-dn") || string.equals("token-escape-for-dest-dn") || string.equals("token-escape-for-src-dn") || string.equals("token-lower-case") || string.equals("token-replace-all") || string.equals("token-replace-first") || string.equals("token-substring") || string.equals("token-upper-case") || string.equals("token-parse-dn")) {
            this.type = 9;
            this.name = string;
        } else {
            throw new VRDException(9124, RuleUtil.getNodeLocation(element), element.getNodeName(), element.getParentNode().getNodeName());
        }
        if (this.type == 0) {
            arrayList.add(new ActionSet(element, ruleStaticContext));
        } else {
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    switch (this.type) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 6: 
                        case 7: 
                        case 9: {
                            arrayList.add(Token.createToken((Element)node, ruleStaticContext, false));
                            break;
                        }
                        case 5: {
                            arrayList.add(Token.createToken((Element)node, ruleStaticContext, true));
                            break;
                        }
                        case 0: {
                            break;
                        }
                        case 4: {
                            Arg arg = new Arg((Element)node, ruleStaticContext);
                            if (arg.type != 7 && arg.type != 8) {
                                throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), element.getNodeName());
                            }
                            if (arrayList.size() != 0) {
                                throw new VRDException(9126, RuleUtil.getNodeLocation(node), (Object)node.getNodeName());
                            }
                            arrayList.add(arg);
                            break;
                        }
                        case 8: {
                            Arg arg = new Arg((Element)node, ruleStaticContext);
                            if (arg.type != 2) {
                                throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), element.getNodeName());
                            }
                            arrayList.add(arg);
                            break;
                        }
                        case 10: {
                            if (arrayList.size() != 0) {
                                throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), element.getNodeName());
                            }
                            Token token = Token.createToken((Element)node, ruleStaticContext, false);
                            if (!(token instanceof TokenXPath) && !(token instanceof TokenLocalVariable)) {
                                throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), element.getNodeName());
                            }
                            arrayList.add(token);
                        }
                    }
                } else if (node instanceof Text && node.getNodeValue().trim().length() != 0) {
                    throw new VRDException(9141, RuleUtil.getNodeLocation(node), XdsUtil.getNodeText(node), element.getNodeName());
                }
                node = node.getNextSibling();
            }
        }
        if (arrayList.size() != 0) {
            this.contents = arrayList.toArray();
        }
    }

    int getType() {
        return this.type;
    }

    String getName() {
        return this.name;
    }

    String getTypeElementName() {
        switch (this.type) {
            case 0: {
                return "arg-actions";
            }
            case 1: {
                return "arg-association";
            }
            case 2: {
                return "arg-component";
            }
            case 3: {
                return "arg-dn";
            }
            case 4: {
                return "arg-match-attr";
            }
            case 5: {
                return "arg-node-set";
            }
            case 6: {
                return "arg-string";
            }
            case 7: 
            case 8: {
                return "arg-value";
            }
            case 9: {
                return this.name;
            }
        }
        return "";
    }

    static Arg[] getArgs(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        ArrayList<Arg> arrayList = new ArrayList<Arg>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                arrayList.add(new Arg((Element)node, ruleStaticContext));
            } else if (node instanceof Text && node.getNodeValue().trim().length() != 0) {
                throw new VRDException(9141, RuleUtil.getNodeLocation(node), XdsUtil.getNodeText(node), element.getNodeName());
            }
            node = node.getNextSibling();
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new Arg[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Object evaluate(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        this.staticContext.tracer.trace(3, this.display);
        this.staticContext.tracer.pushIndent(1);
        boolean bl = ruleDynamicContext.sensitive > 0;
        try {
            switch (this.type) {
                case 5: {
                    RuleUtil.updateSandboxDocumentOrder(ruleDynamicContext);
                    NodeSet nodeSet = new NodeSet();
                    if (this.contents != null) {
                        int n = 0;
                        while (n < this.contents.length) {
                            Object var8_18;
                            Object object;
                            this.staticContext.tracer.trace(3, ((Token)this.contents[n]).display);
                            this.staticContext.tracer.pushIndent(1);
                            bl |= this.contents[n] instanceof TokenPassword;
                            try {
                                object = ((Token)this.contents[n]).expand(element, ruleDynamicContext);
                                var8_18 = null;
                                this.staticContext.tracer.popIndent();
                            }
                            catch (Throwable throwable) {
                                var8_18 = null;
                                this.staticContext.tracer.popIndent();
                                throw throwable;
                            }
                            if (object instanceof Node) {
                                if (this.staticContext.tracer.getLevel() >= 3) {
                                    this.staticContext.tracer.trace(3, "rct_token_expands_to_ns", (MessageSource)RuleConstants.messageSource, (Object)(bl ? suppressedString : XPathUtil.describeNode((Node)((Node)object))));
                                }
                                nodeSet.add((Node)object);
                            } else if (object instanceof NodeSet) {
                                if (this.staticContext.tracer.getLevel() >= 3) {
                                    this.staticContext.tracer.trace(3, "rct_token_expands_to_ns", (MessageSource)RuleConstants.messageSource, (Object)this.describeNodeSet((NodeSet)object));
                                }
                                nodeSet.union((NodeSet)object);
                            } else {
                                String string = object.toString();
                                this.staticContext.tracer.trace(3, "rct_token_expands_to", (MessageSource)RuleConstants.messageSource, (Object)(bl ? suppressedString : string));
                                nodeSet.add((Node)RuleUtil.createSandboxTextNode(string, ruleDynamicContext));
                            }
                            ++n;
                        }
                    }
                    if (this.staticContext.tracer.getLevel() >= 3) {
                        this.staticContext.tracer.trace(3, "rct_arg_expands_to_ns", (MessageSource)RuleConstants.messageSource, (Object)(bl ? suppressedString : this.describeNodeSet(nodeSet)));
                    }
                    NodeSet nodeSet2 = nodeSet;
                    Object var14_23 = null;
                    this.staticContext.tracer.popIndent();
                    return nodeSet2;
                }
                case 0: {
                    Object object = this.contents[0];
                    Object var14_24 = null;
                    this.staticContext.tracer.popIndent();
                    return object;
                }
                case 4: {
                    if (this.contents != null) {
                        Object object = ((Arg)this.contents[0]).evaluate(element, ruleDynamicContext);
                        Object var14_25 = null;
                        this.staticContext.tracer.popIndent();
                        return object;
                    }
                    Object var5_9 = null;
                    Object var14_26 = null;
                    this.staticContext.tracer.popIndent();
                    return var5_9;
                }
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 9: {
                    Object object;
                    StringBuffer stringBuffer = new StringBuffer();
                    if (this.contents != null) {
                        int n = 0;
                        while (n < this.contents.length) {
                            Object var10_35;
                            bl |= this.contents[n] instanceof TokenPassword;
                            this.staticContext.tracer.trace(3, ((Token)this.contents[n]).display);
                            this.staticContext.tracer.pushIndent(1);
                            try {
                                object = ((Token)this.contents[n]).expand(element, ruleDynamicContext).toString();
                                if (!(this.contents[n] instanceof TokenText)) {
                                    this.staticContext.tracer.trace(3, "rct_token_expands_to", (MessageSource)RuleConstants.messageSource, bl ? suppressedString : object);
                                }
                                stringBuffer.append((String)object);
                                var10_35 = null;
                                this.staticContext.tracer.popIndent();
                            }
                            catch (Throwable throwable) {
                                var10_35 = null;
                                this.staticContext.tracer.popIndent();
                                throw throwable;
                            }
                            ++n;
                        }
                    }
                    String string = stringBuffer.toString();
                    if (this.staticContext.tracer.getLevel() >= 3) {
                        this.staticContext.tracer.trace(3, "rct_arg_expands_to", (MessageSource)RuleConstants.messageSource, (Object)(bl ? suppressedString : string));
                    }
                    if (this.type == 7) {
                        object = element.getOwnerDocument().createElementNS(null, "value");
                        if (this.name.length() != 0) {
                            object.setAttributeNS(null, "type", this.name);
                        }
                        XdsUtil.setNodeText((Node)object, string);
                        Object object2 = object;
                        Object var14_27 = null;
                        this.staticContext.tracer.popIndent();
                        return object2;
                    }
                    if (this.type == 2) {
                        object = element.getOwnerDocument().createElementNS(null, "component");
                        object.setAttributeNS(null, "name", this.name);
                        XdsUtil.setNodeText((Node)object, string);
                        Object object3 = object;
                        Object var14_28 = null;
                        this.staticContext.tracer.popIndent();
                        return object3;
                    }
                    object = string;
                    Object var14_29 = null;
                    this.staticContext.tracer.popIndent();
                    return object;
                }
                case 8: {
                    Element element2 = element.getOwnerDocument().createElementNS(null, "value");
                    element2.setAttributeNS(null, "type", "structured");
                    if (this.contents != null) {
                        int n = 0;
                        while (n < this.contents.length) {
                            element2.appendChild((Node)((Arg)this.contents[n]).evaluate(element, ruleDynamicContext));
                            ++n;
                        }
                    }
                    Element element3 = element2;
                    Object var14_30 = null;
                    this.staticContext.tracer.popIndent();
                    return element3;
                }
                case 10: {
                    if (this.contents != null) {
                        this.staticContext.tracer.trace(3, ((Token)this.contents[0]).display);
                        this.staticContext.tracer.pushIndent(1);
                        try {
                            Object object = ((Token)this.contents[0]).expand(element, ruleDynamicContext);
                            Object var12_40 = null;
                            this.staticContext.tracer.popIndent();
                            return object;
                        }
                        finally {
                            Object var14_31 = null;
                            this.staticContext.tracer.popIndent();
                        }
                    }
                    String string = "";
                    Object var14_32 = null;
                    this.staticContext.tracer.popIndent();
                    return string;
                }
            }
            String string = "";
            Object var14_33 = null;
            this.staticContext.tracer.popIndent();
            return string;
        }
        catch (Throwable throwable) {
            Object var14_34 = null;
            this.staticContext.tracer.popIndent();
            throw throwable;
        }
    }

    String describeNodeSet(NodeSet nodeSet) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        Node node = nodeSet.first();
        if (node != null) {
            stringBuffer.append(XPathUtil.describeNode((Node)node));
        }
        while ((node = nodeSet.next()) != null) {
            stringBuffer.append(',');
            stringBuffer.append(XPathUtil.describeNode((Node)node));
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }
}

