/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.io.Base64InputStream;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.event.DSEAttributeValue;
import com.novell.nds.dirxml.engine.event.DSEAttributeValueFactory;
import com.novell.nds.dirxml.engine.rules.IfAssociation;
import com.novell.nds.dirxml.engine.rules.IfDestDn;
import com.novell.nds.dirxml.engine.rules.IfOperation;
import com.novell.nds.dirxml.engine.rules.IfSrcDn;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleContextProvider;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.engine.rules.XPathVariable;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.xml.dom.DOMEvaluator;
import com.novell.xml.dom.DocumentFactory;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathEvaluationException;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

abstract class Condition
implements RuleConstants,
VariableBindings,
RuleContextProvider {
    static final int OP_ASSOCIATED = 0;
    static final int OP_AVAILABLE = 1;
    static final int OP_CHANGING = 2;
    static final int OP_CHANGING_FROM = 3;
    static final int OP_CHANGING_TO = 4;
    static final int OP_EQUAL = 5;
    static final int OP_IN_CONTAINER = 6;
    static final int OP_IN_SUBTREE = 7;
    static final int OP_TRUE = 8;
    static final String[] OP_TABLE = new String[]{"associated", "not-associated", "available", "not-available", "changing", "not-changing", "changing-from", "not-changing-from", "changing-to", "not-changing-to", "equal", "not-equal", "in-container", "not-in-container", "in-subtree", "not-in-subtree", "true", "not-true"};
    static final int MODE_CASE = 0;
    static final int MODE_NOCASE = 1;
    static final int MODE_REGEX = 2;
    static final int MODE_SRC_DN = 3;
    static final int MODE_DEST_DN = 4;
    static final int MODE_NUMERIC = 5;
    static final int MODE_OCTET = 6;
    static final int MODE_STRUCTURED = 7;
    static final String[] MODE_TABLE = new String[]{"case", "nocase", "regex", "src-dn", "dest-dn", "numeric", "octet", "structured"};
    protected RuleStaticContext staticContext;
    protected int op;
    protected int mode;
    protected boolean not;
    protected Object value;
    protected String name = null;
    protected String display;
    protected RuleDynamicContext currentDynamicContext = null;
    protected String location;

    Condition(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        this.staticContext = ruleStaticContext;
        this.location = RuleUtil.getNodeLocation(element);
        this.display = "(" + RuleConstants.displayString.getConditionString(element) + ")";
        this.op = RuleUtil.getAttrIndex(element, "op", -1, OP_TABLE);
        this.not = (this.op & 1) == 1;
        this.op /= 2;
        int n = 1;
        if (this instanceof IfSrcDn) {
            n = 3;
        } else if (this instanceof IfDestDn) {
            n = 4;
        } else if (this instanceof IfOperation || this instanceof IfAssociation) {
            n = 0;
        }
        switch (this.op) {
            case 3: 
            case 4: 
            case 5: {
                this.mode = RuleUtil.getAttrIndex(element, "mode", n, MODE_TABLE);
                break;
            }
            default: {
                this.mode = n;
            }
        }
        this.name = element.getAttributeNS(null, "name");
        switch (this.op) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                String string = XdsUtil.getNodeText(element);
                switch (this.mode) {
                    case 0: 
                    case 1: 
                    case 3: 
                    case 4: {
                        this.value = string;
                        break;
                    }
                    case 2: {
                        try {
                            this.value = Pattern.compile(string, 98);
                            break;
                        }
                        catch (PatternSyntaxException patternSyntaxException) {
                            throw new VRDException(9129, RuleUtil.getNodeLocation(element), string, patternSyntaxException.toString());
                        }
                    }
                    case 5: {
                        try {
                            this.value = Double.valueOf(string);
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new VRDException(9142, RuleUtil.getNodeLocation(element), string, numberFormatException.toString());
                        }
                    }
                    case 6: {
                        try {
                            this.value = Base64InputStream.decode((String)string);
                            break;
                        }
                        catch (IOException iOException) {
                            throw new VRDException(9143, RuleUtil.getNodeLocation(element), string, iOException.toString());
                        }
                    }
                    case 7: {
                        Document document = DocumentFactory.newDocument();
                        Element element2 = document.createElementNS(null, "value");
                        element2.setAttributeNS(null, "type", "structured");
                        int n2 = 0;
                        Node node = element.getFirstChild();
                        while (node != null) {
                            if (node instanceof Text && node.getNodeValue().trim().length() != 0) {
                                throw new VRDException(9141, RuleUtil.getNodeLocation(element), XdsUtil.getNodeText(element), element.getNodeName());
                            }
                            if (node.getNodeType() == 1) {
                                if (node.getNamespaceURI() != null) {
                                    throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), element.getNodeName());
                                }
                                String string2 = node.getLocalName();
                                if (string2.equals("component")) {
                                    Element element3 = XdsUtil.getFirstChildElement((Element)node);
                                    if (element3 != null) {
                                        throw new VRDException(9124, RuleUtil.getNodeLocation(element3), element3.getNodeName(), node.getNodeName());
                                    }
                                    XdsUtil.graftSubtree(element2, node);
                                    String string3 = RuleUtil.getAttrString((Element)node, "name", null);
                                    if (n2 == 0) {
                                        n2 = RuleUtil.guessStructuredSyntaxFromComponentName(string3);
                                    }
                                } else {
                                    throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), element.getNodeName());
                                }
                            }
                            node = node.getNextSibling();
                        }
                        this.value = DSEAttributeValueFactory.createValue(n2, this.name);
                        ((DSEAttributeValue)this.value).fromXML(element2);
                    }
                }
                break;
            }
            case 8: {
                String string = XdsUtil.getNodeText(element);
                try {
                    this.value = new DOMEvaluator(string, (Node)XdsUtil.getFirstAncestorElementByTagNameNS(element, null, "policy"), ruleStaticContext.loader, (VariableBindings)this);
                    break;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new VRDException(9130, RuleUtil.getNodeLocation(element), string, illegalArgumentException.toString());
                }
            }
            case 0: 
            case 1: 
            case 2: {
                if (XdsUtil.getNodeText(element).trim().length() > 0) {
                    throw new VRDException(9141, RuleUtil.getNodeLocation(element), XdsUtil.getNodeText(element), element.getNodeName());
                }
                Element element4 = XdsUtil.getFirstChildElement(element);
                if (element4 == null) break;
                throw new VRDException(9124, RuleUtil.getNodeLocation(element4), element4.getNodeName(), element.getNodeName());
            }
        }
    }

    Condition(RuleStaticContext ruleStaticContext) throws VRDException {
        this.staticContext = ruleStaticContext;
    }

    boolean evaluateCondition(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        boolean bl = false;
        this.currentDynamicContext = ruleDynamicContext;
        int n = 0;
        while (!bl && n < 2) {
            Object[] objectArray = n == 0 ? this.getPrimaryValues(element, ruleDynamicContext) : this.getSecondaryValues(element, ruleDynamicContext);
            if (objectArray != null) {
                int n2 = 0;
                while (!bl && n2 < objectArray.length) {
                    try {
                        block1 : switch (this.op) {
                            case 0: 
                            case 1: 
                            case 2: {
                                bl = true;
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                String string = null;
                                if (this.mode != 7) {
                                    string = objectArray[n2] instanceof Node ? XdsUtil.getNodeText((Node)objectArray[n2]) : objectArray[n2].toString();
                                }
                                switch (this.mode) {
                                    case 0: {
                                        bl = ((String)this.value).equals(string);
                                        break block1;
                                    }
                                    case 1: {
                                        bl = ((String)this.value).equalsIgnoreCase(string);
                                        break block1;
                                    }
                                    case 2: {
                                        bl = ((Pattern)this.value).matcher(string).matches();
                                        break block1;
                                    }
                                    case 3: 
                                    case 4: {
                                        char[] cArray = this.mode == 3 ? this.staticContext.srcDelims : this.staticContext.destDelims;
                                        XdsDN xdsDN = RuleUtil.parseDN(string, cArray);
                                        XdsDN xdsDN2 = RuleUtil.parseDN((String)this.value, cArray);
                                        bl = xdsDN.checkScope(xdsDN2, 2);
                                        break block1;
                                    }
                                    case 5: {
                                        bl = Double.valueOf(string).equals(this.value);
                                        break block1;
                                    }
                                    case 6: {
                                        bl = Arrays.equals((byte[])this.value, Base64InputStream.decode(string));
                                        break block1;
                                    }
                                    case 7: {
                                        bl = ((DSEAttributeValue)this.value).equals((Element)objectArray[n2]);
                                    }
                                }
                                break;
                            }
                            case 6: 
                            case 7: {
                                char[] cArray = this.mode == 3 ? this.staticContext.srcDelims : this.staticContext.destDelims;
                                XdsDN xdsDN = RuleUtil.parseDN(objectArray[n2].toString(), cArray);
                                XdsDN xdsDN3 = RuleUtil.parseDN((String)this.value, cArray);
                                bl = xdsDN.checkScope(xdsDN3, this.op == 6 ? 1 : 0);
                                if (!bl && this instanceof IfSrcDn && !this.staticContext.fromNDS && this.staticContext.driver != null && !this.staticContext.driver.isTrustedDriver() && !xdsDN3.hasTreeName() && xdsDN.hasTreeName()) {
                                    xdsDN3.setHasTreeName(true);
                                    bl = xdsDN.checkScope(xdsDN3, this.op == 6 ? 1 : 0);
                                }
                                if (bl && this instanceof IfSrcDn) {
                                    ruleDynamicContext.unmatchedSrcDnComponentCount = xdsDN.getComponentCount() + (xdsDN.hasTreeName() ? 0 : 1) - (xdsDN3.getComponentCount() + (xdsDN3.hasTreeName() ? 0 : 1));
                                }
                                break;
                            }
                            case 8: {
                                bl = ruleDynamicContext.evaluateXPath((DOMEvaluator)this.value, (Node)objectArray[n2]).getBooleanValue();
                            }
                        }
                    }
                    catch (XPathEvaluationException xPathEvaluationException) {
                        throw new VRDException(9131, this.location, this.display, xPathEvaluationException.toString());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (this.not) {
            bl = !bl;
        }
        this.staticContext.tracer.trace(3, bl ? "rct_condition_true" : "rct_condition_false", (MessageSource)RuleConstants.messageSource, (Object)this.display);
        this.currentDynamicContext = null;
        return bl;
    }

    Object[] getPrimaryValues(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        return null;
    }

    Object[] getSecondaryValues(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        return null;
    }

    public RuleStaticContext getStaticContext() {
        return this.staticContext;
    }

    public RuleDynamicContext getDynamicContext() {
        return this.currentDynamicContext;
    }

    public Expression getVariable(ExpandedQName expandedQName) {
        if (!expandedQName.getNamespaceName().isEmpty()) {
            return null;
        }
        return new XPathVariable(expandedQName.getLocalPart(), this);
    }
}

