/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.rules.Condition;
import com.novell.nds.dirxml.engine.rules.IfAssociation;
import com.novell.nds.dirxml.engine.rules.IfAttr;
import com.novell.nds.dirxml.engine.rules.IfClassName;
import com.novell.nds.dirxml.engine.rules.IfDestAttr;
import com.novell.nds.dirxml.engine.rules.IfDestDn;
import com.novell.nds.dirxml.engine.rules.IfEntitlement;
import com.novell.nds.dirxml.engine.rules.IfGlobalVariable;
import com.novell.nds.dirxml.engine.rules.IfLocalVariable;
import com.novell.nds.dirxml.engine.rules.IfNamedPassword;
import com.novell.nds.dirxml.engine.rules.IfOpAttr;
import com.novell.nds.dirxml.engine.rules.IfOpProperty;
import com.novell.nds.dirxml.engine.rules.IfOperation;
import com.novell.nds.dirxml.engine.rules.IfPassword;
import com.novell.nds.dirxml.engine.rules.IfSrcAttr;
import com.novell.nds.dirxml.engine.rules.IfSrcDn;
import com.novell.nds.dirxml.engine.rules.IfXpath;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class ConditionSet
extends Condition
implements RuleConstants {
    private int operator;
    private Condition[] conditions;

    private ConditionSet(Element element, int n, RuleStaticContext ruleStaticContext) throws VRDException {
        super(ruleStaticContext);
        this.operator = n;
        ArrayList<IfAssociation> arrayList = new ArrayList<IfAssociation>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && !RuleUtil.getAttrBoolean((Element)node, "disabled", false)) {
                Condition condition;
                if (node.getNamespaceURI() != null) {
                    throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), element.getNodeName());
                }
                String string = node.getLocalName();
                if (string.equals("if-association")) {
                    condition = new IfAssociation((Element)node, ruleStaticContext);
                } else if (string.equals("if-attr")) {
                    condition = new IfAttr((Element)node, ruleStaticContext);
                } else if (string.equals("if-class-name")) {
                    condition = new IfClassName((Element)node, ruleStaticContext);
                } else if (string.equals("if-dest-attr")) {
                    condition = new IfDestAttr((Element)node, ruleStaticContext);
                } else if (string.equals("if-dest-dn")) {
                    condition = new IfDestDn((Element)node, ruleStaticContext);
                } else if (string.equals("if-entitlement")) {
                    condition = new IfEntitlement((Element)node, ruleStaticContext);
                } else if (string.equals("if-global-variable")) {
                    condition = new IfGlobalVariable((Element)node, ruleStaticContext);
                } else if (string.equals("if-local-variable")) {
                    condition = new IfLocalVariable((Element)node, ruleStaticContext);
                } else if (string.equals("if-named-password")) {
                    condition = new IfNamedPassword((Element)node, ruleStaticContext);
                } else if (string.equals("if-op-attr")) {
                    condition = new IfOpAttr((Element)node, ruleStaticContext);
                } else if (string.equals("if-op-property")) {
                    condition = new IfOpProperty((Element)node, ruleStaticContext);
                } else if (string.equals("if-operation")) {
                    condition = new IfOperation((Element)node, ruleStaticContext);
                } else if (string.equals("if-password")) {
                    condition = new IfPassword((Element)node, ruleStaticContext);
                } else if (string.equals("if-src-attr")) {
                    condition = new IfSrcAttr((Element)node, ruleStaticContext);
                } else if (string.equals("if-src-dn")) {
                    condition = new IfSrcDn((Element)node, ruleStaticContext);
                } else if (string.equals("if-xpath")) {
                    condition = new IfXpath((Element)node, ruleStaticContext);
                } else {
                    throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), element.getNodeName());
                }
                arrayList.add((IfAssociation)condition);
            }
            node = node.getNextSibling();
        }
        this.conditions = arrayList.toArray(new Condition[arrayList.size()]);
    }

    ConditionSet(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        super(ruleStaticContext);
        this.operator = 0;
        ArrayList<ConditionSet> arrayList = new ArrayList<ConditionSet>();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1 && !RuleUtil.getAttrBoolean((Element)node, "disabled", false)) {
                if (node.getNamespaceURI() != null) {
                    throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), "conditions");
                }
                String string = node.getLocalName();
                if (string.equals("and")) {
                    if (arrayList.size() == 0) {
                        this.operator = 1;
                    } else if (this.operator != 1) {
                        throw new VRDException(9125, RuleUtil.getNodeLocation(node), "and", "or");
                    }
                    arrayList.add(new ConditionSet((Element)node, 0, ruleStaticContext));
                } else if (string.equals("or")) {
                    if (arrayList.size() == 0) {
                        this.operator = 0;
                    } else if (this.operator != 0) {
                        throw new VRDException(9125, RuleUtil.getNodeLocation(node), "and", "or");
                    }
                    arrayList.add(new ConditionSet((Element)node, 1, ruleStaticContext));
                } else {
                    throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), "conditions");
                }
            }
            node = node.getNextSibling();
        }
        this.conditions = arrayList.toArray(new Condition[arrayList.size()]);
    }

    boolean evaluateCondition(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        int n = this.conditions.length;
        if (n == 0) {
            return true;
        }
        if (this.operator == 1) {
            int n2 = 0;
            while (n2 < n) {
                if (this.conditions[n2].evaluateCondition(element, ruleDynamicContext)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if (this.operator == 0) {
            int n3 = 0;
            while (n3 < n) {
                if (!this.conditions[n3].evaluateCondition(element, ruleDynamicContext)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        return false;
    }
}

