/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.driver.XmlDocument;
import com.novell.nds.dirxml.engine.ConfigAbstraction;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.ThreadGroupVars;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.ActionSet;
import com.novell.nds.dirxml.engine.rules.ConditionSet;
import com.novell.nds.dirxml.engine.rules.DNConverterImpl;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleProcessor;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.xml.dom.DOMUtil;
import com.novell.xml.dom.NodeImpl;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DirXMLScriptProcessor
implements RuleProcessor,
RuleConstants {
    private static DNConverterImpl dnConverter = new DNConverterImpl();
    protected RuleStaticContext staticContext;
    protected Rule[] rules;
    protected RuleProcessor nextRule = null;
    protected String policyDescription = null;

    public DirXMLScriptProcessor(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        Object object;
        Object object2;
        this.staticContext = ruleStaticContext;
        ArrayList<Rule> arrayList = new ArrayList<Rule>();
        TreeSet treeSet = new TreeSet();
        Stack stack = new Stack();
        int n = 0;
        if (element.getNamespaceURI() != null || !element.getLocalName().equals("policy")) {
            throw new VRDException(9127, RuleUtil.getNodeLocation(element), (Object)"policy");
        }
        Node node = element.getFirstChild();
        while (node != null) {
            if (node.getNodeType() == 1) {
                if (node.getNamespaceURI() != null) {
                    throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), "policy");
                }
                object2 = node.getLocalName();
                if (((String)object2).equals("description")) {
                    if (this.policyDescription != null) {
                        throw new VRDException(9126, RuleUtil.getNodeLocation(node), (Object)node.getNodeName());
                    }
                    if (arrayList.size() != 0) {
                        throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), "policy");
                    }
                    object = XdsUtil.getNodeText(node);
                    if (((String)object).length() != 0) {
                        this.policyDescription = "'" + (String)object + "'";
                    }
                } else if (((String)object2).equals("rule")) {
                    if (!RuleUtil.getAttrBoolean((Element)node, "disabled", false)) {
                        arrayList.add(new Rule((Element)node, n++));
                    }
                } else if (((String)object2).equals("include")) {
                    if (!RuleUtil.getAttrBoolean((Element)node, "disabled", false)) {
                        if (stack.size() > 100) {
                            throw new VRDException(9178, RuleUtil.getNodeLocation(node), (Object)node.getNodeName());
                        }
                        stack.push(new TreeSet(treeSet));
                        element.insertBefore(element.getOwnerDocument().createElementNS(null, "pop_include"), node.getNextSibling());
                        this.includePolicy((Element)node, treeSet);
                    }
                } else if (((String)object2).equals("pop_include") && !stack.empty()) {
                    treeSet = (TreeSet)stack.pop();
                } else {
                    throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), "policy");
                }
            }
            node = node.getNextSibling();
        }
        if (this.policyDescription == null && element instanceof NodeImpl) {
            this.policyDescription = ((NodeImpl)element).getBaseURI();
            if (this.policyDescription != null && this.policyDescription.length() > 0 && ((Matcher)(object = ((Pattern)(object2 = Pattern.compile("^.*?([^/\\#]+)(#XmlData)?$"))).matcher(this.policyDescription))).matches()) {
                this.policyDescription = ((Matcher)object).replaceFirst("$1");
            }
        }
        if (this.policyDescription == null) {
            this.policyDescription = "";
        }
        this.rules = arrayList.toArray(new Rule[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document applyRules(Document document, RuleDynamicContext ruleDynamicContext) throws VRDException {
        this.staticContext.tracer.trace(3, "rct_applying_rules", (MessageSource)RuleConstants.messageSource, (Object)this.policyDescription);
        this.staticContext.tracer.pushIndent(1);
        boolean bl = ruleDynamicContext.forceDirect;
        try {
            Element element;
            block35: {
                block36: {
                    element = document.getDocumentElement();
                    if (element == null) break block35;
                    if (element.getNamespaceURI() != null) break block36;
                    if (element.getLocalName().equals("nds")) {
                        Element element2 = XdsUtil.getFirstElementByTagNameNS(element, null, "input");
                        element = element2 != null ? element2 : XdsUtil.getFirstElementByTagNameNS(element, null, "output");
                        break block35;
                    } else if (!element.getLocalName().equals("input") && !element.getLocalName().equals("output")) {
                        element = null;
                    }
                    break block35;
                }
                element = null;
            }
            if (element != null) {
                Element[] elementArray = XdsUtil.getChildElements(element);
                Element element3 = (Element)element.cloneNode(false);
                ruleDynamicContext.sandBoxFragment = document.createDocumentFragment();
                if (element != document.getDocumentElement()) {
                    Element element4 = (Element)document.getDocumentElement().cloneNode(false);
                    element4.appendChild(element3);
                    ruleDynamicContext.sandBoxFragment.appendChild(element4);
                } else {
                    ruleDynamicContext.sandBoxFragment.appendChild(element3);
                }
                ruleDynamicContext.sandBoxFragment.appendChild(document.createTextNode(""));
                if (element.getLocalName().equals("output")) {
                    ruleDynamicContext.forceDirect = true;
                }
                int n = 0;
                block6: while (true) {
                    Element[] elementArray2;
                    Document document2;
                    Object object;
                    int n2;
                    block34: {
                        String string;
                        int n3;
                        Throwable throwable3;
                        Node node;
                        block33: {
                            Object var15_17;
                            if (n >= elementArray.length) {
                                break;
                            }
                            this.staticContext.tracer.trace(3, "rct_applying_to", (MessageSource)RuleConstants.messageSource, (Object)elementArray[n].getNodeName(), (Object)new Integer(n + 1));
                            this.staticContext.tracer.pushIndent(1);
                            node = elementArray[n].getNextSibling();
                            element3.appendChild(elementArray[n]);
                            try {
                                ruleDynamicContext.localVariables = new TreeMap();
                                ruleDynamicContext.localVariables.put("fromNds", new Boolean(this.staticContext.fromNDS));
                                ruleDynamicContext.localVariables.put("srcQueryProcessor", ruleDynamicContext.srcQueryProcessor);
                                ruleDynamicContext.localVariables.put("destQueryProcessor", ruleDynamicContext.destQueryProcessor);
                                ruleDynamicContext.localVariables.put("srcCommandProcessor", ruleDynamicContext.srcCommandProcessor);
                                ruleDynamicContext.localVariables.put("destCommandProcessor", ruleDynamicContext.destCommandProcessor);
                                ruleDynamicContext.localVariables.put("dnConverter", dnConverter);
                                n2 = 0;
                                while (true) {
                                    if (n2 >= this.rules.length) {
                                        break;
                                    }
                                    ruleDynamicContext.unmatchedSrcDnComponentCount = -1;
                                    object = this.rules[n2];
                                    if (((Rule)object).evaluateConditions(elementArray[n], ruleDynamicContext)) {
                                        this.staticContext.tracer.trace(3, "rct_applying_rule", (MessageSource)RuleConstants.messageSource, (Object)((Rule)object).description);
                                        this.staticContext.tracer.pushIndent(1);
                                        try {
                                            if (((Rule)object).actions.apply(elementArray[n], ruleDynamicContext)) {
                                                document2 = null;
                                                this.staticContext.tracer.popIndent();
                                                break;
                                            }
                                            document2 = null;
                                            this.staticContext.tracer.popIndent();
                                        }
                                        catch (Throwable throwable2) {
                                            document2 = null;
                                            this.staticContext.tracer.popIndent();
                                            throw throwable2;
                                        }
                                    }
                                    ++n2;
                                }
                                var15_17 = null;
                            }
                            catch (Throwable throwable3) {
                                var15_17 = null;
                                elementArray2 = XdsUtil.getChildElements(element3);
                                n3 = 0;
                                break block33;
                            }
                            elementArray2 = XdsUtil.getChildElements(element3);
                            n3 = 0;
                            while (true) {
                                if (n3 < elementArray2.length) {
                                    string = elementArray2[n3].getAttributeNS(null, "direct");
                                    if (string.length() == 0) {
                                        element.insertBefore(elementArray2[n3], node);
                                        elementArray2[n3] = null;
                                    } else {
                                        element3.removeChild(elementArray2[n3]);
                                    }
                                    ++n3;
                                    continue;
                                }
                                break block34;
                                break;
                            }
                        }
                        while (true) {
                            if (n3 >= elementArray2.length) {
                                ruleDynamicContext.localVariables = null;
                                this.staticContext.tracer.popIndent();
                                throw throwable3;
                            }
                            string = elementArray2[n3].getAttributeNS(null, "direct");
                            if (string.length() == 0) {
                                element.insertBefore(elementArray2[n3], node);
                                elementArray2[n3] = null;
                            } else {
                                element3.removeChild(elementArray2[n3]);
                            }
                            ++n3;
                        }
                    }
                    ruleDynamicContext.localVariables = null;
                    this.staticContext.tracer.popIndent();
                    n2 = 0;
                    while (true) {
                        if (n2 >= elementArray2.length) {
                            ++n;
                            continue block6;
                        }
                        if (elementArray2[n2] != null) {
                            object = elementArray2[n2].getAttributeNS(null, "direct");
                            elementArray2[n2].removeAttributeNS(null, "direct");
                            Element element5 = NdsDtd.createDoc("input");
                            document2 = element5.getOwnerDocument();
                            element5.appendChild(document2.importNode(elementArray2[n2], true));
                            DOMUtil.addNamespaceDecls((Node)elementArray2[n2]);
                            if (((String)object).equals("src")) {
                                ruleDynamicContext.srcCommandProcessor.execute(document2);
                            } else {
                                ruleDynamicContext.destCommandProcessor.execute(document2);
                            }
                        }
                        ++n2;
                    }
                    break;
                }
            }
            Object var19_21 = null;
            this.staticContext.tracer.popIndent();
            ruleDynamicContext.sandBoxFragment = null;
            ruleDynamicContext.forceDirect = bl;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            this.staticContext.tracer.popIndent();
            ruleDynamicContext.sandBoxFragment = null;
            ruleDynamicContext.forceDirect = bl;
            throw throwable;
        }
        if (this.staticContext.tracer.getLevel() >= 3) {
            this.staticContext.tracer.trace("rct_rulret", (MessageSource)RuleConstants.messageSource);
            this.staticContext.tracer.trace(document);
        }
        if (this.nextRule == null) return document;
        return this.nextRule.applyRules(document, ruleDynamicContext);
    }

    public void setNextRule(RuleProcessor ruleProcessor) {
        this.nextRule = ruleProcessor;
    }

    public void includePolicy(Element element, TreeSet treeSet) throws VRDException {
        Element element2;
        Serializable serializable;
        String string;
        URL uRL;
        URL uRL2;
        ConfigAbstraction configAbstraction;
        String string2;
        block27: {
            string2 = RuleUtil.getAttrString(element, "name", null);
            configAbstraction = (ConfigAbstraction)ThreadGroupVars.get("registry");
            uRL2 = null;
            uRL = null;
            if (element instanceof NodeImpl && (string = ((NodeImpl)element).getBaseURI()) != null && string.length() != 0) {
                try {
                    treeSet.add(string);
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                if (uRL2 != null || string2.charAt(0) == '\\') break block27;
                throw new VRDException(9128, RuleUtil.getNodeLocation(element), string2, "name", element.getNodeName());
            }
        }
        if (uRL == null) {
            try {
                if (string2.charAt(0) == '\\') {
                    string = new XdsDN(string2, "00.\\+=*'".toCharArray());
                    if (configAbstraction != null) {
                        string.setTreeName(configAbstraction.getTreeName());
                    }
                    serializable = new StringBuffer(128);
                    ((StringBuffer)serializable).append("vnd.nds.stream:/");
                    ((StringBuffer)serializable).append(string.getDN("00./+=*\\".toCharArray()));
                    ((StringBuffer)serializable).append("#XmlData");
                    uRL = new URL(((StringBuffer)serializable).toString());
                } else if (uRL2.getProtocol().equals("vnd.nds.stream")) {
                    string = new XdsDN(string2, "00.\\+=*'".toCharArray());
                    serializable = new StringBuffer(128);
                    ((StringBuffer)serializable).append(string.getDN("00./+=*\\".toCharArray()));
                    ((StringBuffer)serializable).append("#XmlData");
                    uRL = new URL(uRL2, ((StringBuffer)serializable).toString());
                } else {
                    uRL = new URL(uRL2, string2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                throw new VRDException(9128, RuleUtil.getNodeLocation(element), string2, "name", element.getNodeName());
            }
        }
        if (treeSet.contains(string = uRL.toString())) {
            throw new VRDException(9176, RuleUtil.getNodeLocation(element), (Object)string);
        }
        treeSet.add(string);
        serializable = new XmlDocument();
        try {
            ((XmlDocument)serializable).readDocument(uRL);
        }
        catch (IOException iOException) {
            throw new VRDException(9177, RuleUtil.getNodeLocation(element), string, iOException.toString());
        }
        Document document = ((XmlDocument)serializable).getDocument();
        if (document == null) {
            throw new VRDException(9013, ((XmlDocument)serializable).getParserErrorMsgString());
        }
        if (document instanceof NodeImpl) {
            ((NodeImpl)document).setBaseURI(string);
        }
        if (configAbstraction != null) {
            try {
                document = configAbstraction.processDocument(document);
            }
            catch (VRDException vRDException) {
                throw vRDException;
            }
            catch (Exception exception) {
                throw new VRDException(exception);
            }
        }
        if ((element2 = document.getDocumentElement()).getNamespaceURI() != null || !element2.getLocalName().equals("policy")) {
            throw new VRDException(9127, RuleUtil.getNodeLocation(element2), (Object)"policy");
        }
        Node node = element.getNextSibling();
        Node node2 = element.getParentNode();
        Document document2 = element.getOwnerDocument();
        Node node3 = element2.getFirstChild();
        while (node3 != null) {
            if (node3.getNodeType() == 1) {
                if (node3.getNamespaceURI() != null) {
                    throw new VRDException(9124, RuleUtil.getNodeLocation(node3), node3.getNodeName(), "policy");
                }
                String string3 = node3.getLocalName();
                if (!string3.equals("description")) {
                    node2.insertBefore(document2.importNode(node3, true), node);
                }
            }
            node3 = node3.getNextSibling();
        }
    }

    protected class Rule {
        ConditionSet conditions = null;
        ActionSet actions = null;
        int ordinal;
        String description = null;

        protected Rule(Element element, int n) throws VRDException {
            this.ordinal = n;
            Node node = element.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == 1) {
                    if (node.getNamespaceURI() != null) {
                        throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), "policy");
                    }
                    String string = node.getLocalName();
                    if (string.equals("description")) {
                        if (this.description != null) {
                            throw new VRDException(9126, RuleUtil.getNodeLocation(node), (Object)node.getNodeName());
                        }
                        if (this.conditions != null || this.actions != null) {
                            throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), "rule");
                        }
                        String string2 = XdsUtil.getNodeText(node);
                        if (string2.length() != 0) {
                            this.description = "'" + string2 + "'";
                        }
                    } else if (!string.equals("comment")) {
                        if (string.equals("conditions")) {
                            if (this.conditions != null) {
                                throw new VRDException(9126, RuleUtil.getNodeLocation(node), (Object)node.getNodeName());
                            }
                            if (this.actions != null) {
                                throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), "rule");
                            }
                            this.conditions = new ConditionSet((Element)node, DirXMLScriptProcessor.this.staticContext);
                        } else if (string.equals("actions")) {
                            if (this.actions != null) {
                                throw new VRDException(9126, RuleUtil.getNodeLocation(node), (Object)node.getNodeName());
                            }
                            this.actions = new ActionSet((Element)node, DirXMLScriptProcessor.this.staticContext);
                        } else {
                            throw new VRDException(9124, RuleUtil.getNodeLocation(node), node.getNodeName(), "rule");
                        }
                    }
                }
                node = node.getNextSibling();
            }
            if (this.description == null) {
                this.description = "#" + (n + 1);
            }
            if (this.conditions == null) {
                throw new VRDException(9127, RuleUtil.getNodeLocation(element), (Object)"conditions");
            }
            if (this.actions == null) {
                throw new VRDException(9127, RuleUtil.getNodeLocation(element), (Object)"actions");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean evaluateConditions(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
            boolean bl = true;
            DirXMLScriptProcessor.this.staticContext.tracer.trace(3, "rct_eval_select", (MessageSource)RuleConstants.messageSource, (Object)this.description);
            DirXMLScriptProcessor.this.staticContext.tracer.pushIndent(1);
            try {
                bl = this.conditions.evaluateCondition(element, ruleDynamicContext);
                Object var5_4 = null;
                DirXMLScriptProcessor.this.staticContext.tracer.popIndent();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                DirXMLScriptProcessor.this.staticContext.tracer.popIndent();
                throw throwable;
            }
            if (DirXMLScriptProcessor.this.staticContext.tracer.getLevel() >= 3) {
                if (bl) {
                    DirXMLScriptProcessor.this.staticContext.tracer.trace("rct_rule_selected", (MessageSource)RuleConstants.messageSource);
                } else {
                    DirXMLScriptProcessor.this.staticContext.tracer.trace("rct_rule_rejected", (MessageSource)RuleConstants.messageSource);
                }
            }
            return bl;
        }
    }
}

