/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.driver.XdsQueryProcessor;
import com.novell.nds.dirxml.engine.DirXML;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.PersistentLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.Action;
import com.novell.nds.dirxml.engine.rules.Arg;
import com.novell.nds.dirxml.engine.rules.RuleConstants;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.mail.SMTPPassword;
import com.novell.nds.dirxml.util.mail.SendMail;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Hashtable;
import novell.jclient.JCCEstringValue;
import novell.jclient.JCCIstringValue;
import novell.jclient.JCContext;
import novell.jclient.JCReadFilter;
import novell.jclient.JCValue;
import novell.jclient.JClient;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class DoSendEmailFromTemplate
extends Action {
    private Arg[] args = null;
    private String sNotificationDN;
    private String sTemplateDN;
    private String sServer = null;
    private String sUserID = null;
    private String sPassword = null;
    private String sSubject = null;
    private String sMessage = null;
    private String sFromAddress = null;
    private boolean bHtml = false;
    private static final String SMTP_FROM_ATTR = "notfSMTPEmailFrom";
    private static final String SMTP_SERVER_ATTR = "notfSMTPEmailHost";
    private static final String SMTP_USER_ATTR = "notfSMTPEmailUserName";
    private static final String SUBJECT_ATTR = "notfMergeTemplateSubject";
    private static final String MESSAGE_ATTR = "notfMergeTemplateData";
    private static final int TYPE_CI_STRING = 0;
    private static final int TYPE_CE_STRING = 1;
    static String toMsg = RuleConstants.messageSource.getMessageString("rct_noemailto");
    static String srvrMsg = RuleConstants.messageSource.getMessageString("rct_nosmtpsrvr");

    protected DoSendEmailFromTemplate(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        super(element, ruleStaticContext);
        this.sNotificationDN = RuleUtil.getAttrString(element, "notification-dn", null);
        this.sTemplateDN = RuleUtil.getAttrString(element, "template-dn", null);
        this.sPassword = RuleUtil.getAttrString(element, "password", "");
        this.sPassword = this.sPassword.length() == 0 ? null : SMTPPassword.decode((String)this.sPassword);
        this.args = Arg.getArgs(element, ruleStaticContext);
        if (this.args != null) {
            int n = 0;
            while (n < this.args.length) {
                String string = this.args[n].getName();
                if (this.args[n].getType() != 6 || string.length() == 0) {
                    throw new VRDException(9124, this.args[n].location, this.args[n].getTypeElementName(), element.getNodeName());
                }
                ++n;
            }
        }
    }

    boolean apply(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        SendMail.EmailAddress[] emailAddressArray;
        String string = null;
        String string2 = null;
        int n = 0;
        String string3 = null;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.readNotificationAttrs(ruleDynamicContext);
        this.readTemplateAttrs(ruleDynamicContext);
        if (this.sServer == null || this.sServer.length() == 0) {
            if (!DirXML.isExternal()) {
                PersistentLog.logEvent(39, 5, null, 0L, "DoSendEmailFromTemplate", srvrMsg, null, null, 0L, 0L);
            }
            if (this.staticContext.tracer.getLevel() >= 3) {
                this.staticContext.tracer.trace("rct_nosmtpsrvr", (MessageSource)RuleConstants.messageSource);
            }
            return false;
        }
        if (this.sMessage != null) {
            emailAddressArray = new StringReader(this.sMessage);
            XMLParser xMLParser = XMLParserFactory.newParser();
            Document document = xMLParser.parse((Reader)emailAddressArray);
            this.bHtml = false;
            if (!xMLParser.anyErrors() && document.getDocumentElement().getNodeName().equalsIgnoreCase("html")) {
                this.bHtml = true;
            }
        }
        if (this.args != null) {
            n = this.args.length;
        }
        emailAddressArray = new SendMail.EmailAddress[n + 1];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            String string4 = this.args[n2].getName();
            if (string4 != null) {
                String string5;
                if (string4.equalsIgnoreCase("to")) {
                    string5 = this.args[n2].evaluate(element, ruleDynamicContext).toString();
                    if (string5 != null && string5.length() != 0) {
                        string = string5;
                        emailAddressArray[n3++] = new SendMail.EmailAddress(string, 0);
                    }
                } else if (string4.equalsIgnoreCase("cc")) {
                    string5 = this.args[n2].evaluate(element, ruleDynamicContext).toString();
                    if (string5 != null && string5.length() != 0) {
                        emailAddressArray[n3++] = new SendMail.EmailAddress(string5, 1);
                    }
                } else if (string4.equalsIgnoreCase("bcc")) {
                    string5 = this.args[n2].evaluate(element, ruleDynamicContext).toString();
                    if (string5 != null && string5.length() != 0) {
                        emailAddressArray[n3++] = new SendMail.EmailAddress(string5, 2);
                    }
                } else if (string4.equalsIgnoreCase("reply-to")) {
                    string2 = this.args[n2].evaluate(element, ruleDynamicContext).toString();
                } else if (string4.equalsIgnoreCase("encoding")) {
                    string3 = this.args[n2].evaluate(element, ruleDynamicContext).toString();
                } else {
                    string5 = this.args[n2].evaluate(element, ruleDynamicContext).toString();
                    hashtable.put(string4, string5);
                }
            }
            ++n2;
        }
        if (string == null || string.length() == 0) {
            if (!DirXML.isExternal()) {
                PersistentLog.logEvent(39, 5, null, 0L, "DoSendEmailFromTemplate", toMsg, null, null, 0L, 0L);
            }
            if (this.staticContext.tracer.getLevel() >= 3) {
                this.staticContext.tracer.trace("rct_noemailto", (MessageSource)RuleConstants.messageSource);
            }
            return false;
        }
        if (this.sSubject == null) {
            this.sSubject = "";
        }
        if (this.sMessage == null) {
            this.sMessage = "";
        }
        SendMail.generateEMailFromTemplate((String)this.sFromAddress, string2, (SendMail.EmailAddress[])emailAddressArray, (String)this.sSubject, (String)this.sMessage, (String)this.sServer, (String)this.sUserID, (String)this.sPassword, string3, hashtable, (boolean)this.bHtml);
        return false;
    }

    void readNotificationAttrs(RuleDynamicContext ruleDynamicContext) {
        String[] stringArray = new String[]{SMTP_SERVER_ATTR, SMTP_USER_ATTR, SMTP_FROM_ATTR};
        HashMap hashMap = this.readObjectStringAttrs(ruleDynamicContext, this.sNotificationDN, stringArray, 0);
        this.sServer = (String)hashMap.get(SMTP_SERVER_ATTR);
        this.sUserID = (String)hashMap.get(SMTP_USER_ATTR);
        this.sFromAddress = (String)hashMap.get(SMTP_FROM_ATTR);
        if (this.sServer == null || this.sServer.length() == 0) {
            this.staticContext.tracer.trace("rct_nosmtpsrvr", (MessageSource)RuleConstants.messageSource);
        }
    }

    void readTemplateAttrs(RuleDynamicContext ruleDynamicContext) {
        String[] stringArray = new String[]{SUBJECT_ATTR, MESSAGE_ATTR};
        HashMap hashMap = this.readObjectStringAttrs(ruleDynamicContext, this.sTemplateDN, stringArray, 1);
        this.sSubject = (String)hashMap.get(SUBJECT_ATTR);
        this.sMessage = (String)hashMap.get(MESSAGE_ATTR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HashMap readObjectStringAttrs(RuleDynamicContext ruleDynamicContext, String string, String[] stringArray, int n) {
        JCContext jCContext;
        HashMap<String, String> hashMap;
        block22: {
            block24: {
                hashMap = new HashMap<String, String>();
                if (!DirXML.isExternal()) break block24;
                StringBuffer stringBuffer = new StringBuffer();
                int n2 = 0;
                while (true) {
                    block25: {
                        if (n2 < stringArray.length) break block25;
                    }
                    if (n2 > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(stringArray[n2]);
                    ++n2;
                }
                XdsQueryProcessor xdsQueryProcessor = this.staticContext.fromNDS ? ruleDynamicContext.srcQueryProcessor : ruleDynamicContext.destQueryProcessor;
                Element element = null;
                try {
                    element = xdsQueryProcessor.readObject(null, string, "", stringBuffer.toString());
                }
                catch (VRDException vRDException) {
                    // empty catch block
                }
                if (element == null) return hashMap;
                n2 = 0;
                while (true) {
                    if (n2 >= stringArray.length) {
                        return hashMap;
                    }
                    Element[] elementArray = RuleUtil.getValues(element, stringArray[n2], 5);
                    if (elementArray != null) {
                        hashMap.put(stringArray[n2], XdsUtil.getNodeText(elementArray[0]));
                    }
                    ++n2;
                }
            }
            JCContext jCContext2 = null;
            jCContext = null;
            try {
                try {
                    String string2 = MiscDS.getTreeName();
                    jCContext2 = new JCContext(0, string2, "00.\\+=*'");
                    jCContext = MiscDS.createLocalContext();
                    jCContext2.connect(0L, jCContext.getServerReferral());
                    String string3 = string;
                    if (string.startsWith("\\cn=")) {
                        string3 = string.substring(1);
                    }
                    String string4 = jCContext2.standardizeDN(string3, null);
                    try {
                        jCContext2.loginAsServer();
                    }
                    catch (Throwable throwable) {
                        jCContext2.setLocal(0);
                    }
                    jCContext2.resolve(2, string4);
                    jCContext2.authenticate();
                    int n3 = 0;
                    while (n3 < stringArray.length) {
                        block21: {
                            String[] stringArray2 = new String[]{stringArray[n3]};
                            JCReadFilter jCReadFilter = new JCReadFilter();
                            jCReadFilter.attributeNames = stringArray2;
                            JCValue[] jCValueArray = null;
                            try {
                                jCValueArray = JClient.readEntry((JCContext)jCContext2, (long)1L, (JCReadFilter)jCReadFilter);
                            }
                            catch (Throwable throwable) {
                                break block21;
                            }
                            if (jCValueArray != null && jCValueArray.length != 0) {
                                String string5 = n == 1 ? ((JCCEstringValue)jCValueArray[0]).getString() : ((JCCIstringValue)jCValueArray[0]).getString();
                                hashMap.put(jCValueArray[0].attributeName, string5);
                            }
                        }
                        ++n3;
                    }
                }
                catch (Throwable throwable) {
                    this.staticContext.tracer.trace("Unable to read Email Notification attributes");
                    Object var17_26 = null;
                    if (jCContext2 != null) {
                        jCContext2.free();
                    }
                    if (jCContext == null) return hashMap;
                    jCContext.free();
                    return hashMap;
                }
                Object var17_25 = null;
                if (jCContext2 == null) break block22;
            }
            catch (Throwable throwable) {
                Object var17_27 = null;
                if (jCContext2 != null) {
                    jCContext2.free();
                }
                if (jCContext == null) throw throwable;
                jCContext.free();
                throw throwable;
            }
            jCContext2.free();
        }
        if (jCContext == null) return hashMap;
        jCContext.free();
        return hashMap;
    }
}

