/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.rules.Action;
import com.novell.nds.dirxml.engine.rules.RuleContextProvider;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.engine.rules.XPathVariable;
import com.novell.xml.dom.DOMEvaluator;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.NodeSet;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathEvaluationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class DoStripXPath
extends Action
implements VariableBindings,
RuleContextProvider {
    private String expressionString;
    private DOMEvaluator expression;
    private RuleDynamicContext currentDynamicContext;

    protected DoStripXPath(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        super(element, ruleStaticContext);
        this.expressionString = RuleUtil.getAttrString(element, "expression", null);
        try {
            this.expression = new DOMEvaluator(this.expressionString, (Node)XdsUtil.getFirstAncestorElementByTagNameNS(element, null, "policy"), ruleStaticContext.loader, (VariableBindings)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new VRDException(9130, this.location, this.expressionString, illegalArgumentException.toString());
        }
    }

    boolean apply(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        this.currentDynamicContext = ruleDynamicContext;
        try {
            NodeSet nodeSet = ruleDynamicContext.evaluateXPath(this.expression, element).getNodeSetValue();
            Node node = nodeSet.first();
            while (node != null) {
                if (node.getOwnerDocument() == element.getOwnerDocument()) {
                    Node node2 = node.getParentNode();
                    if (node.getNodeType() == 2) {
                        Element element2 = ((Attr)node).getOwnerElement();
                        if (element2 != null) {
                            element2.removeAttributeNode((Attr)node);
                        }
                    } else if (node2 != null) {
                        node2.removeChild(node);
                    }
                }
                node = nodeSet.next();
            }
        }
        catch (XPathEvaluationException xPathEvaluationException) {
            throw new VRDException(9131, this.location, this.display, xPathEvaluationException.toString());
        }
        return false;
    }

    public RuleStaticContext getStaticContext() {
        return this.staticContext;
    }

    public RuleDynamicContext getDynamicContext() {
        return this.currentDynamicContext;
    }

    public Expression getVariable(ExpandedQName expandedQName) {
        if (!expandedQName.getNamespaceName().isEmpty()) {
            return null;
        }
        return new XPathVariable(expandedQName.getLocalPart(), this);
    }
}

