/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.rules.Action;
import com.novell.nds.dirxml.engine.rules.Arg;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import org.w3c.dom.Element;

class DoTraceMessage
extends Action {
    private Arg argString = null;
    private int level;
    private int color;
    private static final String[] COLOR_TABLE = new String[]{"black", "blue", "green", "cyan", "red", "purple", "brown", "grey", "drgrey", "brblue", "brgreen", "brcyan", "brred", "brpurple", "yellow", "white"};

    protected DoTraceMessage(Element element, RuleStaticContext ruleStaticContext) throws VRDException {
        super(element, ruleStaticContext);
        this.level = RuleUtil.getAttrInt(element, "level", 0, false, 0, Integer.MAX_VALUE);
        this.color = RuleUtil.getAttrIndex(element, "color", 13, COLOR_TABLE);
        Arg[] argArray = Arg.getArgs(element, ruleStaticContext);
        if (argArray == null || argArray.length == 0) {
            throw new VRDException(9127, this.location, (Object)"arg-string");
        }
        int n = 0;
        while (n < argArray.length) {
            if (n > 0) {
                throw new VRDException(9124, argArray[n].location, argArray[n].getTypeElementName(), element.getNodeName());
            }
            switch (argArray[n].getType()) {
                case 6: {
                    this.argString = argArray[n];
                    break;
                }
                default: {
                    throw new VRDException(9124, argArray[n].location, argArray[n].getTypeElementName(), element.getNodeName());
                }
            }
            ++n;
        }
        if (this.argString == null) {
            throw new VRDException(9127, this.location, (Object)"arg-string");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean apply(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        if (this.staticContext.tracer.getLevel() >= this.level) {
            String string = this.argString.evaluate(element, ruleDynamicContext).toString();
            this.staticContext.tracer.pushIndent(-this.staticContext.tracer.getIndent());
            try {
                this.staticContext.tracer.pushColorAlways(this.color);
                try {
                    this.staticContext.tracer.trace(this.level, string);
                    Object var5_4 = null;
                    this.staticContext.tracer.popColorAlways();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    this.staticContext.tracer.popColorAlways();
                    throw throwable;
                }
                Object var7_7 = null;
                this.staticContext.tracer.popIndent();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.staticContext.tracer.popIndent();
                throw throwable;
            }
        }
        return false;
    }
}

