/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.rules;

import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.rules.RuleDynamicContext;
import com.novell.nds.dirxml.engine.rules.RuleStaticContext;
import com.novell.nds.dirxml.engine.rules.RuleUtil;
import com.novell.nds.dirxml.engine.rules.Token;
import com.novell.nds.dirxml.util.XdsDN;
import org.w3c.dom.Element;

class TokenSrcDN
extends Token {
    private boolean convert;
    private int start;
    private int length;

    TokenSrcDN(Element element, RuleStaticContext ruleStaticContext, boolean bl) throws VRDException {
        super(element, ruleStaticContext, bl);
        this.convert = RuleUtil.getAttrBoolean(element, "convert", false);
        this.start = RuleUtil.getAttrInt(element, "start", 0);
        this.length = RuleUtil.getAttrInt(element, "length", -1);
    }

    Object expand(Element element, RuleDynamicContext ruleDynamicContext) throws VRDException {
        XdsDN xdsDN;
        if (this.convert) {
            xdsDN = RuleUtil.getSrcDN(element, this.staticContext);
        } else {
            String string = element.getAttributeNS(null, "src-dn");
            if (this.start == 0 && this.length == -1) {
                return string;
            }
            xdsDN = RuleUtil.parseDN(string, this.staticContext.srcDelims);
        }
        return xdsDN.getDNFragment(this.convert ? this.staticContext.destDelims : this.staticContext.srcDelims, this.start, this.length, true);
    }
}

