/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.url;

import com.novell.nds.dirxml.util.XdsDN;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import java.util.StringTokenizer;
import novell.jclient.JCContext;

public abstract class NDSURLConnection
extends URLConnection {
    static Hashtable contextTable = new Hashtable();
    private static final String DELIMITERS = "00./+=*\\";
    static final String handlerPackage = "com.novell.nds.dirxml.engine.url";
    static final String handlerProperty = "java.protocol.handler.pkgs";

    public NDSURLConnection(URL uRL) {
        super(uRL);
    }

    public static JCContext setThreadBaseContext(JCContext jCContext) {
        if (jCContext == null) {
            return (JCContext)contextTable.remove(Thread.currentThread());
        }
        return contextTable.put(Thread.currentThread(), jCContext);
    }

    public static JCContext getThreadBaseContext() {
        return (JCContext)contextTable.get(Thread.currentThread());
    }

    public static String decodeURL(String string) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '+') {
                byteArrayOutputStream.write(32);
            } else if (c == '%') {
                int n2 = Character.digit(string.charAt(++n), 16);
                int n3 = Character.digit(string.charAt(++n), 16);
                byteArrayOutputStream.write((char)(n2 * 16 + n3));
            } else {
                byteArrayOutputStream.write(c);
            }
            ++n;
        }
        return byteArrayOutputStream.toString();
    }

    public static void enableURLHandlers() {
        String string = System.getProperty(handlerProperty);
        if (string != null && string.length() != 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                if (!stringTokenizer.nextToken().equals(handlerPackage)) continue;
                return;
            }
            string = string + "|com.novell.nds.dirxml.engine.url";
        } else {
            string = new String(handlerPackage);
        }
        System.getProperties().put(handlerProperty, string);
    }

    public static String getDNFromURL(URL uRL) throws MalformedURLException {
        if (!uRL.getProtocol().equals("vnd.nds.stream") && !uRL.getProtocol().equals("vnd.nds.xds")) {
            throw new MalformedURLException();
        }
        String string = uRL.getFile();
        String string2 = uRL.getHost();
        string = NDSURLConnection.decodeURL(string);
        if (string2 != null && string2.length() != 0) {
            string2 = NDSURLConnection.decodeURL(string2);
            string = "/" + string2 + string;
        } else if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        XdsDN xdsDN = new XdsDN(string, DELIMITERS.toCharArray());
        return xdsDN.getDN("00.\\+=*'".toCharArray());
    }
}

