/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.url.vnd.nds.haha;

import com.novell.nds.dirxml.engine.url.NDSURLConnection;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class HahaURLConnection
extends NDSURLConnection {
    private InputStream inputStream = null;

    public HahaURLConnection(URL uRL) {
        super(uRL);
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.inputStream;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public int getContentLength() {
        return -1;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            String string = this.url.getFile();
            this.inputStream = new HahaInputStream(new FileInputStream(string));
            this.connected = true;
        }
    }

    private static class HahaInputStream
    extends InputStream {
        private InputStream is;
        private int pos = 0;
        private int mask = 222;
        private int saveMask;
        private int savePos;

        HahaInputStream(InputStream inputStream) {
            this.is = inputStream;
        }

        public int read() throws IOException {
            int n = this.is.read();
            if (n != -1) {
                this.mask = n ^ (((n ^= this.mask) & 0x80) != 0 ? this.pos & 0xFF : -(this.pos & 0xFF) + 255);
                ++this.pos;
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if ((n2 = this.is.read(byArray, n, n2)) > 0) {
                int n3 = n;
                int n4 = 0;
                while (n4 < n2) {
                    byte by;
                    int n5 = n3;
                    byArray[n5] = (byte)(byArray[n5] ^ (byte)this.mask);
                    this.mask = by ^ (((by = byArray[n3]) & 0x80) != 0 ? this.pos & 0xFF : -(this.pos & 0xFF) + 255);
                    ++this.pos;
                    ++n4;
                    ++n3;
                }
            }
            return n2;
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public synchronized void mark(int n) {
            this.saveMask = this.mask;
            this.savePos = this.pos;
            this.is.mark(n);
        }

        public synchronized void reset() throws IOException {
            this.is.reset();
            this.mask = this.saveMask;
            this.pos = this.savePos;
        }

        public long skip(long l) throws IOException {
            int n;
            long l2 = l;
            byte[] byArray = new byte[(int)(l < 2048L ? l : 2048L)];
            while (l2 > 0L && (n = this.read(byArray, 0, (int)(l2 < (long)byArray.length ? l2 : (long)byArray.length))) != -1) {
                l2 -= (long)n;
            }
            return l - l2;
        }

        public void close() throws IOException {
            this.is.close();
        }
    }
}

