/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.url.vnd.nds.stream;

import com.novell.nds.dirxml.engine.url.NDSURLConnection;
import com.novell.nds.io.NDSStreamAttributeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import novell.jclient.JCContext;
import novell.jclient.JCException;

public class StreamURLConnection
extends NDSURLConnection {
    private NDSStreamAttributeInputStream inputStream = null;
    private static final String DELIMITERS = "00./+=*\\";
    private static final String DEFAULT_ATTRIBUTE = "XmlData";

    public StreamURLConnection(URL uRL) {
        super(uRL);
    }

    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.inputStream;
    }

    public String getContentType() {
        return "application/octet-stream";
    }

    public int getContentLength() {
        return -1;
    }

    public void connect() throws IOException {
        if (!this.connected) {
            JCContext jCContext = null;
            try {
                String string = this.url.getFile();
                String string2 = this.url.getHost();
                String string3 = this.url.getRef();
                if (string3 == null || string3.length() == 0) {
                    string3 = DEFAULT_ATTRIBUTE;
                }
                string3 = NDSURLConnection.decodeURL(string3);
                string = NDSURLConnection.decodeURL(string);
                if (string2 != null && string2.length() != 0) {
                    string2 = NDSURLConnection.decodeURL(string2);
                    string = "/" + string2 + string;
                } else if (string.charAt(0) == '/') {
                    string = string.substring(1);
                }
                JCContext jCContext2 = NDSURLConnection.getThreadBaseContext();
                if (jCContext2 != null) {
                    jCContext = jCContext2.duplicate();
                    jCContext.setBaseDN(null, DELIMITERS);
                } else {
                    jCContext = new JCContext(0, null, DELIMITERS);
                }
                this.inputStream = new NDSStreamAttributeInputStream(jCContext, string, string3);
            }
            catch (JCException jCException) {
                if (jCContext != null) {
                    jCContext.free();
                    jCContext = null;
                }
                throw new IOException(jCException.toString());
            }
        }
    }
}

