/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.url.vnd.nds.xds;

import com.novell.nds.dirxml.engine.NDSReader;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.url.NDSURLConnection;
import com.novell.xml.dom.DOMUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import novell.jclient.JCContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XDSURLConnection
extends NDSURLConnection {
    private final String DELIMITERS = "00./+=*\\";
    private final String SCOPE_BASE = "base";
    private final String SCOPE_ONE = "one";
    private final String SCOPE_SUB = "sub";
    private byte[] data = null;
    private Document urlDoc = null;

    public XDSURLConnection(URL uRL) {
        super(uRL);
    }

    private byte[] getData() throws IOException {
        if (this.data == null) {
            if (this.urlDoc == null) {
                this.connect();
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            DOMUtil.printDocumentWithFormat((Writer)outputStreamWriter, (Document)this.urlDoc);
            ((Writer)outputStreamWriter).flush();
            this.data = byteArrayOutputStream.toByteArray();
        }
        return this.data;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.getData());
    }

    public Object getContent() throws IOException {
        if (this.urlDoc == null) {
            this.connect();
        }
        return this.urlDoc;
    }

    public String getContentType() {
        return "application/x-xds";
    }

    public int getContentLength() {
        try {
            byte[] byArray = this.getData();
            return byArray.length;
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private String[] splitFilename(String string) {
        String[] stringArray = new String[]{null, null, null};
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            n2 = string.indexOf(63, n);
            if (n2 == -1) {
                stringArray[n3] = string.substring(n);
                break;
            }
            stringArray[n3] = n == n2 ? null : string.substring(n, n2);
            n = n2 + 1;
            ++n3;
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connect() throws IOException {
        Object object;
        String string;
        if (this.connected) {
            return;
        }
        URL uRL = this.getURL();
        String[] stringArray = null;
        String string2 = uRL.getHost();
        String string3 = "";
        int n = 0;
        String string4 = "";
        JCContext jCContext = null;
        String[] stringArray2 = this.splitFilename(uRL.getFile());
        if (stringArray2[0] != null) {
            string3 = NDSURLConnection.decodeURL(stringArray2[0]);
        }
        if (stringArray2[1] != null) {
            string = NDSURLConnection.decodeURL(stringArray2[1]);
            if (string.equals("base") || string.equals("")) {
                n = 0;
            } else if (string.equals("one")) {
                n = 1;
            } else {
                if (!string.equals("sub")) throw new MalformedURLException();
                n = 2;
            }
        }
        if (stringArray2[2] != null) {
            string4 = NDSURLConnection.decodeURL(stringArray2[2]);
        }
        if (string2 != null && string2.length() != 0) {
            string2 = NDSURLConnection.decodeURL(string2);
            string3 = "/" + string2 + string3;
        } else if (string3.charAt(0) == '/') {
            string3 = string3.substring(1);
        }
        string = uRL.getRef();
        if (string != null && string.length() != 0) {
            object = new StringTokenizer(string, ",");
            int n2 = ((StringTokenizer)object).countTokens();
            stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = NDSURLConnection.decodeURL(((StringTokenizer)object).nextToken());
                ++n3;
            }
        }
        try {
            try {
                object = NDSURLConnection.getThreadBaseContext();
                if (object != null) {
                    jCContext = object.duplicate();
                    jCContext.setBaseDN(null, "00./+=*\\");
                } else {
                    jCContext = new JCContext(0, null, "00./+=*\\");
                }
                Element element = NdsDtd.createDoc("output");
                NDSReader.readObjects(jCContext, string3, null, stringArray, n, (Node)element, null, null, null);
                this.urlDoc = element.getOwnerDocument();
                this.connected = true;
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
            Object var14_15 = null;
            if (jCContext == null) return;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
    }
}

