/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.verb;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.DirXML;
import com.novell.nds.dirxml.engine.Driver;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.NdsDtd;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.VRDException;
import com.novell.nds.dirxml.engine.XdsUtil;
import com.novell.nds.dirxml.engine.cache.CacheInputStream;
import com.novell.nds.dirxml.engine.cache.CheckAbort;
import com.novell.nds.dirxml.engine.cache.DriverCache;
import com.novell.nds.dirxml.engine.cache.Transaction;
import com.novell.nds.dirxml.engine.event.DSEEventInfo;
import com.novell.nds.dirxml.engine.verb.DirXMLVerbs;
import com.novell.nds.dirxml.engine.verb.SubVerbHandler;
import com.novell.nds.wire.DSWire;
import com.novell.nds.wire.PositionInputStream;
import com.novell.xml.dom.DOMWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import novell.jclient.JCContext;
import novell.jclient.JCException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CacheUtil
implements SubVerbHandler,
CheckAbort {
    private static final int DEFAULT_TIMEOUT = 1;
    private static final int MAX_TIMEOUT = 10;
    private static final long MAX_LOCK_WAIT = 1000L;
    private long driverEntryID;
    private String driverDN;
    private int startingOffset;
    private long transactionCount;
    private int timeoutPeriod;
    private JCContext context = null;

    CacheUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] processSubVerb(long l, int n, PositionInputStream positionInputStream, int n2) throws DSErr {
        byte[] byArray;
        block17: {
            byte[] byArray2;
            block16: {
                try {
                    try {
                        int n3 = DSWire.WGetInt32((InputStream)positionInputStream);
                        if (n3 > 1) {
                            throw new DSErr(-641);
                        }
                        int n4 = DSWire.WGetInt32((InputStream)positionInputStream);
                        this.driverEntryID = DirXMLVerbs.resolveDN(DSWire.WGetString((InputStream)positionInputStream), n4);
                        if (!DirXMLVerbs.hasSupervisorRights(this.driverEntryID, l)) {
                            throw new DSErr(-672);
                        }
                        this.driverDN = DDSServ.getLocalEntryName((long)this.driverEntryID, (int)0);
                        DSWire.WGetAlign32((PositionInputStream)positionInputStream);
                        if (n3 == 0) {
                            this.timeoutPeriod = DSWire.WGetInt32((InputStream)positionInputStream);
                            if (this.timeoutPeriod < 0 || this.timeoutPeriod > 10) {
                                StatusLog.logError(9137, new Integer(this.timeoutPeriod), this.getSubVerbName());
                                throw new DSErr(-641);
                            }
                            if (this.timeoutPeriod == 0) {
                                this.timeoutPeriod = 1;
                            }
                        }
                        this.startingOffset = DSWire.WGetInt32((InputStream)positionInputStream);
                        this.transactionCount = (long)DSWire.WGetInt32((InputStream)positionInputStream) & 0xFFFFFFFFFFFFFFFFL;
                        if (this.transactionCount == 0L) {
                            StatusLog.logError(9168, new Integer((int)this.transactionCount), this.getSubVerbName());
                            throw new DSErr(-641);
                        }
                        try {
                            this.context = MiscDS.createLocalContext();
                            int n5 = MiscDS.getDriverStartOption(this.context, this.driverEntryID);
                            if (n5 == 0) {
                                StatusLog.logError(9169, this.getSubVerbName(), this.driverDN);
                                throw new DSErr(-641);
                            }
                            this.verifyDriverStopped();
                            if (n3 == 0) {
                                byArray2 = this.version0();
                                Object var11_14 = null;
                                if (this.context == null) return byArray2;
                                break block16;
                            }
                            byArray = this.version1((InputStream)positionInputStream);
                            break block17;
                        }
                        catch (JCException jCException) {
                            throw new DSErr(jCException.getErrorCode());
                        }
                    }
                    catch (IOException iOException) {
                        StatusLog.logError(9140, this.getSubVerbName(), iOException.getLocalizedMessage());
                        throw new DSErr(-641);
                    }
                    catch (DSErr dSErr) {
                        StatusLog.logError(9140, this.getSubVerbName(), dSErr.getLocalizedMessage());
                        throw dSErr;
                    }
                    catch (Throwable throwable) {
                        StatusLog.logError(9140, this.getSubVerbName(), throwable.getLocalizedMessage());
                        throw new DSErr(-255);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    if (this.context == null) throw throwable;
                    this.context.free();
                    this.context = null;
                    throw throwable;
                }
            }
            this.context.free();
            this.context = null;
            return byArray2;
        }
        Object var11_15 = null;
        if (this.context == null) return byArray;
        this.context.free();
        this.context = null;
        return byArray;
    }

    private void verifyDriverStopped() throws DSErr, JCException {
        int n = MiscDS.getDriverState(this.context, this.driverEntryID);
        if (n != 0) {
            StatusLog.logError(9170, this.getSubVerbName(), this.driverDN);
            throw new DSErr(-641);
        }
    }

    public String getSubVerbName() {
        return "DSVR_CACHE_UTIL";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] version0() throws DSErr, IOException, VRDException {
        Transaction transaction;
        Object object;
        int n = 0;
        int n2 = 0;
        long l = this.startingOffset;
        boolean bl = false;
        Element element = NdsDtd.createDoc("input");
        Document document = element.getOwnerDocument();
        if (!DriverCache.lock(this.driverEntryID)) {
            throw new DSErr(-162);
        }
        try {
            object = new DriverCache(this.driverEntryID, EngineTrace.staticTracer);
            ((DriverCache)object).setCheckAbort(this);
            ((DriverCache)object).setAutoAbort(false);
            ((DriverCache)object).setStartPosition(l);
            while (this.transactionCount > 0L) {
                transaction = ((DriverCache)object).getTransaction();
                if (transaction.isDataAvailable()) {
                    this.readTransaction(transaction);
                    if (!transaction.isEndTransaction()) continue;
                    this.buildXML(element, transaction);
                    bl = true;
                    --this.transactionCount;
                    l = transaction.getEndPosition();
                    continue;
                }
                this.transactionCount = 0L;
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            DriverCache.unlock(this.driverEntryID);
            throw throwable;
        }
        DriverCache.unlock(this.driverEntryID);
        if (bl) {
            object = new ByteArrayOutputStream();
            transaction = new DOMWriter((Node)document, (OutputStream)object, "UTF-8");
            transaction.setWriteDeclaration(true);
            transaction.setIndent(true);
            transaction.write();
            transaction.flush();
            ((ByteArrayOutputStream)object).close();
            byte[] byArray = ((ByteArrayOutputStream)object).toByteArray();
            n = DirXMLVerbs.registerResult(byArray, this.timeoutPeriod, this.driverEntryID, 16L);
            n2 = byArray.length;
        }
        object = new ByteArrayOutputStream(12);
        DSWire.WPutInt32((OutputStream)object, (int)n);
        DSWire.WPutInt32((OutputStream)object, (int)n2);
        DSWire.WPutInt32((OutputStream)object, (int)((int)l));
        ((ByteArrayOutputStream)object).close();
        return ((ByteArrayOutputStream)object).toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] version1(InputStream inputStream) throws DSErr, IOException {
        Object object;
        long l;
        long l2;
        DriverCache driverCache;
        block11: {
            String string = DirXMLVerbs.WGetUTF8String(inputStream);
            if (!DriverCache.lock(this.driverEntryID)) {
                throw new DSErr(-162);
            }
            try {
                driverCache = new DriverCache(this.driverEntryID, EngineTrace.staticTracer);
                driverCache.setCheckAbort(this);
                driverCache.setAutoAbort(false);
                driverCache.setStartPosition(this.startingOffset);
                if (string != null && string.length() != 0) {
                    l2 = this.findTransaction(string, driverCache);
                    if (l2 == -1L) {
                        throw new DSErr(-602);
                    }
                    driverCache = new DriverCache(this.driverEntryID, EngineTrace.staticTracer);
                    driverCache.setCheckAbort(this);
                    driverCache.setAutoAbort(false);
                    driverCache.setStartPosition(l2);
                } else {
                    l2 = this.startingOffset;
                }
                l = l2;
                while (this.transactionCount > 0L) {
                    object = driverCache.getTransaction();
                    if (((Transaction)object).isDataAvailable()) {
                        this.readTransaction((Transaction)object);
                        if (!((Transaction)object).isEndTransaction()) continue;
                        --this.transactionCount;
                        l = ((Transaction)object).getEndPosition();
                        continue;
                    }
                    this.transactionCount = 0L;
                }
                if (l - l2 >= 0L) break block11;
                object = null;
                Object var10_7 = null;
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                DriverCache.unlock(this.driverEntryID);
                throw throwable;
            }
            DriverCache.unlock(this.driverEntryID);
            return object;
        }
        if (l2 == 0L) {
            object = new CacheInputStream(this.driverEntryID);
            ((CacheInputStream)object).setCheckAbort(this);
            ((CacheInputStream)object).skip(l - l2);
            ((CacheInputStream)object).commit();
        } else {
            object = DSEEventInfo.constructIgnoreHeader(l - l2);
            driverCache.writeBytes((byte[])object, l2);
        }
        object = null;
        Object var10_8 = null;
        DriverCache.unlock(this.driverEntryID);
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private void readTransaction(Transaction var1_1) throws IOException, DSErr {
        ** GOTO lbl13
        {
            if (!var1_1.isDataAvailable()) {
                return;
            }
            if (this.abort()) {
                throw new DSErr(-750);
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException var2_2) {
                // empty catch block
            }
            do {
                if (!var1_1.getEvent()) continue block2;
lbl13:
                // 2 sources

            } while (!this.abort() && !var1_1.isEndTransaction());
        }
    }

    private void buildXML(Element element, Transaction transaction) throws VRDException {
        DSEEventInfo dSEEventInfo;
        DSEEventInfo dSEEventInfo2 = transaction.getEndTransaction();
        if (dSEEventInfo2 == null) {
            return;
        }
        Element[] elementArray = new Element[]{element};
        Element[] elementArray2 = dSEEventInfo2.toXML(this.context, this.driverDN, EngineTrace.staticTracer, elementArray, dSEEventInfo2, true);
        if (elementArray2 == null || elementArray2.length < 1) {
            return;
        }
        Iterator iterator = transaction.iterator();
        while (iterator.hasNext() && (dSEEventInfo = (DSEEventInfo)iterator.next()) != dSEEventInfo2) {
            Element[] elementArray3 = dSEEventInfo.toXML(this.context, this.driverDN, EngineTrace.staticTracer, elementArray2, dSEEventInfo2, true);
            if (elementArray3 == null || dSEEventInfo.getAttrValue() == null || !Driver.isSensitiveAttr(dSEEventInfo.getAttrValue().getAttrName())) continue;
            this.stripValues(elementArray3);
        }
    }

    private void stripValues(Element[] elementArray) {
        int n = 0;
        while (n < elementArray.length) {
            Element element;
            NodeList nodeList = XdsUtil.getElementsByTagNameNS(elementArray[n], null, "value");
            int n2 = 0;
            while ((element = (Element)nodeList.item(n2++)) != null) {
                XdsUtil.removeAllChildren(element);
                Document document = element.getOwnerDocument();
                element.appendChild(document.createComment(" content suppressed "));
            }
            ++n;
        }
    }

    private long findTransaction(String string, DriverCache driverCache) throws IOException, DSErr {
        Transaction transaction;
        long l = -1L;
        do {
            if (this.abort()) {
                throw new DSErr(-750);
            }
            transaction = driverCache.getTransaction();
            if (!transaction.isDataAvailable()) continue;
            this.readTransaction(transaction);
            if (!transaction.isEndTransaction()) continue;
            l = transaction.getStartPosition();
            DSEEventInfo dSEEventInfo = transaction.getEndTransaction();
            if (dSEEventInfo.getEventID() == null || !dSEEventInfo.getEventID().equals(string)) continue;
            return l;
        } while (transaction.isDataAvailable());
        return -1L;
    }

    public boolean abort() {
        return DirXML.isShuttingDown();
    }
}

