/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.verb;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dhutil.VerbHandler;
import com.novell.nds.dhutil.VerbProcessor;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.Entry;
import com.novell.nds.dirxml.engine.MiscDS;
import com.novell.nds.dirxml.engine.NdsConstants;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.verb.CacheUtil;
import com.novell.nds.dirxml.engine.verb.CheckObjectPassword;
import com.novell.nds.dirxml.engine.verb.ChunkyResults;
import com.novell.nds.dirxml.engine.verb.CloseChunkedResult;
import com.novell.nds.dirxml.engine.verb.GetChunkedResult;
import com.novell.nds.dirxml.engine.verb.InitDriverObject;
import com.novell.nds.dirxml.engine.verb.OpenDriverAction;
import com.novell.nds.dirxml.engine.verb.SubVerbHandler;
import com.novell.nds.dirxml.util.LocalizedMessageSource;
import com.novell.nds.dirxml.util.MessageSource;
import com.novell.nds.dirxml.util.XdsDN;
import com.novell.nds.wire.DSWire;
import com.novell.nds.wire.PositionInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import novell.jclient.JCContext;
import novell.jclient.JCException;

public class DirXMLVerbs {
    private static LocalizedMessageSource messageSource = new LocalizedMessageSource("com.novell.nds.dirxml.engine.verb.DirXMLVerbs");
    private static final String NOT_INITIALIZED_MSG = "com.novell.dirxml.engine.verb.DirXMLVerbs has not been initialized";
    private static final int VERBOSE_TRACE = 10;
    private static final String PROCESSING_SUBVERB = "dxv_proc";
    private static final String WIRE_DN = "dxv_todn";
    private static final String CONVERTED_DN = "dxv_tcdn";
    static int initCount = 0;
    static DirXMLVerbs instance = null;
    SetVerbHandler setHandler = new SetVerbHandler();
    GetVerbHandler getHandler = new GetVerbHandler();
    Map getMap = new HashMap();
    Map setMap = new HashMap();
    ChunkyResults verbResults = new ChunkyResults();

    public static void initialize() throws DSErr {
        if (++initCount == 1) {
            VerbProcessor.initialize();
            try {
                instance = new DirXMLVerbs();
            }
            catch (Throwable throwable) {
                StatusLog.logError(9033, throwable);
                DirXMLVerbs.cleanup();
                throw new DSErr(-255);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanup() {
        block7: {
            try {
                if (--initCount == 0) {
                    if (instance != null) {
                        try {
                            VerbProcessor.unregisterHandler((int)121);
                            VerbProcessor.unregisterHandler((int)120);
                            Object var1 = null;
                            instance = null;
                        }
                        catch (Throwable throwable) {
                            Object var1_1 = null;
                            instance = null;
                            throw throwable;
                        }
                    }
                    VerbProcessor.cleanup();
                    break block7;
                }
                if (initCount < 0) {
                    initCount = 0;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static long resolveDN(String string, int n) throws DSErr {
        if ((n & 2) == 0) {
            char[] cArray = (n & 1) != 0 ? "00..+=*\\".toCharArray() : "10..+=*\\".toCharArray();
            XdsDN xdsDN = new XdsDN(string, cArray);
            String string2 = xdsDN.getDN(NdsConstants.SLASH_DELIMS_ARRAY);
            if (string2.charAt(0) != '\\') {
                String string3 = MiscDS.getTreeName();
                String string4 = string2.substring(0, Math.min(string3.length() + 1, string2.length()));
                if (string4.equalsIgnoreCase(string3 + "\\")) {
                    String string5;
                    boolean bl = false;
                    try {
                        String string6 = "\\" + string3 + "\\" + string3;
                        bl = DDSServ.getLocalEntryID((String)string6) != -1L;
                    }
                    catch (DSErr dSErr) {
                        // empty catch block
                    }
                    int n2 = string2.indexOf(92);
                    string2 = bl && n2 != -1 ? ((string5 = string2.substring(n2 + 1, Math.min(n2 + 1 + string3.length(), string2.length()))).equalsIgnoreCase(string3) ? "\\" + string2 : "\\" + string3 + "\\" + string2) : "\\" + string2;
                } else {
                    string2 = "\\" + string3 + "\\" + string2;
                }
            }
            if (EngineTrace.staticTracer.getLevel() >= 10) {
                EngineTrace.staticTracer.trace(WIRE_DN, (MessageSource)messageSource, string);
            }
            string = string2;
            if (EngineTrace.staticTracer.getLevel() >= 10) {
                EngineTrace.staticTracer.trace(CONVERTED_DN, (MessageSource)messageSource, string);
            }
        }
        return DDSServ.getLocalEntryID((String)string);
    }

    static boolean hasSupervisorRights(long l, long l2) throws DSErr {
        return (DirXMLVerbs.getEntryRights(l, l2) & 0x10L) != 0L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static long getEntryRights(long l, long l2) throws DSErr {
        long l3;
        JCContext jCContext = null;
        try {
            try {
                jCContext = MiscDS.createLocalContext();
                Entry entry = new Entry(l);
                entry.goTo(jCContext);
                String string = DDSServ.getLocalEntryName((long)l2, (int)0);
                l3 = jCContext.getEffectivePrivileges(string, "[Entry Rights]");
                Object var10_8 = null;
                if (jCContext == null) return l3;
            }
            catch (JCException jCException) {
                throw new DSErr(jCException.getErrorCode());
            }
            catch (Throwable throwable) {
                throw new DSErr(-255);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (jCContext == null) throw throwable;
            jCContext.free();
            throw throwable;
        }
        jCContext.free();
        return l3;
    }

    static int registerResult(byte[] byArray, int n, long l, long l2) throws DSErr, IllegalStateException {
        return DirXMLVerbs.instance.verbResults.registerResult(byArray, n, l, l2);
    }

    static boolean checkResultRights(int n, long l) throws DSErr {
        long l2 = DirXMLVerbs.getEntryRights(DirXMLVerbs.getResultEntryID(n), l);
        return (l2 & DirXMLVerbs.instance.verbResults.getResultRightsBits(n)) != 0L;
    }

    static long getResultEntryID(int n) throws DSErr {
        return DirXMLVerbs.instance.verbResults.getResultEntryID(n);
    }

    static void discardResult(int n) {
        DirXMLVerbs.instance.verbResults.discardResult(n);
    }

    static byte[] getResultChunk(int n, int n2, int n3) throws DSErr {
        if (instance == null) {
            throw new IllegalStateException(NOT_INITIALIZED_MSG);
        }
        return DirXMLVerbs.instance.verbResults.getResultChunk(n, n2, n3);
    }

    static String WGetUTF8String(InputStream inputStream) throws IOException {
        int n = DSWire.WGetInt32((InputStream)inputStream);
        if (n == 0) {
            return "";
        }
        byte[] byArray = new byte[n];
        if (inputStream.read(byArray) != n) {
            throw new EOFException();
        }
        return new String(byArray, "UTF-8");
    }

    private DirXMLVerbs() throws IllegalArgumentException, IllegalStateException {
        this.setMap.put(new Integer(11), new OpenDriverAction());
        this.setMap.put(new Integer(16), new InitDriverObject());
        this.setMap.put(new Integer(18), new CacheUtil());
        this.getMap.put(new Integer(12), new GetChunkedResult());
        this.getMap.put(new Integer(13), new CloseChunkedResult());
        this.getMap.put(new Integer(15), new CheckObjectPassword());
        VerbProcessor.registerHandler((VerbHandler)this.setHandler, (int)120);
        VerbProcessor.registerHandler((VerbHandler)this.getHandler, (int)121);
    }

    private class GetVerbHandler
    implements VerbHandler {
        private GetVerbHandler() {
        }

        public byte[] processVerb(long l, byte[] byArray, int n) throws DSErr {
            int n2;
            PositionInputStream positionInputStream;
            try {
                positionInputStream = new PositionInputStream((InputStream)new ByteArrayInputStream(byArray));
                n2 = DSWire.WGetInt32((InputStream)positionInputStream);
            }
            catch (IOException iOException) {
                throw new DSErr(-641);
            }
            SubVerbHandler subVerbHandler = (SubVerbHandler)DirXMLVerbs.this.getMap.get(new Integer(n2));
            if (subVerbHandler == null) {
                throw new DSErr(-714);
            }
            EngineTrace.staticTracer.trace(DirXMLVerbs.PROCESSING_SUBVERB, (MessageSource)messageSource, subVerbHandler.getSubVerbName());
            return subVerbHandler.processSubVerb(l, n2, positionInputStream, n);
        }

        public String getVerbName() {
            return "DSV_GET_REPLICATION_FILTER";
        }
    }

    private class SetVerbHandler
    implements VerbHandler {
        private SetVerbHandler() {
        }

        public byte[] processVerb(long l, byte[] byArray, int n) throws DSErr {
            int n2;
            PositionInputStream positionInputStream;
            try {
                positionInputStream = new PositionInputStream((InputStream)new ByteArrayInputStream(byArray));
                n2 = DSWire.WGetInt32((InputStream)positionInputStream);
            }
            catch (IOException iOException) {
                throw new DSErr(-641);
            }
            SubVerbHandler subVerbHandler = (SubVerbHandler)DirXMLVerbs.this.setMap.get(new Integer(n2));
            if (subVerbHandler == null) {
                throw new DSErr(-714);
            }
            EngineTrace.staticTracer.trace(DirXMLVerbs.PROCESSING_SUBVERB, (MessageSource)messageSource, subVerbHandler.getSubVerbName());
            return subVerbHandler.processSubVerb(l, n2, positionInputStream, n);
        }

        public String getVerbName() {
            return "DSV_SET_REPLICATION_FILTER";
        }
    }
}

