/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.verb;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.verb.DirXMLVerbs;
import com.novell.nds.dirxml.engine.verb.SubVerbHandler;
import com.novell.nds.wire.DSWire;
import com.novell.nds.wire.PositionInputStream;
import java.io.IOException;
import java.io.InputStream;

class GetChunkedResult
implements SubVerbHandler {
    private static final int MAX_TIMEOUT = 10;

    GetChunkedResult() {
    }

    public byte[] processSubVerb(long l, int n, PositionInputStream positionInputStream, int n2) throws DSErr {
        try {
            int n3 = DSWire.WGetInt32((InputStream)positionInputStream);
            if (n3 != 0) {
                throw new DSErr(-641);
            }
            int n4 = DSWire.WGetInt32((InputStream)positionInputStream);
            int n5 = DSWire.WGetInt32((InputStream)positionInputStream);
            if (n5 < 0 || n5 > 10) {
                StatusLog.logError(9137, new Integer(n5), this.getSubVerbName());
                throw new DSErr(-641);
            }
            if (!DirXMLVerbs.checkResultRights(n4, l)) {
                throw new DSErr(-672);
            }
            return DirXMLVerbs.getResultChunk(n4, n2, n5);
        }
        catch (IOException iOException) {
            StatusLog.logError(9140, this.getSubVerbName(), iOException.getLocalizedMessage());
            throw new DSErr(-641);
        }
        catch (DSErr dSErr) {
            StatusLog.logError(9140, this.getSubVerbName(), dSErr.getLocalizedMessage());
            throw dSErr;
        }
        catch (Throwable throwable) {
            StatusLog.logError(9140, this.getSubVerbName(), throwable.getLocalizedMessage());
            throw new DSErr(-255);
        }
    }

    public String getSubVerbName() {
        return "DSVR_GET_CHUNKED_RESULT";
    }
}

