/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.verb;

import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.EngineTrace;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.controls.ControlValues;
import com.novell.nds.dirxml.engine.verb.DirXMLVerbs;
import com.novell.nds.dirxml.engine.verb.SubVerbHandler;
import com.novell.nds.wire.DSWire;
import com.novell.nds.wire.PositionInputStream;
import java.io.IOException;
import java.io.InputStream;

class InitDriverObject
implements SubVerbHandler {
    InitDriverObject() {
    }

    public byte[] processSubVerb(long l, int n, PositionInputStream positionInputStream, int n2) throws DSErr {
        try {
            int n3 = DSWire.WGetInt32((InputStream)positionInputStream);
            if (n3 != 0) {
                throw new DSErr(-641);
            }
            int n4 = DSWire.WGetInt32((InputStream)positionInputStream);
            long l2 = DirXMLVerbs.resolveDN(DSWire.WGetString((InputStream)positionInputStream), n4);
            if (!DirXMLVerbs.hasSupervisorRights(l2, l)) {
                throw new DSErr(-672);
            }
            ControlValues controlValues = new ControlValues(EngineTrace.staticTracer);
            controlValues.writeToDriver(l2);
            return new byte[0];
        }
        catch (IOException iOException) {
            StatusLog.logError(9140, this.getSubVerbName(), iOException.getLocalizedMessage());
            throw new DSErr(-641);
        }
        catch (DSErr dSErr) {
            StatusLog.logError(9140, this.getSubVerbName(), dSErr.getLocalizedMessage());
            throw dSErr;
        }
        catch (Throwable throwable) {
            StatusLog.logError(9140, this.getSubVerbName(), throwable.getLocalizedMessage());
            throw new DSErr(-255);
        }
    }

    public String getSubVerbName() {
        return "DSVR_INIT_DRIVER_OBJECT";
    }
}

