/*
 * Decompiled with CFR 0.152.
 */
package com.novell.nds.dirxml.engine.verb;

import com.novell.nds.dhutil.DDSServ;
import com.novell.nds.dhutil.DSErr;
import com.novell.nds.dirxml.engine.DriverEntry;
import com.novell.nds.dirxml.engine.DriverList;
import com.novell.nds.dirxml.engine.StatusLog;
import com.novell.nds.dirxml.engine.verb.DirXMLVerbs;
import com.novell.nds.dirxml.engine.verb.SubVerbHandler;
import com.novell.nds.wire.DSWire;
import com.novell.nds.wire.PositionInputStream;
import com.novell.xml.dom.DOMWriter;
import com.novell.xml.parser.XMLParser;
import com.novell.xml.parser.XMLParserFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

class OpenDriverAction
implements SubVerbHandler {
    private static final int DEFAULT_TIMEOUT = 1;
    private static final int MAX_TIMEOUT = 10;

    OpenDriverAction() {
    }

    public byte[] processSubVerb(long l, int n, PositionInputStream positionInputStream, int n2) throws DSErr {
        try {
            int n3 = DSWire.WGetInt32((InputStream)positionInputStream);
            if (n3 != 0) {
                throw new DSErr(-641);
            }
            int n4 = DSWire.WGetInt32((InputStream)positionInputStream);
            long l2 = DirXMLVerbs.resolveDN(DSWire.WGetString((InputStream)positionInputStream), n4);
            if (!DirXMLVerbs.hasSupervisorRights(l2, l)) {
                throw new DSErr(-672);
            }
            DSWire.WGetAlign32((PositionInputStream)positionInputStream);
            int n5 = DSWire.WGetInt32((InputStream)positionInputStream);
            if (n5 < 0 || n5 > 10) {
                StatusLog.logError(9137, new Integer(n5), this.getSubVerbName());
                throw new DSErr(-641);
            }
            if (n5 == 0) {
                n5 = 1;
            }
            byte[] byArray = DSWire.WGetData((InputStream)positionInputStream);
            XMLParser xMLParser = XMLParserFactory.newParser();
            Document document = xMLParser.parse((InputStream)new ByteArrayInputStream(byArray));
            byArray = null;
            if (xMLParser.anyErrors()) {
                StatusLog.logError(9138, this.getSubVerbName(), xMLParser.getErrorMsgString());
                throw new DSErr(-641);
            }
            DriverEntry driverEntry = DriverList.findEntry(l2);
            if (driverEntry == null) {
                StatusLog.logError(9139, this.getSubVerbName(), DDSServ.getLocalEntryName((long)l2, (int)0));
                throw new DSErr(-641);
            }
            Document document2 = driverEntry.submitAction(document);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DOMWriter dOMWriter = new DOMWriter((Node)document2, (OutputStream)byteArrayOutputStream, "UTF-8");
            dOMWriter.write();
            dOMWriter.flush();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
            int n6 = DirXMLVerbs.registerResult(byArray, n5, l2, 16L);
            byteArrayOutputStream = new ByteArrayOutputStream(8);
            DSWire.WPutInt32((OutputStream)byteArrayOutputStream, (int)n6);
            DSWire.WPutInt32((OutputStream)byteArrayOutputStream, (int)byArray.length);
            byteArrayOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            StatusLog.logError(9140, this.getSubVerbName(), iOException.getLocalizedMessage());
            throw new DSErr(-641);
        }
        catch (DSErr dSErr) {
            StatusLog.logError(9140, this.getSubVerbName(), dSErr.getLocalizedMessage());
            throw dSErr;
        }
        catch (Throwable throwable) {
            StatusLog.logError(9140, this.getSubVerbName(), throwable.getLocalizedMessage());
            throw new DSErr(-255);
        }
    }

    public String getSubVerbName() {
        return "DSVR_OPEN_DRIVER_ACTION";
    }
}

