/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.DSMLSearchResults;
import com.novell.ldap.LDAPAddRequest;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPConstraints;
import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPDeleteRequest;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPLocalException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.LDAPMessageQueue;
import com.novell.ldap.LDAPModification;
import com.novell.ldap.LDAPModifyDNRequest;
import com.novell.ldap.LDAPModifyRequest;
import com.novell.ldap.LDAPResponseQueue;
import com.novell.ldap.LDAPSearchConstraints;
import com.novell.ldap.LDAPSearchQueue;
import com.novell.ldap.LDAPSearchRequest;
import com.novell.ldap.LDAPSearchResults;
import com.novell.ldap.LDAPSocketFactory;
import com.novell.ldap.util.DSMLReader;
import com.novell.ldap.util.DSMLWriter;
import com.novell.ldap.util.HttpRequestCallback;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringBufferInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class DsmlConnection
extends LDAPConnection {
    HttpClient con = new HttpClient();
    String serverString;
    String binddn;
    String pass;
    boolean isBound;
    boolean isConnected;
    private String host;
    HttpRequestCallback callback;

    private LDAPMessage sendMessage(LDAPMessage message) throws LDAPException {
        return (LDAPMessage)this.sendMessage(message, false);
    }

    private DSMLSearchResults execQuery(LDAPMessage message) throws LDAPException {
        return (DSMLSearchResults)this.sendMessage(message, true);
    }

    private Object sendMessage(LDAPMessage message, boolean isSearch) throws LDAPException {
        try {
            PostMethod post = new PostMethod(this.serverString);
            post.setRequestHeader("Content-Type", "text/xml; charset=utf8");
            post.setRequestHeader("SOAPAction", "#batchRequest");
            if (this.callback != null) {
                this.callback.manipulationPost(post, this);
            }
            StringWriter out = new StringWriter();
            DSMLWriter writer = new DSMLWriter(out);
            PrintWriter pout = new PrintWriter(out);
            pout.println("<?xml version=\"1.0\" encoding=\"UTF8\"?>");
            pout.println("<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\">");
            pout.println("<soap-env:Body>");
            writer.writeMessage(message);
            writer.finish();
            pout.println("</soap-env:Body>");
            pout.println("</soap-env:Envelope>");
            ByteArrayInputStream in = new ByteArrayInputStream(out.toString().getBytes("UTF-8"));
            post.setRequestBody((InputStream)in);
            this.con.executeMethod((HttpMethod)post);
            if (post.getStatusCode() != 200) {
                if (post.getStatusCode() == 401 || post.getStatusCode() == 403) {
                    throw new LDAPException(LDAPException.resultCodeToString(49), 49, LDAPException.resultCodeToString(49));
                }
                throw new LDAPException(LDAPException.resultCodeToString(52), 52, post.getStatusText());
            }
            DSMLReader reader = new DSMLReader(post.getResponseBodyAsStream());
            post.releaseConnection();
            ArrayList errors = reader.getErrors();
            if (errors.size() > 0) {
                throw (LDAPException)errors.get(0);
            }
            if (isSearch) {
                return new DSMLSearchResults(reader);
            }
            return reader.readMessage();
        }
        catch (HttpException e) {
            throw new LDAPLocalException("Http Error", 91, e);
        }
        catch (IOException e) {
            throw new LDAPLocalException("Communications Error", 91, e);
        }
    }

    public ArrayList sendDoc(String DSML) throws LDAPException {
        ArrayList<LDAPMessage> results = new ArrayList<LDAPMessage>();
        try {
            LDAPMessage msg;
            PostMethod post = new PostMethod(this.serverString);
            post.setRequestHeader("Content-Type", "text/xml; charset=utf8");
            post.setRequestHeader("SOAPAction", "#batchRequest");
            if (this.callback != null) {
                this.callback.manipulationPost(post, this);
            }
            StringWriter out = new StringWriter();
            PrintWriter pout = new PrintWriter(out);
            pout.println("<?xml version=\"1.0\" encoding=\"UTF8\"?>");
            pout.println("<soap-env:Envelope xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\">");
            pout.println("<soap-env:Body>");
            pout.write(DSML);
            pout.println("</soap-env:Body>");
            pout.println("</soap-env:Envelope>");
            StringBufferInputStream in = new StringBufferInputStream(out.toString());
            post.setRequestBody((InputStream)in);
            this.con.executeMethod((HttpMethod)post);
            DSMLReader reader = new DSMLReader(post.getResponseBodyAsStream());
            post.releaseConnection();
            ArrayList errors = reader.getErrors();
            if (errors.size() > 0) {
                throw (LDAPException)errors.get(0);
            }
            while ((msg = reader.readMessage()) != null) {
                results.add(msg);
            }
        }
        catch (HttpException e) {
            throw new LDAPLocalException("Http Error", 91, e);
        }
        catch (IOException e) {
            throw new LDAPLocalException("Communications Error", 91, e);
        }
        return results;
    }

    public DsmlConnection() {
        this.con.getState().setAuthenticationPreemptive(true);
    }

    public DsmlConnection(LDAPSocketFactory factory) {
        this();
    }

    public void connect(String serverUrl, int port) throws LDAPException {
        this.serverString = serverUrl;
        this.host = serverUrl.substring(serverUrl.indexOf("//") + 2, serverUrl.indexOf("/", serverUrl.indexOf("//") + 2));
        this.isConnected = true;
    }

    public void bind(int arg0, String binddn, byte[] pass, LDAPConstraints arg3) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public LDAPResponseQueue bind(int arg0, String arg1, byte[] arg2, LDAPResponseQueue arg3, LDAPConstraints arg4) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue bind(int arg0, String arg1, byte[] arg2, LDAPResponseQueue arg3) throws LDAPException {
        return null;
    }

    public void bind(int arg0, String binddn, byte[] pass) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(int arg0, String binddn, String pass, LDAPConstraints arg3) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(int arg0, String binddn, String pass) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String pass, LDAPConstraints arg2) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String pass, Map arg2, Object arg3, LDAPConstraints arg4) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String pass, Map arg2, Object arg3) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String pass, String[] arg2, Map arg3, Object arg4, LDAPConstraints arg5) throws LDAPException {
        this.bind(binddn, new String(pass));
    }

    public void bind(String binddn, String arg1, String[] arg2, Map arg3, Object arg4) throws LDAPException {
        this.bind(binddn, new String(this.pass));
    }

    public void bind(String binddn, String password) throws LDAPException {
        if (this.isBound) {
            GetMethod get = new GetMethod(this.serverString + "?clearbind");
            try {
                this.con.executeMethod((HttpMethod)get);
            }
            catch (HttpException e) {
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.isBound = false;
        this.con.getState().setCredentials(null, null, (Credentials)new UsernamePasswordCredentials(binddn, password));
        this.search("", 0, "(objectClass=*)", new String[]{"1.1"}, false);
        this.isBound = true;
    }

    public void add(LDAPEntry entry, LDAPConstraints cont) throws LDAPException {
        LDAPControl[] conts = cont != null ? cont.getControls() : null;
        LDAPAddRequest add = new LDAPAddRequest(entry, conts);
        this.sendMessage(add);
    }

    public LDAPResponseQueue add(LDAPEntry arg0, LDAPResponseQueue arg1, LDAPConstraints arg2) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue add(LDAPEntry arg0, LDAPResponseQueue arg1) throws LDAPException {
        return null;
    }

    public void add(LDAPEntry entry) throws LDAPException {
        this.add(entry, (LDAPConstraints)null);
    }

    public void modify(String dn, LDAPModification mod, LDAPConstraints consts) throws LDAPException {
        this.modify(dn, new LDAPModification[]{mod}, consts);
    }

    public LDAPResponseQueue modify(String arg0, LDAPModification arg1, LDAPResponseQueue arg2, LDAPConstraints arg3) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue modify(String arg0, LDAPModification arg1, LDAPResponseQueue arg2) throws LDAPException {
        return null;
    }

    public void modify(String dn, LDAPModification mod) throws LDAPException {
        this.modify(dn, new LDAPModification[]{mod}, (LDAPConstraints)null);
    }

    public void modify(String dn, LDAPModification[] mods, LDAPConstraints consts) throws LDAPException {
        LDAPControl[] controls = consts != null ? consts.getControls() : null;
        LDAPModifyRequest msg = new LDAPModifyRequest(dn, mods, controls);
        this.sendMessage(msg);
    }

    public LDAPResponseQueue modify(String arg0, LDAPModification[] arg1, LDAPResponseQueue arg2, LDAPConstraints arg3) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue modify(String arg0, LDAPModification[] arg1, LDAPResponseQueue arg2) throws LDAPException {
        return null;
    }

    public void modify(String dn, LDAPModification[] mods) throws LDAPException {
        this.modify(dn, mods, (LDAPConstraints)null);
    }

    public void rename(String dn, String newDn, boolean delOld, LDAPConstraints consts) throws LDAPException {
        this.rename(dn, newDn, "", delOld, consts);
    }

    public LDAPResponseQueue rename(String arg0, String arg1, boolean arg2, LDAPResponseQueue arg3, LDAPConstraints arg4) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue rename(String arg0, String arg1, boolean arg2, LDAPResponseQueue arg3) throws LDAPException {
        return null;
    }

    public void rename(String dn, String newDn, boolean delOld) throws LDAPException {
        this.rename(dn, newDn, "", delOld, (LDAPConstraints)null);
    }

    public void rename(String dn, String newRdn, String newParentDN, boolean delOld, LDAPConstraints constr) throws LDAPException {
        LDAPControl[] controls = constr != null ? constr.getControls() : null;
        LDAPModifyDNRequest msg = new LDAPModifyDNRequest(dn, newRdn, newParentDN, delOld, controls);
        this.sendMessage(msg);
    }

    public LDAPResponseQueue rename(String arg0, String arg1, String arg2, boolean arg3, LDAPResponseQueue arg4, LDAPConstraints arg5) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue rename(String arg0, String arg1, String arg2, boolean arg3, LDAPResponseQueue arg4) throws LDAPException {
        return null;
    }

    public void rename(String dn, String newRdn, String newParentDN, boolean delOld) throws LDAPException {
        this.rename(dn, newRdn, newParentDN, delOld, (LDAPConstraints)null);
    }

    public void delete(String dn, LDAPConstraints consts) throws LDAPException {
        LDAPControl[] controls = consts != null ? consts.getControls() : null;
        LDAPDeleteRequest msg = new LDAPDeleteRequest(dn, controls);
        this.sendMessage(msg);
    }

    public LDAPResponseQueue delete(String arg0, LDAPResponseQueue arg1, LDAPConstraints arg2) throws LDAPException {
        return null;
    }

    public LDAPResponseQueue delete(String arg0, LDAPResponseQueue arg1) throws LDAPException {
        return null;
    }

    public void delete(String dn) throws LDAPException {
        this.delete(dn, (LDAPConstraints)null);
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchConstraints cons) throws LDAPException {
        LDAPControl[] controls = cons != null ? cons.getControls() : null;
        LDAPSearchRequest msg = new LDAPSearchRequest(base, scope, filter, attrs, 0, 0, 0, typesOnly, controls);
        DSMLSearchResults res = this.execQuery(msg);
        if (res == null) {
            res = new DSMLSearchResults(null);
        }
        return res;
    }

    public LDAPSearchQueue search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchQueue queue, LDAPSearchConstraints cons) throws LDAPException {
        return null;
    }

    public LDAPSearchQueue search(String base, int scope, String filter, String[] attrs, boolean typesOnly, LDAPSearchQueue queue) throws LDAPException {
        return null;
    }

    public LDAPSearchResults search(String base, int scope, String filter, String[] attrs, boolean typesOnly) throws LDAPException {
        return this.search(base, scope, filter, attrs, typesOnly, (LDAPSearchConstraints)null);
    }

    public boolean isConnectionAlive() {
        GetMethod get = new GetMethod(this.serverString + "?wsdl");
        try {
            this.con.executeMethod((HttpMethod)get);
            return true;
        }
        catch (HttpException e) {
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isBound() {
        return this.isBound;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public boolean isTLS() {
        return this.serverString.toLowerCase().startsWith("https");
    }

    public void disconnect() throws LDAPException {
        this.serverString = null;
        this.isConnected = false;
    }

    public void disconnect(LDAPConstraints cons) throws LDAPException {
        this.disconnect();
    }

    public LDAPMessageQueue sendRequest(LDAPMessage request, LDAPMessageQueue queue) throws LDAPException {
        this.sendMessage(request);
        return null;
    }

    public HttpRequestCallback getCallback() {
        return this.callback;
    }

    public void setCallback(HttpRequestCallback call) {
        this.callback = call;
    }

    public String getBinddn() {
        return this.binddn;
    }

    public HttpClient getCon() {
        return this.con;
    }

    public String getHost() {
        return this.host;
    }

    public String getPass() {
        return this.pass;
    }

    public String getServerString() {
        return this.serverString;
    }
}

